/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.builtin;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ResourceOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ItemOption
extends ConfigOption<class_1792> {
    public static final ConfigParser<class_1792> PARSER = new Parser(true);
    public static final ConfigParser<class_1792> PARSER_NO_AIR = new Parser(false);
    private final boolean allowAir;

    protected ItemOption(@NotNull Supplier<class_1792> defaultValue, boolean allowAir) {
        super(defaultValue);
        this.allowAir = allowAir;
    }

    @Override
    @NotNull
    protected ConfigParser<class_1792> getParser() {
        return this.allowAir ? PARSER : PARSER_NO_AIR;
    }

    public static ItemOption create(@NotNull class_1935 defaultValue) {
        return new ItemOption(() -> ((class_1935)defaultValue).method_8389(), true);
    }

    public static ItemOption create(@NotNull class_1935 defaultValue, boolean allowAir) {
        return new ItemOption(() -> ((class_1935)defaultValue).method_8389(), allowAir);
    }

    public static ItemOption create(@NotNull Supplier<class_1792> defaultValue) {
        return new ItemOption(defaultValue, true);
    }

    public static ItemOption create(@NotNull Supplier<class_1792> defaultValue, boolean allowAir) {
        return new ItemOption(defaultValue, allowAir);
    }

    private static class Parser
    implements ConfigParser<class_1792> {
        private final boolean allowAir;

        private Parser(boolean allowAir) {
            this.allowAir = allowAir;
        }

        @Override
        @NotNull
        public class_1792 tryParse(@NotNull String cleanLine) throws ConfigParsingException {
            if (cleanLine.isBlank() && this.allowAir) {
                return class_1802.field_8162;
            }
            class_2960 itemID = ResourceOption.PARSER.tryParse(cleanLine);
            if (!class_7923.field_41178.method_10250(itemID)) {
                throw new ConfigParsingException("No item found with id " + itemID + "!");
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemID);
            if (item == class_1802.field_8162 && !this.allowAir) {
                throw new ConfigParsingException("Air is not an allowed item!");
            }
            return item;
        }

        @Override
        @NotNull
        public String write(@NotNull class_1792 value) {
            return ResourceOption.PARSER.write(class_7923.field_41178.method_10221((Object)value));
        }
    }
}

