/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumOption<T extends Enum<T>>
extends ConfigOption<T> {
    private final ConfigParser<T> parser;
    private final Class<T> clazz;

    public static <T extends Enum<T>> ConfigParser<T> buildParser(@NotNull Class<T> clazz) {
        return new EnumParser<T>(clazz);
    }

    protected EnumOption(@NotNull Supplier<T> defaultValue, Class<T> clazz) {
        super(defaultValue);
        this.parser = EnumOption.buildParser(clazz);
        this.clazz = clazz;
    }

    @Override
    @NotNull
    protected ConfigParser<T> getParser() {
        return this.parser;
    }

    @Override
    @Nullable
    protected String bonusComment() {
        StringBuilder builder = new StringBuilder("Options: ");
        boolean comma = false;
        for (Enum option : (Enum[])this.clazz.getEnumConstants()) {
            if (comma) {
                builder.append(", ");
            } else {
                comma = true;
            }
            builder.append(option.name());
        }
        return builder.toString();
    }

    public static <T extends Enum<T>> EnumOption<T> create(@NotNull T defaultValue) {
        return new EnumOption<Enum>(() -> defaultValue, defaultValue.getClass());
    }

    public static <T extends Enum<T>> EnumOption<T> create(@NotNull Supplier<T> defaultValue, @NotNull Class<?> clazz) {
        return new EnumOption<T>(defaultValue, clazz);
    }

    private static class EnumParser<T extends Enum<T>>
    implements ConfigParser<T> {
        private final Class<T> clazz;

        private EnumParser(@NotNull Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        @NotNull
        public T tryParse(@NotNull String cleanLine) throws ConfigParsingException {
            Enum result = EnumUtil.enumFromString((String)cleanLine, (Enum[])((Enum[])this.clazz.getEnumConstants()), null);
            if (result == null) {
                throw new ConfigParsingException(cleanLine + " is not a valid enum option!");
            }
            return (T)result;
        }

        @Override
        @NotNull
        public String write(@NotNull T value) {
            return ((Enum)value).name();
        }
    }
}

