/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class BooleanOption
extends ConfigOption<Boolean> {
    public static final ConfigParser<Boolean> PARSER = new Parser();

    protected BooleanOption(@NotNull Supplier<Boolean> defaultValue) {
        super(defaultValue);
    }

    @Override
    @NotNull
    protected ConfigParser<Boolean> getParser() {
        return PARSER;
    }

    public static BooleanOption createTrue() {
        return BooleanOption.create(() -> true);
    }

    public static BooleanOption createFalse() {
        return BooleanOption.create(() -> false);
    }

    public static BooleanOption create(@NotNull Supplier<Boolean> defaultValue) {
        return new BooleanOption(defaultValue);
    }

    private static class Parser
    implements ConfigParser<Boolean> {
        private Parser() {
        }

        @Override
        @NotNull
        public Boolean tryParse(@NotNull String cleanLine) throws ConfigParsingException {
            return Boolean.parseBoolean(cleanLine);
        }

        @Override
        @NotNull
        public String write(@NotNull Boolean value) {
            return Boolean.toString(value);
        }
    }
}

