/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mapping.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.FieldDef;
import net.fabricmc.mapping.tree.MethodDef;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.mapping.util.ClassMapper;
import net.fabricmc.mapping.util.EntryTriple;
import org.spongepowered.asm.mixin.extensibility.IRemapper;

public class MixinRemapper
implements IRemapper {
    private final Map<EntryTriple, String> fieldNames = new HashMap<EntryTriple, String>();
    private final Map<EntryTriple, String> methodNames = new HashMap<EntryTriple, String>();
    private final ClassMapper mapper;
    private final ClassMapper unmapper;

    public MixinRemapper(TinyTree mapping, String from, String to) {
        this(mapping.getClasses(), from, to);
    }

    public MixinRemapper(Collection<ClassDef> classes, String from, String to) {
        HashMap<String, String> classNames = new HashMap<String, String>();
        HashMap<String, String> unmapClassNames = new HashMap<String, String>();
        for (ClassDef clz : classes) {
            String className = clz.getName(from);
            String mappedClassName = clz.getName(to);
            classNames.put(className, mappedClassName);
            unmapClassNames.put(mappedClassName, className);
            for (FieldDef field : clz.getFields()) {
                this.fieldNames.put(new EntryTriple(className, field.getName(from), field.getDescriptor(from)), field.getName(to));
            }
            for (MethodDef method : clz.getMethods()) {
                this.methodNames.put(new EntryTriple(className, method.getName(from), method.getDescriptor(from)), method.getName(to));
            }
        }
        this.mapper = new ClassMapper(classNames);
        this.unmapper = new ClassMapper(unmapClassNames);
    }

    public String mapMethodName(String owner, String name, String desc) {
        return this.methodNames.getOrDefault(new EntryTriple(owner, name, desc), name);
    }

    public String mapFieldName(String owner, String name, String desc) {
        return this.fieldNames.getOrDefault(new EntryTriple(owner, name, desc), name);
    }

    public String map(String typeName) {
        return this.mapper.mapClass(typeName);
    }

    public String unmap(String typeName) {
        return this.unmapper.mapClass(typeName);
    }

    public String mapDesc(String desc) {
        return this.mapper.mapDescriptor(desc);
    }

    public String unmapDesc(String desc) {
        return this.unmapper.mapDescriptor(desc);
    }
}

