/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1492;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1693;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2501;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;
import net.minecraft.class_7298;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.AbstractHorseAccessor;
import vazkii.botania.mixin.RandomizableContainerBlockEntityAccessor;

public class SpectatorItem
extends BaubleItem {
    private static final int[] EMPTY_ENTITIES_ARRAY = new int[0];
    private static final long[] EMPTY_BLOCKPOS_ARRAY = new long[0];
    public static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
    public static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock";
    public static final int RANGE_ENTITIES = 24;
    public static final int RANGE_BLOCKS = 12;
    public static final int SCAN_INTERVAL_TICKS = 4;

    public SpectatorItem(class_1792.class_1793 props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(class_1799 stack, class_1309 living) {
        if (!(living instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)living;
        if (living.method_37908().field_9236) {
            this.showScanResults(stack, player);
        } else if (living.field_6012 % 4 == 0) {
            this.scanForItems(stack, player);
        }
    }

    @Override
    public void onUnequipped(class_1799 stack, class_1309 entity) {
        ItemNBTHelper.removeEntry(stack, TAG_BLOCK_POSITIONS);
        ItemNBTHelper.removeEntry(stack, TAG_ENTITY_POSITIONS);
    }

    protected void showScanResults(class_1799 stack, class_1657 player) {
        int[] entities;
        long[] blockPosLongs;
        if (player != Proxy.INSTANCE.getClientPlayer()) {
            return;
        }
        for (long blockPosLong : blockPosLongs = ItemNBTHelper.verifyType(stack, TAG_BLOCK_POSITIONS, class_2501.class) ? ItemNBTHelper.getLongArray(stack, TAG_BLOCK_POSITIONS) : EMPTY_BLOCKPOS_ARRAY) {
            class_2338 pos = class_2338.method_10092((long)blockPosLong);
            float m = 0.02f;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), false);
            player.method_37908().method_8406((class_2394)data, (double)((float)pos.method_10263() + (float)Math.random()), (double)((float)pos.method_10264() + (float)Math.random()), (double)((float)pos.method_10260() + (float)Math.random()), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)), (double)(m * (float)(Math.random() - 0.5)));
        }
        for (int i : entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS)) {
            class_1297 e = player.method_37908().method_8469(i);
            if (e == null || !e.method_5805() || !(Math.random() < 0.6)) continue;
            WispParticleData data = WispParticleData.wisp(0.15f + 0.05f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), Math.random() < 0.6);
            player.method_37908().method_8406((class_2394)data, e.method_23317() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.method_23318() + (double)e.method_17682(), e.method_23321() + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), 0.0, (double)(0.05f + 0.03f * (float)Math.random()), 0.0);
        }
    }

    public void scanForItems(class_1799 stack, class_1657 player) {
        class_1799 mainHandStack = player.method_6047();
        class_1799 offHandStack = player.method_6079();
        int[] entityIds = this.scanEntities(player, mainHandStack, offHandStack);
        ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, entityIds);
        long[] blockPositionLongs = this.scanBlockContainers(player, mainHandStack, offHandStack);
        ItemNBTHelper.setLongArray(stack, TAG_BLOCK_POSITIONS, blockPositionLongs);
    }

    private int[] scanEntities(class_1657 player, class_1799 mainHandStack, class_1799 offHandStack) {
        boolean emptyHands;
        boolean bl = emptyHands = mainHandStack.method_7960() && offHandStack.method_7960();
        if (emptyHands && !player.method_5715()) {
            return EMPTY_ENTITIES_ARRAY;
        }
        IntArrayList entityIds = new IntArrayList();
        List entities = player.method_37908().method_18467(class_1297.class, new class_238(player.method_24515()).method_1014(24.0));
        for (class_1297 e : entities) {
            class_1693 minecart;
            class_1263 inv;
            class_7298 allay;
            class_1492 horse;
            if (e == player) continue;
            if (e instanceof class_1542) {
                class_1542 item = (class_1542)e;
                class_1799 entityStack = item.method_6983();
                if (player.method_5715() || this.equalStacks(entityStack, mainHandStack, offHandStack)) {
                    entityIds.add(item.method_5628());
                }
            } else if (emptyHands) continue;
            if (e instanceof class_1657) {
                class_1657 targetPlayer = (class_1657)e;
                if (this.scanInventory((class_1263)targetPlayer.method_31548(), mainHandStack, offHandStack)) {
                    entityIds.add(targetPlayer.method_5628());
                    continue;
                }
                class_1263 baubleInventory = BotaniaAPI.instance().getAccessoriesInventory(targetPlayer);
                if (!this.scanInventory(baubleInventory, mainHandStack, offHandStack)) continue;
                entityIds.add(targetPlayer.method_5628());
                continue;
            }
            if (e instanceof class_1492 && (horse = (class_1492)e).method_6703()) {
                if (!this.scanInventory((class_1263)((AbstractHorseAccessor)horse).getInventory(), mainHandStack, offHandStack)) continue;
                entityIds.add(horse.method_5628());
                continue;
            }
            if (e instanceof class_7298 && (allay = (class_7298)e).method_43396()) {
                if (!this.equalStacks(allay.method_6047(), mainHandStack, offHandStack)) continue;
                entityIds.add(allay.method_5628());
                continue;
            }
            if (e instanceof class_1915) {
                class_1915 villager = (class_1915)e;
                for (class_1914 offer : villager.method_8264()) {
                    if (!this.equalStacks(offer.method_8246(), mainHandStack, offHandStack) && !this.equalStacks(offer.method_8247(), mainHandStack, offHandStack) && !this.equalStacks(offer.method_8250(), mainHandStack, offHandStack)) continue;
                    entityIds.add(e.method_5628());
                }
                continue;
            }
            if (!(e instanceof class_1263) || (inv = (class_1263)e) instanceof class_1693 && (minecart = (class_1693)inv).method_42276() != null || !this.scanInventory(inv, mainHandStack, offHandStack)) continue;
            entityIds.add(e.method_5628());
        }
        entityIds.trim();
        return entityIds.elements();
    }

    private long[] scanBlockContainers(class_1657 player, class_1799 mainHandStack, class_1799 offHandStack) {
        if (mainHandStack.method_7960() && offHandStack.method_7960()) {
            return EMPTY_BLOCKPOS_ARRAY;
        }
        LongArrayList blockPositions = new LongArrayList();
        class_2338.method_29715((class_238)new class_238(player.method_24515()).method_1014(12.0)).filter(pos -> this.scanBlock(player, (class_2338)pos, mainHandStack, offHandStack)).forEach(pos -> blockPositions.add(pos.method_10063()));
        blockPositions.trim();
        return blockPositions.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanBlock(class_1657 player, class_2338 pos, class_1799 mainHandStack, class_1799 offHandStack) {
        class_2586 blockEntity = player.method_37908().method_8321(pos);
        if (!(blockEntity instanceof class_1263)) return false;
        class_1263 inv = (class_1263)blockEntity;
        if (blockEntity instanceof class_2621) {
            class_2621 lootInv = (class_2621)blockEntity;
            if (((RandomizableContainerBlockEntityAccessor)lootInv).getLootTable() != null) return false;
        }
        if (!this.scanInventory(inv, mainHandStack, offHandStack)) return false;
        return true;
    }

    private boolean equalStacks(class_1799 testStack, class_1799 referenceStack1, class_1799 referenceStack2) {
        return !testStack.method_7960() && (class_1799.method_31577((class_1799)testStack, (class_1799)referenceStack1) || class_1799.method_31577((class_1799)testStack, (class_1799)referenceStack2));
    }

    private boolean scanInventory(class_1263 inv, class_1799 mainHandStack, class_1799 offHandStack) {
        for (int l = 0; l < inv.method_5439(); ++l) {
            class_1799 inventoryStack = inv.method_5438(l);
            if (inventoryStack == null || !this.equalStacks(inventoryStack, mainHandStack, offHandStack)) continue;
            return true;
        }
        return false;
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean armor = !living.method_6118(class_1304.field_6169).method_7960();
            bipedModel.field_3398.method_22703(ms);
            ms.method_22904(-0.35, -0.2, armor ? 0.05 : 0.1);
            ms.method_22905(0.75f, -0.75f, -0.75f);
            class_1087 model = MiscellaneousModels.INSTANCE.itemFinderGem;
            class_4588 buffer = buffers.getBuffer(class_4722.method_24074());
            class_310.method_1551().method_1541().method_3350().method_3367(ms.method_23760(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
        }
    }
}

