/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.mana;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ManaProficiencyArmor;
import vazkii.botania.api.mana.ManaDiscountArmor;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaItemHandlerImpl
implements ManaItemHandler {
    @Override
    public List<class_1799> getManaItems(class_1657 player) {
        if (player == null) {
            return Collections.emptyList();
        }
        ArrayList<class_1799> toReturn = new ArrayList<class_1799>();
        for (class_1799 stackInSlot : Iterables.concat((Iterable)player.method_31548().field_7547, (Iterable)player.method_31548().field_7544)) {
            if (stackInSlot.method_7960() || XplatAbstractions.INSTANCE.findManaItem(stackInSlot) == null) continue;
            toReturn.add(stackInSlot);
        }
        XplatAbstractions.INSTANCE.fireManaItemEvent(player, toReturn);
        return toReturn;
    }

    @Override
    public List<class_1799> getManaAccesories(class_1657 player) {
        if (player == null) {
            return Collections.emptyList();
        }
        class_1263 acc = BotaniaAPI.instance().getAccessoriesInventory(player);
        ArrayList<class_1799> toReturn = new ArrayList<class_1799>(acc.method_5439());
        for (int slot = 0; slot < acc.method_5439(); ++slot) {
            class_1799 stackInSlot = acc.method_5438(slot);
            if (stackInSlot.method_7960() || XplatAbstractions.INSTANCE.findManaItem(stackInSlot) == null) continue;
            toReturn.add(stackInSlot);
        }
        return toReturn;
    }

    @Override
    public int requestMana(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
        if (stack.method_7960()) {
            return 0;
        }
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        int manaReceived = 0;
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            ManaItem requestor;
            ManaItem manaItem;
            if (stackInSlot == stack || !(manaItem = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canExportManaToItem(stack) || manaItem.getMana() <= 0 || (requestor = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !requestor.canReceiveManaFromItem(stackInSlot)) continue;
            int mana = Math.min(manaToGet - manaReceived, manaItem.getMana());
            if (remove) {
                manaItem.addMana(-mana);
            }
            if ((manaReceived += mana) < manaToGet) continue;
            break;
        }
        return manaReceived;
    }

    @Override
    public boolean requestManaExact(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
        if (stack.method_7960()) {
            return false;
        }
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        int manaReceived = 0;
        Object2IntOpenHashMap manaToRemove = new Object2IntOpenHashMap();
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            ManaItem manaItem;
            ManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canExportManaToItem(stack) || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canReceiveManaFromItem(stackInSlot)) continue;
            int mana = Math.min(manaToGet - manaReceived, manaItemSlot.getMana());
            if (remove) {
                manaToRemove.put((Object)manaItemSlot, mana);
            }
            if ((manaReceived += mana) < manaToGet) continue;
            break;
        }
        if (manaReceived == manaToGet) {
            for (Object2IntMap.Entry e : manaToRemove.object2IntEntrySet()) {
                ((ManaItem)e.getKey()).addMana(-e.getIntValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public int dispatchMana(class_1799 stack, class_1657 player, int manaToSend, boolean add) {
        if (stack.method_7960()) {
            return 0;
        }
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            ManaItem manaItem;
            ManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canReceiveManaFromItem(stack) || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canExportManaToItem(stackInSlot)) continue;
            int received = manaItemSlot.getMana() + manaToSend <= manaItemSlot.getMaxMana() ? manaToSend : manaToSend - (manaItemSlot.getMana() + manaToSend - manaItemSlot.getMaxMana());
            if (add) {
                manaItemSlot.addMana(manaToSend);
            }
            return received;
        }
        return 0;
    }

    @Override
    public boolean dispatchManaExact(class_1799 stack, class_1657 player, int manaToSend, boolean add) {
        if (stack.method_7960()) {
            return false;
        }
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            ManaItem manaItem;
            ManaItem manaItemSlot;
            if (stackInSlot == stack || (manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)).getMana() + manaToSend > manaItemSlot.getMaxMana() || !manaItemSlot.canReceiveManaFromItem(stack) || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canExportManaToItem(stackInSlot)) continue;
            if (add) {
                manaItemSlot.addMana(manaToSend);
            }
            return true;
        }
        return false;
    }

    private int discountManaForTool(class_1799 stack, class_1657 player, int inCost) {
        float multiplier = Math.max(0.0f, 1.0f - this.getFullDiscountForTools(player, stack));
        return (int)((float)inCost * multiplier);
    }

    @Override
    public int requestManaForTool(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestMana(stack, player, cost, remove);
    }

    @Override
    public boolean requestManaExactForTool(class_1799 stack, class_1657 player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestManaExact(stack, player, cost, remove);
    }

    @Override
    public int getInvocationCountForTool(class_1799 stack, class_1657 player, int manaToGet) {
        if (stack.method_7960()) {
            return 0;
        }
        int cost = this.discountManaForTool(stack, player, manaToGet);
        int invocations = 0;
        List<class_1799> items = this.getManaItems(player);
        List<class_1799> acc = this.getManaAccesories(player);
        for (class_1799 stackInSlot : Iterables.concat(items, acc)) {
            ManaItem manaItem;
            if (stackInSlot == stack) continue;
            ManaItem manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot);
            int availableMana = manaItemSlot.getMana();
            if (!manaItemSlot.canExportManaToItem(stack) || availableMana <= cost || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canReceiveManaFromItem(stackInSlot)) continue;
            invocations += availableMana / cost;
        }
        return invocations;
    }

    @Override
    public float getFullDiscountForTools(class_1657 player, class_1799 tool) {
        float discount = 0.0f;
        for (int i = 0; i < player.method_31548().field_7548.size(); ++i) {
            class_1792 class_17922;
            class_1799 armor = (class_1799)player.method_31548().field_7548.get(i);
            if (armor.method_7960() || !((class_17922 = armor.method_7909()) instanceof ManaDiscountArmor)) continue;
            ManaDiscountArmor discountArmor = (ManaDiscountArmor)class_17922;
            discount += discountArmor.getDiscount(armor, i, player, tool);
        }
        int unbreaking = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)tool);
        discount += (float)unbreaking * 0.05f;
        discount = XplatAbstractions.INSTANCE.fireManaDiscountEvent(player, discount, tool);
        return discount;
    }

    @Override
    public boolean hasProficiency(class_1657 player, class_1799 manaItem) {
        boolean proficient = false;
        for (class_1304 e : class_1304.values()) {
            ManaProficiencyArmor armor;
            class_1792 item;
            class_1799 stack;
            if (e.method_5925() != class_1304.class_1305.field_6178 || (stack = player.method_6118(e)).method_7960() || !((item = stack.method_7909()) instanceof ManaProficiencyArmor) || !(armor = (ManaProficiencyArmor)item).shouldGiveProficiency(stack, e, player, manaItem)) continue;
            proficient = true;
            break;
        }
        return XplatAbstractions.INSTANCE.fireManaProficiencyEvent(player, manaItem, proficient);
    }
}

