/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2158;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.OrechidRecipe;

public class MarimorphosisRecipe
extends OrechidRecipe {
    private final int weightBonus;
    private final class_6862<class_1959> biomes;

    public MarimorphosisRecipe(class_2960 id, StateIngredient input, StateIngredient output, int weight, class_2158.class_2159 successFunction, int weightBonus, class_6862<class_1959> biomes) {
        super(id, input, output, weight, successFunction);
        this.weightBonus = weightBonus;
        this.biomes = biomes;
    }

    @Override
    public int getWeight(@NotNull class_1937 level, @NotNull class_2338 pos) {
        if (level.method_23753(pos).method_40220(this.biomes)) {
            return this.getWeight() + this.weightBonus;
        }
        return this.getWeight();
    }

    @NotNull
    public class_3956<? extends MarimorphosisRecipe> method_17716() {
        return BotaniaRecipeTypes.MARIMORPHOSIS_TYPE;
    }

    @Override
    public class_1865<?> method_8119() {
        return BotaniaRecipeTypes.MARIMORPHOSIS_SERIALIZER;
    }

    public int getWeightBonus() {
        return this.weightBonus;
    }

    public class_6862<class_1959> getBiomes() {
        return this.biomes;
    }

    public static class Serializer
    implements class_1865<MarimorphosisRecipe> {
        public MarimorphosisRecipe fromJson(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
            OrechidRecipe base = (OrechidRecipe)BotaniaRecipeTypes.ORECHID_SERIALIZER.method_8121(recipeId, json);
            class_6862 biomes = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(class_3518.method_15265((JsonObject)json, (String)"biome_bonus_tag")));
            int weightBonus = class_3518.method_15282((JsonObject)json, (String)"biome_bonus", (int)0);
            if (base.getWeight() + weightBonus <= 0) {
                throw new JsonSyntaxException("Weight combined with bonus cannot be 0 or less");
            }
            return new MarimorphosisRecipe(recipeId, base.getInput(), base.getOutput(), base.getWeight(), base.getSuccessFunction(), weightBonus, (class_6862<class_1959>)biomes);
        }

        public MarimorphosisRecipe fromNetwork(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
            OrechidRecipe base = (OrechidRecipe)BotaniaRecipeTypes.ORECHID_SERIALIZER.method_8122(recipeId, buffer);
            class_6862 biomes = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)buffer.method_10810());
            int weightBonus = buffer.method_10816();
            return new MarimorphosisRecipe(recipeId, base.getInput(), base.getOutput(), base.getWeight(), base.getSuccessFunction(), weightBonus, (class_6862<class_1959>)biomes);
        }

        public void toNetwork(@NotNull class_2540 buffer, @NotNull MarimorphosisRecipe recipe) {
            BotaniaRecipeTypes.ORECHID_SERIALIZER.method_8124(buffer, (class_1860)recipe);
            buffer.method_10812(recipe.biomes.comp_327());
            buffer.method_10804(recipe.weightBonus);
        }
    }
}

