/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1438;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_7917;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.mixin.MushroomCowAccessor;

public class PollidisiacBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 6;
    private static final int MANA_COST = 12;

    public PollidisiacBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaFlowerBlocks.POLLIDISIAC, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.method_10997().field_9236 && this.getMana() >= 12) {
            class_238 pickupBounds = new class_238(this.method_11016()).method_1014(6.0);
            List items = this.method_10997().method_8390(class_1542.class, pickupBounds, itemEntity -> DelayHelper.canInteractWith(this, itemEntity));
            if (items.isEmpty()) {
                return;
            }
            class_238 bounds = new class_238(this.getEffectivePos()).method_1014(6.0);
            List animals = this.method_10997().method_8390(class_1429.class, bounds, Predicate.not(class_1296::method_6109));
            Collections.shuffle(animals);
            for (class_1429 animal : animals) {
                if (!animal.method_6479()) {
                    for (class_1542 item : items) {
                        if (!animal.method_6481(item.method_6983())) continue;
                        this.consumeFoodItem(item);
                        animal.method_6476(1200);
                        this.method_10997().method_8421((class_1297)animal, (byte)18);
                        break;
                    }
                    if (this.getMana() < 12) break;
                }
                if (!PollidisiacBlockEntity.isBrownMooshroomWithoutEffect(animal)) continue;
                for (class_1542 item : items) {
                    class_7917 effect;
                    class_1799 stack = item.method_6983();
                    if (!stack.method_31573(class_3489.field_15543) || (effect = class_7917.method_47380((class_1935)stack.method_7909())) == null) continue;
                    this.consumeFoodItem(item);
                    MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal;
                    cowAccessor.setEffect(effect.method_10188());
                    cowAccessor.setEffectDuration(effect.method_10187());
                    animal.method_5783(class_3417.field_18267, 2.0f, 1.0f);
                    break;
                }
                if (this.getMana() >= 12) continue;
                break;
            }
        }
    }

    private void consumeFoodItem(class_1542 itemEntity) {
        EntityHelper.shrinkItem(itemEntity);
        this.addMana(-12);
    }

    private static boolean isBrownMooshroomWithoutEffect(class_1429 animal) {
        class_1438 mushroomCow;
        if (animal instanceof class_1438 && (mushroomCow = (class_1438)animal).method_47847() == class_1438.class_4053.field_18110) {
            MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal;
            return cowAccessor.getEffect() == null;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 6);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return this.method_11016().equals((Object)this.getEffectivePos()) ? null : RadiusDescriptor.Rectangle.square(this.method_11016(), 6);
    }

    @Override
    public int getMaxMana() {
        return 120;
    }

    @Override
    public int getColor() {
        return 13584665;
    }
}

