/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.shared;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.text.NumberFormat;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.shared.LocaleHelper;
import vazkii.botania.common.handler.OrechidManager;

public class OrechidUIHelper {
    private static final float MAX_ACCEPTABLE_RATIO_ERROR = 0.05f;
    private static final int MAX_NUM_INPUTS_FOR_RATIO = 16;

    @NotNull
    public static class_2561 getPercentageComponent(double chance) {
        String chanceText = LocaleHelper.formatAsPercentage(chance, 1);
        return class_2561.method_43470((String)chanceText);
    }

    @NotNull
    public static class_2561 getRatioTooltipComponent(@NotNull IntIntPair ratio) {
        NumberFormat formatter = LocaleHelper.getIntegerFormat();
        return class_2561.method_43469((String)"botaniamisc.conversionRatio", (Object[])new Object[]{formatter.format(ratio.secondInt()), formatter.format(ratio.firstInt())});
    }

    @NotNull
    public static class_2561 getBiomeChanceTooltipComponent(double chance, @NotNull String biomeTranslationKey) {
        return class_2561.method_43469((String)"botaniamisc.conversionChanceBiome", (Object[])new Object[]{OrechidUIHelper.getPercentageComponent(chance), class_2561.method_43471((String)biomeTranslationKey).method_27692(class_124.field_1056)}).method_27692(class_124.field_1080);
    }

    @NotNull
    public static Stream<class_2561> getBiomeChanceAndRatioTooltipComponents(double chance, OrechidRecipe recipe) {
        String biomeTranslationKey = OrechidUIHelper.getPlayerBiomeTranslationKey();
        class_746 player = class_310.method_1551().field_1724;
        if (biomeTranslationKey == null || player == null) {
            return Stream.empty();
        }
        Double biomeChance = OrechidUIHelper.getChance(recipe, player.method_24515());
        if (biomeChance == null || class_3532.method_20390((double)chance, (double)biomeChance)) {
            return Stream.empty();
        }
        IntIntPair biomeRatio = OrechidUIHelper.getRatioForChance(biomeChance);
        return Stream.of(OrechidUIHelper.getBiomeChanceTooltipComponent(biomeChance, biomeTranslationKey), class_2561.method_43470((String)"(").method_10852(OrechidUIHelper.getRatioTooltipComponent(biomeRatio)).method_27693(")").method_27692(class_124.field_1080));
    }

    @Nullable
    public static <T extends OrechidRecipe> Double getChance(T recipe, @Nullable class_2338 pos) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        class_3956<? extends OrechidRecipe> type = recipe.method_17716();
        class_2680 state = recipe.getInput().getDisplayed().get(0);
        int totalWeight = OrechidManager.getTotalDisplayWeightAt((class_1937)level, type, state, pos);
        int weight = pos != null ? recipe.getWeight((class_1937)level, pos) : recipe.getWeight();
        return (double)weight / (double)totalWeight;
    }

    @NotNull
    public static IntIntPair getRatioForChance(double actualRatio) {
        int bestNumOutputs = 1;
        int bestNumInputs = (int)Math.round(1.0 / actualRatio);
        double bestError = OrechidUIHelper.calcError(actualRatio, bestNumOutputs, bestNumInputs);
        if (bestNumInputs < 16 && bestError > (double)0.05f) {
            int numOutputsNminus1 = 1;
            int numOutputsNminus2 = 0;
            int numInputsNminus1 = 0;
            int numInputsNminus2 = 1;
            double remainderN = actualRatio;
            do {
                int coefficientN = (int)Math.floor(remainderN);
                int numOutputsN = coefficientN * numOutputsNminus1 + numOutputsNminus2;
                int numInputsN = coefficientN * numInputsNminus1 + numInputsNminus2;
                if (numInputsN > 16) break;
                double errorN = OrechidUIHelper.calcError(actualRatio, numOutputsN, numInputsN);
                if (errorN < bestError) {
                    bestNumOutputs = numOutputsN;
                    bestNumInputs = numInputsN;
                    bestError = errorN;
                }
                numOutputsNminus2 = numOutputsNminus1;
                numOutputsNminus1 = numOutputsN;
                numInputsNminus2 = numInputsNminus1;
                numInputsNminus1 = numInputsN;
                remainderN = 1.0 / (remainderN - (double)coefficientN);
            } while (numInputsNminus1 != 0 && bestError > (double)0.05f);
        }
        return IntIntImmutablePair.of((int)bestNumInputs, (int)bestNumOutputs);
    }

    private static double calcError(double chance, int numOutputs, int numInputs) {
        return Math.abs((double)numOutputs / (double)numInputs - chance) / chance;
    }

    public static String getPlayerBiomeTranslationKey() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return null;
        }
        class_5321 biomeKey = player.method_37908().method_23753(player.method_24515()).method_40230().orElse(null);
        if (biomeKey == null) {
            return "argument.id.invalid";
        }
        return String.format("biome.%s.%s", biomeKey.method_29177().method_12836(), biomeKey.method_29177().method_12832());
    }
}

