/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.util;

import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3708;
import net.minecraft.class_3908;
import net.minecraft.class_4838;
import net.minecraft.class_5251;
import net.zestyblaze.lootr.advancement.GenericTrigger;
import net.zestyblaze.lootr.api.IHasOpeners;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.block.LootrShulkerBlock;
import net.zestyblaze.lootr.block.entities.LootrInventoryBlockEntity;
import net.zestyblaze.lootr.config.ConfigManager;
import net.zestyblaze.lootr.data.DataStorage;
import net.zestyblaze.lootr.data.SpecialChestInventory;
import net.zestyblaze.lootr.entity.LootrChestMinecartEntity;
import net.zestyblaze.lootr.init.ModAdvancements;
import net.zestyblaze.lootr.init.ModStats;
import net.zestyblaze.lootr.network.NetworkConstants;

public class ChestUtil {
    public static void handleLootSneak(class_2248 block, class_1937 level, class_2338 pos, class_1657 player) {
        ILootBlockEntity tile;
        if (level.method_8608() || player.method_7325()) {
            return;
        }
        class_2586 te = level.method_8321(pos);
        if (te instanceof ILootBlockEntity && (tile = (ILootBlockEntity)te).getOpeners().remove(player.method_5667())) {
            te.method_5431();
            tile.updatePacketViaState();
        }
    }

    public static void handleLootCartSneak(class_1937 level, LootrChestMinecartEntity cart, class_1657 player) {
        if (level.method_8608() || player.method_7325()) {
            return;
        }
        cart.getOpeners().remove(player.method_5667());
        NetworkConstants.sendCloseCart(cart.method_5628(), (class_3222)player);
    }

    public static class_2583 getInvalidStyle() {
        return ConfigManager.get().notifications.disable_message_styles ? class_2583.field_24360 : class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true));
    }

    public static class_2583 getDecayStyle() {
        return ConfigManager.get().notifications.disable_message_styles ? class_2583.field_24360 : class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true));
    }

    public static class_2583 getRefreshStyle() {
        return ConfigManager.get().notifications.disable_message_styles ? class_2583.field_24360 : class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true));
    }

    public static void handleLootChest(class_2248 block, class_1937 level, class_2338 pos, class_1657 player) {
        if (level.method_8608() || player.method_7325()) {
            if (player.method_7325()) {
                player.method_17355(null);
            }
            return;
        }
        class_2586 te = level.method_8321(pos);
        if (te instanceof ILootBlockEntity) {
            int refreshValue;
            ILootBlockEntity tile = (ILootBlockEntity)te;
            UUID tileId = tile.getTileId();
            if (tileId == null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.invalid_block").method_10862(ChestUtil.getInvalidStyle()), true);
                return;
            }
            if (DataStorage.isDecayed(tileId)) {
                level.method_22352(pos, true);
                ChestUtil.notifyDecay(player, tileId);
                return;
            }
            int decayValue = DataStorage.getDecayValue(tileId);
            if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).method_10862(ChestUtil.getDecayStyle()), true);
            } else if (decayValue == -1 && ConfigManager.isDecaying((class_3218)level, tile)) {
                ChestUtil.startDecay(player, tileId, decayValue);
            }
            GenericTrigger<UUID> trigger = ModAdvancements.CHEST_PREDICATE;
            if (block instanceof class_3708) {
                trigger = ModAdvancements.BARREL_PREDICATE;
            } else if (block instanceof LootrShulkerBlock) {
                trigger = ModAdvancements.SHULKER_PREDICATE;
            }
            trigger.trigger((class_3222)player, tileId);
            if (DataStorage.isRefreshed(tileId)) {
                DataStorage.refreshInventory(level, pos, tileId, (class_3222)player);
                ChestUtil.notifyRefresh(player, tileId);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).method_10862(ChestUtil.getRefreshStyle()), true);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing((class_3218)level, tile)) {
                ChestUtil.startRefresh(player, tileId, refreshValue);
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, tileId, pos, (class_3222)player, (class_2621)te, tile::unpackLootTable);
            if (provider == null) {
                return;
            }
            ChestUtil.checkScore((class_3222)player, tileId);
            if (ChestUtil.addOpener(tile, player)) {
                te.method_5431();
                tile.updatePacketViaState();
            }
            player.method_17355((class_3908)provider);
            class_4838.method_24733((class_1657)player, (boolean)true);
        }
    }

    private static boolean addOpener(IHasOpeners openable, class_1657 player) {
        return openable.getOpeners().add(player.method_5667());
    }

    public static void handleLootCart(class_1937 level, LootrChestMinecartEntity cart, class_1657 player) {
        int refreshValue;
        if (level.method_8608() || player.method_7325()) {
            if (player.method_7325()) {
                player.method_17355(null);
            }
            return;
        }
        ModAdvancements.CART_PREDICATE.trigger((class_3222)player, cart.method_5667());
        UUID tileId = cart.method_5667();
        if (DataStorage.isDecayed(tileId)) {
            cart.method_7516(cart.method_48923().method_48829());
            ChestUtil.notifyDecay(player, tileId);
            return;
        }
        int decayValue = DataStorage.getDecayValue(tileId);
        if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).method_10862(ChestUtil.getDecayStyle()), true);
        } else if (decayValue == -1 && ConfigManager.isDecaying((class_3218)level, cart)) {
            ChestUtil.startDecay(player, tileId, decayValue);
        }
        ChestUtil.addOpener(cart, player);
        ChestUtil.checkScore((class_3222)player, cart.method_5667());
        if (DataStorage.isRefreshed(tileId)) {
            DataStorage.refreshInventory(level, cart, (class_3222)player);
            ChestUtil.notifyRefresh(player, tileId);
        }
        if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).method_10862(ChestUtil.getRefreshStyle()), true);
        } else if (refreshValue == -1 && ConfigManager.isRefreshing((class_3218)level, cart)) {
            ChestUtil.startRefresh(player, tileId, refreshValue);
        }
        SpecialChestInventory provider = DataStorage.getInventory(level, cart, (class_3222)player, cart::addLoot);
        if (provider == null) {
            return;
        }
        player.method_17355((class_3908)provider);
    }

    public static void handleLootInventory(class_2248 block, class_1937 level, class_2338 pos, class_1657 player) {
        if (level.method_8608() || player.method_7325()) {
            if (player.method_7325()) {
                player.method_17355(null);
            }
            return;
        }
        class_2586 te = level.method_8321(pos);
        if (te instanceof LootrInventoryBlockEntity) {
            int refreshValue;
            UUID tileId;
            LootrInventoryBlockEntity tile = (LootrInventoryBlockEntity)te;
            ModAdvancements.CHEST_PREDICATE.trigger((class_3222)player, tile.getTileId());
            class_2371<class_1799> stacks = null;
            if (tile.getCustomInventory() != null) {
                stacks = ChestUtil.copyItemList(tile.getCustomInventory());
            }
            if (DataStorage.isRefreshed(tileId = tile.getTileId())) {
                DataStorage.refreshInventory(level, pos, tile.getTileId(), stacks, (class_3222)player);
                ChestUtil.notifyRefresh(player, tileId);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).method_10862(ChestUtil.getRefreshStyle()), true);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing((class_3218)level, tile)) {
                ChestUtil.startRefresh(player, tileId, refreshValue);
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, tile.getTileId(), stacks, (class_3222)player, pos, (class_2621)tile);
            if (provider == null) {
                return;
            }
            ChestUtil.checkScore((class_3222)player, tile.getTileId());
            if (ChestUtil.addOpener(tile, player)) {
                te.method_5431();
                tile.updatePacketViaState();
            }
            player.method_17355((class_3908)provider);
            class_4838.method_24733((class_1657)player, (boolean)true);
        }
    }

    public static class_2371<class_1799> copyItemList(class_2371<class_1799> reference) {
        class_2371 contents = class_2371.method_10213((int)reference.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((class_1799)reference.get(i)).method_7972());
        }
        return contents;
    }

    private static void checkScore(class_3222 player, UUID tileId) {
        if (!DataStorage.isScored(player.method_5667(), tileId)) {
            player.method_7259(ModStats.LOOTED_STAT);
            ModAdvancements.SCORE_PREDICATE.trigger(player, null);
            DataStorage.score(player.method_5667(), tileId);
        }
    }

    private static void notifyDecay(class_1657 player, UUID tileId) {
        player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.decayed").method_10862(ChestUtil.getDecayStyle()), true);
        DataStorage.removeDecayed(tileId);
    }

    private static void notifyRefresh(class_1657 player, UUID tileId) {
        DataStorage.removeRefreshed(tileId);
        player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.refreshed").method_10862(ChestUtil.getRefreshStyle()), true);
    }

    private static void startDecay(class_1657 player, UUID tileId, int decayValue) {
        DataStorage.setDecaying(tileId, ConfigManager.get().decay.decay_value);
        player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_start", (Object[])new Object[]{ConfigManager.get().decay.decay_value / 20}).method_10862(ChestUtil.getDecayStyle()), true);
    }

    private static void startRefresh(class_1657 player, UUID tileId, int refreshValue) {
        DataStorage.setRefreshing(tileId, ConfigManager.get().refresh.refresh_value);
        player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_start", (Object[])new Object[]{ConfigManager.get().refresh.refresh_value / 20}).method_10862(ChestUtil.getRefreshStyle()), true);
    }
}

