/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.moremcmeta.moremcmeta.api.client.texture.FrameGroup;
import io.github.moremcmeta.moremcmeta.api.client.texture.PersistentFrameView;
import io.github.moremcmeta.moremcmeta.api.math.Point;
import io.github.moremcmeta.moremcmeta.impl.client.texture.BaseCollection;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CoreTextureComponent;
import io.github.moremcmeta.moremcmeta.impl.client.texture.EventDrivenTexture;
import io.github.moremcmeta.moremcmeta.impl.client.texture.TexturePreparer;
import java.util.Objects;
import net.minecraft.class_2960;

public final class UploadComponent
implements CoreTextureComponent {
    private final TexturePreparer PREPARER;
    private final BaseCollection BASE_DATA;

    public UploadComponent(TexturePreparer preparer, BaseCollection baseData) {
        this.PREPARER = Objects.requireNonNull(preparer, "Preparer cannot be null");
        this.BASE_DATA = Objects.requireNonNull(baseData, "Base data cannot be null");
    }

    @Override
    public void onRegistration(EventDrivenTexture.TextureAndFrameView currentFrame, FrameGroup<? extends PersistentFrameView> predefinedFrames) {
        currentFrame.lowerMipmapLevel(this.BASE_DATA.maxMipmap());
        EventDrivenTexture texture = currentFrame.texture();
        int frameWidth = currentFrame.width();
        int frameHeight = currentFrame.height();
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.prepareTexture(texture, frameWidth, frameHeight));
        } else {
            this.prepareTexture(texture, frameWidth, frameHeight);
        }
    }

    @Override
    public void onUpload(EventDrivenTexture.TextureAndFrameView currentFrame, class_2960 baseLocation) {
        this.BASE_DATA.baseData(baseLocation).forEach(base -> {
            long uploadPoint = base.uploadPoint();
            currentFrame.upload(Point.x(uploadPoint), Point.y(uploadPoint), base.mipmap());
        });
    }

    private void prepareTexture(EventDrivenTexture texture, int frameWidth, int frameHeight) {
        this.PREPARER.prepare(texture.method_4624(), 0, frameWidth, frameHeight);
    }
}

