/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import io.github.moremcmeta.moremcmeta.api.client.texture.ColorTransform;
import io.github.moremcmeta.moremcmeta.api.client.texture.CurrentFrameView;
import io.github.moremcmeta.moremcmeta.api.client.texture.FrameGroup;
import io.github.moremcmeta.moremcmeta.api.client.texture.IllegalFrameReferenceException;
import io.github.moremcmeta.moremcmeta.api.client.texture.NegativeUploadPointException;
import io.github.moremcmeta.moremcmeta.api.client.texture.PersistentFrameView;
import io.github.moremcmeta.moremcmeta.api.client.texture.TextureComponent;
import io.github.moremcmeta.moremcmeta.api.math.Area;
import io.github.moremcmeta.moremcmeta.api.math.Point;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CloseableImageFrame;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CoreTextureComponent;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CustomTickable;
import io.github.moremcmeta.moremcmeta.impl.client.texture.FrameGroupImpl;
import io.github.moremcmeta.moremcmeta.impl.client.texture.PredefinedFrameView;
import io.github.moremcmeta.moremcmeta.impl.client.texture.UploadableFrameView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class EventDrivenTexture
extends class_1044
implements CustomTickable {
    public static final long SELF_UPLOAD_POINT = Point.pack(0, 0);
    public static final int SELF_MIPMAP_LEVEL = 0;
    private final List<CoreTextureComponent> COMPONENTS;
    private final TextureState CURRENT_STATE;
    private int ticks;

    public void method_4527(boolean blur, boolean clamp) {
        this.method_23207();
    }

    public void method_4625(@Nullable class_3300 resourceManager) {
        this.runListeners((component, view) -> component.onRegistration((TextureAndFrameView)view, (FrameGroup<? extends PersistentFrameView>)this.CURRENT_STATE.predefinedFrames()));
    }

    @Override
    public void tick() {
        this.runListeners((component, view) -> component.onTick(view, this.CURRENT_STATE.predefinedFrames()));
        this.ticks = Math.max(0, this.ticks + 1);
    }

    public void close() {
        this.runListeners((component, view) -> component.onClose(view, this.CURRENT_STATE.predefinedFrames()));
    }

    public void upload(class_2960 base) {
        Objects.requireNonNull(base, "Base cannot be null");
        if (this.ticks > 0) {
            this.runListeners((component, view) -> component.onTick(view, this.CURRENT_STATE.predefinedFrames(), this.ticks));
            this.ticks = 0;
        }
        if (!this.CURRENT_STATE.BASES_UPLOADED_SINCE_UPDATE.contains(base)) {
            this.CURRENT_STATE.BASES_UPLOADED_SINCE_UPDATE.add(base);
            this.runListeners((textureComponent, textureAndFrameView) -> textureComponent.onUpload((TextureAndFrameView)textureAndFrameView, base));
        }
    }

    private void runListeners(BiConsumer<CoreTextureComponent, TextureAndFrameView> method) {
        for (int layer = 0; layer < this.COMPONENTS.size(); ++layer) {
            TextureAndFrameView view = new TextureAndFrameView(this.CURRENT_STATE, layer);
            method.accept(this.COMPONENTS.get(layer), view);
            view.invalidate();
        }
    }

    private EventDrivenTexture(List<CoreTextureComponent> components, List<? extends CloseableImageFrame> predefinedFrames, CloseableImageFrame generatedFrame) {
        this.COMPONENTS = components;
        this.CURRENT_STATE = new TextureState(this, predefinedFrames, generatedFrame);
    }

    private static class TextureState {
        private final EventDrivenTexture TEXTURE;
        private final List<? extends CloseableImageFrame> PREDEFINED_FRAMES;
        private final FrameGroup<PersistentFrameView> PREDEFINED_FRAME_GROUP;
        private final CloseableImageFrame GENERATED_FRAME;
        private final Set<class_2960> BASES_UPLOADED_SINCE_UPDATE;
        private Integer currentFrameIndex;

        public void generateWith(ColorTransform transform, Area applyArea, int layer) {
            Objects.requireNonNull(transform, "Frame transform cannot be null");
            Objects.requireNonNull(applyArea, "Apply area cannot be null");
            this.markNeedsUpload();
            this.currentFrameIndex = null;
            this.GENERATED_FRAME.applyTransform(transform, applyArea, layer);
        }

        public int width() {
            return this.PREDEFINED_FRAMES.get(0).width();
        }

        public int height() {
            return this.PREDEFINED_FRAMES.get(0).height();
        }

        public EventDrivenTexture texture() {
            return this.TEXTURE;
        }

        public void uploadAt(int x, int y, int mipmap) {
            this.currentFrame().uploadAt(x, y, mipmap);
        }

        public void lowerMipmapLevel(int newMipmapLevel) {
            for (CloseableImageFrame closeableImageFrame : this.PREDEFINED_FRAMES) {
                closeableImageFrame.lowerMipmapLevel(newMipmapLevel);
            }
            this.GENERATED_FRAME.lowerMipmapLevel(newMipmapLevel);
        }

        public FrameGroup<PersistentFrameView> predefinedFrames() {
            return this.PREDEFINED_FRAME_GROUP;
        }

        private TextureState(EventDrivenTexture texture, List<? extends CloseableImageFrame> predefinedFrames, CloseableImageFrame generatedFrame) {
            this.TEXTURE = texture;
            this.PREDEFINED_FRAMES = predefinedFrames;
            this.PREDEFINED_FRAME_GROUP = new FrameGroupImpl<PersistentFrameView>(predefinedFrames, (frame, index) -> new PredefinedFrameView((CloseableImageFrame)frame));
            this.GENERATED_FRAME = generatedFrame;
            this.BASES_UPLOADED_SINCE_UPDATE = new HashSet<class_2960>();
            this.replaceWith(0);
        }

        private void replaceWith(int index) {
            if (this.currentFrameIndex != null && index == this.currentFrameIndex) {
                return;
            }
            this.markNeedsUpload();
            this.currentFrameIndex = index;
        }

        private void markNeedsUpload() {
            this.BASES_UPLOADED_SINCE_UPDATE.clear();
        }

        private CloseableImageFrame currentFrame() {
            return this.currentFrameIndex == null ? this.GENERATED_FRAME : this.PREDEFINED_FRAMES.get(this.currentFrameIndex);
        }
    }

    public static final class TextureAndFrameView
    implements CurrentFrameView,
    UploadableFrameView {
        private final TextureState STATE;
        private final int LAYER;
        private boolean valid;

        @Override
        public void generateWith(ColorTransform transform, Area applyArea) {
            this.checkValid();
            this.STATE.generateWith(transform, applyArea, this.LAYER);
        }

        @Override
        public int width() {
            this.checkValid();
            return this.STATE.width();
        }

        @Override
        public int height() {
            this.checkValid();
            return this.STATE.height();
        }

        public EventDrivenTexture texture() {
            this.checkValid();
            return this.STATE.texture();
        }

        @Override
        public void upload(int x, int y, int mipmap) {
            this.checkValid();
            if (x < 0 || y < 0) {
                throw new NegativeUploadPointException(x, y);
            }
            this.STATE.uploadAt(x, y, mipmap);
        }

        public void lowerMipmapLevel(int newMipmapLevel) {
            this.checkValid();
            this.STATE.lowerMipmapLevel(newMipmapLevel);
        }

        @VisibleForTesting
        public void markNeedsUpload() {
            this.checkValid();
            this.STATE.markNeedsUpload();
        }

        private TextureAndFrameView(TextureState state, int layer) {
            this.STATE = state;
            this.LAYER = layer;
            this.valid = true;
        }

        private void checkValid() throws IllegalFrameReferenceException {
            if (!this.valid) {
                throw new IllegalFrameReferenceException();
            }
        }

        private void invalidate() {
            this.valid = false;
        }
    }

    public static final class Builder {
        private final List<CoreTextureComponent> COMPONENTS = new ArrayList<CoreTextureComponent>();
        private List<? extends CloseableImageFrame> predefinedFrames;
        private CloseableImageFrame generatedFrame;

        public Builder setPredefinedFrames(List<? extends CloseableImageFrame> frames) {
            Objects.requireNonNull(frames, "Predefined frames cannot be null");
            if (frames.size() == 0) {
                throw new IllegalArgumentException("Predefined frames cannot be empty");
            }
            if (frames.stream().mapToInt(CloseableImageFrame::mipmapLevel).distinct().count() > 1L) {
                throw new IllegalArgumentException("All predefined frames must have the same mipmap level");
            }
            if (frames.stream().mapToInt(CloseableImageFrame::width).distinct().count() > 1L) {
                throw new IllegalArgumentException("All predefined frames must have the same width");
            }
            if (frames.stream().mapToInt(CloseableImageFrame::height).distinct().count() > 1L) {
                throw new IllegalArgumentException("All predefined frames must have the same height");
            }
            if (frames.stream().mapToInt(CloseableImageFrame::layers).distinct().count() > 1L) {
                throw new IllegalArgumentException("All predefined frames must have the same number of layers");
            }
            this.predefinedFrames = frames;
            return this;
        }

        public Builder setGeneratedFrame(CloseableImageFrame frame) {
            Objects.requireNonNull(frame, "Generated frame cannot be null");
            this.generatedFrame = frame;
            return this;
        }

        public Builder add(final TextureComponent<? super TextureAndFrameView> component) {
            Objects.requireNonNull(component, "Component cannot be null");
            this.add(new CoreTextureComponent(){

                @Override
                public void onTick(TextureAndFrameView currentFrame, FrameGroup<? extends PersistentFrameView> predefinedFrames) {
                    component.onTick(currentFrame, predefinedFrames);
                }

                @Override
                public void onTick(TextureAndFrameView currentFrame, FrameGroup<? extends PersistentFrameView> predefinedFrames, int ticks) {
                    component.onTick(currentFrame, predefinedFrames, ticks);
                }

                @Override
                public void onClose(TextureAndFrameView currentFrame, FrameGroup<? extends PersistentFrameView> predefinedFrames) {
                    component.onClose(currentFrame, predefinedFrames);
                }
            });
            return this;
        }

        public Builder add(CoreTextureComponent component) {
            Objects.requireNonNull(component, "Component cannot be null");
            this.COMPONENTS.add(component);
            return this;
        }

        public EventDrivenTexture build() {
            if (this.predefinedFrames == null) {
                throw new IllegalStateException("Texture must have predefined frames");
            }
            if (this.generatedFrame == null) {
                throw new IllegalStateException("Texture must have a generated frame");
            }
            if (this.predefinedFrames.get(0).mipmapLevel() != this.generatedFrame.mipmapLevel()) {
                throw new IllegalStateException("Predefined frames and generated frame must have same mipmap level");
            }
            if (this.predefinedFrames.get(0).width() != this.generatedFrame.width()) {
                throw new IllegalStateException("Predefined frames and generated frame must have same width");
            }
            if (this.predefinedFrames.get(0).height() != this.generatedFrame.height()) {
                throw new IllegalStateException("Predefined frames and generated frame must have same height");
            }
            int components = this.COMPONENTS.size();
            int predefinedLayers = this.predefinedFrames.get(0).layers();
            if (components > 0 && predefinedLayers != components) {
                throw new IllegalStateException(String.format("Predefined frames have %s layers but there are %s components; must be the same", predefinedLayers, components));
            }
            int generatedLayers = this.generatedFrame.layers();
            if (components > 0 && generatedLayers != components) {
                throw new IllegalStateException(String.format("Generated frame %s layers but there are %s components; must be the same", generatedLayers, components));
            }
            return new EventDrivenTexture(this.COMPONENTS, this.predefinedFrames, this.generatedFrame);
        }
    }
}

