/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import com.google.common.collect.ImmutableList;
import io.github.moremcmeta.moremcmeta.api.client.texture.ColorTransform;
import io.github.moremcmeta.moremcmeta.api.client.texture.PixelOutOfBoundsException;
import io.github.moremcmeta.moremcmeta.api.math.Area;
import io.github.moremcmeta.moremcmeta.api.math.Point;
import io.github.moremcmeta.moremcmeta.impl.adt.SparseIntMatrix;
import io.github.moremcmeta.moremcmeta.impl.client.io.FrameReader;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CloseableImage;
import io.github.moremcmeta.moremcmeta.impl.client.texture.ColorBlender;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CloseableImageFrame {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    private static final int SUB_AREA_SIZE_HINT = 16384;
    private final int WIDTH;
    private final int HEIGHT;
    private final ImmutableList<Layer> LOWER_LAYERS;
    private final TopLayer TOP_LAYER;
    private final int TOP_LAYER_INDEX;
    private ImmutableList<? extends CloseableImage> mipmaps;
    private boolean closed;

    public CloseableImageFrame(FrameReader.FrameData frameData, ImmutableList<? extends CloseableImage> mipmaps, int layers) {
        Objects.requireNonNull(frameData, "Frame data cannot be null");
        this.mipmaps = Objects.requireNonNull(mipmaps, "Mipmaps cannot be null");
        if (mipmaps.isEmpty()) {
            throw new IllegalArgumentException("At least one mipmap must be provided");
        }
        int frameWidth = frameData.width();
        int frameHeight = frameData.height();
        for (int level = 0; level < mipmaps.size(); ++level) {
            CloseableImage image = (CloseableImage)mipmaps.get(level);
            int imageWidth = image.width();
            int imageHeight = image.height();
            if (imageWidth == frameWidth >> level && imageHeight == frameHeight >> level) continue;
            throw new IllegalArgumentException(String.format("Mipmap %s of size %sx%s conflicts with frame size %sx%s", level, imageWidth, imageHeight, frameWidth, frameHeight));
        }
        this.WIDTH = frameWidth;
        this.HEIGHT = frameHeight;
        this.closed = false;
        if (layers < 1) {
            throw new IllegalArgumentException(String.format("Layers must be positive: %s", layers));
        }
        if (layers > 128) {
            throw new IllegalArgumentException(String.format("Maximum number of layers is 128, was %s", layers));
        }
        this.TOP_LAYER = new TopLayer((CloseableImage)mipmaps.get(0), this.WIDTH, this.HEIGHT, (byte)(layers - 1));
        ImmutableList.Builder layerBuilder = new ImmutableList.Builder();
        if (layers > 1) {
            BottomLayer bottomLayer = new BottomLayer(this.TOP_LAYER, this.WIDTH, this.HEIGHT);
            this.TOP_LAYER.setBottomLayer(bottomLayer);
            Layer lastLayer = bottomLayer;
            for (byte layerIndex = 0; layerIndex < layers - 1; layerIndex = (byte)(layerIndex + 1)) {
                lastLayer = new MiddleLayer(this.TOP_LAYER, lastLayer, this.WIDTH, this.HEIGHT, layerIndex);
                layerBuilder.add((Object)lastLayer);
            }
        }
        this.LOWER_LAYERS = layerBuilder.build();
        this.TOP_LAYER_INDEX = this.LOWER_LAYERS.size();
    }

    public int color(int x, int y) {
        this.checkOpen();
        return ((CloseableImage)this.mipmaps.get(0)).color(x, y);
    }

    public void uploadAt(int x, int y, int mipmap) {
        this.checkOpen();
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Point coordinates must be greater than zero");
        }
        if (mipmap < 0) {
            throw new IllegalArgumentException("Mipmap cannot be negative, but was " + mipmap);
        }
        if (mipmap >= this.mipmaps.size()) {
            throw new IllegalArgumentException("Provided mipmap level " + mipmap + " is greater than frame mipmap level " + (this.mipmaps.size() - 1));
        }
        for (int level = 0; level <= mipmap; ++level) {
            int mipmappedX = x >> level;
            int mipmappedY = y >> level;
            CloseableImage mipmapImage = (CloseableImage)this.mipmaps.get(level);
            int mipmappedWidth = mipmapImage.width();
            int mipmappedHeight = mipmapImage.height();
            if (mipmappedWidth <= 0 || mipmappedHeight <= 0) continue;
            mipmapImage.upload(mipmappedX, mipmappedY);
        }
    }

    public int width() {
        this.checkOpen();
        return this.WIDTH;
    }

    public int height() {
        this.checkOpen();
        return this.HEIGHT;
    }

    public int mipmapLevel() {
        this.checkOpen();
        return this.mipmaps.size() - 1;
    }

    public void lowerMipmapLevel(int newMipmapLevel) {
        this.checkOpen();
        if (newMipmapLevel == this.mipmapLevel()) {
            return;
        }
        if (newMipmapLevel < 0) {
            throw new IllegalArgumentException("New mipmap level must be at least zero");
        }
        if (newMipmapLevel > this.mipmapLevel()) {
            throw new IllegalArgumentException("New mipmap level " + newMipmapLevel + " is greater than current mipmap level " + this.mipmapLevel());
        }
        for (int level = newMipmapLevel + 1; level < this.mipmaps.size(); ++level) {
            ((CloseableImage)this.mipmaps.get(level)).close();
        }
        this.mipmaps = this.mipmaps.subList(0, newMipmapLevel + 1);
    }

    public void applyTransform(ColorTransform transform, Area applyArea, int layer) {
        this.checkOpen();
        Objects.requireNonNull(transform, "Transform cannot be null");
        Objects.requireNonNull(applyArea, "Apply area cannot be null");
        if (layer < 0) {
            throw new IllegalArgumentException(String.format("Layer index cannot be negative: %s", layer));
        }
        if (layer > this.TOP_LAYER_INDEX) {
            throw new IllegalArgumentException(String.format("Layer index is out of bounds: %s when the max is %s", layer, this.TOP_LAYER_INDEX));
        }
        Layer layerBelow = this.layerBelow(layer);
        TopLayer thisLayer = layer == this.TOP_LAYER_INDEX ? this.TOP_LAYER : (Layer)this.LOWER_LAYERS.get(layer);
        ArrayList<LongList> results = new ArrayList<LongList>();
        if (applyArea.size() > 16384) {
            List<Callable> tasks = applyArea.split(16384).stream().map(subArea -> () -> this.applyTransform(transform, layerBelow, thisLayer, (Area)subArea)).toList();
            try {
                for (Future<Object> future : THREAD_POOL.invokeAll(tasks)) {
                    results.add((LongList)future.get());
                }
            }
            catch (InterruptedException err) {
                throw new RuntimeException("Parallel frame generation was interrupted", err);
            }
            catch (ExecutionException err) {
                throw new RuntimeException("Exception during frame generation", err);
            }
        } else {
            results.add(this.applyTransform(transform, layerBelow, thisLayer, applyArea));
        }
        for (int level = 1; level <= this.mipmapLevel(); ++level) {
            block5: for (LongList longList : results) {
                LongListIterator longListIterator = longList.iterator();
                while (longListIterator.hasNext()) {
                    long point = (Long)longListIterator.next();
                    int x = Point.x(point);
                    int y = Point.y(point);
                    if (((CloseableImage)this.mipmaps.get(level)).width() == 0 && ((CloseableImage)this.mipmaps.get(level)).height() == 0) continue block5;
                    int cornerX = CloseableImageFrame.makeEven(x >> level - 1);
                    int cornerY = CloseableImageFrame.makeEven(y >> level - 1);
                    CloseableImage prevImage = (CloseableImage)this.mipmaps.get(level - 1);
                    int topLeft = prevImage.color(cornerX, cornerY);
                    int topRight = prevImage.color(cornerX + 1, cornerY);
                    int bottomLeft = prevImage.color(cornerX, cornerY + 1);
                    int bottomRight = prevImage.color(cornerX + 1, cornerY + 1);
                    int blended = ColorBlender.blend(topLeft, topRight, bottomLeft, bottomRight);
                    ((CloseableImage)this.mipmaps.get(level)).setColor(x >> level, y >> level, blended);
                }
            }
        }
    }

    public int layers() {
        return this.TOP_LAYER_INDEX + 1;
    }

    public void close() {
        this.closed = true;
        this.mipmaps.forEach(CloseableImage::close);
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("Frame is closed");
        }
    }

    private Layer layerBelow(int layer) {
        if (this.TOP_LAYER_INDEX == 0) {
            return this.TOP_LAYER;
        }
        if (layer == 0) {
            return this.TOP_LAYER.bottomLayer;
        }
        return (Layer)this.LOWER_LAYERS.get(layer - 1);
    }

    private void checkPointInBounds(int x, int y) throws PixelOutOfBoundsException {
        if (x < 0 || y < 0 || x >= this.WIDTH || y >= this.HEIGHT) {
            throw new PixelOutOfBoundsException(x, y);
        }
    }

    private LongList applyTransform(ColorTransform transform, Layer layerBelow, Layer thisLayer, Area subArea) {
        LongArrayList modifiedPoints = new LongArrayList();
        subArea.forEach(arg_0 -> this.lambda$applyTransform$3(transform, layerBelow, thisLayer, (LongList)modifiedPoints, arg_0));
        return modifiedPoints;
    }

    private static int makeEven(int num) {
        return num & 0xFFFFFFFE;
    }

    private /* synthetic */ void lambda$applyTransform$3(ColorTransform transform, Layer layerBelow, Layer thisLayer, LongList modifiedPoints, long point) {
        int x = Point.x(point);
        int y = Point.y(point);
        this.checkPointInBounds(x, y);
        int newColor = transform.transform(x, y, (depX, depY) -> {
            this.checkPointInBounds(depX, depY);
            return layerBelow.read(depX, depY);
        });
        if (thisLayer.write(x, y, newColor)) {
            modifiedPoints.add(point);
        }
    }

    private static class TopLayer
    implements Layer {
        private final CloseableImage IMAGE;
        private final int WIDTH;
        private final byte INDEX;
        private final byte[] MODIFIED_BY;
        private BottomLayer bottomLayer;

        public TopLayer(CloseableImage image, int width, int height, byte index) {
            this.IMAGE = image;
            this.WIDTH = width;
            this.INDEX = index;
            this.MODIFIED_BY = new byte[width * height];
        }

        public void setBottomLayer(BottomLayer bottomLayer) {
            this.bottomLayer = bottomLayer;
        }

        public boolean tryWrite(int x, int y, int color, byte layer) {
            int pointIndex = this.pointIndex(x, y);
            if (layer < this.MODIFIED_BY[pointIndex]) {
                return false;
            }
            if (this.bottomLayer != null) {
                this.bottomLayer.tryWrite(x, y, this.read(x, y));
            }
            this.IMAGE.setColor(x, y, color);
            this.MODIFIED_BY[pointIndex] = layer;
            return true;
        }

        @Override
        public boolean write(int x, int y, int color) {
            return this.tryWrite(x, y, color, this.INDEX);
        }

        @Override
        public int read(int x, int y) {
            return this.IMAGE.color(x, y);
        }

        private int pointIndex(int x, int y) {
            return this.WIDTH * y + x;
        }
    }

    private static class BottomLayer
    implements Layer {
        private final TopLayer TOP_LAYER;
        private final byte INDEX;
        private final SparseIntMatrix POINTS;

        public BottomLayer(TopLayer topLayer, int width, int height) {
            this.TOP_LAYER = topLayer;
            this.INDEX = 0;
            this.POINTS = new SparseIntMatrix(width, height, 3);
        }

        public void tryWrite(int x, int y, int color) {
            if (!this.POINTS.isSet(x, y)) {
                this.POINTS.set(x, y, color);
            }
        }

        @Override
        public boolean write(int x, int y, int color) {
            this.POINTS.set(x, y, color);
            return this.TOP_LAYER.tryWrite(x, y, color, this.INDEX);
        }

        @Override
        public int read(int x, int y) {
            if (this.POINTS.isSet(x, y)) {
                return this.POINTS.get(x, y);
            }
            return this.TOP_LAYER.read(x, y);
        }
    }

    private static class MiddleLayer
    implements Layer {
        private final TopLayer TOP_LAYER;
        private final Layer LAYER_BELOW;
        private final byte INDEX;
        private final SparseIntMatrix POINTS;

        public MiddleLayer(TopLayer topLayer, Layer layerBelow, int width, int height, byte index) {
            this.TOP_LAYER = topLayer;
            this.LAYER_BELOW = layerBelow;
            this.INDEX = index;
            this.POINTS = new SparseIntMatrix(width, height, 3);
        }

        @Override
        public boolean write(int x, int y, int color) {
            this.POINTS.set(x, y, color);
            return this.TOP_LAYER.tryWrite(x, y, color, this.INDEX);
        }

        @Override
        public int read(int x, int y) {
            if (this.POINTS.isSet(x, y)) {
                return this.POINTS.get(x, y);
            }
            return this.LAYER_BELOW.read(x, y);
        }
    }

    private static interface Layer {
        public boolean write(int var1, int var2, int var3);

        public int read(int var1, int var2);
    }
}

