/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import io.github.moremcmeta.moremcmeta.api.math.Point;
import io.github.moremcmeta.moremcmeta.impl.client.texture.EventDrivenTexture;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Sprite;
import io.github.moremcmeta.moremcmeta.impl.client.texture.SpriteFinder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;

public final class BaseCollection {
    private final Map<class_2960, Collection<MipmappedBase>> BASES;
    private final int MAX_MIPMAP;

    public static BaseCollection find(SpriteFinder spriteFinder, class_2960 textureLocation) {
        Objects.requireNonNull(spriteFinder, "Sprite finder cannot be null");
        Objects.requireNonNull(textureLocation, "Texture location cannot be null");
        HashMap<class_2960, Collection<MipmappedBase>> newBases = new HashMap<class_2960, Collection<MipmappedBase>>();
        BaseCollection.baseSet(newBases, textureLocation).add(new MipmappedBase(EventDrivenTexture.SELF_UPLOAD_POINT, 0));
        BaseCollection.findSpriteBase(spriteFinder, textureLocation, EventDrivenTexture.SELF_UPLOAD_POINT).ifPresent(pair -> BaseCollection.baseSet(newBases, ((Sprite)pair.getFirst()).atlas()).add((MipmappedBase)pair.getSecond()));
        return new BaseCollection(newBases);
    }

    private static Collection<MipmappedBase> baseSet(Map<class_2960, Collection<MipmappedBase>> newBases, class_2960 baseLocation) {
        return newBases.computeIfAbsent(baseLocation, location -> new HashSet());
    }

    private static Optional<Pair<Sprite, MipmappedBase>> findSpriteBase(SpriteFinder spriteFinder, class_2960 baseLocation, long uploadPoint) {
        Optional<Sprite> spriteOptional = spriteFinder.findSprite(baseLocation);
        if (spriteOptional.isEmpty()) {
            return Optional.empty();
        }
        Sprite sprite = spriteOptional.get();
        long uploadPointInSprite = Point.pack(Point.x(uploadPoint) + Point.x(sprite.uploadPoint()), Point.y(uploadPoint) + Point.y(sprite.uploadPoint()));
        return Optional.of(Pair.of((Object)sprite, (Object)new MipmappedBase(uploadPointInSprite, sprite.mipmapLevel())));
    }

    public Collection<class_2960> baseNames() {
        return this.BASES.keySet();
    }

    public Collection<MipmappedBase> baseData(class_2960 baseName) {
        Objects.requireNonNull(baseName, "Base name cannot be null");
        return this.BASES.getOrDefault(baseName, (Collection<MipmappedBase>)ImmutableSet.of());
    }

    public int maxMipmap() {
        return this.MAX_MIPMAP;
    }

    private BaseCollection(Map<class_2960, Collection<MipmappedBase>> bases) {
        HashMap<class_2960, Collection<MipmappedBase>> basesCopy = new HashMap<class_2960, Collection<MipmappedBase>>(bases);
        basesCopy.replaceAll((location, baseData) -> ImmutableList.copyOf((Collection)baseData));
        this.BASES = ImmutableMap.copyOf(basesCopy);
        this.MAX_MIPMAP = this.BASES.values().stream().flatMap(Collection::stream).map(MipmappedBase::mipmap).max(Integer::compareTo).orElse(0);
    }

    public static final class MipmappedBase {
        private final long UPLOAD_POINT;
        private final int MIPMAP;

        public long uploadPoint() {
            return this.UPLOAD_POINT;
        }

        public int mipmap() {
            return this.MIPMAP;
        }

        public int hashCode() {
            return Objects.hash(this.UPLOAD_POINT, this.MIPMAP);
        }

        public boolean equals(Object other) {
            if (!(other instanceof MipmappedBase)) {
                return false;
            }
            MipmappedBase otherBase = (MipmappedBase)other;
            return this.UPLOAD_POINT == otherBase.UPLOAD_POINT && this.MIPMAP == otherBase.MIPMAP;
        }

        private MipmappedBase(long uploadPoint, int mipmap) {
            this.UPLOAD_POINT = uploadPoint;
            this.MIPMAP = mipmap;
        }
    }
}

