/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.io;

import com.google.common.collect.ImmutableList;
import io.github.moremcmeta.moremcmeta.api.client.metadata.AnalyzedMetadata;
import io.github.moremcmeta.moremcmeta.api.client.texture.ComponentBuilder;
import io.github.moremcmeta.moremcmeta.api.math.NegativeDimensionException;
import io.github.moremcmeta.moremcmeta.impl.client.texture.CloseableImage;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Triple;

public final class TextureData<I extends CloseableImage> {
    private final FrameSize FRAME_SIZE;
    private final boolean BLUR;
    private final boolean CLAMP;
    private final I IMAGE;
    private final List<Triple<String, AnalyzedMetadata, ComponentBuilder>> ANALYZED_SECTIONS;

    public TextureData(FrameSize frameSize, boolean blur, boolean clamp, I image, List<Triple<String, AnalyzedMetadata, ComponentBuilder>> analyzedSections) {
        if (frameSize.width() > image.width()) {
            throw new IllegalArgumentException("Frame width cannot be larger than image width");
        }
        if (frameSize.height() > image.height()) {
            throw new IllegalArgumentException("Frame height cannot be larger than image height");
        }
        this.FRAME_SIZE = Objects.requireNonNull(frameSize, "Frame size cannot be null");
        this.BLUR = blur;
        this.CLAMP = clamp;
        this.IMAGE = (CloseableImage)Objects.requireNonNull(image, "Image cannot be null");
        this.ANALYZED_SECTIONS = (List)Objects.requireNonNull(ImmutableList.copyOf(analyzedSections), "Analyzed sections cannot be null");
    }

    public FrameSize frameSize() {
        return this.FRAME_SIZE;
    }

    public boolean clamp() {
        return this.CLAMP;
    }

    public boolean blur() {
        return this.BLUR;
    }

    public I image() {
        return this.IMAGE;
    }

    public List<Triple<String, AnalyzedMetadata, ComponentBuilder>> analyzedMetadata() {
        return this.ANALYZED_SECTIONS;
    }

    public static final class FrameSize {
        private final int WIDTH;
        private final int HEIGHT;

        public FrameSize(int width, int height) {
            if (width < 0) {
                throw new NegativeDimensionException(width);
            }
            if (height < 0) {
                throw new NegativeDimensionException(height);
            }
            this.WIDTH = width;
            this.HEIGHT = height;
        }

        public int width() {
            return this.WIDTH;
        }

        public int height() {
            return this.HEIGHT;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FrameSize)) {
                return false;
            }
            FrameSize otherSize = (FrameSize)other;
            return this.width() == otherSize.width() && this.height() == otherSize.height();
        }

        public int hashCode() {
            return 31 * this.WIDTH + this.HEIGHT;
        }
    }
}

