/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.io;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.Function;

public final class FrameReader<F> {
    private final Function<FrameData, ? extends F> FRAME_FACTORY;

    public FrameReader(Function<FrameData, ? extends F> frameFactory) {
        this.FRAME_FACTORY = Objects.requireNonNull(frameFactory, "Frame factory cannot be null");
    }

    public ImmutableList<F> read(int imageWidth, int imageHeight, int frameWidth, int frameHeight) {
        if (imageWidth <= 0 || imageHeight <= 0) {
            throw new IllegalArgumentException("Image must not be empty");
        }
        if (frameWidth <= 0 || frameHeight <= 0) {
            throw new IllegalArgumentException("Frame width and height must not be zero or negative");
        }
        int numFramesX = imageWidth / frameWidth;
        int numFramesY = imageHeight / frameHeight;
        return this.findFrames(frameWidth, frameHeight, numFramesX, numFramesY);
    }

    private ImmutableList<F> findFrames(int frameWidth, int frameHeight, int numFramesX, int numFramesY) {
        ImmutableList.Builder frames = ImmutableList.builder();
        for (int row = 0; row < numFramesY; ++row) {
            for (int column = 0; column < numFramesX; ++column) {
                FrameData data = new FrameData(frameWidth, frameHeight, column * frameWidth, row * frameHeight);
                F nextFrame = this.FRAME_FACTORY.apply(data);
                Objects.requireNonNull(nextFrame, "Found frame was created as null");
                frames.add(nextFrame);
            }
        }
        return frames.build();
    }

    public static final class FrameData {
        private final int WIDTH;
        private final int HEIGHT;
        private final int X_OFFSET;
        private final int Y_OFFSET;

        public FrameData(int width, int height, int xOffset, int yOffset) {
            this.WIDTH = width;
            this.HEIGHT = height;
            this.X_OFFSET = xOffset;
            this.Y_OFFSET = yOffset;
        }

        public int width() {
            return this.WIDTH;
        }

        public int height() {
            return this.HEIGHT;
        }

        public int xOffset() {
            return this.X_OFFSET;
        }

        public int yOffset() {
            return this.Y_OFFSET;
        }
    }
}

