/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.adapter;

import io.github.moremcmeta.moremcmeta.api.client.texture.SpriteName;
import io.github.moremcmeta.moremcmeta.api.math.Point;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Atlas;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Sprite;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public final class AtlasAdapter
implements Atlas {
    private final class_1059 ATLAS;
    private final ToIntFunction<class_1058> MIPMAP_LEVEL_GETTER;

    public AtlasAdapter(class_2960 location, ToIntFunction<class_1058> mipmapLevelGetter) {
        Objects.requireNonNull(location, "Location cannot be null");
        this.MIPMAP_LEVEL_GETTER = Objects.requireNonNull(mipmapLevelGetter, "Mipmap level getter cannot be null");
        class_1044 texture = class_310.method_1551().method_1531().method_4619(location);
        this.ATLAS = texture instanceof class_1059 ? (class_1059)texture : null;
    }

    @Override
    public Optional<Sprite> sprite(class_2960 location) {
        Objects.requireNonNull(location, "Sprite location cannot be null");
        if (this.ATLAS == null) {
            return Optional.empty();
        }
        class_2960 properSpriteName = SpriteName.fromTexturePath(location);
        class_1058 sprite = this.ATLAS.method_4608(properSpriteName);
        if (sprite.method_45851().method_45816().equals((Object)class_1047.method_4539())) {
            sprite = this.ATLAS.method_4608(location);
        }
        if (sprite.method_45851().method_45816().equals((Object)class_1047.method_4539())) {
            return Optional.empty();
        }
        return Optional.of(new SpriteAdapter(sprite, this.MIPMAP_LEVEL_GETTER.applyAsInt(sprite)));
    }

    private static class SpriteAdapter
    implements Sprite {
        private final class_1058 SPRITE;
        private final long UPLOAD_POINT;
        private final int MIPMAP_LEVEL;

        public SpriteAdapter(class_1058 sprite, int mipmapLevel) {
            this.SPRITE = sprite;
            this.UPLOAD_POINT = this.findUploadPoint();
            if (mipmapLevel < 0) {
                throw new IllegalArgumentException("Sprite cannot have negative mipmaps");
            }
            this.MIPMAP_LEVEL = mipmapLevel;
        }

        @Override
        public class_2960 name() {
            return this.SPRITE.method_45851().method_45816();
        }

        @Override
        public class_2960 atlas() {
            return this.SPRITE.method_45852();
        }

        @Override
        public long uploadPoint() {
            return this.UPLOAD_POINT;
        }

        @Override
        public int mipmapLevel() {
            return this.MIPMAP_LEVEL;
        }

        @Override
        public int width() {
            return this.SPRITE.method_45851().method_45807();
        }

        @Override
        public int height() {
            return this.SPRITE.method_45851().method_45815();
        }

        private long findUploadPoint() {
            return Point.pack(this.SPRITE.method_35806(), this.SPRITE.method_35807());
        }
    }
}

