/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.fabric.impl.client;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.TextureUtil;
import io.github.moremcmeta.moremcmeta.api.client.ClientPlugin;
import io.github.moremcmeta.moremcmeta.fabric.impl.client.adapter.SimpleReloadListenerAdapter;
import io.github.moremcmeta.moremcmeta.fabric.impl.client.event.ResourceManagerInitializedCallback;
import io.github.moremcmeta.moremcmeta.fabric.impl.client.mixin.LoadingOverlayAccessor;
import io.github.moremcmeta.moremcmeta.fabric.impl.client.mixin.PackRepositoryAccessor;
import io.github.moremcmeta.moremcmeta.fabric.impl.client.mixin.SpriteAccessor;
import io.github.moremcmeta.moremcmeta.fabric.impl.client.mixin.TextureManagerAccessor;
import io.github.moremcmeta.moremcmeta.impl.client.MoreMcmeta;
import io.github.moremcmeta.moremcmeta.impl.client.resource.StagedResourceReloadListener;
import io.github.moremcmeta.moremcmeta.impl.client.texture.EventDrivenTexture;
import io.github.moremcmeta.moremcmeta.impl.client.texture.TextureManagerWrapper;
import io.github.moremcmeta.moremcmeta.impl.client.texture.TexturePreparer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_4011;
import net.minecraft.class_425;
import org.apache.logging.log4j.Logger;

public final class MoreMcmetaFabric
extends MoreMcmeta
implements ClientModInitializer {
    private static final String PLUGIN_ENTRYPOINT = "moremcmeta-client";

    public void onInitializeClient() {
        this.start();
    }

    @Override
    protected Collection<ClientPlugin> fetchTexturePlugins(Logger logger) {
        return this.listPlugins(ClientPlugin.class, logger);
    }

    @Override
    protected ToIntFunction<class_1058> mipmapLevelGetter(Logger logger) {
        return sprite -> ((SpriteAccessor)sprite.method_45851()).moremcmeta_mainImage().length - 1;
    }

    @Override
    protected TexturePreparer preparer() {
        return TextureUtil::prepareImage;
    }

    @Override
    protected BiConsumer<class_1060, class_2960> unregisterAction() {
        return (manager, location) -> {
            TextureManagerAccessor accessor = (TextureManagerAccessor)manager;
            accessor.moremcmeta_byPath().remove(location);
            manager.method_4615(location);
        };
    }

    @Override
    protected void onResourceManagerInitialized(Consumer<class_310> callback) {
        ResourceManagerInitializedCallback.EVENT.register(callback::accept);
    }

    @Override
    protected void addRepositorySource(class_3283 packRepository, class_3285 repositorySource) {
        PackRepositoryAccessor accessor = (PackRepositoryAccessor)packRepository;
        ImmutableSet.Builder sources = new ImmutableSet.Builder();
        sources.addAll(accessor.moremcmeta_sources());
        sources.add((Object)repositorySource);
        accessor.moremcmeta_setSources((Set<class_3285>)sources.build());
    }

    @Override
    protected StagedResourceReloadListener<Map<class_2960, EventDrivenTexture.Builder>> wrapListener(StagedResourceReloadListener<Map<class_2960, EventDrivenTexture.Builder>> original) {
        return new SimpleReloadListenerAdapter<Map<class_2960, EventDrivenTexture.Builder>>(original, new class_2960("moremcmeta", "texture_reload_listener"));
    }

    @Override
    protected Optional<class_4011> reloadInstance(class_425 overlay, Logger logger) {
        return Optional.of(((LoadingOverlayAccessor)overlay).moremcmeta_reloadInstance());
    }

    @Override
    protected void startTicking(TextureManagerWrapper<EventDrivenTexture> texManager) {
        ClientTickEvents.START_CLIENT_TICK.register(client -> texManager.tick());
    }

    private <T> List<T> listPlugins(Class<T> pluginClass, Logger logger) {
        ArrayList plugins = new ArrayList();
        FabricLoader.getInstance().getEntrypointContainers(PLUGIN_ENTRYPOINT, pluginClass).forEach(entrypoint -> {
            try {
                plugins.add(entrypoint.getEntrypoint());
            }
            catch (Throwable err) {
                logger.error("Mod {} provided broken plugin to {}: {}", (Object)entrypoint.getProvider().getMetadata().getId(), (Object)"moremcmeta", (Object)err);
            }
        });
        return plugins;
    }
}

