/*
 * Decompiled with CFR 0.152.
 */
package com.chefsdelights.farmersrespite.common.block.entity;

import com.chefsdelights.farmersrespite.common.block.KettleBlock;
import com.chefsdelights.farmersrespite.common.block.entity.container.KettleContainer;
import com.chefsdelights.farmersrespite.common.block.entity.inventory.KettlePotInventory;
import com.chefsdelights.farmersrespite.common.crafting.KettleRecipe;
import com.chefsdelights.farmersrespite.core.FarmersRespite;
import com.chefsdelights.farmersrespite.core.registry.FRBlockEntityTypes;
import com.chefsdelights.farmersrespite.core.registry.FRRecipeSerializers;
import com.nhoryzon.mc.farmersdelight.entity.block.HeatableBlockEntity;
import com.nhoryzon.mc.farmersdelight.entity.block.SyncedBlockEntity;
import com.nhoryzon.mc.farmersdelight.entity.block.inventory.ItemStackInventory;
import com.nhoryzon.mc.farmersdelight.entity.block.inventory.RecipeWrapper;
import com.nhoryzon.mc.farmersdelight.mixin.accessors.RecipeManagerAccessorMixin;
import com.nhoryzon.mc.farmersdelight.registry.ParticleTypesRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class KettleBlockEntity
extends SyncedBlockEntity
implements KettlePotInventory,
ExtendedScreenHandlerFactory,
HeatableBlockEntity,
class_1275 {
    public static final String TAG_KEY_COOK_RECIPES_USED = "RecipesUsed";
    public static final int MEAL_DISPLAY_SLOT = 2;
    public static final int CONTAINER_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;
    public static final int INVENTORY_SIZE = 5;
    private class_2561 customName;
    private final class_2371<class_1799> inventory;
    private int cookTime;
    private int cookTimeTotal;
    private class_1799 mealContainer = class_1799.field_8037;
    protected final class_3913 cookingPotData;
    private final Object2IntOpenHashMap<class_2960> experienceTracker;
    private class_2960 lastRecipeID;
    private boolean checkNewRecipe = true;
    private boolean needWater;

    public KettleBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(FRBlockEntityTypes.KETTLE, blockPos, blockState);
        this.inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        this.cookingPotData = new CookingPotSyncedData();
        this.experienceTracker = new Object2IntOpenHashMap();
    }

    public class_1703 createMenu(int id, class_1661 player, class_1657 entity) {
        return new KettleContainer(id, player, this, this.cookingPotData);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.readInventoryNbt(tag);
        this.cookTime = tag.method_10550("CookTime");
        this.cookTimeTotal = tag.method_10550("CookTimeTotal");
        this.mealContainer = class_1799.method_7915((class_2487)tag.method_10562("Container"));
        this.needWater = tag.method_10577("NeedWater");
        if (tag.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)tag.method_10558("CustomName"));
        }
        class_2487 compoundRecipes = tag.method_10562(TAG_KEY_COOK_RECIPES_USED);
        for (String key : compoundRecipes.method_10541()) {
            this.experienceTracker.put((Object)new class_2960(key), compoundRecipes.method_10550(key));
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("CookTime", this.cookTime);
        tag.method_10569("CookTimeTotal", this.cookTimeTotal);
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        tag.method_10556("NeedWater", this.needWater);
        tag.method_10566("Container", (class_2520)this.mealContainer.method_7953(new class_2487()));
        this.writeInventoryNbt(tag);
        class_2487 compoundRecipes = new class_2487();
        this.experienceTracker.forEach((identifier, craftedAmount) -> compoundRecipes.method_10569(identifier.toString(), craftedAmount.intValue()));
        tag.method_10566(TAG_KEY_COOK_RECIPES_USED, (class_2520)compoundRecipes);
    }

    public class_2487 writeMeal(class_2487 tag) {
        if (this.getMeal().method_7960()) {
            return tag;
        }
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        tag.method_10566("Container", (class_2520)this.mealContainer.method_7953(new class_2487()));
        class_2371 drops = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        for (int i = 0; i < 5; ++i) {
            drops.set(i, (Object)(i == 2 ? this.method_5438(i) : class_1799.field_8037));
        }
        tag.method_10566("Inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)drops));
        return tag;
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : FarmersRespite.i18n("container.kettle", new Object[0]);
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public static void cookingTick(class_1937 world, class_2338 pos, class_2680 state, KettleBlockEntity cookingPot) {
        boolean isHeated = cookingPot.isHeated(world, pos);
        boolean dirty = false;
        if (isHeated && cookingPot.hasInput()) {
            Optional<KettleRecipe> recipe = cookingPot.getMatchingRecipe(new RecipeWrapper((ItemStackInventory)cookingPot));
            if (recipe.isPresent() && cookingPot.canCook(recipe.get())) {
                dirty = cookingPot.processCooking(recipe.get());
            } else {
                cookingPot.cookTime = 0;
            }
        } else if (cookingPot.cookTime > 0) {
            cookingPot.cookTime = class_3532.method_15340((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
        }
        class_1799 meal = cookingPot.getMeal();
        if (!meal.method_7960()) {
            if (!cookingPot.doesMealHaveContainer(meal)) {
                cookingPot.moveMealToOutput();
                dirty = true;
            } else if (!cookingPot.method_5438(3).method_7960()) {
                cookingPot.useStoredContainersOnMeal();
                dirty = true;
            }
        }
        if (dirty) {
            cookingPot.inventoryChanged();
        }
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    private Optional<KettleRecipe> getMatchingRecipe(RecipeWrapper inventory) {
        Object recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (class_1860)((RecipeManagerAccessorMixin)this.field_11863.method_8433()).getAllForType(FRRecipeSerializers.BREWING).get(this.lastRecipeID)) instanceof KettleRecipe) {
            KettleRecipe kettleRecipe = (KettleRecipe)recipe;
            if (recipe.method_8115((class_1263)inventory, this.field_11863)) {
                return Optional.of(kettleRecipe);
            }
            if (class_1799.method_7984((class_1799)recipe.method_8110(this.field_11863.method_30349()), (class_1799)this.getMeal())) {
                return Optional.empty();
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.field_11863.method_8433().method_8132(FRRecipeSerializers.BREWING, (class_1263)inventory, this.field_11863))).isPresent()) {
            this.lastRecipeID = ((KettleRecipe)((Optional)recipe).get()).method_8114();
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public class_1799 getMealContainer() {
        return !this.mealContainer.method_7960() ? this.mealContainer : new class_1799((class_1935)this.getMeal().method_7909().method_7858());
    }

    private boolean hasInput() {
        for (int i = 0; i < 2; ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(KettleRecipe recipeIn) {
        this.needWater = recipeIn.getNeedWater();
        if (this.hasInput() && recipeIn != null) {
            class_1799 recipeOutput = recipeIn.method_8110(this.field_11863.method_30349());
            if (recipeOutput.method_7960()) {
                return false;
            }
            class_1799 currentOutput = this.method_5438(2);
            if (this.isWater() || !this.needWater) {
                if (currentOutput.method_7960()) {
                    return true;
                }
                if (!class_1799.method_7984((class_1799)currentOutput, (class_1799)recipeOutput)) {
                    return false;
                }
                if (currentOutput.method_7947() + recipeOutput.method_7947() <= this.method_5444()) {
                    return true;
                }
                return currentOutput.method_7947() + recipeOutput.method_7947() <= recipeOutput.method_7914();
            }
        }
        return false;
    }

    private boolean processCooking(KettleRecipe recipe) {
        if (this.field_11863 != null && recipe != null) {
            int j = (Integer)this.method_11010().method_11654((class_2769)KettleBlock.WATER_LEVEL);
            ++this.cookTime;
            this.cookTimeTotal = recipe.brewTime;
            if (this.cookTime < this.cookTimeTotal) {
                return false;
            }
            this.cookTime = 0;
            this.mealContainer = recipe.container;
            class_1799 recipeOutput = recipe.method_8110(this.field_11863.method_30349());
            class_1799 currentOutput = this.method_5438(2);
            if (currentOutput.method_7960()) {
                this.method_5447(2, recipeOutput.method_7972());
            } else if (currentOutput.method_7909() == recipeOutput.method_7909()) {
                currentOutput.method_7933(recipeOutput.method_7947());
            }
            this.trackRecipeExperience(recipe);
            if (this.needWater) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)KettleBlock.WATER_LEVEL, (Comparable)Integer.valueOf(j - 1)));
            }
            for (int i = 0; i < 2; ++i) {
                class_1799 itemStack = this.method_5438(i);
                if (itemStack.method_7909().method_7857() && this.field_11863 != null) {
                    class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)KettleBlock.FACING)).method_10160();
                    double dropX = (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.25;
                    double dropY = (double)this.field_11867.method_10264() + 0.7;
                    double dropZ = (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.25;
                    class_1542 entity = new class_1542(this.field_11863, dropX, dropY, dropZ, new class_1799((class_1935)this.method_5438(i).method_7909().method_7858()));
                    entity.method_18800((double)((float)direction.method_10148() * 0.08f), 0.25, (double)((float)direction.method_10165() * 0.08f));
                    this.field_11863.method_8649((class_1297)entity);
                }
                if (this.method_5438(i).method_7960()) continue;
                this.method_5438(i).method_7934(1);
            }
            return true;
        }
        return false;
    }

    public void trackRecipeExperience(@Nullable class_1860<?> recipe) {
        if (recipe != null) {
            class_2960 recipeID = recipe.method_8114();
            this.experienceTracker.addTo((Object)recipeID, 1);
        }
    }

    public void clearUsedRecipes(class_1657 player) {
        this.grantStoredRecipeExperience(player.method_37908(), player.method_19538());
        this.experienceTracker.clear();
    }

    public void grantStoredRecipeExperience(class_1937 world, class_243 pos) {
        ObjectIterator objectIterator = this.experienceTracker.object2IntEntrySet().iterator();
        while (objectIterator.hasNext()) {
            Object2IntMap.Entry resourceLocationEntry;
            Object2IntMap.Entry entry = resourceLocationEntry = (Object2IntMap.Entry)objectIterator.next();
            world.method_8433().method_8130((class_2960)entry.getKey()).ifPresent(recipe -> KettleBlockEntity.splitAndSpawnExperience(world, pos, entry.getIntValue(), ((KettleRecipe)recipe).getExperience()));
        }
    }

    private static void splitAndSpawnExperience(class_1937 world, class_243 pos, int craftedAmount, float experience) {
        int expTotal = class_3532.method_15375((float)((float)craftedAmount * experience));
        float expFraction = class_3532.method_22450((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        while (expTotal > 0) {
            int expValue = class_1303.method_5918((int)expTotal);
            expTotal -= expValue;
            world.method_8649((class_1297)new class_1303(world, pos.field_1352, pos.field_1351, pos.field_1350, expValue));
        }
    }

    public static void animationTick(class_1937 world, class_2338 pos, class_2680 state, KettleBlockEntity cookingPot) {
        if (world != null && cookingPot.isHeated(world, pos)) {
            double baseZ;
            double baseY;
            double baseX;
            class_5819 random = world.field_9229;
            if (random.method_43057() < 0.2f) {
                baseX = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.6 - 0.3);
                baseY = (double)pos.method_10264() + 0.7;
                baseZ = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.6 - 0.3);
                world.method_8406((class_2394)class_2398.field_11241, baseX, baseY, baseZ, 0.0, 0.0, 0.0);
            }
            if (random.method_43057() < 0.05f) {
                baseX = (double)pos.method_10263() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                baseY = (double)pos.method_10264() + 0.5;
                baseZ = (double)pos.method_10260() + 0.5 + (random.method_43058() * 0.4 - 0.2);
                double motionY = random.method_43056() ? 0.015 : 0.005;
                world.method_8406((class_2394)ParticleTypesRegistry.STEAM.get(), baseX, baseY, baseZ, 0.0, motionY, 0.0);
            }
        }
    }

    public class_1799 getMeal() {
        return this.method_5438(2);
    }

    public boolean isHeated() {
        return this.field_11863 != null && this.isHeated(this.field_11863, this.field_11867);
    }

    public class_2371<class_1799> getDroppableInventory() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < 5; ++i) {
            drops.add((Object)(i == 2 ? class_1799.field_8037 : this.method_5438(i)));
        }
        return drops;
    }

    private void moveMealToOutput() {
        class_1799 mealDisplay = this.method_5438(2);
        class_1799 finalOutput = this.method_5438(4);
        int mealCount = Math.min(mealDisplay.method_7947(), mealDisplay.method_7914() - finalOutput.method_7947());
        if (finalOutput.method_7960()) {
            this.method_5447(4, mealDisplay.method_7971(mealCount));
        } else if (finalOutput.method_7909() == mealDisplay.method_7909()) {
            mealDisplay.method_7934(mealCount);
            finalOutput.method_7933(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        class_1799 mealDisplay = this.method_5438(2);
        class_1799 containerInput = this.method_5438(3);
        class_1799 finalOutput = this.method_5438(4);
        if (this.isContainerValid(containerInput) && finalOutput.method_7947() < finalOutput.method_7914()) {
            int smallerStack = Math.min(mealDisplay.method_7947(), containerInput.method_7947());
            int mealCount = Math.min(smallerStack, mealDisplay.method_7914() - finalOutput.method_7947());
            if (finalOutput.method_7960()) {
                containerInput.method_7934(mealCount);
                this.method_5447(4, mealDisplay.method_7971(mealCount));
            } else if (finalOutput.method_7909() == mealDisplay.method_7909()) {
                mealDisplay.method_7934(mealCount);
                containerInput.method_7934(mealCount);
                finalOutput.method_7933(mealCount);
            }
        }
    }

    public class_1799 useHeldItemOnMeal(class_1799 container) {
        if (this.isContainerValid(container) && !this.getMeal().method_7960()) {
            container.method_7934(1);
            return this.getMeal().method_7971(1);
        }
        return class_1799.field_8037;
    }

    private boolean doesMealHaveContainer(class_1799 meal) {
        return !this.mealContainer.method_7960() || meal.method_7909().method_7857();
    }

    public boolean isContainerValid(class_1799 containerItem) {
        if (containerItem.method_7960()) {
            return false;
        }
        return !this.mealContainer.method_7960() ? class_1799.method_7984((class_1799)this.mealContainer, (class_1799)containerItem) : containerItem.method_31574(this.getMeal().method_7909().method_7858());
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public void onContentsChanged(int slot) {
        if (slot >= 0 && slot < 4) {
            this.checkNewRecipe = true;
        }
        this.inventoryChanged();
    }

    public void setCheckNewRecipe(boolean checkNewRecipe) {
        this.checkNewRecipe = checkNewRecipe;
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public boolean isWater() {
        if (this.field_11863 == null) {
            return false;
        }
        class_2680 state = this.field_11863.method_8320(this.method_11016());
        int i = (Integer)state.method_11654((class_2769)KettleBlock.WATER_LEVEL);
        boolean flag = i > 0;
        return flag;
    }

    private class CookingPotSyncedData
    implements class_3913 {
        private CookingPotSyncedData() {
        }

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> KettleBlockEntity.this.cookTime;
                case 1 -> KettleBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                KettleBlockEntity.this.cookTime = value;
            } else if (index == 1) {
                KettleBlockEntity.this.cookTimeTotal = value;
            }
        }

        public int method_17389() {
            return 2;
        }
    }
}

