/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.data.CompatibilityDataTypes;
import io.github.apace100.origins.data.OriginsDataTypes;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.origin.OriginUpgrade;
import io.github.apace100.origins.registry.ModComponents;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class Origin {
    public static final SerializableData DATA = new SerializableData().add("powers", SerializableDataTypes.IDENTIFIERS, (Object)Lists.newArrayList()).add("icon", CompatibilityDataTypes.ITEM_OR_ITEM_STACK, (Object)new class_1799((class_1935)class_1802.field_8162)).add("unchoosable", SerializableDataTypes.BOOLEAN, (Object)false).add("order", SerializableDataTypes.INT, (Object)Integer.MAX_VALUE).add("impact", OriginsDataTypes.IMPACT, (Object)Impact.NONE).add("loading_priority", SerializableDataTypes.INT, (Object)0).add("upgrades", OriginsDataTypes.UPGRADES, null).add("name", SerializableDataTypes.STRING, (Object)"").add("description", SerializableDataTypes.STRING, (Object)"");
    public static final Origin EMPTY = Origin.register(new Origin(new class_2960("origins", "empty"), new class_1799((class_1935)class_1802.field_8162), Impact.NONE, -1, Integer.MAX_VALUE).setUnchoosable().setSpecial());
    private class_2960 identifier;
    private List<PowerType<?>> powerTypes = new LinkedList();
    private final class_1799 displayItem;
    private final Impact impact;
    private boolean isChoosable;
    private final int order;
    private final int loadingPriority;
    private List<OriginUpgrade> upgrades = new LinkedList<OriginUpgrade>();
    private boolean isSpecial;
    private String nameTranslationKey;
    private String descriptionTranslationKey;

    public static void init() {
    }

    private static Origin register(Origin origin) {
        return OriginRegistry.register(origin);
    }

    public static HashMap<OriginLayer, Origin> get(class_1297 entity) {
        if (entity instanceof class_1657) {
            return Origin.get((class_1657)entity);
        }
        return new HashMap<OriginLayer, Origin>();
    }

    public static HashMap<OriginLayer, Origin> get(class_1657 player) {
        return ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getOrigins();
    }

    public Origin(class_2960 id, class_1799 icon, Impact impact, int order, int loadingPriority) {
        this.identifier = id;
        this.displayItem = icon.method_7972();
        this.impact = impact;
        this.isChoosable = true;
        this.order = order;
        this.loadingPriority = loadingPriority;
    }

    public Origin addUpgrade(OriginUpgrade upgrade) {
        this.upgrades.add(upgrade);
        return this;
    }

    public boolean hasUpgrade() {
        return this.upgrades.size() > 0;
    }

    public Optional<OriginUpgrade> getUpgrade(class_161 advancement) {
        for (OriginUpgrade upgrade : this.upgrades) {
            if (!upgrade.getAdvancementCondition().equals((Object)advancement.method_688())) continue;
            return Optional.of(upgrade);
        }
        return Optional.empty();
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public Origin add(PowerType<?> ... powerTypes) {
        this.powerTypes.addAll(Lists.newArrayList((Object[])powerTypes));
        return this;
    }

    public void removePowerType(PowerType<?> powerType) {
        this.powerTypes.remove(powerType);
    }

    protected Origin setUnchoosable() {
        this.isChoosable = false;
        return this;
    }

    public Origin setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public Origin setName(String name) {
        this.nameTranslationKey = name;
        return this;
    }

    public Origin setDescription(String description) {
        this.descriptionTranslationKey = description;
        return this;
    }

    public boolean hasPowerType(PowerType<?> powerType) {
        if (powerType.getIdentifier() == null) {
            return false;
        }
        if (this.powerTypes.contains(powerType)) {
            return true;
        }
        for (PowerType<?> pt : this.powerTypes) {
            if (!(pt instanceof MultiplePowerType) || !((MultiplePowerType)pt).getSubPowers().contains((Object)powerType.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public int getLoadingPriority() {
        return this.loadingPriority;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public boolean isChoosable() {
        return this.isChoosable;
    }

    public Iterable<PowerType<?>> getPowerTypes() {
        return this.powerTypes;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public class_1799 getDisplayItem() {
        return this.displayItem;
    }

    public String getOrCreateNameTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "origin." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".name";
        }
        return this.nameTranslationKey;
    }

    public class_5250 getName() {
        return class_2561.method_43471((String)this.getOrCreateNameTranslationKey());
    }

    public String getOrCreateDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null || this.descriptionTranslationKey.isEmpty()) {
            this.descriptionTranslationKey = "origin." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".description";
        }
        return this.descriptionTranslationKey;
    }

    public class_5250 getDescription() {
        return class_2561.method_43471((String)this.getOrCreateDescriptionTranslationKey());
    }

    public int getOrder() {
        return this.order;
    }

    public void write(class_2540 buffer) {
        SerializableData.Instance data = new SerializableData.Instance(DATA);
        data.set("icon", (Object)this.displayItem);
        data.set("impact", (Object)this.impact);
        data.set("order", (Object)this.order);
        data.set("loading_priority", (Object)this.loadingPriority);
        data.set("unchoosable", (Object)(!this.isChoosable ? 1 : 0));
        data.set("powers", this.powerTypes.stream().map(PowerType::getIdentifier).collect(Collectors.toList()));
        data.set("name", (Object)this.getOrCreateNameTranslationKey());
        data.set("description", (Object)this.getOrCreateDescriptionTranslationKey());
        data.set("upgrades", this.upgrades);
        DATA.write(buffer, data);
    }

    public static Origin createFromData(class_2960 id, SerializableData.Instance data) {
        Origin origin = new Origin(id, (class_1799)data.get("icon"), (Impact)((Object)data.get("impact")), data.getInt("order"), data.getInt("loading_priority"));
        if (data.getBoolean("unchoosable")) {
            origin.setUnchoosable();
        }
        ((List)data.get("powers")).forEach(powerId -> {
            try {
                PowerType powerType = PowerTypeRegistry.get((class_2960)powerId);
                origin.add(powerType);
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.error("Origin \"" + id + "\" contained unregistered power: \"" + powerId + "\"");
            }
        });
        if (data.isPresent("upgrades")) {
            ((List)data.get("upgrades")).forEach(origin::addUpgrade);
        }
        origin.setName(data.getString("name"));
        origin.setDescription(data.getString("description"));
        return origin;
    }

    @Environment(value=EnvType.CLIENT)
    public static Origin read(class_2540 buffer) {
        class_2960 identifier = class_2960.method_12829((String)buffer.method_10800(Short.MAX_VALUE));
        return Origin.createFromData(identifier, DATA.read(buffer));
    }

    public static Origin fromJson(class_2960 id, JsonObject json) {
        return Origin.createFromData(id, DATA.read(json));
    }

    public String toString() {
        String str = "Origin(" + this.identifier.toString() + ")[";
        for (PowerType<?> pt : this.powerTypes) {
            str = str + PowerTypeRegistry.getId(pt);
            str = str + ",";
        }
        str = str.substring(0, str.length() - 1) + "]";
        return str;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Origin) {
            return ((Origin)obj).identifier.equals((Object)this.identifier);
        }
        return false;
    }
}

