/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.crafttweaker.handlers;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStackMutable;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.integration.crafttweaker.handlers.RecipeHandlerUtils;

@IRecipeHandler.For(value=CookingPotRecipe.class)
public final class CookingPotRecipeHandler
implements IRecipeHandler<CookingPotRecipe> {
    public String dumpToCommandString(IRecipeManager manager, CookingPotRecipe recipe) {
        Object[] objectArray = new Object[7];
        objectArray[0] = manager.getCommandString();
        objectArray[1] = StringUtil.quoteAndEscape((class_2960)recipe.method_8114());
        objectArray[2] = IItemStack.of((class_1799)((class_1799)AccessibleElementsProvider.get().registryAccess(recipe::method_8110))).getCommandString();
        objectArray[3] = recipe.method_8117().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"));
        objectArray[4] = new MCItemStackMutable(recipe.getOutputContainer()).getCommandString();
        objectArray[5] = Float.valueOf(recipe.getExperience());
        objectArray[6] = recipe.getCookTime();
        return String.format("%s.addRecipe(%s, %s, %s, %s, %s, %s);", objectArray);
    }

    public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super CookingPotRecipe> manager, CookingPotRecipe firstRecipe, U secondRecipe) {
        return firstRecipe.equals(secondRecipe);
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super CookingPotRecipe> manager, CookingPotRecipe recipe) {
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Output.ITEMS, (Object)IItemStack.of((class_1799)((class_1799)AccessibleElementsProvider.get().registryAccess(recipe::method_8110)))).with(BuiltinRecipeComponents.Input.INGREDIENTS, recipe.method_8117().stream().map(IIngredient::fromIngredient).toList()).with(BuiltinRecipeComponents.Processing.TIME, (Object)recipe.getCookTime()).with(BuiltinRecipeComponents.Metadata.GROUP, (Object)recipe.method_8112()).with(RecipeHandlerUtils.CONTAINER_COMPONENT, (Object)new MCItemStackMutable(recipe.getOutputContainer())).with(BuiltinRecipeComponents.Output.EXPERIENCE, (Object)Float.valueOf(recipe.getExperience())).build();
        if (recipe.getRecipeBookTab() != null) {
            decomposedRecipe.set(RecipeHandlerUtils.COOKING_TAB_COMPONENT, (Object)recipe.getRecipeBookTab().name());
        }
        return Optional.of(decomposedRecipe);
    }

    public Optional<CookingPotRecipe> recompose(IRecipeManager<? super CookingPotRecipe> manager, class_2960 name, IDecomposedRecipe recipe) {
        IItemStack output = (IItemStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        List ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        class_2371 inputList = class_2371.method_10211();
        for (IIngredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            inputList.add((Object)ingredient.asVanillaIngredient());
        }
        int time = (Integer)recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME);
        String group = (String)recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        IItemStack container = (IItemStack)recipe.getOrThrowSingle(RecipeHandlerUtils.CONTAINER_COMPONENT);
        float exp = ((Float)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.EXPERIENCE)).floatValue();
        List cookingRecipeBookTabList = recipe.get(RecipeHandlerUtils.COOKING_TAB_COMPONENT);
        CookingPotRecipeBookTab cookTab = cookingRecipeBookTabList == null ? null : CookingPotRecipeBookTab.valueOf((String)cookingRecipeBookTabList.get(0));
        return Optional.of(new CookingPotRecipe(name, group, cookTab, (class_2371<class_1856>)inputList, output.getInternal(), container.getInternal(), exp, time));
    }
}

