/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1834;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SkilletItem
extends class_1747
implements CustomEnchantingBehaviorItem {
    public static final float FLIP_TIME = 20.0f;
    public static final class_1834 SKILLET_TIER = class_1834.field_8923;
    protected static final UUID FD_ATTACK_KNOCKBACK_UUID = UUID.fromString("e56350e0-8756-464d-92f9-54289ab41e0a");
    private final Multimap<class_1320, class_1322> toolAttributes;

    public SkilletItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties.method_7898(SKILLET_TIER.method_8025()));
        float attackDamage = 5.0f + SKILLET_TIER.method_8028();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(class_1792.field_8006, "Tool modifier", (double)attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(class_1792.field_8001, "Tool modifier", (double)-3.1f, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23722, (Object)new class_1322(FD_ATTACK_KNOCKBACK_UUID, "Tool modifier", 1.0, class_1322.class_1323.field_6328));
        this.toolAttributes = builder.build();
    }

    public boolean method_7885(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        return !player.method_7337();
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7956(1, attacker, user -> user.method_20235(class_1304.field_6173));
        return true;
    }

    private static boolean isPlayerNearHeatSource(class_1657 player, class_4538 level) {
        if (player.method_5809()) {
            return true;
        }
        class_2338 pos = player.method_24515();
        for (class_2338 nearbyPos : class_2338.method_10097((class_2338)pos.method_10069(-1, -1, -1), (class_2338)pos.method_10069(1, 1, 1))) {
            if (!level.method_8320(nearbyPos).method_26164(ModTags.HEAT_SOURCES)) continue;
            return true;
        }
        return false;
    }

    public int method_7881(class_1799 stack) {
        int fireAspectLevel = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)stack);
        int cookingTime = stack.method_7948().method_10550("CookTimeHandheld");
        return SkilletBlock.getSkilletCookingTime(cookingTime, fireAspectLevel);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 skilletStack = player.method_5998(hand);
        if (SkilletItem.isPlayerNearHeatSource(player, (class_4538)level)) {
            class_1268 otherHand = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
            class_1799 cookingStack = player.method_5998(otherHand);
            if (skilletStack.method_7948().method_10545("Cooking")) {
                player.method_6019(hand);
                return class_1271.method_22430((Object)skilletStack);
            }
            Optional<class_3920> recipe = SkilletItem.getCookingRecipe(cookingStack, level);
            if (recipe.isPresent()) {
                class_1799 cookingStackCopy = cookingStack.method_7972();
                class_1799 cookingStackUnit = cookingStackCopy.method_7971(1);
                skilletStack.method_7948().method_10566("Cooking", cookingStackUnit.serializeNBT());
                skilletStack.method_7948().method_10569("CookTimeHandheld", recipe.get().method_8167());
                player.method_6019(hand);
                player.method_6122(otherHand, cookingStackCopy);
                return class_1271.method_22428((Object)skilletStack);
            }
            player.method_7353((class_2561)TextUtils.getTranslation("item.skillet.how_to_cook", new Object[0]), true);
        }
        return class_1271.method_22430((Object)skilletStack);
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int count) {
        if (entity instanceof class_1657) {
            class_2487 tag;
            class_1657 player = (class_1657)entity;
            class_243 pos = player.method_19538();
            double x = pos.method_10216() + 0.5;
            double y = pos.method_10214();
            double z = pos.method_10215() + 0.5;
            if (level.field_9229.method_43048(50) == 0) {
                level.method_8486(x, y, z, ModSounds.BLOCK_SKILLET_SIZZLE.get(), class_3419.field_15245, 0.4f, level.field_9229.method_43057() * 0.2f + 0.9f, false);
            }
            if ((tag = stack.method_7948()).method_10545("FlipTimeStamp")) {
                long flipTimeStamp = tag.method_10537("FlipTimeStamp");
                if ((float)(level.method_8510() - flipTimeStamp) > 20.0f) {
                    tag.method_10551("FlipTimeStamp");
                    level.method_8486(x, y, z, ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), class_3419.field_15245, 0.4f, level.field_9229.method_43057() * 0.2f + 0.9f, false);
                }
            }
        }
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeLeft) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_2487 tag = stack.method_7948();
            if (tag.method_10545("Cooking")) {
                class_1799 cookingStack = class_1799.method_7915((class_2487)tag.method_10562("Cooking"));
                player.method_31548().method_7398(cookingStack);
                tag.method_10551("Cooking");
                tag.method_10551("CookTimeHandheld");
                tag.method_10551("FlipTimeStamp");
            }
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_2487 tag = stack.method_7948();
            if (tag.method_10545("Cooking")) {
                class_1799 cookingStack = class_1799.method_7915((class_2487)tag.method_10562("Cooking"));
                Optional<class_3920> cookingRecipe = SkilletItem.getCookingRecipe(cookingStack, level);
                cookingRecipe.ifPresent(recipe -> {
                    class_1799 resultStack = recipe.method_8116((class_1263)new class_1277(new class_1799[0]), level.method_30349());
                    if (!player.method_31548().method_7394(resultStack)) {
                        player.method_7328(resultStack, false);
                    }
                    if (player instanceof class_3222) {
                        class_174.field_1198.method_8821((class_3222)player, stack);
                    }
                });
                tag.method_10551("Cooking");
                tag.method_10551("CookTimeHandheld");
                tag.method_10551("FlipTimeStamp");
            }
        }
        return stack;
    }

    public int method_31569(class_1799 stack) {
        if (stack.method_7941("Cooking") != null) {
            return Math.round(13.0f - (float)SkilletItem.getClientPlayerHack().method_6014() * 13.0f / (float)this.method_7881(stack));
        }
        return super.method_31569(stack);
    }

    @Environment(value=EnvType.CLIENT)
    private static class_1657 getClientPlayerHack() {
        return class_310.method_1551().field_1724;
    }

    public int method_31571(class_1799 stack) {
        if (stack.method_7941("Cooking") != null) {
            return 16747343;
        }
        return super.method_31571(stack);
    }

    public boolean method_31567(class_1799 stack) {
        return super.method_31567(stack) || stack.method_7941("Cooking") != null;
    }

    public static Optional<class_3920> getCookingRecipe(class_1799 stack, class_1937 level) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return level.method_8433().method_8132(class_3956.field_17549, (class_1263)new class_1277(new class_1799[]{stack}), level);
    }

    protected boolean method_7710(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        super.method_7710(pos, level, player, stack, state);
        class_2586 tileEntity = level.method_8321(pos);
        if (tileEntity instanceof SkilletBlockEntity) {
            SkilletBlockEntity skillet = (SkilletBlockEntity)tileEntity;
            skillet.setSkilletItem(stack);
            return true;
        }
        return false;
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return SKILLET_TIER.method_8023().method_8093(repair) || super.method_7878(toRepair, repair);
    }

    public boolean method_7879(class_1799 stack, class_1937 level, class_2680 state, class_2338 pos, class_1309 entity) {
        if (!level.field_9236 && state.method_26214((class_1922)level, pos) != 0.0f) {
            stack.method_7956(1, entity, user -> user.method_20235(class_1304.field_6173));
        }
        return true;
    }

    public class_1269 method_7712(class_1750 context) {
        class_1657 player = context.method_8036();
        if (player != null && player.method_5715()) {
            return super.method_7712(context);
        }
        return class_1269.field_5811;
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        if (enchantment.field_9083.equals((Object)class_1886.field_9074)) {
            HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new class_1887[]{class_1893.field_9115});
            return !DENIED_ENCHANTMENTS.contains(enchantment);
        }
        return enchantment.field_9083.method_8177(stack.method_7909());
    }

    public int method_7837() {
        return SKILLET_TIER.method_8026();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return equipmentSlot == class_1304.field_6173 ? this.toolAttributes : super.method_7844(equipmentSlot);
    }

    public static class SkilletEvents {
        public static float attackPower = 0.0f;

        public static void playSkilletAttackSound(class_1309 entity, class_1282 source) {
            class_1297 attacker = source.method_5526();
            if (!(attacker instanceof class_1309)) {
                return;
            }
            class_1309 livingEntity = (class_1309)attacker;
            if (!livingEntity.method_5998(class_1268.field_5808).method_31574(ModItems.SKILLET.get())) {
                return;
            }
            float pitch = 0.9f + livingEntity.method_6051().method_43057() * 0.2f;
            if (livingEntity instanceof class_1657) {
                class_1657 player = (class_1657)livingEntity;
                if (attackPower > 0.8f) {
                    player.method_5783(ModSounds.ITEM_SKILLET_ATTACK_STRONG.get(), 1.0f, pitch);
                } else {
                    player.method_5783(ModSounds.ITEM_SKILLET_ATTACK_WEAK.get(), 0.8f, 0.9f);
                }
            } else {
                livingEntity.method_5783(ModSounds.ITEM_SKILLET_ATTACK_STRONG.get(), 1.0f, pitch);
            }
            attackPower = 0.0f;
        }
    }
}

