/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.transformer;

import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.AccessWidenerClassVisitor;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.transformer.ClassStripper;
import net.fabricmc.loader.impl.transformer.EnvironmentStrippingData;
import net.fabricmc.loader.impl.transformer.PackageAccessFixer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class FabricTransformer {
    public static byte[] transform(boolean isDevelopment, EnvType envType, String name, byte[] bytes) {
        ClassWriter classWriter;
        boolean applyAccessWidener;
        boolean isMinecraftClass = name.startsWith("net.minecraft.") || name.startsWith("com.mojang.blaze3d.") || name.indexOf(46) < 0;
        boolean transformAccess = isMinecraftClass && FabricLauncherBase.getLauncher().getMappingConfiguration().requiresPackageAccessHack();
        boolean environmentStrip = !isMinecraftClass || isDevelopment;
        boolean bl = applyAccessWidener = isMinecraftClass && FabricLoaderImpl.INSTANCE.getAccessWidener().getTargets().contains(name);
        if (!(transformAccess || environmentStrip || applyAccessWidener)) {
            return bytes;
        }
        ClassReader classReader = new ClassReader(bytes);
        Object visitor = classWriter = new ClassWriter(classReader, 0);
        int visitorCount = 0;
        if (applyAccessWidener) {
            visitor = AccessWidenerClassVisitor.createClassVisitor((int)589824, (ClassVisitor)visitor, (AccessWidener)FabricLoaderImpl.INSTANCE.getAccessWidener());
            ++visitorCount;
        }
        if (transformAccess) {
            visitor = new PackageAccessFixer(589824, (ClassVisitor)visitor);
            ++visitorCount;
        }
        if (environmentStrip) {
            EnvironmentStrippingData stripData = new EnvironmentStrippingData(589824, envType.toString());
            classReader.accept((ClassVisitor)stripData, 5);
            if (stripData.stripEntireClass()) {
                throw new RuntimeException("Cannot load class " + name + " in environment type " + (Object)((Object)envType));
            }
            if (!stripData.isEmpty()) {
                visitor = new ClassStripper(589824, (ClassVisitor)visitor, stripData.getStripInterfaces(), stripData.getStripFields(), stripData.getStripMethods());
                ++visitorCount;
            }
        }
        if (visitorCount <= 0) {
            return bytes;
        }
        classReader.accept((ClassVisitor)visitor, 0);
        return classWriter.toByteArray();
    }
}

