/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.client.utils.SoundUtils;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import earth.terrarium.adastra.common.menus.vehicles.LanderMenu;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class Lander
extends Vehicle {
    private float speed;
    private float angle;
    public boolean startedRocketSound;

    public Lander(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.speed = compound.method_10583("Speed");
        this.angle = compound.method_10583("Angle");
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10548("Speed", this.speed);
        compound.method_10548("Angle", this.angle);
    }

    public double method_5621() {
        return 2.3;
    }

    @Override
    public boolean hideRider() {
        return true;
    }

    @Override
    public boolean zoomOutCameraInThirdPerson() {
        return true;
    }

    public class_243 method_24829(class_1309 passenger) {
        return super.method_24829(passenger).method_1019(passenger.method_5720().method_18805(1.0, 0.0, 1.0).method_1029().method_1023(0.0, 2.0, 0.0));
    }

    @Override
    public boolean isSafeToDismount(class_1657 player) {
        return this.method_24828();
    }

    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
        passenger.method_36456(this.method_36454());
        passenger.method_5847(this.method_5791());
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        passenger.method_36456(passenger.method_36454() + this.angle);
        passenger.method_5847(passenger.method_5791() + this.angle);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_24828()) {
            this.flightTick();
        } else {
            this.angle = 0.0f;
        }
    }

    private void flightTick() {
        class_243 delta = this.method_18798();
        float xxa = -this.xxa();
        this.angle = xxa != 0.0f ? (this.angle += xxa * 1.0f) : (this.angle *= 0.9f);
        if (this.passengerHasSpaceDown() && delta.field_1351 < -0.05) {
            this.speed += 0.01f;
            this.field_6017 *= 0.9f;
            this.spawnLanderParticles();
            if (this.method_37908().method_8608() && !this.startedRocketSound) {
                this.startedRocketSound = true;
                SoundUtils.playLanderSound(this);
            }
        } else if ((double)this.speed > -1.1) {
            this.speed -= 0.01f;
        }
        this.angle = class_3532.method_15363((float)this.angle, (float)-3.0f, (float)3.0f);
        this.method_36456(this.method_36454() + this.angle);
        this.method_18800(delta.method_10216(), this.speed, delta.method_10215());
        if (this.method_5799()) {
            this.method_18800(delta.method_10216(), Math.min(0.06, delta.method_10214() + 0.15), delta.method_10215());
            this.speed *= 0.9f;
        }
    }

    public void explode() {
        if (this.method_37908().method_8608()) {
            return;
        }
        this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 10.0f, OxygenApi.API.hasOxygen(this.method_37908()), class_1937.class_7867.field_40891);
        this.method_31472();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        if (this.method_37908().method_8608()) {
            return false;
        }
        if (fallDistance > 40.0f && this.method_24828()) {
            this.explode();
            return true;
        }
        return false;
    }

    public void spawnLanderParticles() {
        int i;
        if (!this.method_37908().method_8608()) {
            return;
        }
        for (i = 0; i < 10; ++i) {
            this.method_37908().method_8406((class_2394)ModParticleTypes.LARGE_FLAME.get(), this.method_23317(), this.method_23318() - 0.2, this.method_23321(), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05));
        }
        for (i = 0; i < 10; ++i) {
            this.method_37908().method_8406((class_2394)ModParticleTypes.LARGE_SMOKE.get(), this.method_23317(), this.method_23318() - 0.2, this.method_23321(), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05), class_3532.method_15366((class_5819)this.method_37908().field_9229, (double)-0.05, (double)0.05));
        }
    }

    @Override
    public class_1799 getDropStack() {
        return class_1799.field_8037;
    }

    @Override
    public int getInventorySize() {
        return 11;
    }

    public class_1703 createMenu(int containerId, class_1661 inventory, class_1657 player) {
        return new LanderMenu(containerId, inventory, this);
    }
}

