/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mrcrayfish.goblintraders.Constants;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.TradeSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class TradeManager
implements class_3302 {
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();
    private static final Gson GSON = new GsonBuilder().create();
    private static TradeManager instance;
    private final List<class_1299<?>> traders = new ArrayList();
    private final Map<class_2960, TradeSerializer<?>> serializers = new HashMap();
    private Map<class_1299<?>, EntityTrades> entityToTrades = new HashMap();

    public static TradeManager instance() {
        if (instance == null) {
            instance = new TradeManager();
        }
        return instance;
    }

    public void registerTrader(class_1299<? extends TraderCreatureEntity> type) {
        if (!this.traders.contains(type)) {
            this.traders.add(type);
        }
    }

    @Nullable
    public EntityTrades getTrades(class_1299<? extends TraderCreatureEntity> type) {
        return this.entityToTrades.get(type);
    }

    public void registerTypeSerializer(TradeSerializer<?> serializer) {
        this.serializers.putIfAbsent(serializer.getId(), serializer);
    }

    @Nullable
    public TradeSerializer<?> getTypeSerializer(class_2960 id) {
        return this.serializers.get(id);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 manager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        HashMap entityToResourceList = new HashMap();
        return CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.traders.forEach(entityType -> {
            String folder = String.format("trades/%s", class_1299.method_5890((class_1299)entityType).method_12832());
            ArrayList resources = new ArrayList(manager.method_14488(folder, fileName -> fileName.method_12832().endsWith(".json")).keySet());
            resources.sort((r1, r2) -> {
                if (r1.method_12836().equals(r2.method_12836())) {
                    return 0;
                }
                return r2.method_12836().equals("goblintraders") ? 1 : -1;
            });
            EnumMap tradeResources = new EnumMap(TradeRarity.class);
            Arrays.stream(TradeRarity.values()).forEach(rarity -> tradeResources.put((TradeRarity)((Object)((Object)((Object)rarity))), new LinkedHashSet()));
            resources.forEach(resource -> {
                String path = resource.method_12832().substring(0, resource.method_12832().length() - FILE_TYPE_LENGTH_VALUE);
                String[] splitPath = path.split("/");
                if (splitPath.length != 3) {
                    return;
                }
                Arrays.stream(TradeRarity.values()).forEach(rarity -> {
                    if (rarity.getKey().equals(splitPath[2])) {
                        ((LinkedHashSet)tradeResources.get(rarity)).add(resource);
                    }
                });
            });
            EntityTrades.Builder builder = EntityTrades.Builder.create();
            Arrays.stream(TradeRarity.values()).forEach(rarity -> this.deserializeTrades(manager, builder, (TradeRarity)((Object)((Object)((Object)rarity))), (LinkedHashSet)tradeResources.get(rarity)));
            entityToResourceList.put(entityType, builder.build());
            this.entityToTrades = ImmutableMap.copyOf((Map)entityToResourceList);
        }), backgroundExecutor)).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0));
    }

    private void deserializeTrades(class_3300 manager, EntityTrades.Builder builder, TradeRarity rarity, LinkedHashSet<class_2960> resources) {
        for (class_2960 resourceLocation : resources) {
            manager.method_14486(resourceLocation).ifPresent(resource -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));){
                    JsonObject object = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                    builder.deserialize(rarity, object);
                }
                catch (IOException e) {
                    Constants.LOG.error("Failed to load trade file: " + resourceLocation);
                }
            });
        }
    }
}

