/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagRegistryManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class TagRegistry<T> {
    private ITagCollection<T> field_232930_b_ = ITagCollection.func_242205_c();
    private final List<NamedTag<T>> field_232931_c_ = Lists.newArrayList();
    private final Function<ITagCollectionSupplier, ITagCollection<T>> field_242184_c;
    private static Map<ResourceLocation, List<NamedTag<?>>> toAdd = Maps.newHashMap();

    public TagRegistry(Function<ITagCollectionSupplier, ITagCollection<T>> p_i241894_1_) {
        this.field_242184_c = p_i241894_1_;
    }

    public ITag.INamedTag<T> func_232937_a_(String p_232937_1_) {
        return this.add(new NamedTag(new ResourceLocation(p_232937_1_)));
    }

    public Tags.IOptionalNamedTag<T> createOptional(ResourceLocation key, @Nullable Set<Supplier<T>> defaults) {
        return this.add(new OptionalNamedTag(key, defaults));
    }

    public static <T> ITag.INamedTag<T> createDelayedTag(ResourceLocation tagRegistry, ResourceLocation name) {
        return TagRegistry.delayedAdd(tagRegistry, new NamedTag(name));
    }

    public static <T> Tags.IOptionalNamedTag<T> createDelayedOptional(ResourceLocation tagRegistry, ResourceLocation key, @Nullable Set<Supplier<T>> defaults) {
        return TagRegistry.delayedAdd(tagRegistry, new OptionalNamedTag(key, defaults));
    }

    private static synchronized <T, R extends NamedTag<T>> R delayedAdd(ResourceLocation tagRegistry, R tag) {
        if (toAdd == null) {
            throw new RuntimeException("Creating delayed tags or optional tags, is only supported before custom tag types have been added.");
        }
        toAdd.computeIfAbsent(tagRegistry, registry -> Lists.newArrayList()).add(tag);
        return tag;
    }

    public static void performDelayedAdd() {
        if (toAdd != null) {
            for (Map.Entry<ResourceLocation, List<NamedTag<?>>> entry : toAdd.entrySet()) {
                TagRegistry<?> tagRegistry = TagRegistryManager.get(entry.getKey());
                if (tagRegistry == null) {
                    throw new RuntimeException("A mod attempted to add a delayed tag for a registry that doesn't have custom tag support.");
                }
                for (NamedTag<?> tag : entry.getValue()) {
                    super.add(tag);
                }
            }
            toAdd = null;
        }
    }

    private <R extends NamedTag<T>> R add(R namedtag) {
        namedtag.func_232943_a_(this.field_232930_b_::func_199910_a);
        this.field_232931_c_.add(namedtag);
        return namedtag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_232932_a_() {
        this.field_232930_b_ = ITagCollection.func_242205_c();
        Tag itag = Tag.func_241284_a_();
        this.field_232931_c_.forEach(arg_0 -> TagRegistry.lambda$resetToEmpty$2((ITag)itag, arg_0));
    }

    public void func_242188_a(ITagCollectionSupplier p_242188_1_) {
        ITagCollection itagcollection = this.field_242184_c.apply(p_242188_1_);
        this.field_232930_b_ = itagcollection;
        this.field_232931_c_.forEach(p_232936_1_ -> p_232936_1_.func_232943_a_(itagcollection::func_199910_a));
    }

    public ITagCollection<T> reinjectOptionalTags(ITagCollection<T> tagCollection) {
        Map currentTags = tagCollection.func_241833_a();
        Map missingOptionals = this.field_232931_c_.stream().filter(e -> e instanceof OptionalNamedTag && !currentTags.containsKey(e.func_230234_a_())).collect(Collectors.toMap(NamedTag::func_230234_a_, namedTag -> {
            OptionalNamedTag optionalNamedTag = (OptionalNamedTag)namedTag;
            optionalNamedTag.defaulted = true;
            return optionalNamedTag.resolveDefaulted();
        }, (existingTag, newTag) -> Tag.func_241286_a_((Set)ImmutableSet.builder().addAll(existingTag.func_230236_b_()).addAll(newTag.func_230236_b_()).build())));
        if (!missingOptionals.isEmpty()) {
            missingOptionals.putAll(currentTags);
            return ITagCollection.func_242202_a(missingOptionals);
        }
        return tagCollection;
    }

    public ITagCollection<T> func_232939_b_() {
        return this.field_232930_b_;
    }

    public List<? extends ITag.INamedTag<T>> func_241288_c_() {
        return this.field_232931_c_;
    }

    public Set<ResourceLocation> func_242189_b(ITagCollectionSupplier p_242189_1_) {
        ITagCollection<T> itagcollection = this.field_242184_c.apply(p_242189_1_);
        Set set = this.field_232931_c_.stream().filter(e -> !(e instanceof OptionalNamedTag)).map(NamedTag::func_230234_a_).collect(Collectors.toSet());
        ImmutableSet immutableset = ImmutableSet.copyOf(itagcollection.func_199908_a());
        return Sets.difference(set, (Set)immutableset);
    }

    private static /* synthetic */ void lambda$resetToEmpty$2(ITag itag, NamedTag p_232933_1_) {
        p_232933_1_.func_232943_a_(p_232934_1_ -> itag);
    }

    private static class OptionalNamedTag<T>
    extends NamedTag<T>
    implements Tags.IOptionalNamedTag<T> {
        @Nullable
        private final Set<Supplier<T>> defaults;
        private boolean defaulted = false;

        private OptionalNamedTag(ResourceLocation name, @Nullable Set<Supplier<T>> defaults) {
            super(name);
            this.defaults = defaults;
        }

        public boolean isDefaulted() {
            return this.defaulted;
        }

        Tag<T> resolveDefaulted() {
            if (this.defaults == null || this.defaults.isEmpty()) {
                return Tag.func_241284_a_();
            }
            return Tag.func_241286_a_((Set)ImmutableSet.copyOf((Collection)this.defaults.stream().map(Supplier::get).collect(Collectors.toSet())));
        }

        @Override
        public String toString() {
            return "OptionalNamedTag[" + this.func_230234_a_().toString() + ']';
        }
    }

    static class NamedTag<T>
    implements ITag.INamedTag<T> {
        @Nullable
        protected ITag<T> field_232942_b_;
        protected final ResourceLocation field_232941_a_;

        private NamedTag(ResourceLocation p_i231430_1_) {
            this.field_232941_a_ = p_i231430_1_;
        }

        @Override
        public ResourceLocation func_230234_a_() {
            return this.field_232941_a_;
        }

        private ITag<T> func_232944_c_() {
            if (this.field_232942_b_ == null) {
                throw new IllegalStateException("Tag " + this.field_232941_a_ + " used before it was bound");
            }
            return this.field_232942_b_;
        }

        void func_232943_a_(Function<ResourceLocation, ITag<T>> p_232943_1_) {
            this.field_232942_b_ = p_232943_1_.apply(this.field_232941_a_);
        }

        @Override
        public boolean func_230235_a_(T p_230235_1_) {
            return this.func_232944_c_().func_230235_a_(p_230235_1_);
        }

        @Override
        public List<T> func_230236_b_() {
            return this.func_232944_c_().func_230236_b_();
        }

        public String toString() {
            return "NamedTag[" + this.func_230234_a_().toString() + ']';
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ITag.INamedTag && Objects.equals(this.func_230234_a_(), ((ITag.INamedTag)o).func_230234_a_());
        }

        public int hashCode() {
            return this.func_230234_a_().hashCode();
        }
    }
}

