/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AttackStrafingTask;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.EndAttackTask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.GetAngryTask;
import net.minecraft.entity.ai.brain.task.HuntCelebrationTask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.PickupWantedItemTask;
import net.minecraft.entity.ai.brain.task.PiglinIdleActivityTask;
import net.minecraft.entity.ai.brain.task.PredicateTask;
import net.minecraft.entity.ai.brain.task.RideEntityTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.RunSometimesTask;
import net.minecraft.entity.ai.brain.task.ShootTargetTask;
import net.minecraft.entity.ai.brain.task.StopRidingEntityTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.AdmireItemTask;
import net.minecraft.entity.monster.piglin.FinishedHuntTask;
import net.minecraft.entity.monster.piglin.ForgetAdmiredItemTask;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.monster.piglin.StartAdmiringItemTask;
import net.minecraft.entity.monster.piglin.StartHuntTask;
import net.minecraft.entity.monster.piglin.StopReachingItemTask;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;

public class PiglinTasks {
    public static final Item field_234444_a_ = Items.field_151043_k;
    private static final RangedInteger field_234445_b_ = TickRangeConverter.func_233037_a_((int)30, (int)120);
    private static final RangedInteger field_234446_c_ = TickRangeConverter.func_233037_a_((int)10, (int)40);
    private static final RangedInteger field_234447_d_ = TickRangeConverter.func_233037_a_((int)10, (int)30);
    private static final RangedInteger field_234448_e_ = TickRangeConverter.func_233037_a_((int)5, (int)20);
    private static final RangedInteger field_234449_f_ = TickRangeConverter.func_233037_a_((int)5, (int)7);
    private static final RangedInteger field_241418_g_ = TickRangeConverter.func_233037_a_((int)5, (int)7);
    private static final Set<Item> field_234450_g_ = ImmutableSet.of((Object)((Object)Items.field_151147_al), (Object)((Object)Items.field_151157_am));

    protected static Brain<?> func_234469_a_(PiglinEntity p_234469_0_, Brain<PiglinEntity> p_234469_1_) {
        PiglinTasks.func_234464_a_(p_234469_1_);
        PiglinTasks.func_234485_b_(p_234469_1_);
        PiglinTasks.func_234502_d_(p_234469_1_);
        PiglinTasks.func_234488_b_(p_234469_0_, p_234469_1_);
        PiglinTasks.func_234495_c_(p_234469_1_);
        PiglinTasks.func_234507_e_(p_234469_1_);
        PiglinTasks.func_234511_f_(p_234469_1_);
        p_234469_1_.func_218199_a((Set)ImmutableSet.of((Object)((Object)Activity.field_221365_a)));
        p_234469_1_.func_218200_b(Activity.field_221366_b);
        p_234469_1_.func_233714_e_();
        return p_234469_1_;
    }

    protected static void func_234466_a_(PiglinEntity p_234466_0_) {
        int i = field_234445_b_.func_233018_a_(p_234466_0_.field_70170_p.field_73012_v);
        p_234466_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234082_P_, (Object)true, (long)i);
    }

    private static void func_234464_a_(Brain<PiglinEntity> p_234464_0_) {
        p_234464_0_.func_233698_a_(Activity.field_221365_a, 0, ImmutableList.of((Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), (Object)new InteractWithDoorTask(), PiglinTasks.func_241428_d_(), PiglinTasks.func_234500_d_(), new StartAdmiringItemTask(), (Object)new AdmireItemTask(120), (Object)new EndAttackTask(300, PiglinTasks::func_234461_a_), (Object)new GetAngryTask()));
    }

    private static void func_234485_b_(Brain<PiglinEntity> p_234485_0_) {
        p_234485_0_.func_233698_a_(Activity.field_221366_b, 10, ImmutableList.of((Object)new LookAtEntityTask(PiglinTasks::func_234482_b_, 14.0f), (Object)new ForgetAttackTargetTask(AbstractPiglinEntity::func_242337_eM, PiglinTasks::func_234526_m_), (Object)new SupplementedTask(PiglinEntity::func_234422_eK_, (Task)new StartHuntTask()), PiglinTasks.func_234493_c_(), PiglinTasks.func_234505_e_(), PiglinTasks.func_234458_a_(), PiglinTasks.func_234481_b_(), (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)));
    }

    private static void func_234488_b_(PiglinEntity p_234488_0_, Brain<PiglinEntity> p_234488_1_) {
        p_234488_1_.func_233699_a_(Activity.field_234621_k_, 10, ImmutableList.of((Object)new FindNewAttackTargetTask(p_234523_1_ -> !PiglinTasks.func_234504_d_(p_234488_0_, p_234523_1_)), (Object)new SupplementedTask(PiglinTasks::func_234494_c_, (Task)new AttackStrafingTask(5, 0.75f)), (Object)new MoveToTargetTask(1.0f), (Object)new AttackTargetTask(20), new ShootTargetTask(), (Object)new FinishedHuntTask(), (Object)new PredicateTask(PiglinTasks::func_234525_l_, MemoryModuleType.field_234103_o_)), MemoryModuleType.field_234103_o_);
    }

    private static void func_234495_c_(Brain<PiglinEntity> p_234495_0_) {
        p_234495_0_.func_233699_a_(Activity.field_234622_l_, 10, ImmutableList.of(PiglinTasks.func_234493_c_(), (Object)new LookAtEntityTask(PiglinTasks::func_234482_b_, 14.0f), (Object)new ForgetAttackTargetTask(AbstractPiglinEntity::func_242337_eM, PiglinTasks::func_234526_m_), (Object)new SupplementedTask(p_234457_0_ -> !p_234457_0_.func_234425_eN_(), (Task)new HuntCelebrationTask(2, 1.0f)), (Object)new SupplementedTask(PiglinEntity::func_234425_eN_, (Task)new HuntCelebrationTask(4, 0.6f)), (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_233591_ai_, 8.0f), (Object)1), (Object)Pair.of((Object)new WalkRandomlyTask(0.6f, 2, 1), (Object)1), (Object)Pair.of((Object)new DummyTask(10, 20), (Object)1)))), MemoryModuleType.field_234083_Q_);
    }

    private static void func_234502_d_(Brain<PiglinEntity> p_234502_0_) {
        p_234502_0_.func_233699_a_(Activity.field_234623_m_, 10, ImmutableList.of((Object)new PickupWantedItemTask(PiglinTasks::func_234455_E_, 1.0f, true, 9), (Object)new ForgetAdmiredItemTask(9), (Object)new StopReachingItemTask(200, 200)), MemoryModuleType.field_234080_N_);
    }

    private static void func_234507_e_(Brain<PiglinEntity> p_234507_0_) {
        p_234507_0_.func_233699_a_(Activity.field_234624_n_, 10, ImmutableList.of((Object)RunAwayTask.func_233965_b_(MemoryModuleType.field_234106_z_, (float)1.0f, (int)12, (boolean)true), PiglinTasks.func_234458_a_(), PiglinTasks.func_234481_b_(), (Object)new PredicateTask(PiglinTasks::func_234533_t_, MemoryModuleType.field_234106_z_)), MemoryModuleType.field_234106_z_);
    }

    private static void func_234511_f_(Brain<PiglinEntity> p_234511_0_) {
        p_234511_0_.func_233699_a_(Activity.field_234625_o_, 10, ImmutableList.of((Object)new RideEntityTask(0.8f), (Object)new LookAtEntityTask(PiglinTasks::func_234482_b_, 8.0f), (Object)new SupplementedTask(Entity::func_184218_aH, PiglinTasks.func_234458_a_()), (Object)new StopRidingEntityTask(8, PiglinTasks::func_234467_a_)), MemoryModuleType.field_234105_s_);
    }

    private static FirstShuffledTask<PiglinEntity> func_234458_a_() {
        return new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_233591_ai_, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    private static FirstShuffledTask<PiglinEntity> func_234481_b_() {
        return new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(0.6f), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a(EntityType.field_233591_ai_, (int)8, MemoryModuleType.field_220952_m, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)new SupplementedTask(PiglinTasks::func_234514_g_, (Task)new WalkTowardsLookTargetTask(0.6f, 3)), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)));
    }

    private static RunAwayTask<BlockPos> func_234493_c_() {
        return RunAwayTask.func_233963_a_(MemoryModuleType.field_234098_af_, (float)1.0f, (int)8, (boolean)false);
    }

    private static PiglinIdleActivityTask<PiglinEntity, LivingEntity> func_241428_d_() {
        return new PiglinIdleActivityTask(PiglinEntity::func_70631_g_, MemoryModuleType.field_234077_K_, MemoryModuleType.field_234106_z_, field_241418_g_);
    }

    private static PiglinIdleActivityTask<PiglinEntity, LivingEntity> func_234500_d_() {
        return new PiglinIdleActivityTask(PiglinTasks::func_234525_l_, MemoryModuleType.field_234093_aa_, MemoryModuleType.field_234106_z_, field_234449_f_);
    }

    protected static void func_234486_b_(PiglinEntity p_234486_0_) {
        Brain<PiglinEntity> brain = p_234486_0_.func_213375_cj();
        Activity activity = brain.func_233716_f_().orElse(null);
        brain.func_233706_a_((List)ImmutableList.of((Object)((Object)Activity.field_234623_m_), (Object)((Object)Activity.field_234621_k_), (Object)((Object)Activity.field_234624_n_), (Object)((Object)Activity.field_234622_l_), (Object)((Object)Activity.field_234625_o_), (Object)((Object)Activity.field_221366_b)));
        Activity activity1 = brain.func_233716_f_().orElse(null);
        if (activity != activity1) {
            PiglinTasks.func_241429_d_(p_234486_0_).ifPresent(p_234486_0_::func_241417_a_);
        }
        p_234486_0_.func_213395_q(brain.func_218191_a(MemoryModuleType.field_234103_o_));
        if (!brain.func_218191_a(MemoryModuleType.field_234105_s_) && PiglinTasks.func_234522_j_(p_234486_0_)) {
            p_234486_0_.func_184210_p();
        }
        if (!brain.func_218191_a(MemoryModuleType.field_234083_Q_)) {
            brain.func_218189_b(MemoryModuleType.field_234084_R_);
        }
        p_234486_0_.func_234442_u_(brain.func_218191_a(MemoryModuleType.field_234084_R_));
    }

    private static boolean func_234522_j_(PiglinEntity p_234522_0_) {
        if (!p_234522_0_.func_70631_g_()) {
            return false;
        }
        Entity entity = p_234522_0_.func_184187_bx();
        return entity instanceof PiglinEntity && ((PiglinEntity)((Object)entity)).func_70631_g_() || entity instanceof HoglinEntity && ((HoglinEntity)((Object)entity)).func_70631_g_();
    }

    protected static void func_234470_a_(PiglinEntity p_234470_0_, ItemEntity p_234470_1_) {
        ItemStack itemstack;
        PiglinTasks.func_234531_r_(p_234470_0_);
        if (p_234470_1_.func_92059_d().func_77973_b() == Items.field_151074_bl) {
            p_234470_0_.func_71001_a(p_234470_1_, p_234470_1_.func_92059_d().func_190916_E());
            itemstack = p_234470_1_.func_92059_d();
            p_234470_1_.func_70106_y();
        } else {
            p_234470_0_.func_71001_a(p_234470_1_, 1);
            itemstack = PiglinTasks.func_234465_a_(p_234470_1_);
        }
        Item item = itemstack.func_77973_b();
        if (PiglinTasks.func_234480_a_(item)) {
            p_234470_0_.func_213375_cj().func_218189_b(MemoryModuleType.field_242310_O);
            PiglinTasks.func_241427_c_(p_234470_0_, itemstack);
            PiglinTasks.func_234501_d_((LivingEntity)((Object)p_234470_0_));
        } else if (PiglinTasks.func_234499_c_(item) && !PiglinTasks.func_234538_z_(p_234470_0_)) {
            PiglinTasks.func_234536_x_(p_234470_0_);
        } else {
            boolean flag = p_234470_0_.func_233665_g_(itemstack);
            if (!flag) {
                PiglinTasks.func_234498_c_(p_234470_0_, itemstack);
            }
        }
    }

    private static void func_241427_c_(PiglinEntity p_241427_0_, ItemStack p_241427_1_) {
        if (PiglinTasks.func_234454_D_(p_241427_0_)) {
            p_241427_0_.func_199701_a_(p_241427_0_.func_184586_b(Hand.OFF_HAND));
        }
        p_241427_0_.func_234439_n_(p_241427_1_);
    }

    private static ItemStack func_234465_a_(ItemEntity p_234465_0_) {
        ItemStack itemstack = p_234465_0_.func_92059_d();
        ItemStack itemstack1 = itemstack.func_77979_a(1);
        if (itemstack.func_190926_b()) {
            p_234465_0_.func_70106_y();
        } else {
            p_234465_0_.func_92058_a(itemstack);
        }
        return itemstack1;
    }

    protected static void func_234477_a_(PiglinEntity p_234477_0_, boolean p_234477_1_) {
        ItemStack itemstack = p_234477_0_.func_184586_b(Hand.OFF_HAND);
        p_234477_0_.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
        if (p_234477_0_.func_242337_eM()) {
            boolean flag1;
            boolean flag = itemstack.isPiglinCurrency();
            if (p_234477_1_ && flag) {
                PiglinTasks.func_234475_a_(p_234477_0_, PiglinTasks.func_234524_k_(p_234477_0_));
            } else if (!flag && !(flag1 = p_234477_0_.func_233665_g_(itemstack))) {
                PiglinTasks.func_234498_c_(p_234477_0_, itemstack);
            }
        } else {
            boolean flag2 = p_234477_0_.func_233665_g_(itemstack);
            if (!flag2) {
                ItemStack itemstack1 = p_234477_0_.func_184614_ca();
                if (PiglinTasks.func_234480_a_(itemstack1.func_77973_b())) {
                    PiglinTasks.func_234498_c_(p_234477_0_, itemstack1);
                } else {
                    PiglinTasks.func_234475_a_(p_234477_0_, Collections.singletonList(itemstack1));
                }
                p_234477_0_.func_234438_m_(itemstack);
            }
        }
    }

    protected static void func_234496_c_(PiglinEntity p_234496_0_) {
        if (PiglinTasks.func_234451_A_(p_234496_0_) && !p_234496_0_.func_184592_cb().func_190926_b()) {
            p_234496_0_.func_199701_a_(p_234496_0_.func_184592_cb());
            p_234496_0_.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
        }
    }

    private static void func_234498_c_(PiglinEntity p_234498_0_, ItemStack p_234498_1_) {
        ItemStack itemstack = p_234498_0_.func_234436_k_(p_234498_1_);
        PiglinTasks.func_234490_b_(p_234498_0_, Collections.singletonList(itemstack));
    }

    private static void func_234475_a_(PiglinEntity p_234475_0_, List<ItemStack> p_234475_1_) {
        Optional optional = p_234475_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_220949_j);
        if (optional.isPresent()) {
            PiglinTasks.func_234472_a_(p_234475_0_, (PlayerEntity)((Object)optional.get()), p_234475_1_);
        } else {
            PiglinTasks.func_234490_b_(p_234475_0_, p_234475_1_);
        }
    }

    private static void func_234490_b_(PiglinEntity p_234490_0_, List<ItemStack> p_234490_1_) {
        PiglinTasks.func_234476_a_(p_234490_0_, p_234490_1_, PiglinTasks.func_234537_y_(p_234490_0_));
    }

    private static void func_234472_a_(PiglinEntity p_234472_0_, PlayerEntity p_234472_1_, List<ItemStack> p_234472_2_) {
        PiglinTasks.func_234476_a_(p_234472_0_, p_234472_2_, p_234472_1_.func_213303_ch());
    }

    private static void func_234476_a_(PiglinEntity p_234476_0_, List<ItemStack> p_234476_1_, Vector3d p_234476_2_) {
        if (!p_234476_1_.isEmpty()) {
            p_234476_0_.func_184609_a(Hand.OFF_HAND);
            for (ItemStack itemstack : p_234476_1_) {
                BrainUtil.func_233865_a_((LivingEntity)((Object)p_234476_0_), (ItemStack)itemstack, (Vector3d)p_234476_2_.func_72441_c(0.0, 1.0, 0.0));
            }
        }
    }

    private static List<ItemStack> func_234524_k_(PiglinEntity p_234524_0_) {
        LootTable loottable = p_234524_0_.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_237385_ay_);
        return loottable.func_216113_a(new LootContext.Builder((ServerWorld)p_234524_0_.field_70170_p).func_216015_a(LootParameters.field_216281_a, p_234524_0_).func_216023_a(p_234524_0_.field_70170_p.field_73012_v).func_216022_a(LootParameterSets.field_237453_h_));
    }

    private static boolean func_234461_a_(LivingEntity p_234461_0_, LivingEntity p_234461_1_) {
        if (p_234461_1_.func_200600_R() != EntityType.field_233588_G_) {
            return false;
        }
        return new Random(p_234461_0_.field_70170_p.func_82737_E()).nextFloat() < 0.1f;
    }

    protected static boolean func_234474_a_(PiglinEntity p_234474_0_, ItemStack p_234474_1_) {
        Item item = p_234474_1_.func_77973_b();
        if (item.func_206844_a(ItemTags.field_232902_M_)) {
            return false;
        }
        if (PiglinTasks.func_234453_C_(p_234474_0_) && p_234474_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_)) {
            return false;
        }
        if (p_234474_1_.isPiglinCurrency()) {
            return PiglinTasks.func_234455_E_(p_234474_0_);
        }
        boolean flag = p_234474_0_.func_234437_l_(p_234474_1_);
        if (item == Items.field_151074_bl) {
            return flag;
        }
        if (PiglinTasks.func_234499_c_(item)) {
            return !PiglinTasks.func_234538_z_(p_234474_0_) && flag;
        }
        if (!PiglinTasks.func_234480_a_(item)) {
            return p_234474_0_.func_234440_o_(p_234474_1_);
        }
        return PiglinTasks.func_234455_E_(p_234474_0_) && flag;
    }

    protected static boolean func_234480_a_(Item p_234480_0_) {
        return p_234480_0_.func_206844_a(ItemTags.field_232903_N_);
    }

    private static boolean func_234467_a_(PiglinEntity p_234467_0_, Entity p_234467_1_) {
        if (!(p_234467_1_ instanceof MobEntity)) {
            return false;
        }
        MobEntity mobentity = (MobEntity)p_234467_1_;
        return !mobentity.func_70631_g_() || !mobentity.func_70089_S() || PiglinTasks.func_234517_h_((LivingEntity)((Object)p_234467_0_)) || PiglinTasks.func_234517_h_(mobentity) || mobentity instanceof PiglinEntity && mobentity.func_184187_bx() == null;
    }

    private static boolean func_234504_d_(PiglinEntity p_234504_0_, LivingEntity p_234504_1_) {
        return PiglinTasks.func_234526_m_(p_234504_0_).filter(p_234483_1_ -> p_234483_1_ == p_234504_1_).isPresent();
    }

    private static boolean func_234525_l_(PiglinEntity p_234525_0_) {
        Brain<PiglinEntity> brain = p_234525_0_.func_213375_cj();
        if (brain.func_218191_a(MemoryModuleType.field_234093_aa_)) {
            LivingEntity livingentity = (LivingEntity)((Object)brain.func_218207_c(MemoryModuleType.field_234093_aa_).get());
            return p_234525_0_.func_233562_a_(livingentity, 6.0);
        }
        return false;
    }

    private static Optional<? extends LivingEntity> func_234526_m_(PiglinEntity p_234526_0_) {
        Optional optional1;
        Brain<PiglinEntity> brain = p_234526_0_.func_213375_cj();
        if (PiglinTasks.func_234525_l_(p_234526_0_)) {
            return Optional.empty();
        }
        Optional optional = BrainUtil.func_233864_a_((LivingEntity)((Object)p_234526_0_), MemoryModuleType.field_234078_L_);
        if (optional.isPresent() && PiglinTasks.func_234506_e_((LivingEntity)((Object)optional.get()))) {
            return optional;
        }
        if (brain.func_218191_a(MemoryModuleType.field_234079_M_) && (optional1 = brain.func_218207_c(MemoryModuleType.field_234102_l_)).isPresent()) {
            return optional1;
        }
        Optional optional3 = brain.func_218207_c(MemoryModuleType.field_234077_K_);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional optional2 = brain.func_218207_c(MemoryModuleType.field_234088_V_);
        return optional2.isPresent() && PiglinTasks.func_234506_e_((LivingEntity)((Object)optional2.get())) ? optional2 : Optional.empty();
    }

    public static void func_234478_a_(PlayerEntity p_234478_0_, boolean p_234478_1_) {
        List list = p_234478_0_.field_70170_p.func_217357_a(PiglinEntity.class, p_234478_0_.func_174813_aQ().func_186662_g(16.0));
        list.stream().filter(PiglinTasks::func_234520_i_).filter(p_234491_2_ -> !p_234478_1_ || BrainUtil.func_233876_c_((LivingEntity)((Object)((Object)p_234491_2_)), (LivingEntity)p_234478_0_)).forEach(p_234479_1_ -> {
            if (p_234479_1_.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                PiglinTasks.func_241431_f_(p_234479_1_, p_234478_0_);
            } else {
                PiglinTasks.func_234497_c_(p_234479_1_, p_234478_0_);
            }
        });
    }

    public static ActionResultType func_234471_a_(PiglinEntity p_234471_0_, PlayerEntity p_234471_1_, Hand p_234471_2_) {
        ItemStack itemstack = p_234471_1_.func_184586_b(p_234471_2_);
        if (PiglinTasks.func_234489_b_(p_234471_0_, itemstack)) {
            ItemStack itemstack1 = itemstack.func_77979_a(1);
            PiglinTasks.func_241427_c_(p_234471_0_, itemstack1);
            PiglinTasks.func_234501_d_((LivingEntity)((Object)p_234471_0_));
            PiglinTasks.func_234531_r_(p_234471_0_);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    protected static boolean func_234489_b_(PiglinEntity p_234489_0_, ItemStack p_234489_1_) {
        return !PiglinTasks.func_234453_C_(p_234489_0_) && !PiglinTasks.func_234451_A_(p_234489_0_) && p_234489_0_.func_242337_eM() && p_234489_1_.isPiglinCurrency();
    }

    protected static void func_234468_a_(PiglinEntity p_234468_0_, LivingEntity p_234468_1_) {
        if (!(p_234468_1_ instanceof PiglinEntity)) {
            if (PiglinTasks.func_234454_D_(p_234468_0_)) {
                PiglinTasks.func_234477_a_(p_234468_0_, false);
            }
            Brain<PiglinEntity> brain = p_234468_0_.func_213375_cj();
            brain.func_218189_b(MemoryModuleType.field_234083_Q_);
            brain.func_218189_b(MemoryModuleType.field_234084_R_);
            brain.func_218189_b(MemoryModuleType.field_234080_N_);
            if (p_234468_1_ instanceof PlayerEntity) {
                brain.func_233696_a_(MemoryModuleType.field_234081_O_, (Object)true, 400L);
            }
            PiglinTasks.func_234515_g_(p_234468_0_).ifPresent(p_234462_2_ -> {
                if (p_234462_2_.func_200600_R() != p_234468_1_.func_200600_R()) {
                    brain.func_218189_b(MemoryModuleType.field_234106_z_);
                }
            });
            if (p_234468_0_.func_70631_g_()) {
                brain.func_233696_a_(MemoryModuleType.field_234106_z_, (Object)p_234468_1_, 100L);
                if (PiglinTasks.func_234506_e_(p_234468_1_)) {
                    PiglinTasks.func_234487_b_(p_234468_0_, p_234468_1_);
                }
            } else if (p_234468_1_.func_200600_R() == EntityType.field_233588_G_ && PiglinTasks.func_234535_v_(p_234468_0_)) {
                PiglinTasks.func_234521_i_(p_234468_0_, p_234468_1_);
                PiglinTasks.func_234516_g_(p_234468_0_, p_234468_1_);
            } else {
                PiglinTasks.func_234509_e_(p_234468_0_, p_234468_1_);
            }
        }
    }

    protected static void func_234509_e_(AbstractPiglinEntity p_234509_0_, LivingEntity p_234509_1_) {
        if (!p_234509_0_.func_213375_cj().func_218214_c(Activity.field_234624_n_) && PiglinTasks.func_234506_e_(p_234509_1_) && !BrainUtil.func_233861_a_((LivingEntity)((Object)p_234509_0_), (LivingEntity)p_234509_1_, (double)4.0)) {
            if (p_234509_1_.func_200600_R() == EntityType.field_200729_aH && p_234509_0_.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                PiglinTasks.func_241431_f_(p_234509_0_, p_234509_1_);
                PiglinTasks.func_241430_f_(p_234509_0_);
            } else {
                PiglinTasks.func_234497_c_(p_234509_0_, p_234509_1_);
                PiglinTasks.func_234487_b_(p_234509_0_, p_234509_1_);
            }
        }
    }

    public static Optional<SoundEvent> func_241429_d_(PiglinEntity p_241429_0_) {
        return p_241429_0_.func_213375_cj().func_233716_f_().map(p_241426_1_ -> PiglinTasks.func_241422_a_(p_241429_0_, p_241426_1_));
    }

    private static SoundEvent func_241422_a_(PiglinEntity p_241422_0_, Activity p_241422_1_) {
        if (p_241422_1_ == Activity.field_234621_k_) {
            return SoundEvents.field_232789_kT_;
        }
        if (p_241422_0_.func_242336_eL()) {
            return SoundEvents.field_232794_kY_;
        }
        if (p_241422_1_ == Activity.field_234624_n_ && PiglinTasks.func_234528_o_(p_241422_0_)) {
            return SoundEvents.field_232794_kY_;
        }
        if (p_241422_1_ == Activity.field_234623_m_) {
            return SoundEvents.field_232787_kR_;
        }
        if (p_241422_1_ == Activity.field_234622_l_) {
            return SoundEvents.field_232790_kU_;
        }
        if (PiglinTasks.func_234510_f_((LivingEntity)((Object)p_241422_0_))) {
            return SoundEvents.field_232792_kW_;
        }
        return PiglinTasks.func_234452_B_(p_241422_0_) ? SoundEvents.field_232794_kY_ : SoundEvents.field_232788_kS_;
    }

    private static boolean func_234528_o_(PiglinEntity p_234528_0_) {
        Brain<PiglinEntity> brain = p_234528_0_.func_213375_cj();
        return !brain.func_218191_a(MemoryModuleType.field_234106_z_) ? false : ((LivingEntity)((Object)brain.func_218207_c(MemoryModuleType.field_234106_z_).get())).func_233562_a_((Entity)((Object)p_234528_0_), 12.0);
    }

    protected static boolean func_234508_e_(PiglinEntity p_234508_0_) {
        return p_234508_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234082_P_) || PiglinTasks.func_234529_p_(p_234508_0_).stream().anyMatch(p_234456_0_ -> p_234456_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234082_P_));
    }

    private static List<AbstractPiglinEntity> func_234529_p_(PiglinEntity p_234529_0_) {
        return (List)p_234529_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_234090_X_).orElse(ImmutableList.of());
    }

    private static List<AbstractPiglinEntity> func_234530_q_(AbstractPiglinEntity p_234530_0_) {
        return (List)p_234530_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_234089_W_).orElse(ImmutableList.of());
    }

    public static boolean func_234460_a_(LivingEntity p_234460_0_) {
        for (ItemStack itemstack : p_234460_0_.func_184193_aE()) {
            Item item = itemstack.func_77973_b();
            if (!itemstack.makesPiglinsNeutral(p_234460_0_)) continue;
            return true;
        }
        return false;
    }

    private static void func_234531_r_(PiglinEntity p_234531_0_) {
        p_234531_0_.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        p_234531_0_.func_70661_as().func_75499_g();
    }

    private static RunSometimesTask<PiglinEntity> func_234505_e_() {
        return new RunSometimesTask((Task)new PiglinIdleActivityTask(PiglinEntity::func_70631_g_, MemoryModuleType.field_234086_T_, MemoryModuleType.field_234105_s_, field_234447_d_), field_234446_c_);
    }

    protected static void func_234487_b_(AbstractPiglinEntity p_234487_0_, LivingEntity p_234487_1_) {
        PiglinTasks.func_234530_q_(p_234487_0_).forEach(p_234484_1_ -> {
            if (p_234487_1_.func_200600_R() != EntityType.field_233588_G_ || p_234484_1_.func_234422_eK_() && ((HoglinEntity)((Object)((Object)((Object)p_234487_1_)))).func_234365_eM_()) {
                PiglinTasks.func_234513_f_(p_234484_1_, p_234487_1_);
            }
        });
    }

    protected static void func_241430_f_(AbstractPiglinEntity p_241430_0_) {
        PiglinTasks.func_234530_q_(p_241430_0_).forEach(p_241419_0_ -> PiglinTasks.func_241432_i_(p_241419_0_).ifPresent(p_241421_1_ -> PiglinTasks.func_234497_c_(p_241419_0_, p_241421_1_)));
    }

    protected static void func_234512_f_(PiglinEntity p_234512_0_) {
        PiglinTasks.func_234529_p_(p_234512_0_).forEach(PiglinTasks::func_234518_h_);
    }

    protected static void func_234497_c_(AbstractPiglinEntity p_234497_0_, LivingEntity p_234497_1_) {
        if (PiglinTasks.func_234506_e_(p_234497_1_)) {
            p_234497_0_.func_213375_cj().func_218189_b(MemoryModuleType.field_223021_x);
            p_234497_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234078_L_, (Object)p_234497_1_.func_110124_au(), 600L);
            if (p_234497_1_.func_200600_R() == EntityType.field_233588_G_ && p_234497_0_.func_234422_eK_()) {
                PiglinTasks.func_234518_h_(p_234497_0_);
            }
            if (p_234497_1_.func_200600_R() == EntityType.field_200729_aH && p_234497_0_.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                p_234497_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234079_M_, (Object)true, 600L);
            }
        }
    }

    private static void func_241431_f_(AbstractPiglinEntity p_241431_0_, LivingEntity p_241431_1_) {
        Optional<PlayerEntity> optional = PiglinTasks.func_241432_i_(p_241431_0_);
        if (optional.isPresent()) {
            PiglinTasks.func_234497_c_(p_241431_0_, optional.get());
        } else {
            PiglinTasks.func_234497_c_(p_241431_0_, p_241431_1_);
        }
    }

    private static void func_234513_f_(AbstractPiglinEntity p_234513_0_, LivingEntity p_234513_1_) {
        Optional<LivingEntity> optional = PiglinTasks.func_234532_s_(p_234513_0_);
        LivingEntity livingentity = BrainUtil.func_233867_a_((LivingEntity)((Object)p_234513_0_), optional, (LivingEntity)p_234513_1_);
        if (!optional.isPresent() || optional.get() != livingentity) {
            PiglinTasks.func_234497_c_(p_234513_0_, livingentity);
        }
    }

    private static Optional<LivingEntity> func_234532_s_(AbstractPiglinEntity p_234532_0_) {
        return BrainUtil.func_233864_a_((LivingEntity)((Object)p_234532_0_), MemoryModuleType.field_234078_L_);
    }

    public static Optional<LivingEntity> func_234515_g_(PiglinEntity p_234515_0_) {
        return p_234515_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234106_z_) ? p_234515_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_234106_z_) : Optional.empty();
    }

    public static Optional<PlayerEntity> func_241432_i_(AbstractPiglinEntity p_241432_0_) {
        return p_241432_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234102_l_) ? p_241432_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_234102_l_) : Optional.empty();
    }

    private static void func_234516_g_(PiglinEntity p_234516_0_, LivingEntity p_234516_1_) {
        PiglinTasks.func_234529_p_(p_234516_0_).stream().filter(p_242341_0_ -> p_242341_0_ instanceof PiglinEntity).forEach(p_234463_1_ -> PiglinTasks.func_234519_h_((PiglinEntity)p_234463_1_, p_234516_1_));
    }

    private static void func_234519_h_(PiglinEntity p_234519_0_, LivingEntity p_234519_1_) {
        Brain<PiglinEntity> brain = p_234519_0_.func_213375_cj();
        LivingEntity lvt_3_1_ = BrainUtil.func_233867_a_((LivingEntity)((Object)p_234519_0_), (Optional)brain.func_218207_c(MemoryModuleType.field_234106_z_), (LivingEntity)p_234519_1_);
        lvt_3_1_ = BrainUtil.func_233867_a_((LivingEntity)((Object)p_234519_0_), (Optional)brain.func_218207_c(MemoryModuleType.field_234103_o_), (LivingEntity)lvt_3_1_);
        PiglinTasks.func_234521_i_(p_234519_0_, lvt_3_1_);
    }

    private static boolean func_234533_t_(PiglinEntity p_234533_0_) {
        Brain<PiglinEntity> brain = p_234533_0_.func_213375_cj();
        if (!brain.func_218191_a(MemoryModuleType.field_234106_z_)) {
            return true;
        }
        LivingEntity livingentity = (LivingEntity)((Object)brain.func_218207_c(MemoryModuleType.field_234106_z_).get());
        EntityType<?> entitytype = livingentity.func_200600_R();
        if (entitytype == EntityType.field_233588_G_) {
            return PiglinTasks.func_234534_u_(p_234533_0_);
        }
        if (PiglinTasks.func_234459_a_(entitytype)) {
            return !brain.func_233708_b_(MemoryModuleType.field_234093_aa_, (Object)livingentity);
        }
        return false;
    }

    private static boolean func_234534_u_(PiglinEntity p_234534_0_) {
        return !PiglinTasks.func_234535_v_(p_234534_0_);
    }

    private static boolean func_234535_v_(PiglinEntity p_234535_0_) {
        int i = p_234535_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_234094_ab_).orElse(0) + 1;
        int j = p_234535_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_234095_ac_).orElse(0);
        return j > i;
    }

    private static void func_234521_i_(PiglinEntity p_234521_0_, LivingEntity p_234521_1_) {
        p_234521_0_.func_213375_cj().func_218189_b(MemoryModuleType.field_234078_L_);
        p_234521_0_.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
        p_234521_0_.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        p_234521_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234106_z_, (Object)p_234521_1_, (long)field_234448_e_.func_233018_a_(p_234521_0_.field_70170_p.field_73012_v));
        PiglinTasks.func_234518_h_(p_234521_0_);
    }

    protected static void func_234518_h_(AbstractPiglinEntity p_234518_0_) {
        p_234518_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234082_P_, (Object)true, (long)field_234445_b_.func_233018_a_(p_234518_0_.field_70170_p.field_73012_v));
    }

    private static void func_234536_x_(PiglinEntity p_234536_0_) {
        p_234536_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234097_ae_, (Object)true, 200L);
    }

    private static Vector3d func_234537_y_(PiglinEntity p_234537_0_) {
        Vector3d vector3d = RandomPositionGenerator.func_191377_b((CreatureEntity)p_234537_0_, (int)4, (int)2);
        return vector3d == null ? p_234537_0_.func_213303_ch() : vector3d;
    }

    private static boolean func_234538_z_(PiglinEntity p_234538_0_) {
        return p_234538_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234097_ae_);
    }

    protected static boolean func_234520_i_(AbstractPiglinEntity p_234520_0_) {
        return p_234520_0_.func_213375_cj().func_218214_c(Activity.field_221366_b);
    }

    private static boolean func_234494_c_(LivingEntity p_234494_0_) {
        return p_234494_0_.func_233634_a_(item -> item instanceof CrossbowItem);
    }

    private static void func_234501_d_(LivingEntity p_234501_0_) {
        p_234501_0_.func_213375_cj().func_233696_a_(MemoryModuleType.field_234080_N_, (Object)true, 120L);
    }

    private static boolean func_234451_A_(PiglinEntity p_234451_0_) {
        return p_234451_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234080_N_);
    }

    private static boolean func_234492_b_(Item p_234492_0_) {
        return p_234492_0_ == field_234444_a_;
    }

    private static boolean func_234499_c_(Item p_234499_0_) {
        return field_234450_g_.contains((Object)p_234499_0_);
    }

    private static boolean func_234506_e_(LivingEntity p_234506_0_) {
        return EntityPredicates.field_233583_f_.test(p_234506_0_);
    }

    private static boolean func_234452_B_(PiglinEntity p_234452_0_) {
        return p_234452_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234098_af_);
    }

    private static boolean func_234510_f_(LivingEntity p_234510_0_) {
        return p_234510_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234096_ad_);
    }

    private static boolean func_234514_g_(LivingEntity p_234514_0_) {
        return !PiglinTasks.func_234510_f_(p_234514_0_);
    }

    public static boolean func_234482_b_(LivingEntity p_234482_0_) {
        return p_234482_0_.func_200600_R() == EntityType.field_200729_aH && p_234482_0_.func_233634_a_(PiglinTasks::func_234480_a_);
    }

    private static boolean func_234453_C_(PiglinEntity p_234453_0_) {
        return p_234453_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_234081_O_);
    }

    private static boolean func_234517_h_(LivingEntity p_234517_0_) {
        return p_234517_0_.func_213375_cj().func_218191_a(MemoryModuleType.field_220957_r);
    }

    private static boolean func_234454_D_(PiglinEntity p_234454_0_) {
        return !p_234454_0_.func_184592_cb().func_190926_b();
    }

    private static boolean func_234455_E_(PiglinEntity p_234455_0_) {
        return p_234455_0_.func_184592_cb().func_190926_b() || !PiglinTasks.func_234480_a_(p_234455_0_.func_184592_cb().func_77973_b());
    }

    public static boolean func_234459_a_(EntityType p_234459_0_) {
        return p_234459_0_ == EntityType.field_233592_ba_ || p_234459_0_ == EntityType.field_233590_aW_;
    }
}

