/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistryCodec;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleRegistry<T>
extends MutableRegistry<T> {
    protected static final Logger field_148743_a = LogManager.getLogger();
    private final ObjectList<T> field_243533_bf = new ObjectArrayList(256);
    private final Object2IntMap<T> field_243534_bg = new Object2IntOpenCustomHashMap(Util.func_212443_g());
    private final BiMap<ResourceLocation, T> field_82596_a;
    private final BiMap<RegistryKey<T>, T> field_239649_bb_;
    private final Map<T, Lifecycle> field_243535_bj;
    private Lifecycle field_243536_bk;
    protected Object[] field_186802_b;
    private int field_195869_d;

    public SimpleRegistry(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle) {
        super(registryKey, lifecycle);
        this.field_243534_bg.defaultReturnValue(-1);
        this.field_82596_a = HashBiMap.create();
        this.field_239649_bb_ = HashBiMap.create();
        this.field_243535_bj = Maps.newIdentityHashMap();
        this.field_243536_bk = lifecycle;
    }

    public static <T> MapCodec<Entry<T>> func_243541_a(RegistryKey<? extends Registry<T>> registryKey, MapCodec<T> mapCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.field_240908_a_.xmap(RegistryKey.func_240902_a_(registryKey), RegistryKey::func_240901_a_).fieldOf("name").forGetter(entry -> entry.field_243546_a), (App)Codec.INT.fieldOf("id").forGetter(entry -> entry.field_243547_b), (App)mapCodec.forGetter(entry -> entry.field_243548_c)).apply((Applicative)instance, Entry::new));
    }

    @Override
    public <V extends T> V func_218382_a(int n, RegistryKey<T> registryKey, V v, Lifecycle lifecycle) {
        return this.func_243537_a(n, registryKey, v, lifecycle, true);
    }

    private <V extends T> V func_243537_a(int n, RegistryKey<T> registryKey, V v, Lifecycle lifecycle, boolean bl) {
        Validate.notNull(registryKey);
        Validate.notNull(v);
        this.field_243533_bf.size(Math.max(this.field_243533_bf.size(), n + 1));
        this.field_243533_bf.set(n, v);
        this.field_243534_bg.put(v, n);
        this.field_186802_b = null;
        if (bl && this.field_239649_bb_.containsKey(registryKey)) {
            field_148743_a.debug("Adding duplicate key '{}' to registry", registryKey);
        }
        if (this.field_82596_a.containsValue(v)) {
            field_148743_a.error("Adding duplicate value '{}' to registry", v);
        }
        this.field_82596_a.put((Object)registryKey.func_240901_a_(), v);
        this.field_239649_bb_.put(registryKey, v);
        this.field_243535_bj.put(v, lifecycle);
        this.field_243536_bk = this.field_243536_bk.add(lifecycle);
        if (this.field_195869_d <= n) {
            this.field_195869_d = n + 1;
        }
        return v;
    }

    @Override
    public <V extends T> V func_218381_a(RegistryKey<T> registryKey, V v, Lifecycle lifecycle) {
        return this.func_218382_a(this.field_195869_d, registryKey, v, lifecycle);
    }

    @Override
    public <V extends T> V func_241874_a(OptionalInt optionalInt, RegistryKey<T> registryKey, V v, Lifecycle lifecycle) {
        int \u26032;
        Validate.notNull(registryKey);
        Validate.notNull(v);
        Object object = this.field_239649_bb_.get(registryKey);
        if (object == null) {
            \u26032 = optionalInt.isPresent() ? optionalInt.getAsInt() : this.field_195869_d;
        } else {
            \u26032 = this.field_243534_bg.getInt(object);
            if (optionalInt.isPresent() && optionalInt.getAsInt() != \u26032) {
                throw new IllegalStateException("ID mismatch");
            }
            this.field_243534_bg.removeInt(object);
            this.field_243535_bj.remove(object);
        }
        return this.func_243537_a(\u26032, registryKey, v, lifecycle, false);
    }

    @Override
    @Nullable
    public ResourceLocation func_177774_c(T t) {
        return (ResourceLocation)this.field_82596_a.inverse().get(t);
    }

    @Override
    public Optional<RegistryKey<T>> func_230519_c_(T t) {
        return Optional.ofNullable(this.field_239649_bb_.inverse().get(t));
    }

    @Override
    public int func_148757_b(@Nullable T t) {
        return this.field_243534_bg.getInt(t);
    }

    @Override
    @Nullable
    public T func_230516_a_(@Nullable RegistryKey<T> registryKey) {
        return (T)this.field_239649_bb_.get(registryKey);
    }

    @Override
    @Nullable
    public T func_148745_a(int n) {
        if (n < 0 || n >= this.field_243533_bf.size()) {
            return null;
        }
        return (T)this.field_243533_bf.get(n);
    }

    @Override
    public Lifecycle func_241876_d(T t) {
        return this.field_243535_bj.get(t);
    }

    @Override
    public Lifecycle func_241875_b() {
        return this.field_243536_bk;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.field_243533_bf.iterator(), Objects::nonNull);
    }

    @Override
    @Nullable
    public T func_82594_a(@Nullable ResourceLocation resourceLocation) {
        return (T)this.field_82596_a.get((Object)resourceLocation);
    }

    @Override
    public Set<ResourceLocation> func_148742_b() {
        return Collections.unmodifiableSet(this.field_82596_a.keySet());
    }

    @Override
    public Set<Map.Entry<RegistryKey<T>, T>> func_239659_c_() {
        return Collections.unmodifiableMap(this.field_239649_bb_).entrySet();
    }

    @Nullable
    public T func_186801_a(Random random2) {
        Random random2;
        if (this.field_186802_b == null) {
            Set set = this.field_82596_a.values();
            if (set.isEmpty()) {
                return null;
            }
            this.field_186802_b = set.toArray(new Object[set.size()]);
        }
        return (T)Util.func_240989_a_(this.field_186802_b, random2);
    }

    @Override
    public boolean func_212607_c(ResourceLocation resourceLocation) {
        return this.field_82596_a.containsKey((Object)resourceLocation);
    }

    public static <T> Codec<SimpleRegistry<T>> func_243539_a(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Codec<T> codec) {
        return SimpleRegistry.func_243541_a(registryKey, codec.fieldOf("element")).codec().listOf().xmap(list -> {
            SimpleRegistry simpleRegistry = new SimpleRegistry(registryKey, lifecycle);
            for (Entry entry : list) {
                simpleRegistry.func_218382_a(entry.field_243547_b, entry.field_243546_a, entry.field_243548_c, lifecycle);
            }
            return simpleRegistry;
        }, simpleRegistry -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object t : simpleRegistry) {
                builder.add(new Entry(simpleRegistry.func_230519_c_(t).get(), simpleRegistry.func_148757_b(t), t));
            }
            return builder.build();
        });
    }

    public static <T> Codec<SimpleRegistry<T>> func_241744_b_(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Codec<T> codec) {
        return SimpleRegistryCodec.func_241793_a_(registryKey, lifecycle, codec);
    }

    public static <T> Codec<SimpleRegistry<T>> func_241745_c_(RegistryKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, Codec<T> codec) {
        return Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_.xmap(RegistryKey.func_240902_a_(registryKey), RegistryKey::func_240901_a_), codec).xmap(map -> {
            SimpleRegistry simpleRegistry = new SimpleRegistry(registryKey, lifecycle);
            map.forEach((? super K registryKey, ? super V object) -> simpleRegistry.func_218381_a((RegistryKey)registryKey, (Object)object, lifecycle));
            return simpleRegistry;
        }, simpleRegistry -> ImmutableMap.copyOf(simpleRegistry.field_239649_bb_));
    }

    public static class Entry<T> {
        public final RegistryKey<T> field_243546_a;
        public final int field_243547_b;
        public final T field_243548_c;

        public Entry(RegistryKey<T> registryKey, int n, T t) {
            this.field_243546_a = registryKey;
            this.field_243547_b = n;
            this.field_243548_c = t;
        }
    }
}

