/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.shapes;

import java.util.Objects;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.border.WorldBorder;

public class VoxelShapeSpliterator
extends Spliterators.AbstractSpliterator<VoxelShape> {
    @Nullable
    private final Entity field_234868_a_;
    private final AxisAlignedBB field_234869_b_;
    private final ISelectionContext field_234870_c_;
    private final CubeCoordinateIterator field_234871_d_;
    private final BlockPos.Mutable field_234872_e_;
    private final VoxelShape field_234873_f_;
    private final ICollisionReader field_234874_g_;
    private boolean field_234875_h_;
    private final BiPredicate<BlockState, BlockPos> field_241458_i_;

    public VoxelShapeSpliterator(ICollisionReader iCollisionReader, @Nullable Entity entity, AxisAlignedBB axisAlignedBB) {
        this(iCollisionReader, entity, axisAlignedBB, (blockState, blockPos) -> true);
    }

    public VoxelShapeSpliterator(ICollisionReader iCollisionReader, @Nullable Entity entity, AxisAlignedBB axisAlignedBB, BiPredicate<BlockState, BlockPos> biPredicate) {
        super(Long.MAX_VALUE, 1280);
        this.field_234870_c_ = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a(entity);
        this.field_234872_e_ = new BlockPos.Mutable();
        this.field_234873_f_ = VoxelShapes.func_197881_a(axisAlignedBB);
        this.field_234874_g_ = iCollisionReader;
        this.field_234875_h_ = entity != null;
        this.field_234868_a_ = entity;
        this.field_234869_b_ = axisAlignedBB;
        this.field_241458_i_ = biPredicate;
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72336_d + 1.0E-7) + 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72337_e + 1.0E-7) + 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c - 1.0E-7) - 1;
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72334_f + 1.0E-7) + 1;
        this.field_234871_d_ = new CubeCoordinateIterator(n, \u2603, \u2603, \u2603, \u2603, \u2603);
    }

    @Override
    public boolean tryAdvance(Consumer<? super VoxelShape> consumer) {
        return this.field_234875_h_ && this.func_234879_b_(consumer) || this.func_234878_a_(consumer);
    }

    boolean func_234878_a_(Consumer<? super VoxelShape> consumer) {
        while (this.field_234871_d_.func_218301_a()) {
            int n = this.field_234871_d_.func_218304_b();
            \u2603 = this.field_234871_d_.func_218302_c();
            \u2603 = this.field_234871_d_.func_218303_d();
            \u2603 = this.field_234871_d_.func_223473_e();
            if (\u2603 == 3 || (\u2603 = this.func_234876_a_(n, \u2603)) == null) continue;
            this.field_234872_e_.func_181079_c(n, \u2603, \u2603);
            BlockState \u26032 = \u2603.func_180495_p(this.field_234872_e_);
            if (!this.field_241458_i_.test(\u26032, this.field_234872_e_) || \u2603 == 1 && !\u26032.func_215704_f() || \u2603 == 2 && !\u26032.func_203425_a(Blocks.field_196603_bb)) continue;
            VoxelShape \u26033 = \u26032.func_215685_b(this.field_234874_g_, this.field_234872_e_, this.field_234870_c_);
            if (\u26033 == VoxelShapes.func_197868_b()) {
                if (!this.field_234869_b_.func_186668_a(n, \u2603, \u2603, (double)n + 1.0, (double)\u2603 + 1.0, (double)\u2603 + 1.0)) continue;
                consumer.accept(\u26033.func_197751_a(n, \u2603, \u2603));
                return true;
            }
            VoxelShape \u26034 = \u26033.func_197751_a(n, \u2603, \u2603);
            if (!VoxelShapes.func_197879_c(\u26034, this.field_234873_f_, IBooleanFunction.field_223238_i_)) continue;
            consumer.accept(\u26034);
            return true;
        }
        return false;
    }

    @Nullable
    private IBlockReader func_234876_a_(int n, int n2) {
        \u2603 = n >> 4;
        \u2603 = n2 >> 4;
        return this.field_234874_g_.func_225522_c_(\u2603, \u2603);
    }

    boolean func_234879_b_(Consumer<? super VoxelShape> consumer) {
        Objects.requireNonNull(this.field_234868_a_);
        this.field_234875_h_ = false;
        WorldBorder worldBorder = this.field_234874_g_.func_175723_af();
        AxisAlignedBB \u26032 = this.field_234868_a_.func_174813_aQ();
        if (!VoxelShapeSpliterator.func_234877_a_(worldBorder, \u26032) && !VoxelShapeSpliterator.func_241461_b_(\u2603 = worldBorder.func_222521_a(), \u26032) && VoxelShapeSpliterator.func_241460_a_(\u2603, \u26032)) {
            consumer.accept(\u2603);
            return true;
        }
        return false;
    }

    private static boolean func_241460_a_(VoxelShape voxelShape, AxisAlignedBB axisAlignedBB) {
        return VoxelShapes.func_197879_c(voxelShape, VoxelShapes.func_197881_a(axisAlignedBB.func_186662_g(1.0E-7)), IBooleanFunction.field_223238_i_);
    }

    private static boolean func_241461_b_(VoxelShape voxelShape, AxisAlignedBB axisAlignedBB) {
        return VoxelShapes.func_197879_c(voxelShape, VoxelShapes.func_197881_a(axisAlignedBB.func_186664_h(1.0E-7)), IBooleanFunction.field_223238_i_);
    }

    public static boolean func_234877_a_(WorldBorder worldBorder, AxisAlignedBB axisAlignedBB) {
        double d = MathHelper.func_76128_c(worldBorder.func_177726_b());
        \u2603 = MathHelper.func_76128_c(worldBorder.func_177736_c());
        \u2603 = MathHelper.func_76143_f(worldBorder.func_177728_d());
        \u2603 = MathHelper.func_76143_f(worldBorder.func_177733_e());
        return axisAlignedBB.field_72340_a > d && axisAlignedBB.field_72340_a < \u2603 && axisAlignedBB.field_72339_c > \u2603 && axisAlignedBB.field_72339_c < \u2603 && axisAlignedBB.field_72336_d > d && axisAlignedBB.field_72336_d < \u2603 && axisAlignedBB.field_72334_f > \u2603 && axisAlignedBB.field_72334_f < \u2603;
    }
}

