/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.math.MathHelper;

public class VillagerLevelAndXpFix
extends DataFix {
    private static final int[] field_223004_a = new int[]{0, 10, 50, 100, 150};

    public static int func_223001_a(int n) {
        return field_223004_a[MathHelper.func_76125_a(n - 1, 0, field_223004_a.length - 1)];
    }

    public VillagerLevelAndXpFix(Schema schema, boolean bl) {
        super(schema, bl);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getChoiceType(TypeReferences.field_211299_o, "minecraft:villager");
        OpticFinder \u26032 = DSL.namedChoice((String)"minecraft:villager", (Type)type);
        OpticFinder \u26033 = type.findField("Offers");
        \u2603 = \u26033.type();
        OpticFinder \u26034 = \u2603.findField("Recipes");
        List.ListType \u26035 = (List.ListType)\u26034.type();
        OpticFinder \u26036 = \u26035.getElement().finder();
        return this.fixTypeEverywhereTyped("Villager level and xp rebuild", this.getInputSchema().getType(TypeReferences.field_211299_o), typed -> typed.updateTyped(\u26032, type, typed2 -> {
            Dynamic dynamic = (Dynamic)typed2.get(DSL.remainderFinder());
            int \u26032 = dynamic.get("VillagerData").get("level").asInt(0);
            Typed<?> \u26033 = typed2;
            if ((\u26032 == 0 || \u26032 == 1) && (\u26032 = MathHelper.func_76125_a((\u2603 = typed2.getOptionalTyped(\u26033).flatMap(typed -> typed.getOptionalTyped(\u26034)).map(typed -> typed.getAllTyped(\u26036).size()).orElse(0).intValue()) / 2, 1, 5)) > 1) {
                \u26033 = VillagerLevelAndXpFix.func_223003_a(\u26033, \u26032);
            }
            if (!(\u2603 = dynamic.get("Xp").asNumber().result()).isPresent()) {
                \u26033 = VillagerLevelAndXpFix.func_222994_b(\u26033, \u26032);
            }
            return \u26033;
        }));
    }

    private static Typed<?> func_223003_a(Typed<?> typed, int n) {
        return typed.update(DSL.remainderFinder(), dynamic2 -> dynamic2.update("VillagerData", dynamic -> dynamic.set("level", dynamic.createInt(n))));
    }

    private static Typed<?> func_222994_b(Typed<?> typed, int n) {
        \u2603 = VillagerLevelAndXpFix.func_223001_a(n);
        return typed.update(DSL.remainderFinder(), dynamic -> dynamic.set("Xp", dynamic.createInt(\u2603)));
    }
}

