/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.StringUtils;
import net.minecraft.util.UUIDCodec;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NBTUtil {
    private static final Logger field_193591_a = LogManager.getLogger();

    @Nullable
    public static GameProfile func_152459_a(CompoundNBT compoundNBT) {
        String string = null;
        UUID \u26032 = null;
        if (compoundNBT.func_150297_b("Name", 8)) {
            string = compoundNBT.func_74779_i("Name");
        }
        if (compoundNBT.func_186855_b("Id")) {
            \u26032 = compoundNBT.func_186857_a("Id");
        }
        try {
            GameProfile gameProfile = new GameProfile(\u26032, string);
            if (compoundNBT.func_150297_b("Properties", 10)) {
                CompoundNBT compoundNBT2 = compoundNBT.func_74775_l("Properties");
                for (String string2 : compoundNBT2.func_150296_c()) {
                    ListNBT listNBT = compoundNBT2.func_150295_c(string2, 10);
                    for (int i = 0; i < listNBT.size(); ++i) {
                        CompoundNBT compoundNBT3 = listNBT.func_150305_b(i);
                        String \u26033 = compoundNBT3.func_74779_i("Value");
                        if (compoundNBT3.func_150297_b("Signature", 8)) {
                            gameProfile.getProperties().put((Object)string2, (Object)new Property(string2, \u26033, compoundNBT3.func_74779_i("Signature")));
                            continue;
                        }
                        gameProfile.getProperties().put((Object)string2, (Object)new Property(string2, \u26033));
                    }
                }
            }
            return gameProfile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static CompoundNBT func_180708_a(CompoundNBT compoundNBT2, GameProfile gameProfile) {
        CompoundNBT compoundNBT2;
        if (!StringUtils.func_151246_b(gameProfile.getName())) {
            compoundNBT2.func_74778_a("Name", gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            compoundNBT2.func_186854_a("Id", gameProfile.getId());
        }
        if (!gameProfile.getProperties().isEmpty()) {
            CompoundNBT compoundNBT3 = new CompoundNBT();
            for (String string : gameProfile.getProperties().keySet()) {
                ListNBT listNBT = new ListNBT();
                for (Property property : gameProfile.getProperties().get((Object)string)) {
                    CompoundNBT compoundNBT4 = new CompoundNBT();
                    compoundNBT4.func_74778_a("Value", property.getValue());
                    if (property.hasSignature()) {
                        compoundNBT4.func_74778_a("Signature", property.getSignature());
                    }
                    listNBT.add(compoundNBT4);
                }
                compoundNBT3.func_218657_a(string, listNBT);
            }
            compoundNBT2.func_218657_a("Properties", compoundNBT3);
        }
        return compoundNBT2;
    }

    @VisibleForTesting
    public static boolean func_181123_a(@Nullable INBT iNBT3, @Nullable INBT iNBT2, boolean bl) {
        INBT iNBT3;
        if (iNBT3 == iNBT2) {
            return true;
        }
        if (iNBT3 == null) {
            return true;
        }
        if (iNBT2 == null) {
            return false;
        }
        if (!iNBT3.getClass().equals(iNBT2.getClass())) {
            return false;
        }
        if (iNBT3 instanceof CompoundNBT) {
            CompoundNBT compoundNBT = (CompoundNBT)iNBT3;
            \u2603 = (CompoundNBT)iNBT2;
            for (String string : compoundNBT.func_150296_c()) {
                INBT iNBT4 = compoundNBT.func_74781_a(string);
                if (NBTUtil.func_181123_a(iNBT4, \u2603.func_74781_a(string), bl)) continue;
                return false;
            }
            return true;
        }
        if (iNBT3 instanceof ListNBT && bl) {
            ListNBT listNBT = (ListNBT)iNBT3;
            \u2603 = (ListNBT)iNBT2;
            if (listNBT.isEmpty()) {
                return \u2603.isEmpty();
            }
            for (int i = 0; i < listNBT.size(); ++i) {
                INBT iNBT5 = listNBT.get(i);
                boolean \u26032 = false;
                for (int j = 0; j < \u2603.size(); ++j) {
                    if (!NBTUtil.func_181123_a(iNBT5, \u2603.get(j), bl)) continue;
                    \u26032 = true;
                    break;
                }
                if (\u26032) continue;
                return false;
            }
            return true;
        }
        return iNBT3.equals(iNBT2);
    }

    public static IntArrayNBT func_240626_a_(UUID uUID) {
        return new IntArrayNBT(UUIDCodec.func_239777_a_(uUID));
    }

    public static UUID func_186860_b(INBT iNBT) {
        if (iNBT.func_225647_b_() != IntArrayNBT.field_229690_a_) {
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + IntArrayNBT.field_229690_a_.func_225648_a_() + ", but found " + iNBT.func_225647_b_().func_225648_a_() + ".");
        }
        int[] nArray = ((IntArrayNBT)iNBT).func_150302_c();
        if (nArray.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + nArray.length + ".");
        }
        return UUIDCodec.func_239779_a_(nArray);
    }

    public static BlockPos func_186861_c(CompoundNBT compoundNBT) {
        return new BlockPos(compoundNBT.func_74762_e("X"), compoundNBT.func_74762_e("Y"), compoundNBT.func_74762_e("Z"));
    }

    public static CompoundNBT func_186859_a(BlockPos blockPos) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("X", blockPos.func_177958_n());
        compoundNBT.func_74768_a("Y", blockPos.func_177956_o());
        compoundNBT.func_74768_a("Z", blockPos.func_177952_p());
        return compoundNBT;
    }

    public static BlockState func_190008_d(CompoundNBT compoundNBT) {
        if (!compoundNBT.func_150297_b("Name", 8)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Block block = Registry.field_212618_g.func_82594_a(new ResourceLocation(compoundNBT.func_74779_i("Name")));
        BlockState \u26032 = block.func_176223_P();
        if (compoundNBT.func_150297_b("Properties", 10)) {
            CompoundNBT compoundNBT2 = compoundNBT.func_74775_l("Properties");
            StateContainer<Block, BlockState> \u26033 = block.func_176194_O();
            for (String string : compoundNBT2.func_150296_c()) {
                net.minecraft.state.Property<?> property = \u26033.func_185920_a(string);
                if (property == null) continue;
                \u26032 = NBTUtil.func_193590_a(\u26032, property, string, compoundNBT2, compoundNBT);
            }
        }
        return \u26032;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S func_193590_a(S s, net.minecraft.state.Property<T> property, String string, CompoundNBT compoundNBT, CompoundNBT compoundNBT2) {
        Optional<T> optional = property.func_185929_b(compoundNBT.func_74779_i(string));
        if (optional.isPresent()) {
            return (S)((StateHolder)s.func_206870_a(property, (Comparable)((Comparable)optional.get())));
        }
        field_193591_a.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)string, (Object)compoundNBT.func_74779_i(string), (Object)compoundNBT2.toString());
        return s;
    }

    public static CompoundNBT func_190009_a(BlockState blockState) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("Name", Registry.field_212618_g.func_177774_c(blockState.func_177230_c()).toString());
        ImmutableMap<net.minecraft.state.Property<?>, Comparable<?>> \u26032 = blockState.func_206871_b();
        if (!\u26032.isEmpty()) {
            \u2603 = new CompoundNBT();
            for (Map.Entry entry : \u26032.entrySet()) {
                net.minecraft.state.Property property = (net.minecraft.state.Property)entry.getKey();
                \u2603.func_74778_a(property.func_177701_a(), NBTUtil.func_190010_a(property, (Comparable)entry.getValue()));
            }
            compoundNBT.func_218657_a("Properties", \u2603);
        }
        return compoundNBT;
    }

    private static <T extends Comparable<T>> String func_190010_a(net.minecraft.state.Property<T> property, Comparable<?> comparable) {
        return property.func_177702_a(comparable);
    }

    public static CompoundNBT func_210822_a(DataFixer dataFixer, DefaultTypeReferences defaultTypeReferences, CompoundNBT compoundNBT, int n) {
        return NBTUtil.func_210821_a(dataFixer, defaultTypeReferences, compoundNBT, n, SharedConstants.func_215069_a().getWorldVersion());
    }

    public static CompoundNBT func_210821_a(DataFixer dataFixer, DefaultTypeReferences defaultTypeReferences, CompoundNBT compoundNBT, int n, int n2) {
        return (CompoundNBT)dataFixer.update(defaultTypeReferences.func_219816_a(), new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundNBT), n, n2).getValue();
    }
}

