/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadingTexture
extends SimpleTexture {
    private static final Logger field_147644_c = LogManager.getLogger();
    @Nullable
    private final File field_152434_e;
    private final String field_110562_b;
    private final boolean field_229154_h_;
    @Nullable
    private final Runnable field_229155_i_;
    @Nullable
    private CompletableFuture<?> field_229156_j_;
    private boolean field_110559_g;

    public DownloadingTexture(@Nullable File file, String string, ResourceLocation resourceLocation, boolean bl, @Nullable Runnable runnable) {
        super(resourceLocation);
        this.field_152434_e = file;
        this.field_110562_b = string;
        this.field_229154_h_ = bl;
        this.field_229155_i_ = runnable;
    }

    private void func_195417_a(NativeImage nativeImage) {
        if (this.field_229155_i_ != null) {
            this.field_229155_i_.run();
        }
        Minecraft.func_71410_x().execute(() -> {
            this.field_110559_g = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.func_229160_b_(nativeImage));
            } else {
                this.func_229160_b_(nativeImage);
            }
        });
    }

    private void func_229160_b_(NativeImage nativeImage) {
        TextureUtil.func_225680_a_(this.func_110552_b(), nativeImage.func_195702_a(), nativeImage.func_195714_b());
        nativeImage.func_195697_a(0, 0, 0, true);
    }

    @Override
    public void func_195413_a(IResourceManager iResourceManager) throws IOException {
        NativeImage \u26032;
        Minecraft.func_71410_x().execute(() -> {
            if (!this.field_110559_g) {
                try {
                    super.func_195413_a(iResourceManager);
                }
                catch (IOException iOException) {
                    field_147644_c.warn("Failed to load texture: {}", (Object)this.field_110568_b, (Object)iOException);
                }
                this.field_110559_g = true;
            }
        });
        if (this.field_229156_j_ != null) {
            return;
        }
        if (this.field_152434_e != null && this.field_152434_e.isFile()) {
            field_147644_c.debug("Loading http texture from local cache ({})", (Object)this.field_152434_e);
            FileInputStream fileInputStream = new FileInputStream(this.field_152434_e);
            \u26032 = this.func_229159_a_(fileInputStream);
        } else {
            \u26032 = null;
        }
        if (\u26032 != null) {
            this.func_195417_a(\u26032);
            return;
        }
        this.field_229156_j_ = CompletableFuture.runAsync(() -> {
            HttpURLConnection httpURLConnection = null;
            field_147644_c.debug("Downloading http texture from {} to {}", (Object)this.field_110562_b, (Object)this.field_152434_e);
            try {
                InputStream \u26032;
                httpURLConnection = (HttpURLConnection)new URL(this.field_110562_b).openConnection(Minecraft.func_71410_x().func_110437_J());
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(false);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() / 100 != 2) {
                    return;
                }
                if (this.field_152434_e != null) {
                    FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)this.field_152434_e);
                    \u26032 = new FileInputStream(this.field_152434_e);
                } else {
                    \u26032 = httpURLConnection.getInputStream();
                }
                Minecraft.func_71410_x().execute(() -> {
                    NativeImage nativeImage = this.func_229159_a_(\u26032);
                    if (nativeImage != null) {
                        this.func_195417_a(nativeImage);
                    }
                });
            }
            catch (Exception exception) {
                field_147644_c.error("Couldn't download http texture", (Throwable)exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }, Util.func_215072_e());
    }

    @Nullable
    private NativeImage func_229159_a_(InputStream inputStream) {
        NativeImage nativeImage = null;
        try {
            nativeImage = NativeImage.func_195713_a(inputStream);
            if (this.field_229154_h_) {
                nativeImage = DownloadingTexture.func_229163_c_(nativeImage);
            }
        }
        catch (IOException \u26032) {
            field_147644_c.warn("Error while loading the skin texture", (Throwable)\u26032);
        }
        return nativeImage;
    }

    private static NativeImage func_229163_c_(NativeImage nativeImage) {
        boolean bl = \u2603 = nativeImage.func_195714_b() == 32;
        if (\u2603) {
            \u2603 = new NativeImage(64, 64, true);
            \u2603.func_195703_a(nativeImage);
            nativeImage.close();
            nativeImage = \u2603;
            nativeImage.func_195715_a(0, 32, 64, 32, 0);
            nativeImage.func_195699_a(4, 16, 16, 32, 4, 4, true, false);
            nativeImage.func_195699_a(8, 16, 16, 32, 4, 4, true, false);
            nativeImage.func_195699_a(0, 20, 24, 32, 4, 12, true, false);
            nativeImage.func_195699_a(4, 20, 16, 32, 4, 12, true, false);
            nativeImage.func_195699_a(8, 20, 8, 32, 4, 12, true, false);
            nativeImage.func_195699_a(12, 20, 16, 32, 4, 12, true, false);
            nativeImage.func_195699_a(44, 16, -8, 32, 4, 4, true, false);
            nativeImage.func_195699_a(48, 16, -8, 32, 4, 4, true, false);
            nativeImage.func_195699_a(40, 20, 0, 32, 4, 12, true, false);
            nativeImage.func_195699_a(44, 20, -8, 32, 4, 12, true, false);
            nativeImage.func_195699_a(48, 20, -16, 32, 4, 12, true, false);
            nativeImage.func_195699_a(52, 20, -8, 32, 4, 12, true, false);
        }
        DownloadingTexture.func_229161_b_(nativeImage, 0, 0, 32, 16);
        if (\u2603) {
            DownloadingTexture.func_229158_a_(nativeImage, 32, 0, 64, 32);
        }
        DownloadingTexture.func_229161_b_(nativeImage, 0, 16, 64, 32);
        DownloadingTexture.func_229161_b_(nativeImage, 16, 48, 48, 64);
        return nativeImage;
    }

    private static void func_229158_a_(NativeImage nativeImage, int n, int n2, int n3, int n4) {
        for (\u2603 = n; \u2603 < n3; ++\u2603) {
            for (\u2603 = n2; \u2603 < n4; ++\u2603) {
                \u2603 = nativeImage.func_195709_a(\u2603, \u2603);
                if ((\u2603 >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (\u2603 = n; \u2603 < n3; ++\u2603) {
            for (\u2603 = n2; \u2603 < n4; ++\u2603) {
                nativeImage.func_195700_a(\u2603, \u2603, nativeImage.func_195709_a(\u2603, \u2603) & 0xFFFFFF);
            }
        }
    }

    private static void func_229161_b_(NativeImage nativeImage, int n, int n2, int n3, int n4) {
        for (\u2603 = n; \u2603 < n3; ++\u2603) {
            for (\u2603 = n2; \u2603 < n4; ++\u2603) {
                nativeImage.func_195700_a(\u2603, \u2603, nativeImage.func_195709_a(\u2603, \u2603) | 0xFF000000);
            }
        }
    }
}

