/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;

public class GlDebugTextUtils {
    private static final Logger field_209253_d = LogManager.getLogger();
    protected static final ByteBuffer field_209250_a = GLAllocation.func_74524_c(64);
    protected static final FloatBuffer field_209251_b = field_209250_a.asFloatBuffer();
    protected static final IntBuffer field_209252_c = field_209250_a.asIntBuffer();
    private static final Joiner field_209254_e = Joiner.on((char)'\n');
    private static final Joiner field_209255_f = Joiner.on((String)"; ");
    private static final Map<Integer, String> field_209256_g = Maps.newHashMap();
    private static final List<Integer> field_209257_h = ImmutableList.of((Object)37190, (Object)37191, (Object)37192, (Object)33387);
    private static final List<Integer> field_209258_i = ImmutableList.of((Object)37190, (Object)37191, (Object)37192);
    private static final Map<String, List<String>> field_209259_j;

    private static String func_209245_c(int n) {
        return "Unknown (0x" + Integer.toHexString(n).toUpperCase() + ")";
    }

    private static String func_209242_d(int n) {
        switch (n) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return GlDebugTextUtils.func_209245_c(n);
    }

    private static String func_209248_e(int n) {
        switch (n) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return GlDebugTextUtils.func_209245_c(n);
    }

    private static String func_209246_f(int n) {
        switch (n) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
            case 33387: {
                return "NOTIFICATION";
            }
        }
        return GlDebugTextUtils.func_209245_c(n);
    }

    private static void func_209244_a(int n, int n2, int n3, int n4, int n5, long l, long l2) {
        field_209253_d.info("OpenGL debug message, id={}, source={}, type={}, severity={}, message={}", (Object)n3, (Object)GlDebugTextUtils.func_209242_d(n), (Object)GlDebugTextUtils.func_209248_e(n2), (Object)GlDebugTextUtils.func_209246_f(n4), (Object)GLDebugMessageCallback.getMessage((int)n5, (long)l));
    }

    private static void func_209243_a(int n, String string3) {
        field_209256_g.merge(n, string3, (string, string2) -> string + "/" + string2);
    }

    public static void func_209247_b(int n, boolean bl) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        if (n <= 0) {
            return;
        }
        GLCapabilities gLCapabilities = GL.getCapabilities();
        if (gLCapabilities.GL_KHR_debug) {
            GL11.glEnable((int)37600);
            if (bl) {
                GL11.glEnable((int)33346);
            }
            for (int i = 0; i < field_209257_h.size(); ++i) {
                boolean bl2 = i < n;
                KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)field_209257_h.get(i), (int[])null, (boolean)bl2);
            }
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLX.make(GLDebugMessageCallback.create(GlDebugTextUtils::func_209244_a), LWJGLMemoryUntracker::func_211545_a)), (long)0L);
        } else if (gLCapabilities.GL_ARB_debug_output) {
            if (bl) {
                GL11.glEnable((int)33346);
            }
            for (int i = 0; i < field_209258_i.size(); ++i) {
                boolean bl3 = i < n;
                ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)field_209258_i.get(i), (int[])null, (boolean)bl3);
            }
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((GLDebugMessageARBCallbackI)GLX.make(GLDebugMessageARBCallback.create(GlDebugTextUtils::func_209244_a), LWJGLMemoryUntracker::func_211545_a)), (long)0L);
        }
    }

    static {
        GlDebugTextUtils.func_209243_a(256, "GL11.GL_ACCUM");
        GlDebugTextUtils.func_209243_a(257, "GL11.GL_LOAD");
        GlDebugTextUtils.func_209243_a(258, "GL11.GL_RETURN");
        GlDebugTextUtils.func_209243_a(259, "GL11.GL_MULT");
        GlDebugTextUtils.func_209243_a(260, "GL11.GL_ADD");
        GlDebugTextUtils.func_209243_a(512, "GL11.GL_NEVER");
        GlDebugTextUtils.func_209243_a(513, "GL11.GL_LESS");
        GlDebugTextUtils.func_209243_a(514, "GL11.GL_EQUAL");
        GlDebugTextUtils.func_209243_a(515, "GL11.GL_LEQUAL");
        GlDebugTextUtils.func_209243_a(516, "GL11.GL_GREATER");
        GlDebugTextUtils.func_209243_a(517, "GL11.GL_NOTEQUAL");
        GlDebugTextUtils.func_209243_a(518, "GL11.GL_GEQUAL");
        GlDebugTextUtils.func_209243_a(519, "GL11.GL_ALWAYS");
        GlDebugTextUtils.func_209243_a(0, "GL11.GL_POINTS");
        GlDebugTextUtils.func_209243_a(1, "GL11.GL_LINES");
        GlDebugTextUtils.func_209243_a(2, "GL11.GL_LINE_LOOP");
        GlDebugTextUtils.func_209243_a(3, "GL11.GL_LINE_STRIP");
        GlDebugTextUtils.func_209243_a(4, "GL11.GL_TRIANGLES");
        GlDebugTextUtils.func_209243_a(5, "GL11.GL_TRIANGLE_STRIP");
        GlDebugTextUtils.func_209243_a(6, "GL11.GL_TRIANGLE_FAN");
        GlDebugTextUtils.func_209243_a(7, "GL11.GL_QUADS");
        GlDebugTextUtils.func_209243_a(8, "GL11.GL_QUAD_STRIP");
        GlDebugTextUtils.func_209243_a(9, "GL11.GL_POLYGON");
        GlDebugTextUtils.func_209243_a(0, "GL11.GL_ZERO");
        GlDebugTextUtils.func_209243_a(1, "GL11.GL_ONE");
        GlDebugTextUtils.func_209243_a(768, "GL11.GL_SRC_COLOR");
        GlDebugTextUtils.func_209243_a(769, "GL11.GL_ONE_MINUS_SRC_COLOR");
        GlDebugTextUtils.func_209243_a(770, "GL11.GL_SRC_ALPHA");
        GlDebugTextUtils.func_209243_a(771, "GL11.GL_ONE_MINUS_SRC_ALPHA");
        GlDebugTextUtils.func_209243_a(772, "GL11.GL_DST_ALPHA");
        GlDebugTextUtils.func_209243_a(773, "GL11.GL_ONE_MINUS_DST_ALPHA");
        GlDebugTextUtils.func_209243_a(774, "GL11.GL_DST_COLOR");
        GlDebugTextUtils.func_209243_a(775, "GL11.GL_ONE_MINUS_DST_COLOR");
        GlDebugTextUtils.func_209243_a(776, "GL11.GL_SRC_ALPHA_SATURATE");
        GlDebugTextUtils.func_209243_a(32769, "GL14.GL_CONSTANT_COLOR");
        GlDebugTextUtils.func_209243_a(32770, "GL14.GL_ONE_MINUS_CONSTANT_COLOR");
        GlDebugTextUtils.func_209243_a(32771, "GL14.GL_CONSTANT_ALPHA");
        GlDebugTextUtils.func_209243_a(32772, "GL14.GL_ONE_MINUS_CONSTANT_ALPHA");
        GlDebugTextUtils.func_209243_a(1, "GL11.GL_TRUE");
        GlDebugTextUtils.func_209243_a(0, "GL11.GL_FALSE");
        GlDebugTextUtils.func_209243_a(12288, "GL11.GL_CLIP_PLANE0");
        GlDebugTextUtils.func_209243_a(12289, "GL11.GL_CLIP_PLANE1");
        GlDebugTextUtils.func_209243_a(12290, "GL11.GL_CLIP_PLANE2");
        GlDebugTextUtils.func_209243_a(12291, "GL11.GL_CLIP_PLANE3");
        GlDebugTextUtils.func_209243_a(12292, "GL11.GL_CLIP_PLANE4");
        GlDebugTextUtils.func_209243_a(12293, "GL11.GL_CLIP_PLANE5");
        GlDebugTextUtils.func_209243_a(5120, "GL11.GL_BYTE");
        GlDebugTextUtils.func_209243_a(5121, "GL11.GL_UNSIGNED_BYTE");
        GlDebugTextUtils.func_209243_a(5122, "GL11.GL_SHORT");
        GlDebugTextUtils.func_209243_a(5123, "GL11.GL_UNSIGNED_SHORT");
        GlDebugTextUtils.func_209243_a(5124, "GL11.GL_INT");
        GlDebugTextUtils.func_209243_a(5125, "GL11.GL_UNSIGNED_INT");
        GlDebugTextUtils.func_209243_a(5126, "GL11.GL_FLOAT");
        GlDebugTextUtils.func_209243_a(5127, "GL11.GL_2_BYTES");
        GlDebugTextUtils.func_209243_a(5128, "GL11.GL_3_BYTES");
        GlDebugTextUtils.func_209243_a(5129, "GL11.GL_4_BYTES");
        GlDebugTextUtils.func_209243_a(5130, "GL11.GL_DOUBLE");
        GlDebugTextUtils.func_209243_a(0, "GL11.GL_NONE");
        GlDebugTextUtils.func_209243_a(1024, "GL11.GL_FRONT_LEFT");
        GlDebugTextUtils.func_209243_a(1025, "GL11.GL_FRONT_RIGHT");
        GlDebugTextUtils.func_209243_a(1026, "GL11.GL_BACK_LEFT");
        GlDebugTextUtils.func_209243_a(1027, "GL11.GL_BACK_RIGHT");
        GlDebugTextUtils.func_209243_a(1028, "GL11.GL_FRONT");
        GlDebugTextUtils.func_209243_a(1029, "GL11.GL_BACK");
        GlDebugTextUtils.func_209243_a(1030, "GL11.GL_LEFT");
        GlDebugTextUtils.func_209243_a(1031, "GL11.GL_RIGHT");
        GlDebugTextUtils.func_209243_a(1032, "GL11.GL_FRONT_AND_BACK");
        GlDebugTextUtils.func_209243_a(1033, "GL11.GL_AUX0");
        GlDebugTextUtils.func_209243_a(1034, "GL11.GL_AUX1");
        GlDebugTextUtils.func_209243_a(1035, "GL11.GL_AUX2");
        GlDebugTextUtils.func_209243_a(1036, "GL11.GL_AUX3");
        GlDebugTextUtils.func_209243_a(0, "GL11.GL_NO_ERROR");
        GlDebugTextUtils.func_209243_a(1280, "GL11.GL_INVALID_ENUM");
        GlDebugTextUtils.func_209243_a(1281, "GL11.GL_INVALID_VALUE");
        GlDebugTextUtils.func_209243_a(1282, "GL11.GL_INVALID_OPERATION");
        GlDebugTextUtils.func_209243_a(1283, "GL11.GL_STACK_OVERFLOW");
        GlDebugTextUtils.func_209243_a(1284, "GL11.GL_STACK_UNDERFLOW");
        GlDebugTextUtils.func_209243_a(1285, "GL11.GL_OUT_OF_MEMORY");
        GlDebugTextUtils.func_209243_a(1536, "GL11.GL_2D");
        GlDebugTextUtils.func_209243_a(1537, "GL11.GL_3D");
        GlDebugTextUtils.func_209243_a(1538, "GL11.GL_3D_COLOR");
        GlDebugTextUtils.func_209243_a(1539, "GL11.GL_3D_COLOR_TEXTURE");
        GlDebugTextUtils.func_209243_a(1540, "GL11.GL_4D_COLOR_TEXTURE");
        GlDebugTextUtils.func_209243_a(1792, "GL11.GL_PASS_THROUGH_TOKEN");
        GlDebugTextUtils.func_209243_a(1793, "GL11.GL_POINT_TOKEN");
        GlDebugTextUtils.func_209243_a(1794, "GL11.GL_LINE_TOKEN");
        GlDebugTextUtils.func_209243_a(1795, "GL11.GL_POLYGON_TOKEN");
        GlDebugTextUtils.func_209243_a(1796, "GL11.GL_BITMAP_TOKEN");
        GlDebugTextUtils.func_209243_a(1797, "GL11.GL_DRAW_PIXEL_TOKEN");
        GlDebugTextUtils.func_209243_a(1798, "GL11.GL_COPY_PIXEL_TOKEN");
        GlDebugTextUtils.func_209243_a(1799, "GL11.GL_LINE_RESET_TOKEN");
        GlDebugTextUtils.func_209243_a(2048, "GL11.GL_EXP");
        GlDebugTextUtils.func_209243_a(2049, "GL11.GL_EXP2");
        GlDebugTextUtils.func_209243_a(2304, "GL11.GL_CW");
        GlDebugTextUtils.func_209243_a(2305, "GL11.GL_CCW");
        GlDebugTextUtils.func_209243_a(2560, "GL11.GL_COEFF");
        GlDebugTextUtils.func_209243_a(2561, "GL11.GL_ORDER");
        GlDebugTextUtils.func_209243_a(2562, "GL11.GL_DOMAIN");
        GlDebugTextUtils.func_209243_a(2816, "GL11.GL_CURRENT_COLOR");
        GlDebugTextUtils.func_209243_a(2817, "GL11.GL_CURRENT_INDEX");
        GlDebugTextUtils.func_209243_a(2818, "GL11.GL_CURRENT_NORMAL");
        GlDebugTextUtils.func_209243_a(2819, "GL11.GL_CURRENT_TEXTURE_COORDS");
        GlDebugTextUtils.func_209243_a(2820, "GL11.GL_CURRENT_RASTER_COLOR");
        GlDebugTextUtils.func_209243_a(2821, "GL11.GL_CURRENT_RASTER_INDEX");
        GlDebugTextUtils.func_209243_a(2822, "GL11.GL_CURRENT_RASTER_TEXTURE_COORDS");
        GlDebugTextUtils.func_209243_a(2823, "GL11.GL_CURRENT_RASTER_POSITION");
        GlDebugTextUtils.func_209243_a(2824, "GL11.GL_CURRENT_RASTER_POSITION_VALID");
        GlDebugTextUtils.func_209243_a(2825, "GL11.GL_CURRENT_RASTER_DISTANCE");
        GlDebugTextUtils.func_209243_a(2832, "GL11.GL_POINT_SMOOTH");
        GlDebugTextUtils.func_209243_a(2833, "GL11.GL_POINT_SIZE");
        GlDebugTextUtils.func_209243_a(2834, "GL11.GL_POINT_SIZE_RANGE");
        GlDebugTextUtils.func_209243_a(2835, "GL11.GL_POINT_SIZE_GRANULARITY");
        GlDebugTextUtils.func_209243_a(2848, "GL11.GL_LINE_SMOOTH");
        GlDebugTextUtils.func_209243_a(2849, "GL11.GL_LINE_WIDTH");
        GlDebugTextUtils.func_209243_a(2850, "GL11.GL_LINE_WIDTH_RANGE");
        GlDebugTextUtils.func_209243_a(2851, "GL11.GL_LINE_WIDTH_GRANULARITY");
        GlDebugTextUtils.func_209243_a(2852, "GL11.GL_LINE_STIPPLE");
        GlDebugTextUtils.func_209243_a(2853, "GL11.GL_LINE_STIPPLE_PATTERN");
        GlDebugTextUtils.func_209243_a(2854, "GL11.GL_LINE_STIPPLE_REPEAT");
        GlDebugTextUtils.func_209243_a(2864, "GL11.GL_LIST_MODE");
        GlDebugTextUtils.func_209243_a(2865, "GL11.GL_MAX_LIST_NESTING");
        GlDebugTextUtils.func_209243_a(2866, "GL11.GL_LIST_BASE");
        GlDebugTextUtils.func_209243_a(2867, "GL11.GL_LIST_INDEX");
        GlDebugTextUtils.func_209243_a(2880, "GL11.GL_POLYGON_MODE");
        GlDebugTextUtils.func_209243_a(2881, "GL11.GL_POLYGON_SMOOTH");
        GlDebugTextUtils.func_209243_a(2882, "GL11.GL_POLYGON_STIPPLE");
        GlDebugTextUtils.func_209243_a(2883, "GL11.GL_EDGE_FLAG");
        GlDebugTextUtils.func_209243_a(2884, "GL11.GL_CULL_FACE");
        GlDebugTextUtils.func_209243_a(2885, "GL11.GL_CULL_FACE_MODE");
        GlDebugTextUtils.func_209243_a(2886, "GL11.GL_FRONT_FACE");
        GlDebugTextUtils.func_209243_a(2896, "GL11.GL_LIGHTING");
        GlDebugTextUtils.func_209243_a(2897, "GL11.GL_LIGHT_MODEL_LOCAL_VIEWER");
        GlDebugTextUtils.func_209243_a(2898, "GL11.GL_LIGHT_MODEL_TWO_SIDE");
        GlDebugTextUtils.func_209243_a(2899, "GL11.GL_LIGHT_MODEL_AMBIENT");
        GlDebugTextUtils.func_209243_a(2900, "GL11.GL_SHADE_MODEL");
        GlDebugTextUtils.func_209243_a(2901, "GL11.GL_COLOR_MATERIAL_FACE");
        GlDebugTextUtils.func_209243_a(2902, "GL11.GL_COLOR_MATERIAL_PARAMETER");
        GlDebugTextUtils.func_209243_a(2903, "GL11.GL_COLOR_MATERIAL");
        GlDebugTextUtils.func_209243_a(2912, "GL11.GL_FOG");
        GlDebugTextUtils.func_209243_a(2913, "GL11.GL_FOG_INDEX");
        GlDebugTextUtils.func_209243_a(2914, "GL11.GL_FOG_DENSITY");
        GlDebugTextUtils.func_209243_a(2915, "GL11.GL_FOG_START");
        GlDebugTextUtils.func_209243_a(2916, "GL11.GL_FOG_END");
        GlDebugTextUtils.func_209243_a(2917, "GL11.GL_FOG_MODE");
        GlDebugTextUtils.func_209243_a(2918, "GL11.GL_FOG_COLOR");
        GlDebugTextUtils.func_209243_a(2928, "GL11.GL_DEPTH_RANGE");
        GlDebugTextUtils.func_209243_a(2929, "GL11.GL_DEPTH_TEST");
        GlDebugTextUtils.func_209243_a(2930, "GL11.GL_DEPTH_WRITEMASK");
        GlDebugTextUtils.func_209243_a(2931, "GL11.GL_DEPTH_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a(2932, "GL11.GL_DEPTH_FUNC");
        GlDebugTextUtils.func_209243_a(2944, "GL11.GL_ACCUM_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a(2960, "GL11.GL_STENCIL_TEST");
        GlDebugTextUtils.func_209243_a(2961, "GL11.GL_STENCIL_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a(2962, "GL11.GL_STENCIL_FUNC");
        GlDebugTextUtils.func_209243_a(2963, "GL11.GL_STENCIL_VALUE_MASK");
        GlDebugTextUtils.func_209243_a(2964, "GL11.GL_STENCIL_FAIL");
        GlDebugTextUtils.func_209243_a(2965, "GL11.GL_STENCIL_PASS_DEPTH_FAIL");
        GlDebugTextUtils.func_209243_a(2966, "GL11.GL_STENCIL_PASS_DEPTH_PASS");
        GlDebugTextUtils.func_209243_a(2967, "GL11.GL_STENCIL_REF");
        GlDebugTextUtils.func_209243_a(2968, "GL11.GL_STENCIL_WRITEMASK");
        GlDebugTextUtils.func_209243_a(2976, "GL11.GL_MATRIX_MODE");
        GlDebugTextUtils.func_209243_a(2977, "GL11.GL_NORMALIZE");
        GlDebugTextUtils.func_209243_a(2978, "GL11.GL_VIEWPORT");
        GlDebugTextUtils.func_209243_a(2979, "GL11.GL_MODELVIEW_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(2980, "GL11.GL_PROJECTION_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(2981, "GL11.GL_TEXTURE_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(2982, "GL11.GL_MODELVIEW_MATRIX");
        GlDebugTextUtils.func_209243_a(2983, "GL11.GL_PROJECTION_MATRIX");
        GlDebugTextUtils.func_209243_a(2984, "GL11.GL_TEXTURE_MATRIX");
        GlDebugTextUtils.func_209243_a(2992, "GL11.GL_ATTRIB_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(2993, "GL11.GL_CLIENT_ATTRIB_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(3008, "GL11.GL_ALPHA_TEST");
        GlDebugTextUtils.func_209243_a(3009, "GL11.GL_ALPHA_TEST_FUNC");
        GlDebugTextUtils.func_209243_a(3010, "GL11.GL_ALPHA_TEST_REF");
        GlDebugTextUtils.func_209243_a(3024, "GL11.GL_DITHER");
        GlDebugTextUtils.func_209243_a(3040, "GL11.GL_BLEND_DST");
        GlDebugTextUtils.func_209243_a(3041, "GL11.GL_BLEND_SRC");
        GlDebugTextUtils.func_209243_a(3042, "GL11.GL_BLEND");
        GlDebugTextUtils.func_209243_a(3056, "GL11.GL_LOGIC_OP_MODE");
        GlDebugTextUtils.func_209243_a(3057, "GL11.GL_INDEX_LOGIC_OP");
        GlDebugTextUtils.func_209243_a(3058, "GL11.GL_COLOR_LOGIC_OP");
        GlDebugTextUtils.func_209243_a(3072, "GL11.GL_AUX_BUFFERS");
        GlDebugTextUtils.func_209243_a(3073, "GL11.GL_DRAW_BUFFER");
        GlDebugTextUtils.func_209243_a(3074, "GL11.GL_READ_BUFFER");
        GlDebugTextUtils.func_209243_a(3088, "GL11.GL_SCISSOR_BOX");
        GlDebugTextUtils.func_209243_a(3089, "GL11.GL_SCISSOR_TEST");
        GlDebugTextUtils.func_209243_a(3104, "GL11.GL_INDEX_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a(3105, "GL11.GL_INDEX_WRITEMASK");
        GlDebugTextUtils.func_209243_a(3106, "GL11.GL_COLOR_CLEAR_VALUE");
        GlDebugTextUtils.func_209243_a(3107, "GL11.GL_COLOR_WRITEMASK");
        GlDebugTextUtils.func_209243_a(3120, "GL11.GL_INDEX_MODE");
        GlDebugTextUtils.func_209243_a(3121, "GL11.GL_RGBA_MODE");
        GlDebugTextUtils.func_209243_a(3122, "GL11.GL_DOUBLEBUFFER");
        GlDebugTextUtils.func_209243_a(3123, "GL11.GL_STEREO");
        GlDebugTextUtils.func_209243_a(3136, "GL11.GL_RENDER_MODE");
        GlDebugTextUtils.func_209243_a(3152, "GL11.GL_PERSPECTIVE_CORRECTION_HINT");
        GlDebugTextUtils.func_209243_a(3153, "GL11.GL_POINT_SMOOTH_HINT");
        GlDebugTextUtils.func_209243_a(3154, "GL11.GL_LINE_SMOOTH_HINT");
        GlDebugTextUtils.func_209243_a(3155, "GL11.GL_POLYGON_SMOOTH_HINT");
        GlDebugTextUtils.func_209243_a(3156, "GL11.GL_FOG_HINT");
        GlDebugTextUtils.func_209243_a(3168, "GL11.GL_TEXTURE_GEN_S");
        GlDebugTextUtils.func_209243_a(3169, "GL11.GL_TEXTURE_GEN_T");
        GlDebugTextUtils.func_209243_a(3170, "GL11.GL_TEXTURE_GEN_R");
        GlDebugTextUtils.func_209243_a(3171, "GL11.GL_TEXTURE_GEN_Q");
        GlDebugTextUtils.func_209243_a(3184, "GL11.GL_PIXEL_MAP_I_TO_I");
        GlDebugTextUtils.func_209243_a(3185, "GL11.GL_PIXEL_MAP_S_TO_S");
        GlDebugTextUtils.func_209243_a(3186, "GL11.GL_PIXEL_MAP_I_TO_R");
        GlDebugTextUtils.func_209243_a(3187, "GL11.GL_PIXEL_MAP_I_TO_G");
        GlDebugTextUtils.func_209243_a(3188, "GL11.GL_PIXEL_MAP_I_TO_B");
        GlDebugTextUtils.func_209243_a(3189, "GL11.GL_PIXEL_MAP_I_TO_A");
        GlDebugTextUtils.func_209243_a(3190, "GL11.GL_PIXEL_MAP_R_TO_R");
        GlDebugTextUtils.func_209243_a(3191, "GL11.GL_PIXEL_MAP_G_TO_G");
        GlDebugTextUtils.func_209243_a(3192, "GL11.GL_PIXEL_MAP_B_TO_B");
        GlDebugTextUtils.func_209243_a(3193, "GL11.GL_PIXEL_MAP_A_TO_A");
        GlDebugTextUtils.func_209243_a(3248, "GL11.GL_PIXEL_MAP_I_TO_I_SIZE");
        GlDebugTextUtils.func_209243_a(3249, "GL11.GL_PIXEL_MAP_S_TO_S_SIZE");
        GlDebugTextUtils.func_209243_a(3250, "GL11.GL_PIXEL_MAP_I_TO_R_SIZE");
        GlDebugTextUtils.func_209243_a(3251, "GL11.GL_PIXEL_MAP_I_TO_G_SIZE");
        GlDebugTextUtils.func_209243_a(3252, "GL11.GL_PIXEL_MAP_I_TO_B_SIZE");
        GlDebugTextUtils.func_209243_a(3253, "GL11.GL_PIXEL_MAP_I_TO_A_SIZE");
        GlDebugTextUtils.func_209243_a(3254, "GL11.GL_PIXEL_MAP_R_TO_R_SIZE");
        GlDebugTextUtils.func_209243_a(3255, "GL11.GL_PIXEL_MAP_G_TO_G_SIZE");
        GlDebugTextUtils.func_209243_a(3256, "GL11.GL_PIXEL_MAP_B_TO_B_SIZE");
        GlDebugTextUtils.func_209243_a(3257, "GL11.GL_PIXEL_MAP_A_TO_A_SIZE");
        GlDebugTextUtils.func_209243_a(3312, "GL11.GL_UNPACK_SWAP_BYTES");
        GlDebugTextUtils.func_209243_a(3313, "GL11.GL_UNPACK_LSB_FIRST");
        GlDebugTextUtils.func_209243_a(3314, "GL11.GL_UNPACK_ROW_LENGTH");
        GlDebugTextUtils.func_209243_a(3315, "GL11.GL_UNPACK_SKIP_ROWS");
        GlDebugTextUtils.func_209243_a(3316, "GL11.GL_UNPACK_SKIP_PIXELS");
        GlDebugTextUtils.func_209243_a(3317, "GL11.GL_UNPACK_ALIGNMENT");
        GlDebugTextUtils.func_209243_a(3328, "GL11.GL_PACK_SWAP_BYTES");
        GlDebugTextUtils.func_209243_a(3329, "GL11.GL_PACK_LSB_FIRST");
        GlDebugTextUtils.func_209243_a(3330, "GL11.GL_PACK_ROW_LENGTH");
        GlDebugTextUtils.func_209243_a(3331, "GL11.GL_PACK_SKIP_ROWS");
        GlDebugTextUtils.func_209243_a(3332, "GL11.GL_PACK_SKIP_PIXELS");
        GlDebugTextUtils.func_209243_a(3333, "GL11.GL_PACK_ALIGNMENT");
        GlDebugTextUtils.func_209243_a(3344, "GL11.GL_MAP_COLOR");
        GlDebugTextUtils.func_209243_a(3345, "GL11.GL_MAP_STENCIL");
        GlDebugTextUtils.func_209243_a(3346, "GL11.GL_INDEX_SHIFT");
        GlDebugTextUtils.func_209243_a(3347, "GL11.GL_INDEX_OFFSET");
        GlDebugTextUtils.func_209243_a(3348, "GL11.GL_RED_SCALE");
        GlDebugTextUtils.func_209243_a(3349, "GL11.GL_RED_BIAS");
        GlDebugTextUtils.func_209243_a(3350, "GL11.GL_ZOOM_X");
        GlDebugTextUtils.func_209243_a(3351, "GL11.GL_ZOOM_Y");
        GlDebugTextUtils.func_209243_a(3352, "GL11.GL_GREEN_SCALE");
        GlDebugTextUtils.func_209243_a(3353, "GL11.GL_GREEN_BIAS");
        GlDebugTextUtils.func_209243_a(3354, "GL11.GL_BLUE_SCALE");
        GlDebugTextUtils.func_209243_a(3355, "GL11.GL_BLUE_BIAS");
        GlDebugTextUtils.func_209243_a(3356, "GL11.GL_ALPHA_SCALE");
        GlDebugTextUtils.func_209243_a(3357, "GL11.GL_ALPHA_BIAS");
        GlDebugTextUtils.func_209243_a(3358, "GL11.GL_DEPTH_SCALE");
        GlDebugTextUtils.func_209243_a(3359, "GL11.GL_DEPTH_BIAS");
        GlDebugTextUtils.func_209243_a(3376, "GL11.GL_MAX_EVAL_ORDER");
        GlDebugTextUtils.func_209243_a(3377, "GL11.GL_MAX_LIGHTS");
        GlDebugTextUtils.func_209243_a(3378, "GL11.GL_MAX_CLIP_PLANES");
        GlDebugTextUtils.func_209243_a(3379, "GL11.GL_MAX_TEXTURE_SIZE");
        GlDebugTextUtils.func_209243_a(3380, "GL11.GL_MAX_PIXEL_MAP_TABLE");
        GlDebugTextUtils.func_209243_a(3381, "GL11.GL_MAX_ATTRIB_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(3382, "GL11.GL_MAX_MODELVIEW_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(3383, "GL11.GL_MAX_NAME_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(3384, "GL11.GL_MAX_PROJECTION_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(3385, "GL11.GL_MAX_TEXTURE_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(3386, "GL11.GL_MAX_VIEWPORT_DIMS");
        GlDebugTextUtils.func_209243_a(3387, "GL11.GL_MAX_CLIENT_ATTRIB_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(3408, "GL11.GL_SUBPIXEL_BITS");
        GlDebugTextUtils.func_209243_a(3409, "GL11.GL_INDEX_BITS");
        GlDebugTextUtils.func_209243_a(3410, "GL11.GL_RED_BITS");
        GlDebugTextUtils.func_209243_a(3411, "GL11.GL_GREEN_BITS");
        GlDebugTextUtils.func_209243_a(3412, "GL11.GL_BLUE_BITS");
        GlDebugTextUtils.func_209243_a(3413, "GL11.GL_ALPHA_BITS");
        GlDebugTextUtils.func_209243_a(3414, "GL11.GL_DEPTH_BITS");
        GlDebugTextUtils.func_209243_a(3415, "GL11.GL_STENCIL_BITS");
        GlDebugTextUtils.func_209243_a(3416, "GL11.GL_ACCUM_RED_BITS");
        GlDebugTextUtils.func_209243_a(3417, "GL11.GL_ACCUM_GREEN_BITS");
        GlDebugTextUtils.func_209243_a(3418, "GL11.GL_ACCUM_BLUE_BITS");
        GlDebugTextUtils.func_209243_a(3419, "GL11.GL_ACCUM_ALPHA_BITS");
        GlDebugTextUtils.func_209243_a(3440, "GL11.GL_NAME_STACK_DEPTH");
        GlDebugTextUtils.func_209243_a(3456, "GL11.GL_AUTO_NORMAL");
        GlDebugTextUtils.func_209243_a(3472, "GL11.GL_MAP1_COLOR_4");
        GlDebugTextUtils.func_209243_a(3473, "GL11.GL_MAP1_INDEX");
        GlDebugTextUtils.func_209243_a(3474, "GL11.GL_MAP1_NORMAL");
        GlDebugTextUtils.func_209243_a(3475, "GL11.GL_MAP1_TEXTURE_COORD_1");
        GlDebugTextUtils.func_209243_a(3476, "GL11.GL_MAP1_TEXTURE_COORD_2");
        GlDebugTextUtils.func_209243_a(3477, "GL11.GL_MAP1_TEXTURE_COORD_3");
        GlDebugTextUtils.func_209243_a(3478, "GL11.GL_MAP1_TEXTURE_COORD_4");
        GlDebugTextUtils.func_209243_a(3479, "GL11.GL_MAP1_VERTEX_3");
        GlDebugTextUtils.func_209243_a(3480, "GL11.GL_MAP1_VERTEX_4");
        GlDebugTextUtils.func_209243_a(3504, "GL11.GL_MAP2_COLOR_4");
        GlDebugTextUtils.func_209243_a(3505, "GL11.GL_MAP2_INDEX");
        GlDebugTextUtils.func_209243_a(3506, "GL11.GL_MAP2_NORMAL");
        GlDebugTextUtils.func_209243_a(3507, "GL11.GL_MAP2_TEXTURE_COORD_1");
        GlDebugTextUtils.func_209243_a(3508, "GL11.GL_MAP2_TEXTURE_COORD_2");
        GlDebugTextUtils.func_209243_a(3509, "GL11.GL_MAP2_TEXTURE_COORD_3");
        GlDebugTextUtils.func_209243_a(3510, "GL11.GL_MAP2_TEXTURE_COORD_4");
        GlDebugTextUtils.func_209243_a(3511, "GL11.GL_MAP2_VERTEX_3");
        GlDebugTextUtils.func_209243_a(3512, "GL11.GL_MAP2_VERTEX_4");
        GlDebugTextUtils.func_209243_a(3536, "GL11.GL_MAP1_GRID_DOMAIN");
        GlDebugTextUtils.func_209243_a(3537, "GL11.GL_MAP1_GRID_SEGMENTS");
        GlDebugTextUtils.func_209243_a(3538, "GL11.GL_MAP2_GRID_DOMAIN");
        GlDebugTextUtils.func_209243_a(3539, "GL11.GL_MAP2_GRID_SEGMENTS");
        GlDebugTextUtils.func_209243_a(3552, "GL11.GL_TEXTURE_1D");
        GlDebugTextUtils.func_209243_a(3553, "GL11.GL_TEXTURE_2D");
        GlDebugTextUtils.func_209243_a(3568, "GL11.GL_FEEDBACK_BUFFER_POINTER");
        GlDebugTextUtils.func_209243_a(3569, "GL11.GL_FEEDBACK_BUFFER_SIZE");
        GlDebugTextUtils.func_209243_a(3570, "GL11.GL_FEEDBACK_BUFFER_TYPE");
        GlDebugTextUtils.func_209243_a(3571, "GL11.GL_SELECTION_BUFFER_POINTER");
        GlDebugTextUtils.func_209243_a(3572, "GL11.GL_SELECTION_BUFFER_SIZE");
        GlDebugTextUtils.func_209243_a(4096, "GL11.GL_TEXTURE_WIDTH");
        GlDebugTextUtils.func_209243_a(4097, "GL11.GL_TEXTURE_HEIGHT");
        GlDebugTextUtils.func_209243_a(4099, "GL11.GL_TEXTURE_INTERNAL_FORMAT");
        GlDebugTextUtils.func_209243_a(4100, "GL11.GL_TEXTURE_BORDER_COLOR");
        GlDebugTextUtils.func_209243_a(4101, "GL11.GL_TEXTURE_BORDER");
        GlDebugTextUtils.func_209243_a(4352, "GL11.GL_DONT_CARE");
        GlDebugTextUtils.func_209243_a(4353, "GL11.GL_FASTEST");
        GlDebugTextUtils.func_209243_a(4354, "GL11.GL_NICEST");
        GlDebugTextUtils.func_209243_a(16384, "GL11.GL_LIGHT0");
        GlDebugTextUtils.func_209243_a(16385, "GL11.GL_LIGHT1");
        GlDebugTextUtils.func_209243_a(16386, "GL11.GL_LIGHT2");
        GlDebugTextUtils.func_209243_a(16387, "GL11.GL_LIGHT3");
        GlDebugTextUtils.func_209243_a(16388, "GL11.GL_LIGHT4");
        GlDebugTextUtils.func_209243_a(16389, "GL11.GL_LIGHT5");
        GlDebugTextUtils.func_209243_a(16390, "GL11.GL_LIGHT6");
        GlDebugTextUtils.func_209243_a(16391, "GL11.GL_LIGHT7");
        GlDebugTextUtils.func_209243_a(4608, "GL11.GL_AMBIENT");
        GlDebugTextUtils.func_209243_a(4609, "GL11.GL_DIFFUSE");
        GlDebugTextUtils.func_209243_a(4610, "GL11.GL_SPECULAR");
        GlDebugTextUtils.func_209243_a(4611, "GL11.GL_POSITION");
        GlDebugTextUtils.func_209243_a(4612, "GL11.GL_SPOT_DIRECTION");
        GlDebugTextUtils.func_209243_a(4613, "GL11.GL_SPOT_EXPONENT");
        GlDebugTextUtils.func_209243_a(4614, "GL11.GL_SPOT_CUTOFF");
        GlDebugTextUtils.func_209243_a(4615, "GL11.GL_CONSTANT_ATTENUATION");
        GlDebugTextUtils.func_209243_a(4616, "GL11.GL_LINEAR_ATTENUATION");
        GlDebugTextUtils.func_209243_a(4617, "GL11.GL_QUADRATIC_ATTENUATION");
        GlDebugTextUtils.func_209243_a(4864, "GL11.GL_COMPILE");
        GlDebugTextUtils.func_209243_a(4865, "GL11.GL_COMPILE_AND_EXECUTE");
        GlDebugTextUtils.func_209243_a(5376, "GL11.GL_CLEAR");
        GlDebugTextUtils.func_209243_a(5377, "GL11.GL_AND");
        GlDebugTextUtils.func_209243_a(5378, "GL11.GL_AND_REVERSE");
        GlDebugTextUtils.func_209243_a(5379, "GL11.GL_COPY");
        GlDebugTextUtils.func_209243_a(5380, "GL11.GL_AND_INVERTED");
        GlDebugTextUtils.func_209243_a(5381, "GL11.GL_NOOP");
        GlDebugTextUtils.func_209243_a(5382, "GL11.GL_XOR");
        GlDebugTextUtils.func_209243_a(5383, "GL11.GL_OR");
        GlDebugTextUtils.func_209243_a(5384, "GL11.GL_NOR");
        GlDebugTextUtils.func_209243_a(5385, "GL11.GL_EQUIV");
        GlDebugTextUtils.func_209243_a(5386, "GL11.GL_INVERT");
        GlDebugTextUtils.func_209243_a(5387, "GL11.GL_OR_REVERSE");
        GlDebugTextUtils.func_209243_a(5388, "GL11.GL_COPY_INVERTED");
        GlDebugTextUtils.func_209243_a(5389, "GL11.GL_OR_INVERTED");
        GlDebugTextUtils.func_209243_a(5390, "GL11.GL_NAND");
        GlDebugTextUtils.func_209243_a(5391, "GL11.GL_SET");
        GlDebugTextUtils.func_209243_a(5632, "GL11.GL_EMISSION");
        GlDebugTextUtils.func_209243_a(5633, "GL11.GL_SHININESS");
        GlDebugTextUtils.func_209243_a(5634, "GL11.GL_AMBIENT_AND_DIFFUSE");
        GlDebugTextUtils.func_209243_a(5635, "GL11.GL_COLOR_INDEXES");
        GlDebugTextUtils.func_209243_a(5888, "GL11.GL_MODELVIEW");
        GlDebugTextUtils.func_209243_a(5889, "GL11.GL_PROJECTION");
        GlDebugTextUtils.func_209243_a(5890, "GL11.GL_TEXTURE");
        GlDebugTextUtils.func_209243_a(6144, "GL11.GL_COLOR");
        GlDebugTextUtils.func_209243_a(6145, "GL11.GL_DEPTH");
        GlDebugTextUtils.func_209243_a(6146, "GL11.GL_STENCIL");
        GlDebugTextUtils.func_209243_a(6400, "GL11.GL_COLOR_INDEX");
        GlDebugTextUtils.func_209243_a(6401, "GL11.GL_STENCIL_INDEX");
        GlDebugTextUtils.func_209243_a(6402, "GL11.GL_DEPTH_COMPONENT");
        GlDebugTextUtils.func_209243_a(6403, "GL11.GL_RED");
        GlDebugTextUtils.func_209243_a(6404, "GL11.GL_GREEN");
        GlDebugTextUtils.func_209243_a(6405, "GL11.GL_BLUE");
        GlDebugTextUtils.func_209243_a(6406, "GL11.GL_ALPHA");
        GlDebugTextUtils.func_209243_a(6407, "GL11.GL_RGB");
        GlDebugTextUtils.func_209243_a(6408, "GL11.GL_RGBA");
        GlDebugTextUtils.func_209243_a(6409, "GL11.GL_LUMINANCE");
        GlDebugTextUtils.func_209243_a(6410, "GL11.GL_LUMINANCE_ALPHA");
        GlDebugTextUtils.func_209243_a(6656, "GL11.GL_BITMAP");
        GlDebugTextUtils.func_209243_a(6912, "GL11.GL_POINT");
        GlDebugTextUtils.func_209243_a(6913, "GL11.GL_LINE");
        GlDebugTextUtils.func_209243_a(6914, "GL11.GL_FILL");
        GlDebugTextUtils.func_209243_a(7168, "GL11.GL_RENDER");
        GlDebugTextUtils.func_209243_a(7169, "GL11.GL_FEEDBACK");
        GlDebugTextUtils.func_209243_a(7170, "GL11.GL_SELECT");
        GlDebugTextUtils.func_209243_a(7424, "GL11.GL_FLAT");
        GlDebugTextUtils.func_209243_a(7425, "GL11.GL_SMOOTH");
        GlDebugTextUtils.func_209243_a(7680, "GL11.GL_KEEP");
        GlDebugTextUtils.func_209243_a(7681, "GL11.GL_REPLACE");
        GlDebugTextUtils.func_209243_a(7682, "GL11.GL_INCR");
        GlDebugTextUtils.func_209243_a(7683, "GL11.GL_DECR");
        GlDebugTextUtils.func_209243_a(7936, "GL11.GL_VENDOR");
        GlDebugTextUtils.func_209243_a(7937, "GL11.GL_RENDERER");
        GlDebugTextUtils.func_209243_a(7938, "GL11.GL_VERSION");
        GlDebugTextUtils.func_209243_a(7939, "GL11.GL_EXTENSIONS");
        GlDebugTextUtils.func_209243_a(8192, "GL11.GL_S");
        GlDebugTextUtils.func_209243_a(8193, "GL11.GL_T");
        GlDebugTextUtils.func_209243_a(8194, "GL11.GL_R");
        GlDebugTextUtils.func_209243_a(8195, "GL11.GL_Q");
        GlDebugTextUtils.func_209243_a(8448, "GL11.GL_MODULATE");
        GlDebugTextUtils.func_209243_a(8449, "GL11.GL_DECAL");
        GlDebugTextUtils.func_209243_a(8704, "GL11.GL_TEXTURE_ENV_MODE");
        GlDebugTextUtils.func_209243_a(8705, "GL11.GL_TEXTURE_ENV_COLOR");
        GlDebugTextUtils.func_209243_a(8960, "GL11.GL_TEXTURE_ENV");
        GlDebugTextUtils.func_209243_a(9216, "GL11.GL_EYE_LINEAR");
        GlDebugTextUtils.func_209243_a(9217, "GL11.GL_OBJECT_LINEAR");
        GlDebugTextUtils.func_209243_a(9218, "GL11.GL_SPHERE_MAP");
        GlDebugTextUtils.func_209243_a(9472, "GL11.GL_TEXTURE_GEN_MODE");
        GlDebugTextUtils.func_209243_a(9473, "GL11.GL_OBJECT_PLANE");
        GlDebugTextUtils.func_209243_a(9474, "GL11.GL_EYE_PLANE");
        GlDebugTextUtils.func_209243_a(9728, "GL11.GL_NEAREST");
        GlDebugTextUtils.func_209243_a(9729, "GL11.GL_LINEAR");
        GlDebugTextUtils.func_209243_a(9984, "GL11.GL_NEAREST_MIPMAP_NEAREST");
        GlDebugTextUtils.func_209243_a(9985, "GL11.GL_LINEAR_MIPMAP_NEAREST");
        GlDebugTextUtils.func_209243_a(9986, "GL11.GL_NEAREST_MIPMAP_LINEAR");
        GlDebugTextUtils.func_209243_a(9987, "GL11.GL_LINEAR_MIPMAP_LINEAR");
        GlDebugTextUtils.func_209243_a(10240, "GL11.GL_TEXTURE_MAG_FILTER");
        GlDebugTextUtils.func_209243_a(10241, "GL11.GL_TEXTURE_MIN_FILTER");
        GlDebugTextUtils.func_209243_a(10242, "GL11.GL_TEXTURE_WRAP_S");
        GlDebugTextUtils.func_209243_a(10243, "GL11.GL_TEXTURE_WRAP_T");
        GlDebugTextUtils.func_209243_a(10496, "GL11.GL_CLAMP");
        GlDebugTextUtils.func_209243_a(10497, "GL11.GL_REPEAT");
        GlDebugTextUtils.func_209243_a(-1, "GL11.GL_ALL_CLIENT_ATTRIB_BITS");
        GlDebugTextUtils.func_209243_a(32824, "GL11.GL_POLYGON_OFFSET_FACTOR");
        GlDebugTextUtils.func_209243_a(10752, "GL11.GL_POLYGON_OFFSET_UNITS");
        GlDebugTextUtils.func_209243_a(10753, "GL11.GL_POLYGON_OFFSET_POINT");
        GlDebugTextUtils.func_209243_a(10754, "GL11.GL_POLYGON_OFFSET_LINE");
        GlDebugTextUtils.func_209243_a(32823, "GL11.GL_POLYGON_OFFSET_FILL");
        GlDebugTextUtils.func_209243_a(32827, "GL11.GL_ALPHA4");
        GlDebugTextUtils.func_209243_a(32828, "GL11.GL_ALPHA8");
        GlDebugTextUtils.func_209243_a(32829, "GL11.GL_ALPHA12");
        GlDebugTextUtils.func_209243_a(32830, "GL11.GL_ALPHA16");
        GlDebugTextUtils.func_209243_a(32831, "GL11.GL_LUMINANCE4");
        GlDebugTextUtils.func_209243_a(32832, "GL11.GL_LUMINANCE8");
        GlDebugTextUtils.func_209243_a(32833, "GL11.GL_LUMINANCE12");
        GlDebugTextUtils.func_209243_a(32834, "GL11.GL_LUMINANCE16");
        GlDebugTextUtils.func_209243_a(32835, "GL11.GL_LUMINANCE4_ALPHA4");
        GlDebugTextUtils.func_209243_a(32836, "GL11.GL_LUMINANCE6_ALPHA2");
        GlDebugTextUtils.func_209243_a(32837, "GL11.GL_LUMINANCE8_ALPHA8");
        GlDebugTextUtils.func_209243_a(32838, "GL11.GL_LUMINANCE12_ALPHA4");
        GlDebugTextUtils.func_209243_a(32839, "GL11.GL_LUMINANCE12_ALPHA12");
        GlDebugTextUtils.func_209243_a(32840, "GL11.GL_LUMINANCE16_ALPHA16");
        GlDebugTextUtils.func_209243_a(32841, "GL11.GL_INTENSITY");
        GlDebugTextUtils.func_209243_a(32842, "GL11.GL_INTENSITY4");
        GlDebugTextUtils.func_209243_a(32843, "GL11.GL_INTENSITY8");
        GlDebugTextUtils.func_209243_a(32844, "GL11.GL_INTENSITY12");
        GlDebugTextUtils.func_209243_a(32845, "GL11.GL_INTENSITY16");
        GlDebugTextUtils.func_209243_a(10768, "GL11.GL_R3_G3_B2");
        GlDebugTextUtils.func_209243_a(32847, "GL11.GL_RGB4");
        GlDebugTextUtils.func_209243_a(32848, "GL11.GL_RGB5");
        GlDebugTextUtils.func_209243_a(32849, "GL11.GL_RGB8");
        GlDebugTextUtils.func_209243_a(32850, "GL11.GL_RGB10");
        GlDebugTextUtils.func_209243_a(32851, "GL11.GL_RGB12");
        GlDebugTextUtils.func_209243_a(32852, "GL11.GL_RGB16");
        GlDebugTextUtils.func_209243_a(32853, "GL11.GL_RGBA2");
        GlDebugTextUtils.func_209243_a(32854, "GL11.GL_RGBA4");
        GlDebugTextUtils.func_209243_a(32855, "GL11.GL_RGB5_A1");
        GlDebugTextUtils.func_209243_a(32856, "GL11.GL_RGBA8");
        GlDebugTextUtils.func_209243_a(32857, "GL11.GL_RGB10_A2");
        GlDebugTextUtils.func_209243_a(32858, "GL11.GL_RGBA12");
        GlDebugTextUtils.func_209243_a(32859, "GL11.GL_RGBA16");
        GlDebugTextUtils.func_209243_a(32860, "GL11.GL_TEXTURE_RED_SIZE");
        GlDebugTextUtils.func_209243_a(32861, "GL11.GL_TEXTURE_GREEN_SIZE");
        GlDebugTextUtils.func_209243_a(32862, "GL11.GL_TEXTURE_BLUE_SIZE");
        GlDebugTextUtils.func_209243_a(32863, "GL11.GL_TEXTURE_ALPHA_SIZE");
        GlDebugTextUtils.func_209243_a(32864, "GL11.GL_TEXTURE_LUMINANCE_SIZE");
        GlDebugTextUtils.func_209243_a(32865, "GL11.GL_TEXTURE_INTENSITY_SIZE");
        GlDebugTextUtils.func_209243_a(32867, "GL11.GL_PROXY_TEXTURE_1D");
        GlDebugTextUtils.func_209243_a(32868, "GL11.GL_PROXY_TEXTURE_2D");
        GlDebugTextUtils.func_209243_a(32870, "GL11.GL_TEXTURE_PRIORITY");
        GlDebugTextUtils.func_209243_a(32871, "GL11.GL_TEXTURE_RESIDENT");
        GlDebugTextUtils.func_209243_a(32872, "GL11.GL_TEXTURE_BINDING_1D");
        GlDebugTextUtils.func_209243_a(32873, "GL11.GL_TEXTURE_BINDING_2D");
        GlDebugTextUtils.func_209243_a(32884, "GL11.GL_VERTEX_ARRAY");
        GlDebugTextUtils.func_209243_a(32885, "GL11.GL_NORMAL_ARRAY");
        GlDebugTextUtils.func_209243_a(32886, "GL11.GL_COLOR_ARRAY");
        GlDebugTextUtils.func_209243_a(32887, "GL11.GL_INDEX_ARRAY");
        GlDebugTextUtils.func_209243_a(32888, "GL11.GL_TEXTURE_COORD_ARRAY");
        GlDebugTextUtils.func_209243_a(32889, "GL11.GL_EDGE_FLAG_ARRAY");
        GlDebugTextUtils.func_209243_a(32890, "GL11.GL_VERTEX_ARRAY_SIZE");
        GlDebugTextUtils.func_209243_a(32891, "GL11.GL_VERTEX_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a(32892, "GL11.GL_VERTEX_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a(32894, "GL11.GL_NORMAL_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a(32895, "GL11.GL_NORMAL_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a(32897, "GL11.GL_COLOR_ARRAY_SIZE");
        GlDebugTextUtils.func_209243_a(32898, "GL11.GL_COLOR_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a(32899, "GL11.GL_COLOR_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a(32901, "GL11.GL_INDEX_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a(32902, "GL11.GL_INDEX_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a(32904, "GL11.GL_TEXTURE_COORD_ARRAY_SIZE");
        GlDebugTextUtils.func_209243_a(32905, "GL11.GL_TEXTURE_COORD_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a(32906, "GL11.GL_TEXTURE_COORD_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a(32908, "GL11.GL_EDGE_FLAG_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a(32910, "GL11.GL_VERTEX_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a(32911, "GL11.GL_NORMAL_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a(32912, "GL11.GL_COLOR_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a(32913, "GL11.GL_INDEX_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a(32914, "GL11.GL_TEXTURE_COORD_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a(32915, "GL11.GL_EDGE_FLAG_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a(10784, "GL11.GL_V2F");
        GlDebugTextUtils.func_209243_a(10785, "GL11.GL_V3F");
        GlDebugTextUtils.func_209243_a(10786, "GL11.GL_C4UB_V2F");
        GlDebugTextUtils.func_209243_a(10787, "GL11.GL_C4UB_V3F");
        GlDebugTextUtils.func_209243_a(10788, "GL11.GL_C3F_V3F");
        GlDebugTextUtils.func_209243_a(10789, "GL11.GL_N3F_V3F");
        GlDebugTextUtils.func_209243_a(10790, "GL11.GL_C4F_N3F_V3F");
        GlDebugTextUtils.func_209243_a(10791, "GL11.GL_T2F_V3F");
        GlDebugTextUtils.func_209243_a(10792, "GL11.GL_T4F_V4F");
        GlDebugTextUtils.func_209243_a(10793, "GL11.GL_T2F_C4UB_V3F");
        GlDebugTextUtils.func_209243_a(10794, "GL11.GL_T2F_C3F_V3F");
        GlDebugTextUtils.func_209243_a(10795, "GL11.GL_T2F_N3F_V3F");
        GlDebugTextUtils.func_209243_a(10796, "GL11.GL_T2F_C4F_N3F_V3F");
        GlDebugTextUtils.func_209243_a(10797, "GL11.GL_T4F_C4F_N3F_V4F");
        GlDebugTextUtils.func_209243_a(3057, "GL11.GL_LOGIC_OP");
        GlDebugTextUtils.func_209243_a(4099, "GL11.GL_TEXTURE_COMPONENTS");
        GlDebugTextUtils.func_209243_a(32874, "GL12.GL_TEXTURE_BINDING_3D");
        GlDebugTextUtils.func_209243_a(32875, "GL12.GL_PACK_SKIP_IMAGES");
        GlDebugTextUtils.func_209243_a(32876, "GL12.GL_PACK_IMAGE_HEIGHT");
        GlDebugTextUtils.func_209243_a(32877, "GL12.GL_UNPACK_SKIP_IMAGES");
        GlDebugTextUtils.func_209243_a(32878, "GL12.GL_UNPACK_IMAGE_HEIGHT");
        GlDebugTextUtils.func_209243_a(32879, "GL12.GL_TEXTURE_3D");
        GlDebugTextUtils.func_209243_a(32880, "GL12.GL_PROXY_TEXTURE_3D");
        GlDebugTextUtils.func_209243_a(32881, "GL12.GL_TEXTURE_DEPTH");
        GlDebugTextUtils.func_209243_a(32882, "GL12.GL_TEXTURE_WRAP_R");
        GlDebugTextUtils.func_209243_a(32883, "GL12.GL_MAX_3D_TEXTURE_SIZE");
        GlDebugTextUtils.func_209243_a(32992, "GL12.GL_BGR");
        GlDebugTextUtils.func_209243_a(32993, "GL12.GL_BGRA");
        GlDebugTextUtils.func_209243_a(32818, "GL12.GL_UNSIGNED_BYTE_3_3_2");
        GlDebugTextUtils.func_209243_a(33634, "GL12.GL_UNSIGNED_BYTE_2_3_3_REV");
        GlDebugTextUtils.func_209243_a(33635, "GL12.GL_UNSIGNED_SHORT_5_6_5");
        GlDebugTextUtils.func_209243_a(33636, "GL12.GL_UNSIGNED_SHORT_5_6_5_REV");
        GlDebugTextUtils.func_209243_a(32819, "GL12.GL_UNSIGNED_SHORT_4_4_4_4");
        GlDebugTextUtils.func_209243_a(33637, "GL12.GL_UNSIGNED_SHORT_4_4_4_4_REV");
        GlDebugTextUtils.func_209243_a(32820, "GL12.GL_UNSIGNED_SHORT_5_5_5_1");
        GlDebugTextUtils.func_209243_a(33638, "GL12.GL_UNSIGNED_SHORT_1_5_5_5_REV");
        GlDebugTextUtils.func_209243_a(32821, "GL12.GL_UNSIGNED_INT_8_8_8_8");
        GlDebugTextUtils.func_209243_a(33639, "GL12.GL_UNSIGNED_INT_8_8_8_8_REV");
        GlDebugTextUtils.func_209243_a(32822, "GL12.GL_UNSIGNED_INT_10_10_10_2");
        GlDebugTextUtils.func_209243_a(33640, "GL12.GL_UNSIGNED_INT_2_10_10_10_REV");
        GlDebugTextUtils.func_209243_a(32826, "GL12.GL_RESCALE_NORMAL");
        GlDebugTextUtils.func_209243_a(33272, "GL12.GL_LIGHT_MODEL_COLOR_CONTROL");
        GlDebugTextUtils.func_209243_a(33273, "GL12.GL_SINGLE_COLOR");
        GlDebugTextUtils.func_209243_a(33274, "GL12.GL_SEPARATE_SPECULAR_COLOR");
        GlDebugTextUtils.func_209243_a(33071, "GL12.GL_CLAMP_TO_EDGE");
        GlDebugTextUtils.func_209243_a(33082, "GL12.GL_TEXTURE_MIN_LOD");
        GlDebugTextUtils.func_209243_a(33083, "GL12.GL_TEXTURE_MAX_LOD");
        GlDebugTextUtils.func_209243_a(33084, "GL12.GL_TEXTURE_BASE_LEVEL");
        GlDebugTextUtils.func_209243_a(33085, "GL12.GL_TEXTURE_MAX_LEVEL");
        GlDebugTextUtils.func_209243_a(33000, "GL12.GL_MAX_ELEMENTS_VERTICES");
        GlDebugTextUtils.func_209243_a(33001, "GL12.GL_MAX_ELEMENTS_INDICES");
        GlDebugTextUtils.func_209243_a(33901, "GL12.GL_ALIASED_POINT_SIZE_RANGE");
        GlDebugTextUtils.func_209243_a(33902, "GL12.GL_ALIASED_LINE_WIDTH_RANGE");
        GlDebugTextUtils.func_209243_a(33984, "GL13.GL_TEXTURE0");
        GlDebugTextUtils.func_209243_a(33985, "GL13.GL_TEXTURE1");
        GlDebugTextUtils.func_209243_a(33986, "GL13.GL_TEXTURE2");
        GlDebugTextUtils.func_209243_a(33987, "GL13.GL_TEXTURE3");
        GlDebugTextUtils.func_209243_a(33988, "GL13.GL_TEXTURE4");
        GlDebugTextUtils.func_209243_a(33989, "GL13.GL_TEXTURE5");
        GlDebugTextUtils.func_209243_a(33990, "GL13.GL_TEXTURE6");
        GlDebugTextUtils.func_209243_a(33991, "GL13.GL_TEXTURE7");
        GlDebugTextUtils.func_209243_a(33992, "GL13.GL_TEXTURE8");
        GlDebugTextUtils.func_209243_a(33993, "GL13.GL_TEXTURE9");
        GlDebugTextUtils.func_209243_a(33994, "GL13.GL_TEXTURE10");
        GlDebugTextUtils.func_209243_a(33995, "GL13.GL_TEXTURE11");
        GlDebugTextUtils.func_209243_a(33996, "GL13.GL_TEXTURE12");
        GlDebugTextUtils.func_209243_a(33997, "GL13.GL_TEXTURE13");
        GlDebugTextUtils.func_209243_a(33998, "GL13.GL_TEXTURE14");
        GlDebugTextUtils.func_209243_a(33999, "GL13.GL_TEXTURE15");
        GlDebugTextUtils.func_209243_a(34000, "GL13.GL_TEXTURE16");
        GlDebugTextUtils.func_209243_a(34001, "GL13.GL_TEXTURE17");
        GlDebugTextUtils.func_209243_a(34002, "GL13.GL_TEXTURE18");
        GlDebugTextUtils.func_209243_a(34003, "GL13.GL_TEXTURE19");
        GlDebugTextUtils.func_209243_a(34004, "GL13.GL_TEXTURE20");
        GlDebugTextUtils.func_209243_a(34005, "GL13.GL_TEXTURE21");
        GlDebugTextUtils.func_209243_a(34006, "GL13.GL_TEXTURE22");
        GlDebugTextUtils.func_209243_a(34007, "GL13.GL_TEXTURE23");
        GlDebugTextUtils.func_209243_a(34008, "GL13.GL_TEXTURE24");
        GlDebugTextUtils.func_209243_a(34009, "GL13.GL_TEXTURE25");
        GlDebugTextUtils.func_209243_a(34010, "GL13.GL_TEXTURE26");
        GlDebugTextUtils.func_209243_a(34011, "GL13.GL_TEXTURE27");
        GlDebugTextUtils.func_209243_a(34012, "GL13.GL_TEXTURE28");
        GlDebugTextUtils.func_209243_a(34013, "GL13.GL_TEXTURE29");
        GlDebugTextUtils.func_209243_a(34014, "GL13.GL_TEXTURE30");
        GlDebugTextUtils.func_209243_a(34015, "GL13.GL_TEXTURE31");
        GlDebugTextUtils.func_209243_a(34016, "GL13.GL_ACTIVE_TEXTURE");
        GlDebugTextUtils.func_209243_a(34017, "GL13.GL_CLIENT_ACTIVE_TEXTURE");
        GlDebugTextUtils.func_209243_a(34018, "GL13.GL_MAX_TEXTURE_UNITS");
        GlDebugTextUtils.func_209243_a(34065, "GL13.GL_NORMAL_MAP");
        GlDebugTextUtils.func_209243_a(34066, "GL13.GL_REFLECTION_MAP");
        GlDebugTextUtils.func_209243_a(34067, "GL13.GL_TEXTURE_CUBE_MAP");
        GlDebugTextUtils.func_209243_a(34068, "GL13.GL_TEXTURE_BINDING_CUBE_MAP");
        GlDebugTextUtils.func_209243_a(34069, "GL13.GL_TEXTURE_CUBE_MAP_POSITIVE_X");
        GlDebugTextUtils.func_209243_a(34070, "GL13.GL_TEXTURE_CUBE_MAP_NEGATIVE_X");
        GlDebugTextUtils.func_209243_a(34071, "GL13.GL_TEXTURE_CUBE_MAP_POSITIVE_Y");
        GlDebugTextUtils.func_209243_a(34072, "GL13.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y");
        GlDebugTextUtils.func_209243_a(34073, "GL13.GL_TEXTURE_CUBE_MAP_POSITIVE_Z");
        GlDebugTextUtils.func_209243_a(34074, "GL13.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z");
        GlDebugTextUtils.func_209243_a(34075, "GL13.GL_PROXY_TEXTURE_CUBE_MAP");
        GlDebugTextUtils.func_209243_a(34076, "GL13.GL_MAX_CUBE_MAP_TEXTURE_SIZE");
        GlDebugTextUtils.func_209243_a(34025, "GL13.GL_COMPRESSED_ALPHA");
        GlDebugTextUtils.func_209243_a(34026, "GL13.GL_COMPRESSED_LUMINANCE");
        GlDebugTextUtils.func_209243_a(34027, "GL13.GL_COMPRESSED_LUMINANCE_ALPHA");
        GlDebugTextUtils.func_209243_a(34028, "GL13.GL_COMPRESSED_INTENSITY");
        GlDebugTextUtils.func_209243_a(34029, "GL13.GL_COMPRESSED_RGB");
        GlDebugTextUtils.func_209243_a(34030, "GL13.GL_COMPRESSED_RGBA");
        GlDebugTextUtils.func_209243_a(34031, "GL13.GL_TEXTURE_COMPRESSION_HINT");
        GlDebugTextUtils.func_209243_a(34464, "GL13.GL_TEXTURE_COMPRESSED_IMAGE_SIZE");
        GlDebugTextUtils.func_209243_a(34465, "GL13.GL_TEXTURE_COMPRESSED");
        GlDebugTextUtils.func_209243_a(34466, "GL13.GL_NUM_COMPRESSED_TEXTURE_FORMATS");
        GlDebugTextUtils.func_209243_a(34467, "GL13.GL_COMPRESSED_TEXTURE_FORMATS");
        GlDebugTextUtils.func_209243_a(32925, "GL13.GL_MULTISAMPLE");
        GlDebugTextUtils.func_209243_a(32926, "GL13.GL_SAMPLE_ALPHA_TO_COVERAGE");
        GlDebugTextUtils.func_209243_a(32927, "GL13.GL_SAMPLE_ALPHA_TO_ONE");
        GlDebugTextUtils.func_209243_a(32928, "GL13.GL_SAMPLE_COVERAGE");
        GlDebugTextUtils.func_209243_a(32936, "GL13.GL_SAMPLE_BUFFERS");
        GlDebugTextUtils.func_209243_a(32937, "GL13.GL_SAMPLES");
        GlDebugTextUtils.func_209243_a(32938, "GL13.GL_SAMPLE_COVERAGE_VALUE");
        GlDebugTextUtils.func_209243_a(32939, "GL13.GL_SAMPLE_COVERAGE_INVERT");
        GlDebugTextUtils.func_209243_a(34019, "GL13.GL_TRANSPOSE_MODELVIEW_MATRIX");
        GlDebugTextUtils.func_209243_a(34020, "GL13.GL_TRANSPOSE_PROJECTION_MATRIX");
        GlDebugTextUtils.func_209243_a(34021, "GL13.GL_TRANSPOSE_TEXTURE_MATRIX");
        GlDebugTextUtils.func_209243_a(34022, "GL13.GL_TRANSPOSE_COLOR_MATRIX");
        GlDebugTextUtils.func_209243_a(34160, "GL13.GL_COMBINE");
        GlDebugTextUtils.func_209243_a(34161, "GL13.GL_COMBINE_RGB");
        GlDebugTextUtils.func_209243_a(34162, "GL13.GL_COMBINE_ALPHA");
        GlDebugTextUtils.func_209243_a(34176, "GL13.GL_SOURCE0_RGB");
        GlDebugTextUtils.func_209243_a(34177, "GL13.GL_SOURCE1_RGB");
        GlDebugTextUtils.func_209243_a(34178, "GL13.GL_SOURCE2_RGB");
        GlDebugTextUtils.func_209243_a(34184, "GL13.GL_SOURCE0_ALPHA");
        GlDebugTextUtils.func_209243_a(34185, "GL13.GL_SOURCE1_ALPHA");
        GlDebugTextUtils.func_209243_a(34186, "GL13.GL_SOURCE2_ALPHA");
        GlDebugTextUtils.func_209243_a(34192, "GL13.GL_OPERAND0_RGB");
        GlDebugTextUtils.func_209243_a(34193, "GL13.GL_OPERAND1_RGB");
        GlDebugTextUtils.func_209243_a(34194, "GL13.GL_OPERAND2_RGB");
        GlDebugTextUtils.func_209243_a(34200, "GL13.GL_OPERAND0_ALPHA");
        GlDebugTextUtils.func_209243_a(34201, "GL13.GL_OPERAND1_ALPHA");
        GlDebugTextUtils.func_209243_a(34202, "GL13.GL_OPERAND2_ALPHA");
        GlDebugTextUtils.func_209243_a(34163, "GL13.GL_RGB_SCALE");
        GlDebugTextUtils.func_209243_a(34164, "GL13.GL_ADD_SIGNED");
        GlDebugTextUtils.func_209243_a(34165, "GL13.GL_INTERPOLATE");
        GlDebugTextUtils.func_209243_a(34023, "GL13.GL_SUBTRACT");
        GlDebugTextUtils.func_209243_a(34166, "GL13.GL_CONSTANT");
        GlDebugTextUtils.func_209243_a(34167, "GL13.GL_PRIMARY_COLOR");
        GlDebugTextUtils.func_209243_a(34168, "GL13.GL_PREVIOUS");
        GlDebugTextUtils.func_209243_a(34478, "GL13.GL_DOT3_RGB");
        GlDebugTextUtils.func_209243_a(34479, "GL13.GL_DOT3_RGBA");
        GlDebugTextUtils.func_209243_a(33069, "GL13.GL_CLAMP_TO_BORDER");
        GlDebugTextUtils.func_209243_a(33169, "GL14.GL_GENERATE_MIPMAP");
        GlDebugTextUtils.func_209243_a(33170, "GL14.GL_GENERATE_MIPMAP_HINT");
        GlDebugTextUtils.func_209243_a(33189, "GL14.GL_DEPTH_COMPONENT16");
        GlDebugTextUtils.func_209243_a(33190, "GL14.GL_DEPTH_COMPONENT24");
        GlDebugTextUtils.func_209243_a(33191, "GL14.GL_DEPTH_COMPONENT32");
        GlDebugTextUtils.func_209243_a(34890, "GL14.GL_TEXTURE_DEPTH_SIZE");
        GlDebugTextUtils.func_209243_a(34891, "GL14.GL_DEPTH_TEXTURE_MODE");
        GlDebugTextUtils.func_209243_a(34892, "GL14.GL_TEXTURE_COMPARE_MODE");
        GlDebugTextUtils.func_209243_a(34893, "GL14.GL_TEXTURE_COMPARE_FUNC");
        GlDebugTextUtils.func_209243_a(34894, "GL14.GL_COMPARE_R_TO_TEXTURE");
        GlDebugTextUtils.func_209243_a(33872, "GL14.GL_FOG_COORDINATE_SOURCE");
        GlDebugTextUtils.func_209243_a(33873, "GL14.GL_FOG_COORDINATE");
        GlDebugTextUtils.func_209243_a(33874, "GL14.GL_FRAGMENT_DEPTH");
        GlDebugTextUtils.func_209243_a(33875, "GL14.GL_CURRENT_FOG_COORDINATE");
        GlDebugTextUtils.func_209243_a(33876, "GL14.GL_FOG_COORDINATE_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a(33877, "GL14.GL_FOG_COORDINATE_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a(33878, "GL14.GL_FOG_COORDINATE_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a(33879, "GL14.GL_FOG_COORDINATE_ARRAY");
        GlDebugTextUtils.func_209243_a(33062, "GL14.GL_POINT_SIZE_MIN");
        GlDebugTextUtils.func_209243_a(33063, "GL14.GL_POINT_SIZE_MAX");
        GlDebugTextUtils.func_209243_a(33064, "GL14.GL_POINT_FADE_THRESHOLD_SIZE");
        GlDebugTextUtils.func_209243_a(33065, "GL14.GL_POINT_DISTANCE_ATTENUATION");
        GlDebugTextUtils.func_209243_a(33880, "GL14.GL_COLOR_SUM");
        GlDebugTextUtils.func_209243_a(33881, "GL14.GL_CURRENT_SECONDARY_COLOR");
        GlDebugTextUtils.func_209243_a(33882, "GL14.GL_SECONDARY_COLOR_ARRAY_SIZE");
        GlDebugTextUtils.func_209243_a(33883, "GL14.GL_SECONDARY_COLOR_ARRAY_TYPE");
        GlDebugTextUtils.func_209243_a(33884, "GL14.GL_SECONDARY_COLOR_ARRAY_STRIDE");
        GlDebugTextUtils.func_209243_a(33885, "GL14.GL_SECONDARY_COLOR_ARRAY_POINTER");
        GlDebugTextUtils.func_209243_a(33886, "GL14.GL_SECONDARY_COLOR_ARRAY");
        GlDebugTextUtils.func_209243_a(32968, "GL14.GL_BLEND_DST_RGB");
        GlDebugTextUtils.func_209243_a(32969, "GL14.GL_BLEND_SRC_RGB");
        GlDebugTextUtils.func_209243_a(32970, "GL14.GL_BLEND_DST_ALPHA");
        GlDebugTextUtils.func_209243_a(32971, "GL14.GL_BLEND_SRC_ALPHA");
        GlDebugTextUtils.func_209243_a(34055, "GL14.GL_INCR_WRAP");
        GlDebugTextUtils.func_209243_a(34056, "GL14.GL_DECR_WRAP");
        GlDebugTextUtils.func_209243_a(34048, "GL14.GL_TEXTURE_FILTER_CONTROL");
        GlDebugTextUtils.func_209243_a(34049, "GL14.GL_TEXTURE_LOD_BIAS");
        GlDebugTextUtils.func_209243_a(34045, "GL14.GL_MAX_TEXTURE_LOD_BIAS");
        GlDebugTextUtils.func_209243_a(33648, "GL14.GL_MIRRORED_REPEAT");
        GlDebugTextUtils.func_209243_a(32773, "ARBImaging.GL_BLEND_COLOR");
        GlDebugTextUtils.func_209243_a(32777, "ARBImaging.GL_BLEND_EQUATION");
        GlDebugTextUtils.func_209243_a(32774, "GL14.GL_FUNC_ADD");
        GlDebugTextUtils.func_209243_a(32778, "GL14.GL_FUNC_SUBTRACT");
        GlDebugTextUtils.func_209243_a(32779, "GL14.GL_FUNC_REVERSE_SUBTRACT");
        GlDebugTextUtils.func_209243_a(32775, "GL14.GL_MIN");
        GlDebugTextUtils.func_209243_a(32776, "GL14.GL_MAX");
        GlDebugTextUtils.func_209243_a(34962, "GL15.GL_ARRAY_BUFFER");
        GlDebugTextUtils.func_209243_a(34963, "GL15.GL_ELEMENT_ARRAY_BUFFER");
        GlDebugTextUtils.func_209243_a(34964, "GL15.GL_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34965, "GL15.GL_ELEMENT_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34966, "GL15.GL_VERTEX_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34967, "GL15.GL_NORMAL_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34968, "GL15.GL_COLOR_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34969, "GL15.GL_INDEX_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34970, "GL15.GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34971, "GL15.GL_EDGE_FLAG_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34972, "GL15.GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34973, "GL15.GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34974, "GL15.GL_WEIGHT_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(34975, "GL15.GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING");
        GlDebugTextUtils.func_209243_a(35040, "GL15.GL_STREAM_DRAW");
        GlDebugTextUtils.func_209243_a(35041, "GL15.GL_STREAM_READ");
        GlDebugTextUtils.func_209243_a(35042, "GL15.GL_STREAM_COPY");
        GlDebugTextUtils.func_209243_a(35044, "GL15.GL_STATIC_DRAW");
        GlDebugTextUtils.func_209243_a(35045, "GL15.GL_STATIC_READ");
        GlDebugTextUtils.func_209243_a(35046, "GL15.GL_STATIC_COPY");
        GlDebugTextUtils.func_209243_a(35048, "GL15.GL_DYNAMIC_DRAW");
        GlDebugTextUtils.func_209243_a(35049, "GL15.GL_DYNAMIC_READ");
        GlDebugTextUtils.func_209243_a(35050, "GL15.GL_DYNAMIC_COPY");
        GlDebugTextUtils.func_209243_a(35000, "GL15.GL_READ_ONLY");
        GlDebugTextUtils.func_209243_a(35001, "GL15.GL_WRITE_ONLY");
        GlDebugTextUtils.func_209243_a(35002, "GL15.GL_READ_WRITE");
        GlDebugTextUtils.func_209243_a(34660, "GL15.GL_BUFFER_SIZE");
        GlDebugTextUtils.func_209243_a(34661, "GL15.GL_BUFFER_USAGE");
        GlDebugTextUtils.func_209243_a(35003, "GL15.GL_BUFFER_ACCESS");
        GlDebugTextUtils.func_209243_a(35004, "GL15.GL_BUFFER_MAPPED");
        GlDebugTextUtils.func_209243_a(35005, "GL15.GL_BUFFER_MAP_POINTER");
        GlDebugTextUtils.func_209243_a(34138, "NVFogDistance.GL_FOG_DISTANCE_MODE_NV");
        GlDebugTextUtils.func_209243_a(34139, "NVFogDistance.GL_EYE_RADIAL_NV");
        GlDebugTextUtils.func_209243_a(34140, "NVFogDistance.GL_EYE_PLANE_ABSOLUTE_NV");
        field_209259_j = Maps.newHashMap();
    }
}

