/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Monitor;
import net.minecraft.client.renderer.IWindowEventListener;
import net.minecraft.client.renderer.MonitorHandler;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.renderer.VideoMode;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.util.UndeclaredException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class MainWindow
implements AutoCloseable {
    private static final Logger field_198114_a = LogManager.getLogger();
    private final GLFWErrorCallback field_198115_b = GLFWErrorCallback.create(this::func_198084_a);
    private final IWindowEventListener field_227797_c_;
    private final MonitorHandler field_216531_d;
    private final long field_198119_f;
    private int field_198120_g;
    private int field_198121_h;
    private int field_198122_i;
    private int field_198123_j;
    private Optional<VideoMode> field_198124_k;
    private boolean field_198125_l;
    private boolean field_198126_m;
    private int field_198127_n;
    private int field_198128_o;
    private int field_198129_p;
    private int field_198130_q;
    private int field_198131_r;
    private int field_198132_s;
    private int field_198133_t;
    private int field_198134_u;
    private double field_198135_v;
    private String field_198136_w = "";
    private boolean field_198138_y;
    private int field_216532_z;
    private boolean field_216530_A;

    public MainWindow(IWindowEventListener iWindowEventListener, MonitorHandler monitorHandler, ScreenSize screenSize, @Nullable String string, String string2) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        this.field_216531_d = monitorHandler;
        this.func_227803_u_();
        this.func_227799_a_("Pre startup");
        this.field_227797_c_ = iWindowEventListener;
        Optional<VideoMode> optional = VideoMode.func_198061_a(string);
        this.field_198124_k = optional.isPresent() ? optional : (screenSize.field_216496_c.isPresent() && screenSize.field_216497_d.isPresent() ? Optional.of(new VideoMode(screenSize.field_216496_c.getAsInt(), screenSize.field_216497_d.getAsInt(), 8, 8, 8, 60)) : Optional.empty());
        this.field_198126_m = this.field_198125_l = screenSize.field_216498_e;
        Monitor \u26032 = monitorHandler.func_216512_a(GLFW.glfwGetPrimaryMonitor());
        this.field_198129_p = screenSize.field_216494_a > 0 ? screenSize.field_216494_a : 1;
        this.field_198122_i = this.field_198129_p;
        this.field_198130_q = screenSize.field_216495_b > 0 ? screenSize.field_216495_b : 1;
        this.field_198123_j = this.field_198130_q;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)2);
        GLFW.glfwWindowHint((int)139267, (int)0);
        GLFW.glfwWindowHint((int)139272, (int)0);
        this.field_198119_f = GLFW.glfwCreateWindow((int)this.field_198129_p, (int)this.field_198130_q, (CharSequence)string2, (long)(this.field_198125_l && \u26032 != null ? \u26032.func_197995_f() : 0L), (long)0L);
        if (\u26032 != null) {
            VideoMode videoMode = \u26032.func_197992_a(this.field_198125_l ? this.field_198124_k : Optional.empty());
            this.field_198120_g = this.field_198127_n = \u26032.func_197989_c() + videoMode.func_198064_a() / 2 - this.field_198129_p / 2;
            this.field_198121_h = this.field_198128_o = \u26032.func_197990_d() + videoMode.func_198065_b() / 2 - this.field_198130_q / 2;
        } else {
            int[] nArray = new int[1];
            \u2603 = new int[1];
            GLFW.glfwGetWindowPos((long)this.field_198119_f, (int[])nArray, (int[])\u2603);
            this.field_198120_g = this.field_198127_n = nArray[0];
            this.field_198121_h = this.field_198128_o = \u2603[0];
        }
        GLFW.glfwMakeContextCurrent((long)this.field_198119_f);
        GL.createCapabilities();
        this.func_198108_y();
        this.func_198103_w();
        GLFW.glfwSetFramebufferSizeCallback((long)this.field_198119_f, this::func_198102_b);
        GLFW.glfwSetWindowPosCallback((long)this.field_198119_f, this::func_198080_a);
        GLFW.glfwSetWindowSizeCallback((long)this.field_198119_f, this::func_198089_c);
        GLFW.glfwSetWindowFocusCallback((long)this.field_198119_f, this::func_198095_a);
        GLFW.glfwSetCursorEnterCallback((long)this.field_198119_f, this::func_241553_b_);
    }

    public int func_227798_a_() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GLX._getRefreshRate(this);
    }

    public boolean func_227800_b_() {
        return GLX._shouldClose(this);
    }

    public static void func_211162_a(BiConsumer<Integer, String> biConsumer) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            int \u26032 = GLFW.glfwGetError((PointerBuffer)pointerBuffer);
            if (\u26032 != 0) {
                long l = pointerBuffer.get();
                String \u26033 = l == 0L ? "" : MemoryUtil.memUTF8((long)l);
                biConsumer.accept(\u26032, \u26033);
            }
        }
    }

    public void func_216529_a(InputStream inputStream, InputStream inputStream2) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            if (inputStream == null) {
                throw new FileNotFoundException("icons/icon_16x16.png");
            }
            if (inputStream2 == null) {
                throw new FileNotFoundException("icons/icon_32x32.png");
            }
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            GLFWImage.Buffer \u26032 = GLFWImage.mallocStack((int)2, (MemoryStack)memoryStack);
            ByteBuffer \u26033 = this.func_198111_a(inputStream, intBuffer, \u2603, \u2603);
            if (\u26033 == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            \u26032.position(0);
            \u26032.width(intBuffer.get(0));
            \u26032.height(\u2603.get(0));
            \u26032.pixels(\u26033);
            ByteBuffer \u26034 = this.func_198111_a(inputStream2, intBuffer, \u2603, \u2603);
            if (\u26034 == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            \u26032.position(1);
            \u26032.width(intBuffer.get(0));
            \u26032.height(\u2603.get(0));
            \u26032.pixels(\u26034);
            \u26032.position(0);
            GLFW.glfwSetWindowIcon((long)this.field_198119_f, (GLFWImage.Buffer)\u26032);
            STBImage.stbi_image_free((ByteBuffer)\u26033);
            STBImage.stbi_image_free((ByteBuffer)\u26034);
        }
        catch (IOException iOException) {
            field_198114_a.error("Couldn't set icon", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ByteBuffer func_198111_a(InputStream inputStream, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) throws IOException {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = TextureUtil.func_225684_a_(inputStream);
            byteBuffer.rewind();
            ByteBuffer byteBuffer2 = STBImage.stbi_load_from_memory((ByteBuffer)byteBuffer, (IntBuffer)intBuffer, (IntBuffer)intBuffer2, (IntBuffer)intBuffer3, (int)0);
            return byteBuffer2;
        }
        finally {
            if (byteBuffer != null) {
                MemoryUtil.memFree((Buffer)byteBuffer);
            }
        }
    }

    public void func_227799_a_(String string) {
        this.field_198136_w = string;
    }

    private void func_227803_u_() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFW.glfwSetErrorCallback(MainWindow::func_208034_b);
    }

    private static void func_208034_b(int n, long l) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        String string = "GLFW error " + n + ": " + MemoryUtil.memUTF8((long)l);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)(string + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new GlException(string);
    }

    public void func_198084_a(int n, long l) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        String string = MemoryUtil.memUTF8((long)l);
        field_198114_a.error("########## GL ERROR ##########");
        field_198114_a.error("@ {}", (Object)this.field_198136_w);
        field_198114_a.error("{}: {}", (Object)n, (Object)string);
    }

    public void func_227801_c_() {
        GLFWErrorCallback gLFWErrorCallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.field_198115_b);
        if (gLFWErrorCallback != null) {
            gLFWErrorCallback.free();
        }
    }

    public void func_216523_b(boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_216530_A = bl;
        GLFW.glfwSwapInterval((int)(bl ? 1 : 0));
    }

    @Override
    public void close() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        Callbacks.glfwFreeCallbacks((long)this.field_198119_f);
        this.field_198115_b.close();
        GLFW.glfwDestroyWindow((long)this.field_198119_f);
        GLFW.glfwTerminate();
    }

    private void func_198080_a(long l, int n, int n2) {
        this.field_198127_n = n;
        this.field_198128_o = n2;
    }

    private void func_198102_b(long l, int n, int n2) {
        if (l != this.field_198119_f) {
            return;
        }
        \u2603 = this.func_198109_k();
        \u2603 = this.func_198091_l();
        if (n == 0 || n2 == 0) {
            return;
        }
        this.field_198131_r = n;
        this.field_198132_s = n2;
        if (this.func_198109_k() != \u2603 || this.func_198091_l() != \u2603) {
            this.field_227797_c_.func_213226_a();
        }
    }

    private void func_198103_w() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        int[] nArray = new int[1];
        \u2603 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.field_198119_f, (int[])nArray, (int[])\u2603);
        this.field_198131_r = nArray[0];
        this.field_198132_s = \u2603[0];
    }

    private void func_198089_c(long l, int n, int n2) {
        this.field_198129_p = n;
        this.field_198130_q = n2;
    }

    private void func_198095_a(long l, boolean bl) {
        if (l == this.field_198119_f) {
            this.field_227797_c_.func_213228_a(bl);
        }
    }

    private void func_241553_b_(long l, boolean bl) {
        if (bl) {
            this.field_227797_c_.func_241216_b_();
        }
    }

    public void func_216526_a(int n) {
        this.field_216532_z = n;
    }

    public int func_198082_x() {
        return this.field_216532_z;
    }

    public void func_227802_e_() {
        RenderSystem.flipFrame(this.field_198119_f);
        if (this.field_198125_l != this.field_198126_m) {
            this.field_198126_m = this.field_198125_l;
            this.func_216527_d(this.field_216530_A);
        }
    }

    public Optional<VideoMode> func_198106_d() {
        return this.field_198124_k;
    }

    public void func_224797_a(Optional<VideoMode> optional) {
        boolean bl = !optional.equals(this.field_198124_k);
        this.field_198124_k = optional;
        if (bl) {
            this.field_198138_y = true;
        }
    }

    public void func_198097_f() {
        if (this.field_198125_l && this.field_198138_y) {
            this.field_198138_y = false;
            this.func_198108_y();
            this.field_227797_c_.func_213226_a();
        }
    }

    private void func_198108_y() {
        boolean bl;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        boolean bl2 = bl = GLFW.glfwGetWindowMonitor((long)this.field_198119_f) != 0L;
        if (this.field_198125_l) {
            Monitor monitor = this.field_216531_d.func_216515_a(this);
            if (monitor == null) {
                field_198114_a.warn("Failed to find suitable monitor for fullscreen mode");
                this.field_198125_l = false;
            } else {
                VideoMode videoMode = monitor.func_197992_a(this.field_198124_k);
                if (!bl) {
                    this.field_198120_g = this.field_198127_n;
                    this.field_198121_h = this.field_198128_o;
                    this.field_198122_i = this.field_198129_p;
                    this.field_198123_j = this.field_198130_q;
                }
                this.field_198127_n = 0;
                this.field_198128_o = 0;
                this.field_198129_p = videoMode.func_198064_a();
                this.field_198130_q = videoMode.func_198065_b();
                GLFW.glfwSetWindowMonitor((long)this.field_198119_f, (long)monitor.func_197995_f(), (int)this.field_198127_n, (int)this.field_198128_o, (int)this.field_198129_p, (int)this.field_198130_q, (int)videoMode.func_198067_f());
            }
        } else {
            this.field_198127_n = this.field_198120_g;
            this.field_198128_o = this.field_198121_h;
            this.field_198129_p = this.field_198122_i;
            this.field_198130_q = this.field_198123_j;
            GLFW.glfwSetWindowMonitor((long)this.field_198119_f, (long)0L, (int)this.field_198127_n, (int)this.field_198128_o, (int)this.field_198129_p, (int)this.field_198130_q, (int)-1);
        }
    }

    public void func_198077_g() {
        this.field_198125_l = !this.field_198125_l;
    }

    private void func_216527_d(boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        try {
            this.func_198108_y();
            this.field_227797_c_.func_213226_a();
            this.func_216523_b(bl);
            this.func_227802_e_();
        }
        catch (Exception exception) {
            field_198114_a.error("Couldn't toggle fullscreen", (Throwable)exception);
        }
    }

    public int func_216521_a(int n, boolean bl2) {
        boolean bl2;
        for (int i = 1; i != n && i < this.field_198131_r && i < this.field_198132_s && this.field_198131_r / (i + 1) >= 320 && this.field_198132_s / (i + 1) >= 240; ++i) {
        }
        if (bl2 && i % 2 != 0) {
            ++i;
        }
        return i;
    }

    public void func_216525_a(double d) {
        this.field_198135_v = d;
        int n = (int)((double)this.field_198131_r / d);
        this.field_198133_t = (double)this.field_198131_r / d > (double)n ? n + 1 : n;
        \u2603 = (int)((double)this.field_198132_s / d);
        this.field_198134_u = (double)this.field_198132_s / d > (double)\u2603 ? \u2603 + 1 : \u2603;
    }

    public void func_230148_b_(String string) {
        GLFW.glfwSetWindowTitle((long)this.field_198119_f, (CharSequence)string);
    }

    public long func_198092_i() {
        return this.field_198119_f;
    }

    public boolean func_198113_j() {
        return this.field_198125_l;
    }

    public int func_198109_k() {
        return this.field_198131_r;
    }

    public int func_198091_l() {
        return this.field_198132_s;
    }

    public int func_198105_m() {
        return this.field_198129_p;
    }

    public int func_198083_n() {
        return this.field_198130_q;
    }

    public int func_198107_o() {
        return this.field_198133_t;
    }

    public int func_198087_p() {
        return this.field_198134_u;
    }

    public int func_198099_q() {
        return this.field_198127_n;
    }

    public int func_198079_r() {
        return this.field_198128_o;
    }

    public double func_198100_s() {
        return this.field_198135_v;
    }

    @Nullable
    public Monitor func_224796_s() {
        return this.field_216531_d.func_216515_a(this);
    }

    public void func_224798_d(boolean bl) {
        InputMappings.func_224791_a(this.field_198119_f, bl);
    }

    public static class GlException
    extends UndeclaredException {
        private GlException(String string) {
            super(string);
        }
    }
}

