/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractBlock {
    protected static final Direction[] field_212556_a = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP};
    protected final Material field_149764_J;
    protected final boolean field_235688_at_;
    protected final float field_235689_au_;
    protected final boolean field_149789_z;
    protected final SoundType field_149762_H;
    protected final float field_149765_K;
    protected final float field_226886_f_;
    protected final float field_226887_g_;
    protected final boolean field_208621_p;
    protected final Properties field_235684_aB_;
    @Nullable
    protected ResourceLocation field_220085_g;

    public AbstractBlock(Properties properties) {
        this.field_149764_J = properties.field_200953_a;
        this.field_235688_at_ = properties.field_200955_c;
        this.field_220085_g = properties.field_222381_j;
        this.field_235689_au_ = properties.field_200958_f;
        this.field_149789_z = properties.field_200960_h;
        this.field_149762_H = properties.field_200956_d;
        this.field_149765_K = properties.field_200961_i;
        this.field_226886_f_ = properties.field_226893_j_;
        this.field_226887_g_ = properties.field_226894_k_;
        this.field_208621_p = properties.field_208772_j;
        this.field_235684_aB_ = properties;
    }

    @Deprecated
    public void func_196248_b(BlockState blockState, IWorld iWorld, BlockPos blockPos, int n, int n2) {
    }

    @Deprecated
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        switch (pathType) {
            case LAND: {
                return !blockState.func_235785_r_(iBlockReader, blockPos);
            }
            case WATER: {
                return iBlockReader.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return !blockState.func_235785_r_(iBlockReader, blockPos);
            }
        }
        return false;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        return blockState;
    }

    @Deprecated
    public boolean func_200122_a(BlockState blockState, BlockState blockState2, Direction direction) {
        return false;
    }

    @Deprecated
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        DebugPacketSender.func_218806_a(world, blockPos);
    }

    @Deprecated
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
    }

    @Deprecated
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (this.func_235695_q_() && !blockState.func_203425_a(blockState2.func_177230_c())) {
            world.func_175713_t(blockPos);
        }
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        return ActionResultType.PASS;
    }

    @Deprecated
    public boolean func_189539_a(BlockState blockState, World world, BlockPos blockPos, int n, int n2) {
        return false;
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_220074_n(BlockState blockState) {
        return false;
    }

    @Deprecated
    public boolean func_149744_f(BlockState blockState) {
        return false;
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState blockState) {
        return this.field_149764_J.func_186274_m();
    }

    @Deprecated
    public FluidState func_204507_t(BlockState blockState) {
        return Fluids.field_204541_a.func_207188_f();
    }

    @Deprecated
    public boolean func_149740_M(BlockState blockState) {
        return false;
    }

    public OffsetType func_176218_Q() {
        return OffsetType.NONE;
    }

    @Deprecated
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return blockState;
    }

    @Deprecated
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState;
    }

    @Deprecated
    public boolean func_196253_a(BlockState blockState, BlockItemUseContext blockItemUseContext) {
        return this.field_149764_J.func_76222_j() && (blockItemUseContext.func_195996_i().func_190926_b() || blockItemUseContext.func_195996_i().func_77973_b() != this.func_199767_j());
    }

    @Deprecated
    public boolean func_225541_a_(BlockState blockState, Fluid fluid) {
        return this.field_149764_J.func_76222_j() || !this.field_149764_J.func_76220_a();
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder builder) {
        ResourceLocation resourceLocation = this.func_220068_i();
        if (resourceLocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext \u26032 = builder.func_216015_a(LootParameters.field_216287_g, blockState).func_216022_a(LootParameterSets.field_216267_h);
        ServerWorld \u26033 = \u26032.func_202879_g();
        LootTable \u26034 = \u26033.func_73046_m().func_200249_aQ().func_186521_a(resourceLocation);
        return \u26034.func_216113_a(\u26032);
    }

    @Deprecated
    public long func_209900_a(BlockState blockState, BlockPos blockPos) {
        return MathHelper.func_180186_a(blockPos);
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return blockState.func_196954_c(iBlockReader, blockPos);
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.func_220071_b(blockState, iBlockReader, blockPos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return VoxelShapes.func_197880_a();
    }

    @Deprecated
    public int func_200011_d(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (blockState.func_200015_d(iBlockReader, blockPos)) {
            return iBlockReader.func_201572_C();
        }
        return blockState.func_200131_a(iBlockReader, blockPos) ? 0 : 1;
    }

    @Nullable
    @Deprecated
    public INamedContainerProvider func_220052_b(BlockState blockState, World world, BlockPos blockPos) {
        return null;
    }

    @Deprecated
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        return true;
    }

    @Deprecated
    public float func_220080_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return blockState.func_235785_r_(iBlockReader, blockPos) ? 0.2f : 1.0f;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return 0;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.field_235688_at_ ? blockState.func_196954_c(iBlockReader, blockPos) : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.func_220071_b(blockState, iBlockReader, blockPos, iSelectionContext);
    }

    @Deprecated
    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        this.func_225534_a_(blockState, serverWorld, blockPos, random);
    }

    @Deprecated
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
    }

    @Deprecated
    public float func_180647_a(BlockState blockState, PlayerEntity playerEntity, IBlockReader iBlockReader, BlockPos blockPos) {
        float f = blockState.func_185887_b(iBlockReader, blockPos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int \u26032 = playerEntity.func_234569_d_(blockState) ? 30 : 100;
        return playerEntity.func_184813_a(blockState) / f / (float)\u26032;
    }

    @Deprecated
    public void func_220062_a(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, ItemStack itemStack) {
    }

    @Deprecated
    public void func_196270_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity) {
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return 0;
    }

    @Deprecated
    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return 0;
    }

    public final boolean func_235695_q_() {
        return this instanceof ITileEntityProvider;
    }

    public final ResourceLocation func_220068_i() {
        if (this.field_220085_g == null) {
            ResourceLocation resourceLocation = Registry.field_212618_g.func_177774_c(this.func_230328_p_());
            this.field_220085_g = new ResourceLocation(resourceLocation.func_110624_b(), "blocks/" + resourceLocation.func_110623_a());
        }
        return this.field_220085_g;
    }

    @Deprecated
    public void func_220066_a(World world, BlockState blockState, BlockRayTraceResult blockRayTraceResult, ProjectileEntity projectileEntity) {
    }

    public abstract Item func_199767_j();

    protected abstract Block func_230328_p_();

    public MaterialColor func_235697_s_() {
        return (MaterialColor)this.field_235684_aB_.field_235800_b_.apply(this.func_230328_p_().func_176223_P());
    }

    public static interface IExtendedPositionPredicate<A> {
        public boolean test(BlockState var1, IBlockReader var2, BlockPos var3, A var4);
    }

    public static interface IPositionPredicate {
        public boolean test(BlockState var1, IBlockReader var2, BlockPos var3);
    }

    public static abstract class AbstractBlockState
    extends StateHolder<Block, BlockState> {
        private final int field_215708_d;
        private final boolean field_215709_e;
        private final boolean field_235702_f_;
        private final Material field_235703_g_;
        private final MaterialColor field_235704_h_;
        private final float field_235705_i_;
        private final boolean field_235706_j_;
        private final boolean field_235707_k_;
        private final IPositionPredicate field_235708_l_;
        private final IPositionPredicate field_235709_m_;
        private final IPositionPredicate field_235710_n_;
        private final IPositionPredicate field_235711_o_;
        private final IPositionPredicate field_235712_p_;
        @Nullable
        protected Cache field_215707_c;

        protected AbstractBlockState(Block block, ImmutableMap<Property<?>, Comparable<?>> immutableMap, MapCodec<BlockState> mapCodec) {
            super(block, immutableMap, mapCodec);
            Properties properties = block.field_235684_aB_;
            this.field_215708_d = properties.field_235803_e_.applyAsInt(this.func_230340_p_());
            this.field_215709_e = block.func_220074_n(this.func_230340_p_());
            this.field_235702_f_ = properties.field_235813_o_;
            this.field_235703_g_ = properties.field_200953_a;
            this.field_235704_h_ = (MaterialColor)properties.field_235800_b_.apply(this.func_230340_p_());
            this.field_235705_i_ = properties.field_200959_g;
            this.field_235706_j_ = properties.field_235806_h_;
            this.field_235707_k_ = properties.field_226895_m_;
            this.field_235708_l_ = properties.field_235815_q_;
            this.field_235709_m_ = properties.field_235816_r_;
            this.field_235710_n_ = properties.field_235817_s_;
            this.field_235711_o_ = properties.field_235818_t_;
            this.field_235712_p_ = properties.field_235819_u_;
        }

        public void func_215692_c() {
            if (!this.func_177230_c().func_208619_r()) {
                this.field_215707_c = new Cache(this.func_230340_p_());
            }
        }

        public Block func_177230_c() {
            return (Block)this.field_235892_c_;
        }

        public Material func_185904_a() {
            return this.field_235703_g_;
        }

        public boolean func_215688_a(IBlockReader iBlockReader, BlockPos blockPos, EntityType<?> entityType) {
            return this.func_177230_c().field_235684_aB_.field_235814_p_.test(this.func_230340_p_(), iBlockReader, blockPos, entityType);
        }

        public boolean func_200131_a(IBlockReader iBlockReader, BlockPos blockPos) {
            if (this.field_215707_c != null) {
                return this.field_215707_c.field_222500_d;
            }
            return this.func_177230_c().func_200123_i(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public int func_200016_a(IBlockReader iBlockReader, BlockPos blockPos) {
            if (this.field_215707_c != null) {
                return this.field_215707_c.field_222501_e;
            }
            return this.func_177230_c().func_200011_d(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public VoxelShape func_215702_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
            if (this.field_215707_c != null && this.field_215707_c.field_222502_f != null) {
                return this.field_215707_c.field_222502_f[direction.ordinal()];
            }
            return VoxelShapes.func_216387_a(this.func_235754_c_(iBlockReader, blockPos), direction);
        }

        public VoxelShape func_235754_c_(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.func_177230_c().func_196247_c(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public boolean func_215704_f() {
            return this.field_215707_c == null || this.field_215707_c.field_222503_g;
        }

        public boolean func_215691_g() {
            return this.field_215709_e;
        }

        public int func_185906_d() {
            return this.field_215708_d;
        }

        public boolean func_196958_f() {
            return this.field_235702_f_;
        }

        public MaterialColor func_185909_g(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.field_235704_h_;
        }

        public BlockState func_185907_a(Rotation rotation) {
            return this.func_177230_c().func_185499_a(this.func_230340_p_(), rotation);
        }

        public BlockState func_185902_a(Mirror mirror) {
            return this.func_177230_c().func_185471_a(this.func_230340_p_(), mirror);
        }

        public BlockRenderType func_185901_i() {
            return this.func_177230_c().func_149645_b(this.func_230340_p_());
        }

        public boolean func_227035_k_(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.field_235712_p_.test(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public float func_215703_d(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.func_177230_c().func_220080_a(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public boolean func_215686_e(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.field_235708_l_.test(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public boolean func_185897_m() {
            return this.func_177230_c().func_149744_f(this.func_230340_p_());
        }

        public int func_185911_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
            return this.func_177230_c().func_180656_a(this.func_230340_p_(), iBlockReader, blockPos, direction);
        }

        public boolean func_185912_n() {
            return this.func_177230_c().func_149740_M(this.func_230340_p_());
        }

        public int func_185888_a(World world, BlockPos blockPos) {
            return this.func_177230_c().func_180641_l(this.func_230340_p_(), world, blockPos);
        }

        public float func_185887_b(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.field_235705_i_;
        }

        public float func_185903_a(PlayerEntity playerEntity, IBlockReader iBlockReader, BlockPos blockPos) {
            return this.func_177230_c().func_180647_a(this.func_230340_p_(), playerEntity, iBlockReader, blockPos);
        }

        public int func_185893_b(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
            return this.func_177230_c().func_176211_b(this.func_230340_p_(), iBlockReader, blockPos, direction);
        }

        public PushReaction func_185905_o() {
            return this.func_177230_c().func_149656_h(this.func_230340_p_());
        }

        public boolean func_200015_d(IBlockReader iBlockReader, BlockPos blockPos) {
            if (this.field_215707_c != null) {
                return this.field_215707_c.field_222499_c;
            }
            BlockState blockState = this.func_230340_p_();
            if (blockState.func_200132_m()) {
                return Block.func_208062_a(blockState.func_235754_c_(iBlockReader, blockPos));
            }
            return false;
        }

        public boolean func_200132_m() {
            return this.field_235707_k_;
        }

        public boolean func_200017_a(BlockState blockState, Direction direction) {
            return this.func_177230_c().func_200122_a(this.func_230340_p_(), blockState, direction);
        }

        public VoxelShape func_196954_c(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.func_215700_a(iBlockReader, blockPos, ISelectionContext.func_216377_a());
        }

        public VoxelShape func_215700_a(IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
            return this.func_177230_c().func_220053_a(this.func_230340_p_(), iBlockReader, blockPos, iSelectionContext);
        }

        public VoxelShape func_196952_d(IBlockReader iBlockReader, BlockPos blockPos) {
            if (this.field_215707_c != null) {
                return this.field_215707_c.field_230026_g;
            }
            return this.func_215685_b(iBlockReader, blockPos, ISelectionContext.func_216377_a());
        }

        public VoxelShape func_215685_b(IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
            return this.func_177230_c().func_220071_b(this.func_230340_p_(), iBlockReader, blockPos, iSelectionContext);
        }

        public VoxelShape func_196951_e(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.func_177230_c().func_230335_e_(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public VoxelShape func_199611_f(IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
            return this.func_177230_c().func_230322_a_(this.func_230340_p_(), iBlockReader, blockPos, iSelectionContext);
        }

        public VoxelShape func_235777_m_(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.func_177230_c().func_199600_g(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public final boolean func_235719_a_(IBlockReader iBlockReader, BlockPos blockPos, Entity entity) {
            return this.func_215682_a(iBlockReader, blockPos, entity, Direction.UP);
        }

        public final boolean func_215682_a(IBlockReader iBlockReader, BlockPos blockPos, Entity entity, Direction direction) {
            return Block.func_208061_a(this.func_215685_b(iBlockReader, blockPos, ISelectionContext.func_216374_a(entity)), direction);
        }

        public Vector3d func_191059_e(IBlockReader iBlockReader, BlockPos blockPos) {
            OffsetType offsetType = this.func_177230_c().func_176218_Q();
            if (offsetType == OffsetType.NONE) {
                return Vector3d.field_186680_a;
            }
            long \u26032 = MathHelper.func_180187_c(blockPos.func_177958_n(), 0, blockPos.func_177952_p());
            return new Vector3d(((double)((float)(\u26032 & 0xFL) / 15.0f) - 0.5) * 0.5, offsetType == OffsetType.XYZ ? ((double)((float)(\u26032 >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(\u26032 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5);
        }

        public boolean func_235728_a_(World world, BlockPos blockPos, int n, int n2) {
            return this.func_177230_c().func_189539_a(this.func_230340_p_(), world, blockPos, n, n2);
        }

        public void func_215697_a(World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
            this.func_177230_c().func_220069_a(this.func_230340_p_(), world, blockPos, block, blockPos2, bl);
        }

        public final void func_235734_a_(IWorld iWorld, BlockPos blockPos, int n) {
            this.func_241482_a_(iWorld, blockPos, n, 512);
        }

        public final void func_241482_a_(IWorld iWorld, BlockPos blockPos, int n, int n2) {
            this.func_177230_c();
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (Direction direction : field_212556_a) {
                mutable.func_239622_a_(blockPos, direction);
                BlockState blockState = iWorld.func_180495_p(mutable);
                \u2603 = blockState.func_196956_a(direction.func_176734_d(), this.func_230340_p_(), iWorld, mutable, blockPos);
                Block.func_241468_a_(blockState, \u2603, iWorld, mutable, n, n2);
            }
        }

        public final void func_196948_b(IWorld iWorld, BlockPos blockPos, int n) {
            this.func_241483_b_(iWorld, blockPos, n, 512);
        }

        public void func_241483_b_(IWorld iWorld, BlockPos blockPos, int n, int n2) {
            this.func_177230_c().func_196248_b(this.func_230340_p_(), iWorld, blockPos, n, n2);
        }

        public void func_215705_a(World world, BlockPos blockPos, BlockState blockState, boolean bl) {
            this.func_177230_c().func_220082_b(this.func_230340_p_(), world, blockPos, blockState, bl);
        }

        public void func_196947_b(World world, BlockPos blockPos, BlockState blockState, boolean bl) {
            this.func_177230_c().func_196243_a(this.func_230340_p_(), world, blockPos, blockState, bl);
        }

        public void func_227033_a_(ServerWorld serverWorld, BlockPos blockPos, Random random) {
            this.func_177230_c().func_225534_a_(this.func_230340_p_(), serverWorld, blockPos, random);
        }

        public void func_227034_b_(ServerWorld serverWorld, BlockPos blockPos, Random random) {
            this.func_177230_c().func_225542_b_(this.func_230340_p_(), serverWorld, blockPos, random);
        }

        public void func_196950_a(World world, BlockPos blockPos, Entity entity) {
            this.func_177230_c().func_196262_a(this.func_230340_p_(), world, blockPos, entity);
        }

        public void func_215706_a(ServerWorld serverWorld, BlockPos blockPos, ItemStack itemStack) {
            this.func_177230_c().func_220062_a(this.func_230340_p_(), serverWorld, blockPos, itemStack);
        }

        public List<ItemStack> func_215693_a(LootContext.Builder builder) {
            return this.func_177230_c().func_220076_a(this.func_230340_p_(), builder);
        }

        public ActionResultType func_227031_a_(World world, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
            return this.func_177230_c().func_225533_a_(this.func_230340_p_(), world, blockRayTraceResult.func_216350_a(), playerEntity, hand, blockRayTraceResult);
        }

        public void func_196942_a(World world, BlockPos blockPos, PlayerEntity playerEntity) {
            this.func_177230_c().func_196270_a(this.func_230340_p_(), world, blockPos, playerEntity);
        }

        public boolean func_229980_m_(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.field_235709_m_.test(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public boolean func_215696_m(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.field_235710_n_.test(this.func_230340_p_(), iBlockReader, blockPos);
        }

        public BlockState func_196956_a(Direction direction, BlockState blockState, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
            return this.func_177230_c().func_196271_a(this.func_230340_p_(), direction, blockState, iWorld, blockPos, blockPos2);
        }

        public boolean func_196957_g(IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
            return this.func_177230_c().func_196266_a(this.func_230340_p_(), iBlockReader, blockPos, pathType);
        }

        public boolean func_196953_a(BlockItemUseContext blockItemUseContext) {
            return this.func_177230_c().func_196253_a(this.func_230340_p_(), blockItemUseContext);
        }

        public boolean func_227032_a_(Fluid fluid) {
            return this.func_177230_c().func_225541_a_(this.func_230340_p_(), fluid);
        }

        public boolean func_196955_c(IWorldReader iWorldReader, BlockPos blockPos) {
            return this.func_177230_c().func_196260_a(this.func_230340_p_(), iWorldReader, blockPos);
        }

        public boolean func_202065_c(IBlockReader iBlockReader, BlockPos blockPos) {
            return this.field_235711_o_.test(this.func_230340_p_(), iBlockReader, blockPos);
        }

        @Nullable
        public INamedContainerProvider func_215699_b(World world, BlockPos blockPos) {
            return this.func_177230_c().func_220052_b(this.func_230340_p_(), world, blockPos);
        }

        public boolean func_235714_a_(ITag<Block> iTag) {
            return this.func_177230_c().func_203417_a(iTag);
        }

        public boolean func_235715_a_(ITag<Block> iTag, Predicate<AbstractBlockState> predicate) {
            return this.func_177230_c().func_203417_a(iTag) && predicate.test(this);
        }

        public boolean func_203425_a(Block block) {
            return this.func_177230_c().func_235332_a_(block);
        }

        public FluidState func_204520_s() {
            return this.func_177230_c().func_204507_t(this.func_230340_p_());
        }

        public boolean func_204519_t() {
            return this.func_177230_c().func_149653_t(this.func_230340_p_());
        }

        public long func_209533_a(BlockPos blockPos) {
            return this.func_177230_c().func_209900_a(this.func_230340_p_(), blockPos);
        }

        public SoundType func_215695_r() {
            return this.func_177230_c().func_220072_p(this.func_230340_p_());
        }

        public void func_215690_a(World world, BlockState blockState, BlockRayTraceResult blockRayTraceResult, ProjectileEntity projectileEntity) {
            this.func_177230_c().func_220066_a(world, blockState, blockRayTraceResult, projectileEntity);
        }

        public boolean func_224755_d(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
            return this.func_242698_a(iBlockReader, blockPos, direction, BlockVoxelShape.FULL);
        }

        public boolean func_242698_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction, BlockVoxelShape blockVoxelShape) {
            if (this.field_215707_c != null) {
                return this.field_215707_c.func_242700_a(direction, blockVoxelShape);
            }
            return blockVoxelShape.func_241854_a(this.func_230340_p_(), iBlockReader, blockPos, direction);
        }

        public boolean func_235785_r_(IBlockReader iBlockReader, BlockPos blockPos) {
            if (this.field_215707_c != null) {
                return this.field_215707_c.field_225494_j;
            }
            return Block.func_208062_a(this.func_196952_d(iBlockReader, blockPos));
        }

        protected abstract BlockState func_230340_p_();

        public boolean func_235783_q_() {
            return this.field_235706_j_;
        }

        static final class Cache {
            private static final Direction[] field_222497_a = Direction.values();
            private static final int field_242699_f = BlockVoxelShape.values().length;
            protected final boolean field_222499_c;
            private final boolean field_222500_d;
            private final int field_222501_e;
            @Nullable
            private final VoxelShape[] field_222502_f;
            protected final VoxelShape field_230026_g;
            protected final boolean field_222503_g;
            private final boolean[] field_225493_i;
            protected final boolean field_225494_j;

            private Cache(BlockState blockState2) {
                BlockState blockState2;
                Block block = blockState2.func_177230_c();
                this.field_222499_c = blockState2.func_200015_d(EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                this.field_222500_d = block.func_200123_i(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                this.field_222501_e = block.func_200011_d(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                if (!blockState2.func_200132_m()) {
                    this.field_222502_f = null;
                } else {
                    this.field_222502_f = new VoxelShape[field_222497_a.length];
                    VoxelShape voxelShape = block.func_196247_c(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                    Direction[] directionArray = field_222497_a;
                    int n = directionArray.length;
                    for (int i = 0; i < n; ++i) {
                        Direction direction = directionArray[i];
                        this.field_222502_f[direction.ordinal()] = VoxelShapes.func_216387_a(voxelShape, direction);
                    }
                }
                this.field_230026_g = block.func_220071_b(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, ISelectionContext.func_216377_a());
                this.field_222503_g = Arrays.stream(Direction.Axis.values()).anyMatch(axis -> this.field_230026_g.func_197762_b((Direction.Axis)axis) < 0.0 || this.field_230026_g.func_197758_c((Direction.Axis)axis) > 1.0);
                this.field_225493_i = new boolean[field_222497_a.length * field_242699_f];
                for (Direction direction : field_222497_a) {
                    for (BlockVoxelShape blockVoxelShape : BlockVoxelShape.values()) {
                        this.field_225493_i[Cache.func_242701_b((Direction)direction, (BlockVoxelShape)blockVoxelShape)] = blockVoxelShape.func_241854_a(blockState2, EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, direction);
                    }
                }
                this.field_225494_j = Block.func_208062_a(blockState2.func_196952_d(EmptyBlockReader.INSTANCE, BlockPos.field_177992_a));
            }

            public boolean func_242700_a(Direction direction, BlockVoxelShape blockVoxelShape) {
                return this.field_225493_i[Cache.func_242701_b(direction, blockVoxelShape)];
            }

            private static int func_242701_b(Direction direction, BlockVoxelShape blockVoxelShape) {
                return direction.ordinal() * field_242699_f + blockVoxelShape.ordinal();
            }
        }
    }

    public static class Properties {
        private Material field_200953_a;
        private Function<BlockState, MaterialColor> field_235800_b_;
        private boolean field_200955_c = true;
        private SoundType field_200956_d = SoundType.field_185851_d;
        private ToIntFunction<BlockState> field_235803_e_ = blockState -> 0;
        private float field_200958_f;
        private float field_200959_g;
        private boolean field_235806_h_;
        private boolean field_200960_h;
        private float field_200961_i = 0.6f;
        private float field_226893_j_ = 1.0f;
        private float field_226894_k_ = 1.0f;
        private ResourceLocation field_222381_j;
        private boolean field_226895_m_ = true;
        private boolean field_235813_o_;
        private IExtendedPositionPredicate<EntityType<?>> field_235814_p_ = (blockState, iBlockReader, blockPos, entityType) -> blockState.func_224755_d(iBlockReader, blockPos, Direction.UP) && blockState.func_185906_d() < 14;
        private IPositionPredicate field_235815_q_ = (blockState, iBlockReader, blockPos) -> blockState.func_185904_a().func_76218_k() && blockState.func_235785_r_(iBlockReader, blockPos);
        private IPositionPredicate field_235816_r_;
        private IPositionPredicate field_235817_s_ = this.field_235816_r_ = (blockState, iBlockReader, blockPos) -> this.field_200953_a.func_76230_c() && blockState.func_235785_r_(iBlockReader, blockPos);
        private IPositionPredicate field_235818_t_ = (blockState, iBlockReader, blockPos) -> false;
        private IPositionPredicate field_235819_u_ = (blockState, iBlockReader, blockPos) -> false;
        private boolean field_208772_j;

        private Properties(Material material, MaterialColor materialColor) {
            this(material, (BlockState blockState) -> materialColor);
        }

        private Properties(Material material, Function<BlockState, MaterialColor> function) {
            this.field_200953_a = material;
            this.field_235800_b_ = function;
        }

        public static Properties func_200945_a(Material material) {
            return Properties.func_200949_a(material, material.func_151565_r());
        }

        public static Properties func_200952_a(Material material, DyeColor dyeColor) {
            return Properties.func_200949_a(material, dyeColor.func_196055_e());
        }

        public static Properties func_200949_a(Material material, MaterialColor materialColor) {
            return new Properties(material, materialColor);
        }

        public static Properties func_235836_a_(Material material, Function<BlockState, MaterialColor> function) {
            return new Properties(material, function);
        }

        public static Properties func_200950_a(AbstractBlock abstractBlock) {
            Properties properties = new Properties(abstractBlock.field_149764_J, abstractBlock.field_235684_aB_.field_235800_b_);
            properties.field_200953_a = abstractBlock.field_235684_aB_.field_200953_a;
            properties.field_200959_g = abstractBlock.field_235684_aB_.field_200959_g;
            properties.field_200958_f = abstractBlock.field_235684_aB_.field_200958_f;
            properties.field_200955_c = abstractBlock.field_235684_aB_.field_200955_c;
            properties.field_200960_h = abstractBlock.field_235684_aB_.field_200960_h;
            properties.field_235803_e_ = abstractBlock.field_235684_aB_.field_235803_e_;
            properties.field_235800_b_ = abstractBlock.field_235684_aB_.field_235800_b_;
            properties.field_200956_d = abstractBlock.field_235684_aB_.field_200956_d;
            properties.field_200961_i = abstractBlock.field_235684_aB_.field_200961_i;
            properties.field_226893_j_ = abstractBlock.field_235684_aB_.field_226893_j_;
            properties.field_208772_j = abstractBlock.field_235684_aB_.field_208772_j;
            properties.field_226895_m_ = abstractBlock.field_235684_aB_.field_226895_m_;
            properties.field_235813_o_ = abstractBlock.field_235684_aB_.field_235813_o_;
            properties.field_235806_h_ = abstractBlock.field_235684_aB_.field_235806_h_;
            return properties;
        }

        public Properties func_200942_a() {
            this.field_200955_c = false;
            this.field_226895_m_ = false;
            return this;
        }

        public Properties func_226896_b_() {
            this.field_226895_m_ = false;
            return this;
        }

        public Properties func_200941_a(float f) {
            this.field_200961_i = f;
            return this;
        }

        public Properties func_226897_b_(float f) {
            this.field_226893_j_ = f;
            return this;
        }

        public Properties func_226898_c_(float f) {
            this.field_226894_k_ = f;
            return this;
        }

        public Properties func_200947_a(SoundType soundType) {
            this.field_200956_d = soundType;
            return this;
        }

        public Properties func_235838_a_(ToIntFunction<BlockState> toIntFunction) {
            this.field_235803_e_ = toIntFunction;
            return this;
        }

        public Properties func_200948_a(float f, float f2) {
            this.field_200959_g = f;
            this.field_200958_f = Math.max(0.0f, f2);
            return this;
        }

        public Properties func_200946_b() {
            return this.func_200943_b(0.0f);
        }

        public Properties func_200943_b(float f) {
            this.func_200948_a(f, f);
            return this;
        }

        public Properties func_200944_c() {
            this.field_200960_h = true;
            return this;
        }

        public Properties func_208770_d() {
            this.field_208772_j = true;
            return this;
        }

        public Properties func_222380_e() {
            this.field_222381_j = LootTables.field_186419_a;
            return this;
        }

        public Properties func_222379_b(Block block) {
            this.field_222381_j = block.func_220068_i();
            return this;
        }

        public Properties func_235859_g_() {
            this.field_235813_o_ = true;
            return this;
        }

        public Properties func_235827_a_(IExtendedPositionPredicate<EntityType<?>> iExtendedPositionPredicate) {
            this.field_235814_p_ = iExtendedPositionPredicate;
            return this;
        }

        public Properties func_235828_a_(IPositionPredicate iPositionPredicate) {
            this.field_235815_q_ = iPositionPredicate;
            return this;
        }

        public Properties func_235842_b_(IPositionPredicate iPositionPredicate) {
            this.field_235816_r_ = iPositionPredicate;
            return this;
        }

        public Properties func_235847_c_(IPositionPredicate iPositionPredicate) {
            this.field_235817_s_ = iPositionPredicate;
            return this;
        }

        public Properties func_235852_d_(IPositionPredicate iPositionPredicate) {
            this.field_235818_t_ = iPositionPredicate;
            return this;
        }

        public Properties func_235856_e_(IPositionPredicate iPositionPredicate) {
            this.field_235819_u_ = iPositionPredicate;
            return this;
        }

        public Properties func_235861_h_() {
            this.field_235806_h_ = true;
            return this;
        }
    }

    public static enum OffsetType {
        NONE,
        XZ,
        XYZ;

    }
}

