/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.client.FileDownload;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.UploadSpeed;
import net.minecraft.realms.RealmsNarratorHelper;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsDownloadLatestWorldScreen
extends RealmsScreen {
    private static final Logger field_224175_a = LogManager.getLogger();
    private static final ReentrantLock field_237832_b_ = new ReentrantLock();
    private final Screen field_224176_b;
    private final WorldDownload field_224177_c;
    private final ITextComponent field_224178_d;
    private final RateLimiter field_224179_e;
    private Button field_224180_f;
    private final String field_224181_g;
    private final DownloadStatus field_224182_h;
    private volatile ITextComponent field_224183_i;
    private volatile ITextComponent field_224184_j = new TranslationTextComponent("mco.download.preparing");
    private volatile String field_224185_k;
    private volatile boolean field_224186_l;
    private volatile boolean field_224187_m = true;
    private volatile boolean field_224188_n;
    private volatile boolean field_224189_o;
    private Long field_224190_p;
    private Long field_224191_q;
    private long field_224192_r;
    private int field_224193_s;
    private static final String[] field_224194_t = new String[]{"", ".", ". .", ". . ."};
    private int field_224195_u;
    private boolean field_224198_x;
    private final BooleanConsumer field_237831_J_;

    public RealmsDownloadLatestWorldScreen(Screen screen, WorldDownload worldDownload, String string, BooleanConsumer booleanConsumer) {
        this.field_237831_J_ = booleanConsumer;
        this.field_224176_b = screen;
        this.field_224181_g = string;
        this.field_224177_c = worldDownload;
        this.field_224182_h = new DownloadStatus();
        this.field_224178_d = new TranslationTextComponent("mco.download.title");
        this.field_224179_e = RateLimiter.create((double)0.1f);
    }

    @Override
    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_224180_f = this.func_230480_a_(new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 42, 200, 20, DialogTexts.field_240633_d_, button -> {
            this.field_224186_l = true;
            this.func_224174_d();
        }));
        this.func_224162_c();
    }

    private void func_224162_c() {
        if (this.field_224188_n) {
            return;
        }
        if (!this.field_224198_x && this.func_224152_a(this.field_224177_c.field_230643_a_) >= 0x140000000L) {
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("mco.download.confirmation.line1", UploadSpeed.func_237684_b_(0x140000000L));
            \u2603 = new TranslationTextComponent("mco.download.confirmation.line2");
            this.field_230706_i_.func_147108_a(new RealmsLongConfirmationScreen(bl -> {
                this.field_224198_x = true;
                this.field_230706_i_.func_147108_a(this);
                this.func_224165_h();
            }, RealmsLongConfirmationScreen.Type.Warning, translationTextComponent, \u2603, false));
        } else {
            this.func_224165_h();
        }
    }

    private long func_224152_a(String string) {
        FileDownload fileDownload = new FileDownload();
        return fileDownload.func_224827_a(string);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.field_224193_s;
        if (this.field_224184_j != null && this.field_224179_e.tryAcquire(1)) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.field_224178_d);
            arrayList.add(this.field_224184_j);
            if (this.field_224185_k != null) {
                arrayList.add(new StringTextComponent(this.field_224185_k + "%"));
                arrayList.add(new StringTextComponent(UploadSpeed.func_237684_b_(this.field_224192_r) + "/s"));
            }
            if (this.field_224183_i != null) {
                arrayList.add(this.field_224183_i);
            }
            String \u26032 = arrayList.stream().map(ITextComponent::getString).collect(Collectors.joining("\n"));
            RealmsNarratorHelper.func_239550_a_(\u26032);
        }
    }

    @Override
    public boolean func_231046_a_(int n, int n2, int n3) {
        if (n == 256) {
            this.field_224186_l = true;
            this.func_224174_d();
            return true;
        }
        return super.func_231046_a_(n, n2, n3);
    }

    private void func_224174_d() {
        if (this.field_224188_n && this.field_237831_J_ != null && this.field_224183_i == null) {
            this.field_237831_J_.accept(true);
        }
        this.field_230706_i_.func_147108_a(this.field_224176_b);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int n, int n2, float f) {
        this.func_230446_a_(matrixStack);
        RealmsDownloadLatestWorldScreen.func_238472_a_(matrixStack, this.field_230712_o_, this.field_224178_d, this.field_230708_k_ / 2, 20, 0xFFFFFF);
        RealmsDownloadLatestWorldScreen.func_238472_a_(matrixStack, this.field_230712_o_, this.field_224184_j, this.field_230708_k_ / 2, 50, 0xFFFFFF);
        if (this.field_224187_m) {
            this.func_237835_b_(matrixStack);
        }
        if (this.field_224182_h.field_225139_a != 0L && !this.field_224186_l) {
            this.func_237836_c_(matrixStack);
            this.func_237838_d_(matrixStack);
        }
        if (this.field_224183_i != null) {
            RealmsDownloadLatestWorldScreen.func_238472_a_(matrixStack, this.field_230712_o_, this.field_224183_i, this.field_230708_k_ / 2, 110, 0xFF0000);
        }
        super.func_230430_a_(matrixStack, n, n2, f);
    }

    private void func_237835_b_(MatrixStack matrixStack) {
        int n = this.field_230712_o_.func_238414_a_(this.field_224184_j);
        if (this.field_224193_s % 10 == 0) {
            ++this.field_224195_u;
        }
        this.field_230712_o_.func_238421_b_(matrixStack, field_224194_t[this.field_224195_u % field_224194_t.length], this.field_230708_k_ / 2 + n / 2 + 5, 50.0f, 0xFFFFFF);
    }

    private void func_237836_c_(MatrixStack matrixStack) {
        double d = Math.min((double)this.field_224182_h.field_225139_a / (double)this.field_224182_h.field_225140_b, 1.0);
        this.field_224185_k = String.format(Locale.ROOT, "%.1f", d * 100.0);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableTexture();
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        \u2603 = this.field_230708_k_ / 2 - 100;
        \u2603 = 0.5;
        \u26033.func_225582_a_(\u2603 - 0.5, 95.5, 0.0).func_225586_a_(217, 210, 210, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 + 200.0 * d + 0.5, 95.5, 0.0).func_225586_a_(217, 210, 210, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 + 200.0 * d + 0.5, 79.5, 0.0).func_225586_a_(217, 210, 210, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 - 0.5, 79.5, 0.0).func_225586_a_(217, 210, 210, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603, 95.0, 0.0).func_225586_a_(128, 128, 128, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 + 200.0 * d, 95.0, 0.0).func_225586_a_(128, 128, 128, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603 + 200.0 * d, 80.0, 0.0).func_225586_a_(128, 128, 128, 255).func_181675_d();
        \u26033.func_225582_a_(\u2603, 80.0, 0.0).func_225586_a_(128, 128, 128, 255).func_181675_d();
        \u26032.func_78381_a();
        RenderSystem.enableTexture();
        RealmsDownloadLatestWorldScreen.func_238471_a_(matrixStack, this.field_230712_o_, this.field_224185_k + " %", this.field_230708_k_ / 2, 84, 0xFFFFFF);
    }

    private void func_237838_d_(MatrixStack matrixStack2) {
        if (this.field_224193_s % 20 == 0) {
            if (this.field_224190_p != null) {
                long l = Util.func_211177_b() - this.field_224191_q;
                if (l == 0L) {
                    l = 1L;
                }
                this.field_224192_r = 1000L * (this.field_224182_h.field_225139_a - this.field_224190_p) / l;
                this.func_237833_a_(matrixStack2, this.field_224192_r);
            }
            this.field_224190_p = this.field_224182_h.field_225139_a;
            this.field_224191_q = Util.func_211177_b();
        } else {
            MatrixStack matrixStack2;
            this.func_237833_a_(matrixStack2, this.field_224192_r);
        }
    }

    private void func_237833_a_(MatrixStack matrixStack, long l) {
        if (l > 0L) {
            int n = this.field_230712_o_.func_78256_a(this.field_224185_k);
            String \u26032 = "(" + UploadSpeed.func_237684_b_(l) + "/s)";
            this.field_230712_o_.func_238421_b_(matrixStack, \u26032, this.field_230708_k_ / 2 + n / 2 + 15, 84.0f, 0xFFFFFF);
        }
    }

    private void func_224165_h() {
        new Thread(() -> {
            try {
                if (!field_237832_b_.tryLock(1L, TimeUnit.SECONDS)) {
                    this.field_224184_j = new TranslationTextComponent("mco.download.failed");
                    return;
                }
                if (this.field_224186_l) {
                    this.func_224159_i();
                    return;
                }
                this.field_224184_j = new TranslationTextComponent("mco.download.downloading", this.field_224181_g);
                FileDownload fileDownload = new FileDownload();
                fileDownload.func_224827_a(this.field_224177_c.field_230643_a_);
                fileDownload.func_237688_a_(this.field_224177_c, this.field_224181_g, this.field_224182_h, this.field_230706_i_.func_71359_d());
                while (!fileDownload.func_224835_b()) {
                    if (fileDownload.func_224836_c()) {
                        fileDownload.func_224834_a();
                        this.field_224183_i = new TranslationTextComponent("mco.download.failed");
                        this.field_224180_f.func_238482_a_(DialogTexts.field_240632_c_);
                        return;
                    }
                    if (fileDownload.func_224837_d()) {
                        if (!this.field_224189_o) {
                            this.field_224184_j = new TranslationTextComponent("mco.download.extracting");
                        }
                        this.field_224189_o = true;
                    }
                    if (this.field_224186_l) {
                        fileDownload.func_224834_a();
                        this.func_224159_i();
                        return;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        field_224175_a.error("Failed to check Realms backup download status");
                    }
                }
                this.field_224188_n = true;
                this.field_224184_j = new TranslationTextComponent("mco.download.done");
                this.field_224180_f.func_238482_a_(DialogTexts.field_240632_c_);
            }
            catch (InterruptedException interruptedException) {
                field_224175_a.error("Could not acquire upload lock");
            }
            catch (Exception exception) {
                this.field_224183_i = new TranslationTextComponent("mco.download.failed");
                exception.printStackTrace();
            }
            finally {
                if (!field_237832_b_.isHeldByCurrentThread()) {
                    return;
                }
                field_237832_b_.unlock();
                this.field_224187_m = false;
                this.field_224188_n = true;
            }
        }).start();
    }

    private void func_224159_i() {
        this.field_224184_j = new TranslationTextComponent("mco.download.cancelled");
    }

    public class DownloadStatus {
        public volatile long field_225139_a;
        public volatile long field_225140_b;
    }
}

