/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import xaero.common.minimap.waypoints.WaypointWorld;

public class WaypointWorldConnectionManager {
    private Map<String, Set<String>> allConnections = new HashMap<String, Set<String>>();

    public void addConnection(WaypointWorld world1, WaypointWorld world2) {
        this.addConnection(world1.getInternalWorldKey(), world2.getInternalWorldKey());
    }

    void addConnection(String worldKey1, String worldKey2) {
        this.addOneWayConnection(worldKey1, worldKey2);
        this.addOneWayConnection(worldKey2, worldKey1);
    }

    private void addOneWayConnection(String worldKey1, String worldKey2) {
        Set<String> connections = this.allConnections.get(worldKey1);
        if (connections == null) {
            connections = new HashSet<String>();
            this.allConnections.put(worldKey1, connections);
        }
        connections.add(worldKey2);
    }

    public void removeConnection(WaypointWorld world1, WaypointWorld world2) {
        this.removeConnection(world1.getInternalWorldKey(), world2.getInternalWorldKey());
    }

    private void removeConnection(String worldKey1, String worldKey2) {
        this.removeOneWayConnection(worldKey1, worldKey2);
        this.removeOneWayConnection(worldKey2, worldKey1);
    }

    private void removeOneWayConnection(String worldKey1, String worldKey2) {
        Set<String> connections = this.allConnections.get(worldKey1);
        if (connections == null) {
            return;
        }
        connections.remove(worldKey2);
    }

    public boolean isConnected(WaypointWorld world1, WaypointWorld world2) {
        if (world1 == world2) {
            return true;
        }
        Set<String> connections = this.allConnections.get(world1.getInternalWorldKey());
        if (connections == null) {
            return false;
        }
        return connections.contains(world2.getInternalWorldKey());
    }

    public boolean isEmpty() {
        return this.allConnections.isEmpty();
    }

    public void save(PrintWriter writer) {
        if (!this.allConnections.isEmpty()) {
            HashSet<String> redundantConnections = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : this.allConnections.entrySet()) {
                String worldKey = entry.getKey();
                Set<String> connections = entry.getValue();
                for (String c : connections) {
                    String fullConnection = worldKey + ":" + c;
                    if (redundantConnections.contains(fullConnection)) continue;
                    writer.println("connection:" + fullConnection);
                    redundantConnections.add(c + ":" + worldKey);
                }
            }
        }
    }

    public void swapConnections(WaypointWorld world1, WaypointWorld world2) {
        this.swapConnections(world1.getInternalWorldKey(), world2.getInternalWorldKey());
    }

    private void swapConnections(String worldKey1, String worldKey2) {
        HashSet connections1 = new HashSet(this.allConnections.getOrDefault(worldKey1, new HashSet()));
        HashSet connections2 = new HashSet(this.allConnections.getOrDefault(worldKey2, new HashSet()));
        for (String c : connections1) {
            this.removeConnection(worldKey1, c);
        }
        for (String c : connections2) {
            this.addConnection(worldKey1, c);
        }
        for (String c : connections2) {
            this.removeConnection(worldKey2, c);
        }
        for (String c : connections1) {
            this.addConnection(worldKey2, c);
        }
    }

    public void renameDimension(String oldName, String newName) {
        HashSet<String> keysCopy = new HashSet<String>(this.allConnections.keySet());
        for (String worldKey : keysCopy) {
            if (!worldKey.startsWith(oldName + "/")) continue;
            String mwPart = worldKey.substring(oldName.length());
            this.swapConnections(worldKey, newName + mwPart);
        }
    }
}

