/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;

public class EntityIconManager {
    private EntityIconPrerenderer prerenderer;
    private Map<String, Integer> cachedTextures;
    private boolean canPrerender;

    public EntityIconManager(EntityIconPrerenderer prerenderer) {
        this.prerenderer = prerenderer;
        this.cachedTextures = new HashMap<String, Integer>();
    }

    public <T extends Entity> int getEntityHeadTexture(T entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, boolean debug) {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer entityRenderer = renderManager.func_78713_a(entity);
        String entityString = entity.func_70022_Q() + "%" + EntityIconDefinitions.getVariantString(entityRenderer, entity);
        Integer cachedValue = this.cachedTextures.get(entityString);
        if (cachedValue == null) {
            if (this.canPrerender) {
                cachedValue = this.prerenderer.prerender(entityRenderer, entity, defaultFramebuffer, helper, debug);
                this.cachedTextures.put(entityString, cachedValue);
                if (cachedValue != -1) {
                    this.canPrerender = false;
                }
            } else {
                cachedValue = -1;
            }
        }
        return cachedValue;
    }

    public void reset() {
        for (Integer value : this.cachedTextures.values()) {
            if (value == null || value <= 0) continue;
            GlStateManager.func_227758_s_((int)value);
        }
        this.cachedTextures.clear();
        System.out.println("Entity icon manager reset!");
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }
}

