/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Difficulty;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private ArrayList<Entity> players;
    private ArrayList<Entity> living;
    private ArrayList<Entity> livingTamed;
    private ArrayList<Entity> hostile;
    private ArrayList<Entity> items;
    private ArrayList<Entity> entities;
    private ArrayList<Entity> playersOtherTeams;

    public MinimapRadar(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.players = new ArrayList();
        this.living = new ArrayList();
        this.livingTamed = new ArrayList();
        this.hostile = new ArrayList();
        this.items = new ArrayList();
        this.entities = new ArrayList();
        this.playersOtherTeams = new ArrayList();
    }

    public int getType(Entity e, PlayerEntity p, boolean ignoreTamed) {
        if (e instanceof PlayerEntity) {
            if (p.func_96124_cp() != ((PlayerEntity)e).func_96124_cp()) {
                return 6;
            }
            return 1;
        }
        if (!ignoreTamed && e instanceof TameableEntity && ((TameableEntity)e).func_70909_n()) {
            return 7;
        }
        if (e.getPersistentData().func_74764_b("hostileMinimap") ? e.getPersistentData().func_74767_n("hostileMinimap") : Minecraft.func_71410_x().field_71441_e.func_175659_aa() != Difficulty.PEACEFUL && !this.hostileException(e) && (e instanceof MonsterEntity || e instanceof IMob || e.func_184176_by() == SoundCategory.HOSTILE)) {
            return 2;
        }
        if (e instanceof LivingEntity) {
            return 3;
        }
        if (e instanceof ItemEntity) {
            return 4;
        }
        return 0;
    }

    public void updateRadar(ClientWorld world, PlayerEntity p, Entity renderEntity) {
        this.players.clear();
        this.hostile.clear();
        this.living.clear();
        this.items.clear();
        this.entities.clear();
        this.playersOtherTeams.clear();
        this.livingTamed.clear();
        Iterable worldEntities = world.func_217416_b();
        for (Entity e : worldEntities) {
            try {
                int type = this.getType(e, p, false);
                if (type == 1 ? e != p && !this.modMain.getSettings().getShowPlayers() : (type == 2 ? !this.modMain.getSettings().getShowHostile() : (type == 3 ? !this.modMain.getSettings().getShowMobs() : (type == 4 ? !this.modMain.getSettings().getShowItems() : (type == 6 ? !this.modMain.getSettings().getShowOtherTeam() : (type == 7 ? !this.modMain.getSettings().getShowTamedMobs() : !this.modMain.getSettings().getShowOther())))))) continue;
                double offx = e.func_226277_ct_() - renderEntity.func_226277_ct_();
                double offy = e.func_226281_cx_() - renderEntity.func_226281_cx_();
                double offh = renderEntity.func_226278_cu_() - e.func_226278_cu_();
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                double maxDistance = 50625.0 / (this.minimapSession.getMinimapProcessor().getMinimapZoom() * this.minimapSession.getMinimapProcessor().getMinimapZoom());
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(this.modMain.getSettings().heightLimit * this.modMain.getSettings().heightLimit)) continue;
                ArrayList<Entity> typeList = this.entities;
                switch (type) {
                    case 1: {
                        typeList = this.players;
                        break;
                    }
                    case 2: {
                        typeList = this.hostile;
                        break;
                    }
                    case 3: {
                        typeList = this.living;
                        break;
                    }
                    case 4: {
                        typeList = this.items;
                        break;
                    }
                    case 6: {
                        typeList = this.playersOtherTeams;
                        break;
                    }
                    case 7: {
                        typeList = this.livingTamed;
                    }
                }
                if (this.modMain.getSettings().entityAmount != 0 && typeList.size() >= 100 * this.modMain.getSettings().entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    private boolean hostileException(Entity e) {
        if (e instanceof PiglinEntity) {
            return ((PiglinEntity)e).func_70631_g_();
        }
        return false;
    }

    public double getEntityX(Entity e, float partial) {
        return e.field_70142_S + (e.func_226277_ct_() - e.field_70142_S) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        return e.field_70136_U + (e.func_226281_cx_() - e.field_70136_U) * (double)partial;
    }

    public boolean shouldRenderEntity(Entity e) {
        return !e.func_225608_bj_() && !e.func_82150_aj();
    }

    public int getPlayerTeamColour(PlayerEntity p) {
        Integer teamColour = null;
        Team team = p.func_96124_cp();
        if (team != null) {
            teamColour = team.func_178775_l().func_211163_e();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(PlayerEntity p, Entity e, float offh, boolean cave) {
        int entityTeamColour;
        int type = this.getType(e, p, this.modMain.getSettings().tamedMobsColor == -1);
        if (type == 6 && this.modMain.getSettings().otherTeamColor == -1) {
            type = 1;
        }
        int color = type == 1 ? (this.modMain.getSettings().playersColor != -1 ? ModSettings.COLORS[this.modMain.getSettings().playersColor] : ((entityTeamColour = this.getPlayerTeamColour((PlayerEntity)e)) != -1 ? entityTeamColour : -1)) : (type == 2 ? ModSettings.COLORS[this.modMain.getSettings().hostileColor] : (type == 3 ? ModSettings.COLORS[this.modMain.getSettings().mobsColor] : (type == 4 ? ModSettings.COLORS[this.modMain.getSettings().itemsColor] : (type == 6 ? ModSettings.COLORS[this.modMain.getSettings().otherTeamColor] : (type == 7 ? ModSettings.COLORS[this.modMain.getSettings().tamedMobsColor] : ModSettings.COLORS[this.modMain.getSettings().otherColor])))));
        float brightness = this.getEntityBrightness(offh);
        if (brightness < 1.0f) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = 255;
            if (cave) {
                a = (int)((float)a * brightness);
            } else {
                r = (int)((float)r * brightness);
                g = (int)((float)g * brightness);
                b = (int)((float)b * brightness);
            }
            color = a << 24 | r << 16 | g << 8 | b;
        }
        return color;
    }

    public float getEntityBrightness(float offh) {
        float level = (float)this.modMain.getSettings().heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        if (level <= (float)(this.modMain.getSettings().heightLimit / 2) && this.modMain.getSettings().showEntityHeight) {
            brightness = 0.25f + 0.5f * level / (float)this.modMain.getSettings().heightLimit;
        }
        return brightness;
    }

    public Iterator<Entity> getEntitiesIterator() {
        return this.entities.iterator();
    }

    public Iterator<Entity> getItemsIterator() {
        return this.items.iterator();
    }

    public Iterator<Entity> getLivingIterator() {
        return this.living.iterator();
    }

    public Iterator<Entity> getLivingTamedIterator() {
        return this.livingTamed.iterator();
    }

    public Iterator<Entity> getHostileIterator() {
        return this.hostile.iterator();
    }

    public Iterator<Entity> getPlayersIterator() {
        return this.players.iterator();
    }

    public Iterator<Entity> getPlayersOtherTeamsIterator() {
        return this.playersOtherTeams.iterator();
    }
}

