/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class GuiEntityRadar
extends Screen
implements IDropDownCallback {
    private final int ROW_HEIGHT = 25;
    private IXaeroMinimap modMain;
    private Screen parentGuiScreen;
    private ArrayList<RadarCategory> categories;
    private boolean dropped;
    private String[] colorOptions;
    public CursorBox nameTooltip = new CursorBox("gui.xaero_box_entity_radar_names");
    public CursorBox iconTooltip = new CursorBox("gui.xaero_box_entity_radar_icons");

    protected GuiEntityRadar(IXaeroMinimap modMain, Screen par1GuiScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_entity_radar"));
        this.modMain = modMain;
        this.parentGuiScreen = par1GuiScreen;
        this.categories = new ArrayList();
        this.colorOptions = this.createColorOptions();
        String[] playerOptions = new String[this.colorOptions.length + 1];
        String[] teamOptions = new String[this.colorOptions.length + 1];
        String[] tamedOptions = new String[this.colorOptions.length + 1];
        for (int i = 0; i < this.colorOptions.length; ++i) {
            playerOptions[i] = this.colorOptions[i];
            teamOptions[i + 1] = this.colorOptions[i];
            tamedOptions[i + 1] = this.colorOptions[i];
        }
        playerOptions[this.colorOptions.length] = "gui.xaero_team_colours";
        teamOptions[0] = "gui.xaero_players";
        tamedOptions[0] = "gui.xaero_untamed_color";
        ModSettings settings = modMain.getSettings();
        this.categories.add(new RadarCategory("gui.xaero_players", settings.playersColor != -1 ? settings.playersColor : this.colorOptions.length, settings.playerNames, settings.playerIcons, 3, this.categories.size(), playerOptions, ModOptions.PLAYERS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.playersColor = this.color < GuiEntityRadar.this.colorOptions.length ? this.color : -1;
                settings.playerNames = this.names;
                settings.playerIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_other_teams", settings.otherTeamColor + 1, settings.otherTeamsNames, -4, 4, this.categories.size(), teamOptions, ModOptions.DISPLAY_OTHER_TEAM){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.otherTeamColor = this.color - 1;
                settings.otherTeamsNames = this.names;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_mobs", settings.mobsColor, settings.friendlyMobNames, settings.mobIcons, 3, this.categories.size(), this.colorOptions, ModOptions.MOBS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.mobsColor = this.color;
                settings.friendlyMobNames = this.names;
                settings.mobIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_hostile", settings.hostileColor, settings.hostileMobNames, settings.hostileIcons, 3, this.categories.size(), this.colorOptions, ModOptions.HOSTILE){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.hostileColor = this.color;
                settings.hostileMobNames = this.names;
                settings.hostileIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_tamed", settings.tamedMobsColor + 1, settings.tamedMobNames, settings.tamedIcons, 4, this.categories.size(), tamedOptions, ModOptions.TAMED){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.tamedMobsColor = this.color - 1;
                settings.tamedMobNames = this.names;
                settings.tamedIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_items", settings.itemsColor, settings.itemNames, -1, 3, this.categories.size(), this.colorOptions, ModOptions.ITEMS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.itemsColor = this.color;
                settings.itemNames = this.names;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_other", settings.otherColor, settings.otherNames, -1, 3, this.categories.size(), this.colorOptions, ModOptions.ENTITIES){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.otherColor = this.color;
                settings.otherNames = this.names;
            }
        });
    }

    private String[] createColorOptions() {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new MySmallButton(200, this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm", new Object[0]), b -> {
            ModSettings settings = this.modMain.getSettings();
            for (RadarCategory c : this.categories) {
                c.onConfirm(settings);
                c.onDisplayOptionConfirm(settings);
            }
            try {
                settings.saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.field_230706_i_.func_147108_a(this.parentGuiScreen);
        }));
        this.func_230480_a_((Widget)new MySmallButton(201, this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel", new Object[0]), b -> this.field_230706_i_.func_147108_a(this.parentGuiScreen)));
        for (RadarCategory c : this.categories) {
            c.init();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.func_230446_a_(matrixStack);
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.xaero_entity_radar_type", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 - 176), (int)(this.field_230709_l_ / 12), (int)-1);
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.xaero_entity_radar_color", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 - 76), (int)(this.field_230709_l_ / 12), (int)-1);
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.xaero_entity_radar_visiblity", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 + 24), (int)(this.field_230709_l_ / 12), (int)-1);
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.xaero_entity_radar_names", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 + 100), (int)(this.field_230709_l_ / 12), (int)-1);
        AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.xaero_entity_radar_icons", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 + 176), (int)(this.field_230709_l_ / 12), (int)-1);
        for (RadarCategory c : this.categories) {
            c.render(matrixStack, par1, par2, par3);
        }
        if (this.dropped) {
            super.func_230430_a_(matrixStack, 0, 0, par3);
        } else {
            super.func_230430_a_(matrixStack, par1, par2, par3);
        }
        this.dropped = false;
        for (RadarCategory c : this.categories) {
            if (!c.onDropdownRender(matrixStack, par1, par2, par3, true)) continue;
            this.dropped = true;
        }
        for (RadarCategory c : this.categories) {
            c.onDropdownRender(matrixStack, par1, par2, par3, false);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.1);
        for (int k = 0; k < this.field_230710_m_.size(); ++k) {
            Widget b = (Widget)this.field_230710_m_.get(k);
            if (!(b instanceof MyTinyButton)) continue;
            MyTinyButton optionWidget = (MyTinyButton)b;
            if (!optionWidget.field_230693_o_ || optionWidget.getTooltip() == null || par1 < b.field_230690_l_ || par2 < b.field_230691_m_ || par1 >= b.field_230690_l_ + b.func_230998_h_() || par2 >= b.field_230691_m_ + b.func_238483_d_()) continue;
            optionWidget.getTooltip().drawBox(matrixStack, par1, par2, this.field_230708_k_, this.field_230709_l_);
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        for (RadarCategory c : this.categories) {
            if (!c.onDropdownSelect(menu, selected)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double par1, double par2, int par3) {
        for (RadarCategory c : this.categories) {
            if (!c.onClick(par1, par2, par3, false)) continue;
            return true;
        }
        for (RadarCategory c : this.categories) {
            if (!c.onClick(par1, par2, par3, true)) continue;
            return true;
        }
        return super.func_231044_a_(par1, par2, par3);
    }

    public boolean func_231048_c_(double par1, double par2, int par3) {
        for (RadarCategory c : this.categories) {
            c.onRelease(par1, par2, par3);
        }
        return super.func_231048_c_(par1, par2, par3);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            for (RadarCategory c : this.categories) {
                if (!c.onScroll(mouseXScaled, mouseYScaled, wheel)) continue;
                return true;
            }
        }
        return super.func_231043_a_(mouseX, mouseY, wheel);
    }

    public abstract class RadarCategory {
        String name;
        int index;
        GuiDropDown dropdown;
        int color;
        int names;
        int icons;
        boolean display;
        boolean initialDisplay;
        int totalNames;
        String[] dropdownOptions;
        ModOptions displayOption;

        public RadarCategory(String name, int color, int names, int icons, int totalNames, int index, String[] dropdownOptions, ModOptions displayOption) {
            this.name = name;
            this.color = color;
            this.names = names;
            this.icons = icons;
            this.display = this.initialDisplay = GuiEntityRadar.this.modMain.getSettings().getClientBooleanValue(displayOption);
            this.index = index;
            this.dropdownOptions = dropdownOptions;
            this.displayOption = displayOption;
            this.totalNames = totalNames;
        }

        public void init() {
            this.dropdown = new GuiDropDown(this.dropdownOptions, GuiEntityRadar.this.field_230708_k_ / 2 - 136, GuiEntityRadar.this.field_230709_l_ / 12 + 20 + 25 * this.index, 120, this.color, GuiEntityRadar.this);
            GuiEntityRadar.this.func_230480_a_((Widget)new MyTinyButton(null, GuiEntityRadar.this.field_230708_k_ / 2 - 13, GuiEntityRadar.this.field_230709_l_ / 12 + 16 + 25 * this.index, ModOptions.MOBS, (ITextComponent)new StringTextComponent(this.getDisplayButtonText()), this::onSettingClicked));
            GuiEntityRadar.this.func_230480_a_((Widget)new MyTinyButton(GuiEntityRadar.this.nameTooltip, GuiEntityRadar.this.field_230708_k_ / 2 + 63, GuiEntityRadar.this.field_230709_l_ / 12 + 16 + 25 * this.index, (ITextComponent)new TranslationTextComponent(ModSettings.ENTITY_NAMES_OPTIONS[this.names]), b -> {
                this.names = (this.names + 1) % this.totalNames;
                b.func_238482_a_((ITextComponent)new TranslationTextComponent(ModSettings.ENTITY_NAMES_OPTIONS[this.names]));
            }));
            int icons = this.icons;
            if (icons < 0) {
                icons = -icons - 1;
            }
            MyTinyButton iconsButton = new MyTinyButton(GuiEntityRadar.this.iconTooltip, GuiEntityRadar.this.field_230708_k_ / 2 + 139, GuiEntityRadar.this.field_230709_l_ / 12 + 16 + 25 * this.index, (ITextComponent)new TranslationTextComponent(ModSettings.ENTITY_ICONS_OPTIONS[icons]), b -> {
                this.icons = (this.icons + 1) % this.totalNames;
                b.func_238482_a_((ITextComponent)new TranslationTextComponent(ModSettings.ENTITY_ICONS_OPTIONS[this.icons]));
            });
            if (this.icons < 0) {
                iconsButton.field_230693_o_ = false;
            }
            GuiEntityRadar.this.func_230480_a_((Widget)iconsButton);
        }

        public void render(MatrixStack matrixStack, int par1, int par2, float par3) {
            AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)GuiEntityRadar.this.field_230712_o_, (String)I18n.func_135052_a((String)this.name, (Object[])new Object[0]), (int)(GuiEntityRadar.this.field_230708_k_ / 2 - 176), (int)(GuiEntityRadar.this.field_230709_l_ / 12 + 22 + 25 * this.index), (int)-5592406);
        }

        public boolean onDropdownRender(MatrixStack matrixStack, int par1, int par2, float par3, boolean closed) {
            if (closed == this.dropdown.isClosed()) {
                this.dropdown.drawButton(matrixStack, par1, par2, GuiEntityRadar.this.field_230709_l_);
                return false;
            }
            return true;
        }

        public boolean onDropdownSelect(GuiDropDown menu, int selected) {
            if (menu == this.dropdown) {
                this.color = selected;
                return true;
            }
            return false;
        }

        public boolean onClick(double par1, double par2, int par3, boolean closed) {
            if (closed == this.dropdown.isClosed() && this.dropdown.onDropDown((int)par1, (int)par2, GuiEntityRadar.this.field_230709_l_)) {
                this.dropdown.mouseClicked((int)par1, (int)par2, par3, GuiEntityRadar.this.field_230709_l_);
                return true;
            }
            this.dropdown.setClosed(true);
            return false;
        }

        public boolean onRelease(double par1, double par2, int par3) {
            this.dropdown.mouseReleased((int)par1, (int)par2, par3, GuiEntityRadar.this.field_230709_l_);
            return true;
        }

        public boolean onScroll(int mouseXScaled, int mouseYScaled, double wheel) {
            if (!this.dropdown.isClosed() && this.dropdown.onDropDown(mouseXScaled, mouseYScaled, GuiEntityRadar.this.field_230709_l_)) {
                this.dropdown.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, GuiEntityRadar.this.field_230709_l_);
                return true;
            }
            return false;
        }

        private void onSettingClicked(Button b) {
            this.display = !this.display;
            b.func_238482_a_((ITextComponent)new StringTextComponent(this.getDisplayButtonText()));
        }

        private String getDisplayButtonText() {
            String s = "";
            boolean serverSetting = GuiEntityRadar.this.modMain.getSettings().getBooleanValue(this.displayOption);
            s = s + ModSettings.getTranslation(this.display) + (serverSetting != this.initialDisplay ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
            return s;
        }

        public void onDisplayOptionConfirm(ModSettings settings) {
            if (this.display != this.initialDisplay) {
                settings.setOptionValue(this.displayOption);
            }
        }

        public abstract void onConfirm(ModSettings var1);
    }
}

