/*
 * Decompiled with CFR 0.152.
 */
package battys.coordinatesplusmod.client;

import battys.coordinatesplusmod.BattyBaseMod;
import battys.coordinatesplusmod.client.BattyUIKeys;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import net.minecraft.client.ClipboardHelper;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.LightType;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class BattyUI
extends AbstractGui {
    private static Minecraft mc;
    private static ClipboardHelper myClip;
    int showCoords = 1;
    private boolean shadedCoords = true;
    private boolean hideTimer = false;
    private boolean shadedTimer = true;
    public boolean timerRunning = false;
    public boolean toggleTimer = false;
    public boolean resetTimer = false;
    private boolean shadedInfo = true;
    boolean coordsCopyTPFormat = false;
    int showInfo = 1;
    int myTitleText = 0xFF8800;
    int myPosCoordText = 0x55FFFF;
    int myNegCoordText = 0xCCFFFF;
    int myPosChunkText = 0xFFFFFF;
    int myNegChunkText = 0xAAAAAA;
    int myCompassText = 0xFF8800;
    int myChevronText = 0x55FFFF;
    int myBiomeText = 0xAAAAAA;
    int myRectColour = 0x55555555;
    int myTimerStopText = 0xFF8800;
    int myTimerRunText = 0x55FFFF;
    int myFPSText = 0x55FFFF;
    int myDimLightText = 43690;
    int myLightLevelText = 0xCCFFFF;
    int myMoonText = 0x55FFFF;
    int myPosX;
    int myPosY;
    int myPosZ;
    boolean myXminus;
    boolean myZminus;
    int myAngle;
    int myDir;
    int myMoveX;
    int myMoveZ;
    int myFind;
    protected static final ResourceLocation batUIResourceLocation;
    protected static final ResourceLocation[] moonPhase;
    static float batLogoScaler;
    static int batLogoU;
    static int batLogoV;
    static int batLogoX;
    static int batLogoY;
    static float moonPhaseScaler;
    static int moonPhaseU;
    static int moonPhaseV;
    static int moonPhaseX;
    static int moonPhaseY;
    int coordLocation = 0;
    int myXLine;
    int myYLine;
    int myZLine;
    int myBiomeLine;
    int myBaseOffset;
    int myCoord0Offset;
    int myCoord1Offset;
    int myCoord2Offset;
    int myRHSlocation;
    int coordBoxW;
    int coordBoxH;
    int coordBoxL;
    int coordBoxR;
    int coordBoxTop;
    int coordBoxBase;
    int timerLocation = 2;
    int clockBoxW;
    int clockBoxH;
    int clockBoxL;
    int clockBoxR;
    int clockBoxTop;
    int clockBoxBase;
    int myTimerLine;
    int myTimerOffset;
    int infoLocation = 1;
    int infoBoxW;
    int infoBoxH;
    int infoBoxL;
    int infoBoxR;
    int infoBoxTop;
    int infoBoxBase;
    int myInfoLine;
    int myInfoOffset;
    private String myChevronUp = "+";
    private String myChevronDown = "-";
    private static final String[] myCardinalPoint;
    private static final String[] myColourList;
    private static final int[] myColourCodes;
    private File optionsFile;
    private File runtimeFile;
    private int secondCounter = 0;
    private int minuteCounter = 0;
    private int hourCounter = 0;
    private int tickCounter = 0;
    Properties propts = new Properties();
    Properties proprt = new Properties();

    public BattyUI(Minecraft par1Minecraft) {
        mc = par1Minecraft;
        this.optionsFile = new File(BattyUI.mc.field_71412_D, "BatMod.properties");
        this.runtimeFile = new File(BattyUI.mc.field_71412_D, "BatMod.runtime");
        this.retrieveOptions();
        this.retrieveRuntimeOptions();
    }

    public void drawTexture(int x, int y, int u, int v, int width, int height, ResourceLocation resourceLocation, float scaler) {
        MatrixStack myMatrix = new MatrixStack();
        x = (int)((float)x / scaler);
        y = (int)((float)y / scaler);
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glScalef((float)scaler, (float)scaler, (float)scaler);
        BattyUI.mc.field_71446_o.func_110577_a(resourceLocation);
        this.func_238474_b_(myMatrix, x, y, u, v, width, height);
        GL11.glPopMatrix();
    }

    protected void drawLogoTexture(int x, int y) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        this.drawTexture(x, y, batLogoU, batLogoV, (int)((float)batLogoX / batLogoScaler), (int)((float)batLogoY / batLogoScaler), batUIResourceLocation, batLogoScaler);
        GL11.glDisable((int)3042);
    }

    protected void drawMoonTexture(int x, int y, int m) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        this.drawTexture(x, y, moonPhaseU, moonPhaseV, (int)((float)moonPhaseX / moonPhaseScaler), (int)((float)moonPhaseY / moonPhaseScaler), moonPhase[m], moonPhaseScaler);
        GL11.glDisable((int)3042);
    }

    private static int nameSearch(String[] names, String name) {
        for (int n = 0; n < names.length; ++n) {
            if (!names[n].equals(name)) continue;
            return n;
        }
        return -1;
    }

    private int getCardinalPoint(float par0) {
        double myPoint = (double)MathHelper.func_76142_g((float)par0) + 180.0;
        myPoint += 22.5;
        myPoint %= 360.0;
        return MathHelper.func_76128_c((double)(myPoint /= 45.0));
    }

    private String constructCoordVisString() {
        String var1 = "";
        var1 = var1 + this.showCoords;
        return var1;
    }

    private String constructCoordLocString() {
        String var1 = "";
        var1 = var1 + this.coordLocation;
        return var1;
    }

    private String constructTimerVisString() {
        String var1 = this.hideTimer ? "false" : "true";
        return var1;
    }

    private String constructTimerRunString() {
        String var1 = this.timerRunning ? "true" : "false";
        return var1;
    }

    private String constructInfoVisString() {
        String var1 = "";
        var1 = var1 + this.showInfo;
        return var1;
    }

    private String constructInfoLocString() {
        String var1 = "";
        var1 = var1 + this.infoLocation;
        return var1;
    }

    private String constructTimerLocString() {
        String var1 = "";
        var1 = var1 + this.timerLocation;
        return var1;
    }

    private void parseTimeString(String var1) {
        Logger.getLogger("Minecraft").info(var1);
        String[] var2 = var1.split("\\|");
        this.hourCounter = Integer.parseInt(var2[0]);
        this.minuteCounter = Integer.parseInt(var2[1]);
        this.secondCounter = Integer.parseInt(var2[2]);
    }

    private String constructTimeString() {
        String var1 = "";
        var1 = var1 + (this.hourCounter >= 10 ? "" : "0");
        var1 = var1 + this.hourCounter;
        var1 = var1 + ":";
        var1 = var1 + (this.minuteCounter >= 10 ? "" : "0");
        var1 = var1 + this.minuteCounter;
        var1 = var1 + ":";
        var1 = var1 + (this.secondCounter >= 10 ? "" : "0");
        var1 = var1 + this.secondCounter;
        return var1;
    }

    private String getSaveString() {
        return this.constructTimeString().replace(":", "|");
    }

    private void resetTimer() {
        this.resetTimer = false;
        this.secondCounter = 0;
        this.minuteCounter = 0;
        this.hourCounter = 0;
        this.tickCounter = 0;
        this.storeRuntimeOptions();
    }

    private void addOneSecond() {
        ++this.secondCounter;
        if (this.secondCounter >= 60) {
            this.secondCounter -= 60;
            ++this.minuteCounter;
        }
        if (this.minuteCounter >= 60) {
            this.minuteCounter -= 60;
            ++this.hourCounter;
        }
    }

    public void updateTimer(int var1) {
        if (this.resetTimer) {
            this.resetTimer();
        }
        if (this.toggleTimer) {
            this.toggleTimer = false;
            this.tickCounter = 0;
            this.timerRunning = !this.timerRunning;
            this.storeRuntimeOptions();
        }
        if (this.timerRunning) {
            if (this.tickCounter == 0) {
                this.tickCounter = var1;
            }
            if (var1 - this.tickCounter >= 20) {
                this.addOneSecond();
                this.tickCounter += 20;
            }
        }
    }

    private void retrieveOptions() {
        String myInfoShade = "";
        if (this.optionsFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.optionsFile);
                try {
                    this.propts.load(fis);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            catch (FileNotFoundException var5) {
                var5.printStackTrace();
            }
        }
        String myCoordShade = this.propts.getProperty("Coords.shade");
        String myTxtChr1 = this.propts.getProperty("Coords.chars.Increase");
        String myTxtChr2 = this.propts.getProperty("Coords.chars.Decrease");
        String myTxtCol1 = this.propts.getProperty("Coords.colours.TitleText");
        String myTxtCol6 = this.propts.getProperty("Coords.colours.CoordText");
        String myTxtCol2 = this.propts.getProperty("Coords.colours.PosCoordText");
        String myTxtCol7 = this.propts.getProperty("Coords.colours.NegCoordText");
        String myTxtCol3 = this.propts.getProperty("Coords.colours.CompassText");
        String myTxtCol4 = this.propts.getProperty("Coords.colours.ChevronText");
        String myTxtCol5 = this.propts.getProperty("Coords.colours.BiomeText");
        String myTxtCol8 = this.propts.getProperty("Coords.colours.PosChunkText");
        String myTxtCol9 = this.propts.getProperty("Coords.colours.NegChunkText");
        String myTxtFmt1 = this.propts.getProperty("Coords.copy.tpFormat");
        if (myCoordShade != null) {
            this.shadedCoords = myCoordShade.equals("true");
        }
        if (myTxtChr1 != null) {
            this.myChevronUp = myTxtChr1.length() > 1 ? myTxtChr1.substring(0, 1) : myTxtChr1;
        }
        if (myTxtChr2 != null) {
            this.myChevronDown = myTxtChr2.length() > 1 ? myTxtChr2.substring(0, 1) : myTxtChr2;
        }
        if (myTxtCol1 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol1);
            if (this.myFind != -1) {
                this.myTitleText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol2 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol2);
            if (this.myFind != -1) {
                this.myPosCoordText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol7 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol7);
            if (this.myFind != -1) {
                this.myNegCoordText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol3 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol3);
            if (this.myFind != -1) {
                this.myCompassText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol4 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol4);
            if (this.myFind != -1) {
                this.myChevronText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol5 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol5);
            if (this.myFind != -1) {
                this.myBiomeText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol8 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol8);
            if (this.myFind != -1) {
                this.myPosChunkText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol9 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol9);
            if (this.myFind != -1) {
                this.myNegChunkText = myColourCodes[this.myFind];
            }
        }
        if (myTxtFmt1 != null) {
            this.coordsCopyTPFormat = myTxtFmt1.equals("true");
        }
        String myTimeShade = this.propts.getProperty("Timer.shade");
        myTxtCol1 = this.propts.getProperty("Timer.colours.Stopped");
        myTxtCol2 = this.propts.getProperty("Timer.colours.Running");
        if (myTimeShade != null) {
            this.shadedTimer = myTimeShade.equals("true");
        }
        if (myTxtCol1 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol1);
            if (this.myFind != -1) {
                this.myTimerStopText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol2 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol2);
            if (this.myFind != -1) {
                this.myTimerRunText = myColourCodes[this.myFind];
            }
        }
        myInfoShade = this.propts.getProperty("Info.shade");
        myTxtCol1 = this.propts.getProperty("Info.colours.FPS");
        if (myInfoShade != null) {
            this.shadedInfo = myInfoShade.equals("true");
        }
        if (myTxtCol1 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol1);
            if (this.myFind != -1) {
                this.myFPSText = myColourCodes[this.myFind];
            }
        }
        myTxtCol1 = this.propts.getProperty("Info.colours.Bright");
        myTxtCol2 = this.propts.getProperty("Info.colours.Dim");
        if (myTxtCol1 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol1);
            if (this.myFind != -1) {
                this.myLightLevelText = myColourCodes[this.myFind];
            }
        }
        if (myTxtCol2 != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol2);
            if (this.myFind != -1) {
                this.myDimLightText = myColourCodes[this.myFind];
            }
        }
        if ((myTxtCol3 = this.propts.getProperty("Info.colours.Moon")) != null) {
            this.myFind = BattyUI.nameSearch(myColourList, myTxtCol3);
            if (this.myFind != -1) {
                this.myMoonText = myColourCodes[this.myFind];
            }
        }
    }

    private void retrieveRuntimeOptions() {
        String myInfoLoc;
        String myInfoVis;
        String myTimerRuns;
        String myTimerLoc;
        String myCoordsLoc;
        String myTimerVis;
        String myCoordsVis;
        String myTimeString;
        if (this.runtimeFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.runtimeFile);
                try {
                    this.proprt.load(fis);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            catch (FileNotFoundException var5) {
                BattyBaseMod.LOGGER.error("Could not read BatMod.runtime file");
                var5.printStackTrace();
            }
        }
        if ((myTimeString = this.proprt.getProperty("Timer.saved")) != null) {
            this.parseTimeString(myTimeString);
        }
        if ((myCoordsVis = this.proprt.getProperty("Coords.visible")) != null) {
            this.showCoords = Integer.parseInt(myCoordsVis);
        }
        if ((myTimerVis = this.proprt.getProperty("Timer.visible")) != null) {
            boolean bl = this.hideTimer = !myTimerVis.equals("true");
        }
        if ((myCoordsLoc = this.proprt.getProperty("Coords.location")) != null) {
            this.coordLocation = Integer.parseInt(myCoordsLoc);
        }
        if ((myTimerLoc = this.proprt.getProperty("Timer.location")) != null) {
            this.timerLocation = Integer.parseInt(myTimerLoc);
        }
        if ((myTimerRuns = this.proprt.getProperty("Timer.running")) != null) {
            this.timerRunning = myTimerRuns.equals("true");
        }
        if ((myInfoVis = this.proprt.getProperty("Info.visible")) != null) {
            this.showInfo = Integer.parseInt(myInfoVis);
        }
        if ((myInfoLoc = this.proprt.getProperty("Info.location")) != null) {
            this.infoLocation = Integer.parseInt(myInfoLoc);
        }
    }

    private void storeRuntimeOptions() {
        this.proprt.setProperty("Timer.saved", this.getSaveString());
        this.proprt.setProperty("Coords.visible", this.constructCoordVisString());
        this.proprt.setProperty("Timer.visible", this.constructTimerVisString());
        this.proprt.setProperty("Coords.location", this.constructCoordLocString());
        this.proprt.setProperty("Timer.location", this.constructTimerLocString());
        this.proprt.setProperty("Timer.running", this.constructTimerRunString());
        this.proprt.setProperty("Info.visible", this.constructInfoVisString());
        this.proprt.setProperty("Info.location", this.constructInfoLocString());
        try {
            FileOutputStream fos = new FileOutputStream(this.runtimeFile);
            this.proprt.store(fos, null);
            fos.flush();
        }
        catch (IOException e) {
            BattyBaseMod.LOGGER.error("IO Error while trying to store settings into BatMod.runtime file");
            e.printStackTrace();
        }
    }

    private void renderPlayerCoords() {
        GL11.glEnable((int)3008);
        MatrixStack myMatrix = new MatrixStack();
        FontRenderer var8 = BattyUI.mc.field_71466_p;
        MainWindow myRes = mc.func_228018_at_();
        BlockPos myBlock = new BlockPos((Vector3i)mc.func_175606_aa().func_233580_cy_());
        this.myPosX = myBlock.func_177958_n();
        this.myXminus = this.myPosX < 0;
        this.myPosY = myBlock.func_177956_o();
        this.myPosZ = myBlock.func_177952_p();
        this.myZminus = this.myPosZ < 0;
        this.myAngle = this.getCardinalPoint(BattyUI.mc.field_71439_g.field_70177_z);
        this.myDir = MathHelper.func_76128_c((double)((double)(BattyUI.mc.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int compassW = BattyUI.mc.field_71466_p.func_78256_a(myCardinalPoint[7]);
        if (this.showCoords > 2) {
            this.coordBoxW = 104;
            this.coordBoxH = 40;
        } else {
            this.coordBoxW = 80;
            this.coordBoxH = 30;
        }
        switch (this.coordLocation) {
            case 0: {
                this.coordBoxR = this.coordBoxW + 1;
                this.coordBoxBase = this.coordBoxH + 1;
                break;
            }
            case 1: {
                this.coordBoxR = myRes.func_198107_o() - 1;
                this.coordBoxBase = this.coordBoxH + 1;
                break;
            }
            case 2: {
                this.coordBoxR = myRes.func_198107_o() - 1;
                this.coordBoxBase = myRes.func_198087_p() - 1;
                break;
            }
            case 3: {
                this.coordBoxR = this.coordBoxW + 1;
                this.coordBoxBase = myRes.func_198087_p() - 1;
            }
        }
        this.coordBoxL = this.coordBoxR - this.coordBoxW;
        this.coordBoxTop = this.coordBoxBase - this.coordBoxH;
        this.myXLine = this.coordBoxTop + 1;
        this.myYLine = this.myXLine + 10;
        this.myZLine = this.myYLine + 10;
        this.myBiomeLine = this.myZLine + 10;
        this.myBaseOffset = this.coordBoxL + 1;
        this.myCoord0Offset = this.myBaseOffset + 10;
        this.myCoord1Offset = this.myBaseOffset + 16;
        this.myCoord2Offset = this.myBaseOffset + 39;
        this.myRHSlocation = this.showCoords > 2 ? this.coordBoxR - compassW - 1 : this.myBaseOffset + 64;
        if (this.shadedCoords) {
            BattyUI.func_238467_a_((MatrixStack)myMatrix, (int)this.coordBoxL, (int)this.coordBoxTop, (int)this.coordBoxR, (int)this.coordBoxBase, (int)this.myRectColour);
        }
        var8.func_238421_b_(myMatrix, String.format("x: ", new Object[0]), (float)this.myBaseOffset, (float)this.myXLine, this.myTitleText);
        var8.func_238421_b_(myMatrix, String.format("y: ", new Object[0]), (float)this.myBaseOffset, (float)this.myYLine, this.myTitleText);
        var8.func_238421_b_(myMatrix, String.format("z: ", new Object[0]), (float)this.myBaseOffset, (float)this.myZLine, this.myTitleText);
        if (this.showCoords < 5) {
            if (!this.myXminus) {
                var8.func_238421_b_(myMatrix, String.format("%d", this.myPosX), (float)this.myCoord1Offset, (float)this.myXLine, this.myPosCoordText);
            } else {
                var8.func_238421_b_(myMatrix, "-", (float)this.myCoord0Offset, (float)this.myXLine, this.myNegCoordText);
                var8.func_238421_b_(myMatrix, String.format("%d", Math.abs(this.myPosX)), (float)this.myCoord1Offset, (float)this.myXLine, this.myNegCoordText);
            }
            var8.func_238421_b_(myMatrix, String.format("%d", this.myPosY), (float)this.myCoord1Offset, (float)this.myYLine, this.myPosCoordText);
            if (!this.myZminus) {
                var8.func_238421_b_(myMatrix, String.format("%d", this.myPosZ), (float)this.myCoord1Offset, (float)this.myZLine, this.myPosCoordText);
            } else {
                var8.func_238421_b_(myMatrix, "-", (float)this.myCoord0Offset, (float)this.myZLine, this.myNegCoordText);
                var8.func_238421_b_(myMatrix, String.format("%d", Math.abs(this.myPosZ)), (float)this.myCoord1Offset, (float)this.myZLine, this.myNegCoordText);
            }
        } else {
            if (this.myPosX >= 0) {
                var8.func_238421_b_(myMatrix, String.format("c%d ", this.myPosX >> 4), (float)this.myCoord2Offset, (float)this.myXLine, this.myPosChunkText);
                var8.func_238421_b_(myMatrix, String.format("b%d", this.myPosX & 0xF), (float)this.myCoord1Offset, (float)this.myXLine, this.myPosChunkText);
            } else {
                var8.func_238421_b_(myMatrix, String.format("c%d ", this.myPosX >> 4), (float)this.myCoord2Offset, (float)this.myXLine, this.myNegChunkText);
                var8.func_238421_b_(myMatrix, String.format("b%d", this.myPosX & 0xF), (float)this.myCoord1Offset, (float)this.myXLine, this.myPosChunkText);
            }
            var8.func_238421_b_(myMatrix, String.format("%d", this.myPosY), (float)this.myCoord1Offset, (float)this.myYLine, this.myPosCoordText);
            if (this.myPosZ >= 0) {
                var8.func_238421_b_(myMatrix, String.format("c%d ", this.myPosZ >> 4), (float)this.myCoord2Offset, (float)this.myZLine, this.myPosChunkText);
                var8.func_238421_b_(myMatrix, String.format("b%d", this.myPosZ & 0xF), (float)this.myCoord1Offset, (float)this.myZLine, this.myPosChunkText);
            } else {
                var8.func_238421_b_(myMatrix, String.format("c%d ", this.myPosZ >> 4), (float)this.myCoord2Offset, (float)this.myZLine, this.myNegChunkText);
                var8.func_238421_b_(myMatrix, String.format("b%d", this.myPosZ & 0xF), (float)this.myCoord1Offset, (float)this.myZLine, this.myPosChunkText);
            }
        }
        this.drawLogoTexture(this.myRHSlocation - 12, this.myYLine - 1);
        var8.func_238421_b_(myMatrix, myCardinalPoint[this.myAngle], (float)this.myRHSlocation, (float)this.myYLine, this.myCompassText);
        if (this.showCoords > 1) {
            switch (this.myAngle) {
                case 0: {
                    var8.func_238421_b_(myMatrix, this.myChevronDown + this.myChevronDown, (float)this.myRHSlocation, (float)this.myZLine, this.myChevronText);
                    break;
                }
                case 1: {
                    var8.func_238421_b_(myMatrix, this.myChevronDown, (float)this.myRHSlocation, (float)this.myZLine, this.myChevronText);
                    var8.func_238421_b_(myMatrix, this.myChevronUp, (float)this.myRHSlocation, (float)this.myXLine, this.myChevronText);
                    break;
                }
                case 2: {
                    var8.func_238421_b_(myMatrix, this.myChevronUp + this.myChevronUp, (float)this.myRHSlocation, (float)this.myXLine, this.myChevronText);
                    break;
                }
                case 3: {
                    var8.func_238421_b_(myMatrix, this.myChevronUp, (float)this.myRHSlocation, (float)this.myXLine, this.myChevronText);
                    var8.func_238421_b_(myMatrix, this.myChevronUp, (float)this.myRHSlocation, (float)this.myZLine, this.myChevronText);
                    break;
                }
                case 4: {
                    var8.func_238421_b_(myMatrix, this.myChevronUp + this.myChevronUp, (float)this.myRHSlocation, (float)this.myZLine, this.myChevronText);
                    break;
                }
                case 5: {
                    var8.func_238421_b_(myMatrix, this.myChevronUp, (float)this.myRHSlocation, (float)this.myZLine, this.myChevronText);
                    var8.func_238421_b_(myMatrix, this.myChevronDown, (float)this.myRHSlocation, (float)this.myXLine, this.myChevronText);
                    break;
                }
                case 6: {
                    var8.func_238421_b_(myMatrix, this.myChevronDown + this.myChevronDown, (float)this.myRHSlocation, (float)this.myXLine, this.myChevronText);
                    break;
                }
                case 7: {
                    var8.func_238421_b_(myMatrix, this.myChevronDown, (float)this.myRHSlocation, (float)this.myXLine, this.myChevronText);
                    var8.func_238421_b_(myMatrix, this.myChevronDown, (float)this.myRHSlocation, (float)this.myZLine, this.myChevronText);
                }
            }
        }
        if (this.showCoords > 2 && BattyUI.mc.field_71441_e != null && BattyUI.mc.field_71441_e.func_175667_e(myBlock)) {
            BlockPos blockpos = new BlockPos(this.myPosX, this.myPosY, this.myPosZ);
            String myBiomeString = BattyUI.mc.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)BattyUI.mc.field_71441_e.func_226691_t_(blockpos)).toString();
            myBiomeString = myBiomeString.replace("minecraft:", "");
            var8.func_238421_b_(myMatrix, myBiomeString, (float)this.myBaseOffset, (float)this.myBiomeLine, this.myBiomeText);
        }
        if (this.showCoords == 4) {
            var8.func_238421_b_(myMatrix, String.format("dy ", new Object[0]), (float)this.myCoord2Offset, (float)this.myYLine, this.myTitleText);
            var8.func_238421_b_(myMatrix, String.format("%d", BattyUI.mc.field_71441_e.func_72820_D() / 24000L), (float)(this.myCoord2Offset + 14), (float)this.myYLine, this.myTitleText);
        }
    }

    private void renderPlayerTimer() {
        GL11.glEnable((int)3008);
        MainWindow myRes = mc.func_228018_at_();
        MatrixStack myMatrix = new MatrixStack();
        String myTime = this.constructTimeString();
        int timeStringWid = BattyUI.mc.field_71466_p.func_78256_a(myTime);
        this.clockBoxW = 12 + timeStringWid;
        this.clockBoxH = 10;
        switch (this.timerLocation) {
            case 0: {
                this.clockBoxR = this.clockBoxW + 1;
                this.clockBoxBase = this.clockBoxH + 1;
                if (this.coordLocation != 0) break;
                this.clockBoxBase += this.coordBoxH + 1;
                break;
            }
            case 1: {
                this.clockBoxR = myRes.func_198107_o() / 2 + this.clockBoxW / 2;
                this.clockBoxBase = this.clockBoxH + 1;
                break;
            }
            case 2: {
                this.clockBoxR = myRes.func_198107_o() - 1;
                this.clockBoxBase = this.clockBoxH + 1;
                if (this.coordLocation != 1) break;
                this.clockBoxBase += this.coordBoxH + 1;
                break;
            }
            case 3: {
                this.clockBoxR = myRes.func_198107_o() - 1;
                this.clockBoxBase = myRes.func_198087_p() - 1;
                if (this.coordLocation != 2) break;
                this.clockBoxBase -= this.coordBoxH + 1;
                break;
            }
            case 4: {
                this.clockBoxR = this.clockBoxW + 1;
                this.clockBoxBase = myRes.func_198087_p() - 15;
                if (this.coordLocation != 3) break;
                this.clockBoxBase -= this.coordBoxH + 1;
            }
        }
        this.clockBoxL = this.clockBoxR - this.clockBoxW;
        this.clockBoxTop = this.clockBoxBase - this.clockBoxH;
        this.myTimerLine = this.clockBoxTop + 1;
        this.myTimerOffset = this.clockBoxL + 6;
        if (this.shadedTimer) {
            BattyUI.func_238467_a_((MatrixStack)myMatrix, (int)this.clockBoxL, (int)this.clockBoxTop, (int)this.clockBoxR, (int)this.clockBoxBase, (int)this.myRectColour);
        }
        if (this.timerRunning) {
            BattyUI.mc.field_71466_p.func_238421_b_(myMatrix, myTime, (float)this.myTimerOffset, (float)this.myTimerLine, this.myTimerRunText);
        } else {
            BattyUI.mc.field_71466_p.func_238421_b_(myMatrix, myTime, (float)this.myTimerOffset, (float)this.myTimerLine, this.myTimerStopText);
        }
    }

    private void renderInfo() {
        GL11.glEnable((int)3008);
        MainWindow myRes = mc.func_228018_at_();
        MatrixStack myMatrix = new MatrixStack();
        String myInfoString = "";
        int myLight = 0;
        int myMoon = 0;
        switch (this.showInfo) {
            case 1: {
                myInfoString = BattyUI.mc.field_71426_K.split(" ")[0] + " FPS";
                break;
            }
            case 2: {
                ClientWorld world = BattyUI.mc.field_71441_e;
                BlockPos blockpos = new BlockPos((Vector3i)mc.func_175606_aa().func_233580_cy_());
                WorldLightManager worldlightmanager = world.func_72863_F().func_212863_j_();
                myLight = this.myPosY < 0 || this.myPosY > 255 ? 0 : worldlightmanager.func_215569_a(LightType.BLOCK).func_215611_b(blockpos);
                myInfoString = "Lit " + myLight + " Blk";
                break;
            }
            case 3: {
                if (BattyUI.mc.field_71441_e == null) break;
                myMoon = BattyUI.mc.field_71441_e.func_242414_af();
                myInfoString = "Moon   ";
                break;
            }
        }
        int infoStringWid = BattyUI.mc.field_71466_p.func_78256_a(myInfoString);
        this.infoBoxW = 12 + infoStringWid;
        this.infoBoxH = 11;
        switch (this.infoLocation) {
            case 0: {
                this.infoBoxR = this.infoBoxW + 1;
                this.infoBoxBase = this.infoBoxH + 1;
                if (this.timerLocation == 0) {
                    this.infoBoxBase += this.clockBoxH + 1;
                }
                if (this.coordLocation != 0) break;
                this.infoBoxBase += this.coordBoxH + 1;
                break;
            }
            case 1: {
                this.infoBoxR = myRes.func_198107_o() / 2 + this.infoBoxW / 2;
                this.infoBoxBase = this.infoBoxH + 1;
                if (this.timerLocation != 1) break;
                this.infoBoxBase += this.clockBoxH + 1;
                break;
            }
            case 2: {
                this.infoBoxR = myRes.func_198107_o() - 1;
                this.infoBoxBase = this.infoBoxH + 1;
                if (this.timerLocation == 2) {
                    this.infoBoxBase += this.clockBoxH + 1;
                }
                if (this.coordLocation != 1) break;
                this.infoBoxBase += this.coordBoxH + 1;
                break;
            }
            case 3: {
                this.infoBoxR = myRes.func_198107_o() - 1;
                this.infoBoxBase = myRes.func_198087_p() - 1;
                if (this.timerLocation == 3) {
                    this.infoBoxBase -= this.clockBoxH + 1;
                }
                if (this.coordLocation != 2) break;
                this.infoBoxBase -= this.coordBoxH + 1;
                break;
            }
            case 4: {
                this.infoBoxR = this.infoBoxW + 1;
                this.infoBoxBase = myRes.func_198087_p() - 15;
                if (this.timerLocation == 4) {
                    this.infoBoxBase -= this.clockBoxH + 1;
                }
                if (this.coordLocation != 3) break;
                this.infoBoxBase -= this.coordBoxH + 1;
            }
        }
        this.infoBoxL = this.infoBoxR - this.infoBoxW;
        this.infoBoxTop = this.infoBoxBase - this.infoBoxH;
        this.myInfoLine = this.infoBoxTop + 1;
        this.myInfoOffset = this.infoBoxL + 6;
        if (this.shadedInfo) {
            BattyUI.func_238467_a_((MatrixStack)myMatrix, (int)this.infoBoxL, (int)this.infoBoxTop, (int)this.infoBoxR, (int)this.infoBoxBase, (int)this.myRectColour);
        }
        switch (this.showInfo) {
            case 1: {
                BattyUI.mc.field_71466_p.func_238421_b_(myMatrix, myInfoString, (float)this.myInfoOffset, (float)this.myInfoLine, this.myFPSText);
                break;
            }
            case 2: {
                if (myLight > 7) {
                    BattyUI.mc.field_71466_p.func_238421_b_(myMatrix, myInfoString, (float)this.myInfoOffset, (float)this.myInfoLine, this.myLightLevelText);
                    break;
                }
                BattyUI.mc.field_71466_p.func_238421_b_(myMatrix, myInfoString, (float)this.myInfoOffset, (float)this.myInfoLine, this.myDimLightText);
                break;
            }
            case 3: {
                BattyUI.mc.field_71466_p.func_238421_b_(myMatrix, myInfoString, (float)this.myInfoOffset, (float)this.myInfoLine, this.myMoonText);
                this.drawMoonTexture(this.infoBoxR - 12, this.myInfoLine, myMoon);
                break;
            }
        }
    }

    public void hideUnhideCoords() {
        ++this.showCoords;
        if (this.showCoords > 5) {
            this.showCoords = 0;
        }
        this.storeRuntimeOptions();
        BattyUIKeys.keyToggleCoords = false;
    }

    public void rotateScreenCoords() {
        ++this.coordLocation;
        if (this.coordLocation > 2) {
            this.coordLocation = 0;
        }
        this.storeRuntimeOptions();
        BattyUIKeys.keyMoveCoords = false;
    }

    public void copyScreenCoords() {
        String myCoordString = this.coordsCopyTPFormat ? new String(this.myPosX + " " + this.myPosY + " " + this.myPosZ) : new String("x:" + this.myPosX + " y:" + this.myPosY + " z:" + this.myPosZ);
        myClip.func_216489_a(mc.func_228018_at_().func_198092_i(), myCoordString);
        BattyUIKeys.keyCopyCoords = false;
    }

    public void hideUnhideStopWatch() {
        this.hideTimer = !this.hideTimer;
        this.storeRuntimeOptions();
        BattyUIKeys.keyToggleTimerVis = false;
    }

    public void rotateScreenTimer() {
        ++this.timerLocation;
        if (this.timerLocation > 4) {
            this.timerLocation = 0;
        }
        this.storeRuntimeOptions();
        BattyUIKeys.keyMoveTimer = false;
    }

    public void hideUnhideInfo() {
        ++this.showInfo;
        if (this.showInfo > 3) {
            this.showInfo = 0;
        }
        this.storeRuntimeOptions();
    }

    public void rotateScreenInfo() {
        ++this.infoLocation;
        if (this.infoLocation > 3) {
            this.infoLocation = 0;
        }
        this.storeRuntimeOptions();
    }

    @SubscribeEvent
    public void renderPlayerInfo(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        if (BattyUIKeys.keyToggleCoords) {
            this.hideUnhideCoords();
        }
        if (BattyUIKeys.keyMoveCoords) {
            this.rotateScreenCoords();
        }
        if (BattyUIKeys.keyCopyCoords) {
            this.copyScreenCoords();
        }
        if (BattyUIKeys.keyToggleTimerVis) {
            this.hideUnhideStopWatch();
        }
        if (BattyUIKeys.keyToggleTimerRun) {
            this.toggleTimer = true;
            BattyUIKeys.keyToggleTimerRun = false;
        }
        if (BattyUIKeys.keyResetTimer) {
            this.resetTimer = true;
            BattyUIKeys.keyResetTimer = false;
        }
        if (BattyUIKeys.keyMoveTimer) {
            this.rotateScreenTimer();
        }
        if (BattyUIKeys.keyToggleInfoVis) {
            this.hideUnhideInfo();
            BattyUIKeys.keyToggleInfoVis = false;
        }
        if (BattyUIKeys.keyMoveInfo) {
            this.rotateScreenInfo();
            BattyUIKeys.keyMoveInfo = false;
        }
        this.updateTimer(BattyUI.mc.field_71456_v.func_73834_c());
        if (!BattyUI.mc.field_71474_y.field_74330_P) {
            if (this.showCoords > 0) {
                this.renderPlayerCoords();
            } else {
                this.coordBoxH = 0;
            }
            if (this.hideTimer) {
                this.clockBoxH = 0;
            } else {
                this.renderPlayerTimer();
            }
            if (this.showInfo > 0) {
                this.renderInfo();
            } else {
                this.infoBoxH = 0;
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.retrieveOptions();
    }

    @SubscribeEvent
    public void stopTheClock(GuiOpenEvent event) {
        if (event.getGui() instanceof MainMenuScreen) {
            this.timerRunning = false;
        }
        this.storeRuntimeOptions();
    }

    static {
        myClip = new ClipboardHelper();
        batUIResourceLocation = new ResourceLocation("coordinatesplusmod:textures/batheart_icon.png");
        moonPhase = new ResourceLocation[]{new ResourceLocation("coordinatesplusmod:textures/moon_phase_0.png"), new ResourceLocation("coordinatesplusmod:textures/moon_phase_1.png"), new ResourceLocation("coordinatesplusmod:textures/moon_phase_2.png"), new ResourceLocation("coordinatesplusmod:textures/moon_phase_3.png"), new ResourceLocation("coordinatesplusmod:textures/moon_phase_4.png"), new ResourceLocation("coordinatesplusmod:textures/moon_phase_5.png"), new ResourceLocation("coordinatesplusmod:textures/moon_phase_6.png"), new ResourceLocation("coordinatesplusmod:textures/moon_phase_7.png")};
        batLogoScaler = 0.036f;
        batLogoU = 0;
        batLogoV = 0;
        batLogoX = (int)(256.0f * batLogoScaler);
        batLogoY = (int)(256.0 * (double)batLogoScaler);
        moonPhaseScaler = 0.036f;
        moonPhaseU = 0;
        moonPhaseV = 0;
        moonPhaseX = (int)(256.0f * moonPhaseScaler);
        moonPhaseY = (int)(256.0 * (double)moonPhaseScaler);
        myCardinalPoint = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
        myColourList = new String[]{"black", "darkblue", "darkgreen", "darkaqua", "darkred", "purple", "brown", "grey", "darkgrey", "blue", "green", "aqua", "sage", "violet", "orange", "lime", "silver", "coolblue", "red", "gold", "oldgold", "lightpurple", "pink", "yellow", "white"};
        myColourCodes = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xAA5500, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0x88AA00, 0x8855CC, 0xCC5500, 0xCCFF00, 0xCCCCCC, 0xCCFFFF, 0xFF5555, 0xFFAA00, 0xFF8800, 0xFF55FF, 0xFFAAAA, 0xFFFF55, 0xFFFFFF};
    }
}

