/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tapemouse;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.dries007.tapemouse.TapeMouse;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ClientEventHandler {
    private static final Map<String, KeyBinding> KEYBIND_ARRAY = (Map)ObfuscationReflectionHelper.getPrivateValue(KeyBinding.class, null, (String)"field_74516_a");
    private final Minecraft mc = Minecraft.func_71410_x();
    private int delay;
    private KeyBinding keyBinding;
    private int i;

    public ClientEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (KEYBIND_ARRAY == null) {
            NullPointerException e = new NullPointerException("KEYBIND_ARRAY was null.");
            TapeMouse.LOGGER.fatal("Something has gone wrong fetching the keybinding list. I guess we die now.", (Throwable)e);
            throw e;
        }
    }

    @SubscribeEvent
    public void textRenderEvent(RenderGameOverlayEvent.Text event) {
        if (this.keyBinding == null) {
            return;
        }
        if (this.mc.field_71462_r instanceof MainMenuScreen || this.mc.field_71462_r instanceof ChatScreen) {
            event.getLeft().add("TapeMouse paused. If you want to AFK, use ALT+TAB.");
            return;
        }
        event.getLeft().add("TapeMouse active: " + I18n.func_135052_a((String)this.keyBinding.func_197982_m(), (Object[])new Object[0]) + " (" + this.keyBinding.func_151464_g().replaceFirst("^key\\.", "") + ')');
        event.getLeft().add("Delay: " + this.i + " / " + this.delay);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.mc.field_71462_r instanceof MainMenuScreen || this.mc.field_71462_r instanceof ChatScreen) {
            return;
        }
        if (this.keyBinding == null) {
            return;
        }
        if (this.i++ < this.delay) {
            return;
        }
        this.i = 0;
        if (this.delay == 0) {
            KeyBinding.func_197980_a((InputMappings.Input)this.keyBinding.getKey(), (boolean)true);
        }
        KeyBinding.func_197981_a((InputMappings.Input)this.keyBinding.getKey());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void chatEvent(ClientChatEvent event) {
        if (!event.getMessage().startsWith("/tapemouse")) {
            return;
        }
        event.setCanceled(true);
        String[] args = event.getOriginalMessage().split("\\s");
        NewChatGui gui = this.mc.field_71456_v.func_146158_b();
        gui.func_146239_a(event.getOriginalMessage());
        try {
            this.handleCommand(gui, args);
        }
        catch (Exception e) {
            gui.func_146227_a((ITextComponent)new StringTextComponent("An error occurred trying to run the tapemouse command:").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))));
            gui.func_146227_a((ITextComponent)new StringTextComponent(e.toString()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))));
            TapeMouse.LOGGER.error("An error occurred trying to run the tapemouse command:", (Throwable)e);
        }
    }

    private void handleCommand(NewChatGui gui, String[] args) throws Exception {
        switch (args.length) {
            default: {
                gui.func_146227_a((ITextComponent)new StringTextComponent("TapeMouse help: ").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.AQUA))));
                gui.func_146227_a((ITextComponent)new StringTextComponent("Run '/tapemouse list' to get a list of keybindings."));
                gui.func_146227_a((ITextComponent)new StringTextComponent("Run '/tapemouse off' to stop TapeMouse."));
                gui.func_146227_a((ITextComponent)new StringTextComponent("Run '/tapemouse <binding> <delay>' to start TapeMouse."));
                gui.func_146227_a((ITextComponent)new StringTextComponent("  delay is the number of ticks between every keypress. Set to 0 to hold down the key."));
                return;
            }
            case 2: {
                if (args[1].equalsIgnoreCase("off")) {
                    this.keyBinding = null;
                    return;
                }
                if (args[1].equalsIgnoreCase("list")) {
                    List keys = KEYBIND_ARRAY.keySet().stream().map(k -> k.replaceFirst("^key\\.", "")).sorted().collect(Collectors.toList());
                    gui.func_146227_a((ITextComponent)new StringTextComponent(String.join((CharSequence)", ", keys)));
                    break;
                }
                gui.func_146227_a((ITextComponent)new StringTextComponent("Missing delay parameter.").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))));
                break;
            }
            case 3: {
                int delay;
                KeyBinding keyBinding = KEYBIND_ARRAY.get("key." + args[1]);
                if (keyBinding == null) {
                    keyBinding = KEYBIND_ARRAY.get(args[1]);
                }
                if (keyBinding == null) {
                    gui.func_146227_a((ITextComponent)new StringTextComponent(args[1] + " is not a valid keybinding.").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))));
                    return;
                }
                try {
                    delay = Integer.parseInt(args[2]);
                    if (delay < 0) {
                        throw new Exception("bad user");
                    }
                }
                catch (Exception e) {
                    gui.func_146227_a((ITextComponent)new StringTextComponent(args[1] + " is not a positive number or 0.").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))));
                    return;
                }
                this.delay = delay;
                this.i = 0;
                this.keyBinding = keyBinding;
            }
        }
    }
}

