/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.shulkertooltip;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.lwjgl.opengl.GL11;

@Mod(value="shulkertooltip")
public class ShulkerToolTip {
    public static final String MODID = "shulkertooltip";
    private static final KeyBinding enableView = new KeyBinding("key.enableView", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.func_197955_a((String)"key.keyboard.left.alt"), "key.categories.shulkerTooltip");
    private static final KeyBinding openShulker = new KeyBinding("key.openShulker", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.func_197955_a((String)"key.keyboard.n"), "key.categories.shulkerTooltip");
    private static final KeyBinding toggleView = new KeyBinding("key.toggleView", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.func_197955_a((String)"key.keyboard.v"), "key.categories.shulkerTooltip");
    private static final ResourceLocation TEXTURE = new ResourceLocation("shulkertooltip", "textures/gui/shulker_parts.png");

    public ShulkerToolTip() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventManager());
        ClientRegistry.registerKeyBinding((KeyBinding)enableView);
        ClientRegistry.registerKeyBinding((KeyBinding)openShulker);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleView);
    }

    private class EventManager
    extends AbstractGui {
        private boolean box = false;
        private final List<String> ironChestWidths = Arrays.asList("diamond", "crystal", "obsidian");
        private final String[] boxNames = new String[]{"shulker_box", "end_troll_box"};
        private float[] color;
        private boolean show = false;
        private boolean pressed = false;

        private EventManager() {
        }

        private String shulkerStorageItem(ItemStack stack) {
            String name = stack.func_77973_b().getRegistryName().toString();
            for (String n : this.boxNames) {
                if (!name.contains(n)) continue;
                return name;
            }
            return null;
        }

        @SubscribeEvent
        public void tooltipEvent(ItemTooltipEvent e) {
            if (this.shulkerStorageItem(e.getItemStack()) != null && (enableView.getKey().func_197937_c() == -1 || enableView.getKey().func_197937_c() != -1 && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)enableView.getKey().func_197937_c()) == this.show && this.box)) {
                e.getToolTip().clear();
                e.getToolTip().add(new StringTextComponent(""));
            }
        }

        @SubscribeEvent
        public void onClick(GuiScreenEvent.MouseClickedEvent e) {
            if (e.getGui() instanceof FakeShulkerBox) {
                e.setCanceled(true);
            }
        }

        void boxPart(MatrixStack m, int atX, int atY, int fromX, int fromY, int toX, int toY) {
            GL11.glDisable((int)2929);
            if (this.color != null) {
                GlStateManager.func_227702_d_((float)(this.color[0] + 0.15f), (float)(this.color[1] + 0.15f), (float)(this.color[2] + 0.15f), (float)1.0f);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            this.func_238474_b_(m, atX, atY, fromX, fromY, toX, toY);
            GL11.glEnable((int)2929);
        }

        private void drawBar(MatrixStack m, int x, int y, int yStart, int boxWidth, int howTall) {
            this.boxPart(m, x, y, 0, yStart, 5, howTall);
            for (int i = 0; i < boxWidth + 1; ++i) {
                this.boxPart(m, x + 4 + i * 18, y, 4, yStart, 18, howTall);
            }
            this.boxPart(m, x + 4 + (boxWidth + 1) * 18, y, 22, yStart, 6, howTall);
        }

        @SubscribeEvent
        public void event(GuiScreenEvent.DrawScreenEvent.Post event) {
            Minecraft mc = Minecraft.func_71410_x();
            long window = mc.func_228018_at_().func_198092_i();
            ClientPlayerEntity p = mc.field_71439_g;
            if (event.getGui() instanceof ContainerScreen && ((ContainerScreen)event.getGui()).getSlotUnderMouse() != null) {
                ItemStack item = ((ContainerScreen)event.getGui()).getSlotUnderMouse().func_75211_c();
                String name = this.shulkerStorageItem(item);
                if (name != null) {
                    if (toggleView.getKey().func_197937_c() != -1 && InputMappings.func_216506_a((long)window, (int)toggleView.getKey().func_197937_c())) {
                        if (!this.pressed) {
                            this.show = !this.show;
                            this.pressed = true;
                        }
                    } else {
                        this.pressed = false;
                    }
                    for (DyeColor c : DyeColor.values()) {
                        if (name.contains(c.toString().toLowerCase().replace("_", ""))) {
                            this.color = c.func_193349_f();
                            break;
                        }
                        this.color = null;
                    }
                    int boxWidth = this.ironChestWidths.contains(item.func_77973_b().getRegistryName().toString().split(":")[1].split("_")[0]) ? 11 : 8;
                    ListNBT nbttaglist = (item.func_77942_o() ? item.func_77978_p() : new CompoundNBT()).func_74775_l("BlockEntityTag").func_150295_c("Items", 10);
                    int slot = 0;
                    ArrayList<ItemStack> boxContents = new ArrayList<ItemStack>();
                    for (int i = 0; i < nbttaglist.size(); ++i) {
                        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbttaglist.get(i)));
                        String stringofitems = nbttaglist.get(i).toString();
                        int slotnum = Integer.parseInt(stringofitems.split("Slot:")[1].split("b,")[0].replaceAll("[^0-9]", ""));
                        while (slot != slotnum) {
                            ++slot;
                            boxContents.add(ItemStack.field_190927_a);
                        }
                        ++slot;
                        boxContents.add(stack);
                    }
                    slot %= boxWidth + 1;
                    while (boxWidth + 1 > slot && slot != 0) {
                        ++slot;
                        boxContents.add(ItemStack.field_190927_a);
                    }
                    if (openShulker.getKey().func_197937_c() != -1 && InputMappings.func_216506_a((long)window, (int)openShulker.getKey().func_197937_c())) {
                        if (boxWidth != 8 || boxContents.size() > 54) {
                            p.func_145747_a((ITextComponent)new StringTextComponent("\u00a7cERROR: Chest contents wouldn't fit in GUI."), UUID.randomUUID());
                        }
                        Inventory inventory = new Inventory(boxContents.size() < 27 ? 27 : boxContents.size());
                        for (int i = 0; i < boxContents.size(); ++i) {
                            inventory.func_70299_a(i, (ItemStack)boxContents.get(i));
                        }
                        ChestContainer container = new ChestContainer(ContainerType.field_221509_c, p.field_71070_bA.field_75152_c, p.field_71071_by, (IInventory)inventory, 3);
                        mc.func_147108_a((Screen)new FakeShulkerBox(container, p.field_71071_by, item.func_200301_q()));
                    }
                    if (enableView.getKey().func_197937_c() == -1 || enableView.getKey().func_197937_c() != -1 && InputMappings.func_216506_a((long)window, (int)enableView.getKey().func_197937_c()) == this.show) {
                        int lengthOver = event.getMouseX() + 32 + boxWidth * 18 - mc.func_228018_at_().func_198107_o();
                        int toolTipHeight = 8 + (boxContents.size() - 1) / boxWidth * 18;
                        int centerToolTip = toolTipHeight / 2;
                        int lengthAbove = event.getMouseY() - 23 - centerToolTip;
                        int lengthBelow = event.getMouseY() - 10 + toolTipHeight - mc.func_228018_at_().func_198087_p() - centerToolTip;
                        this.box = true;
                        int drawX = event.getMouseX() + 4 - (lengthOver > 0 ? lengthOver : 0);
                        int drawY = event.getMouseY() - 12 - centerToolTip - (lengthBelow > 0 ? lengthBelow : 0) - (lengthAbove < 0 ? lengthAbove : 0);
                        MatrixStack poseStack = event.getMatrixStack();
                        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)777.0f);
                        this.drawBar(poseStack, drawX, drawY - 11, 0, boxWidth, 16);
                        mc.field_71466_p.func_238405_a_(poseStack, item.func_200301_q().getString(), (float)(drawX + 6), (float)(drawY - 6), 0xFFFFFF);
                        int row = 0;
                        slot = 0;
                        int x = 0;
                        int y = drawY + 6 + 18 * row;
                        this.boxPart(poseStack, drawX, drawY + 5, 0, 4, 5, 18);
                        this.boxPart(poseStack, drawX + (boxWidth + 1) * 18 + 5, drawY + 5, 23, 5, 5, 18);
                        for (int i = 0; i < boxContents.size(); ++i) {
                            if (slot > boxWidth) {
                                slot = 0;
                                this.boxPart(poseStack, drawX, drawY + 5 + 18 * ++row, 0, 4, 5, 18);
                                this.boxPart(poseStack, drawX + (boxWidth + 1) * 18 + 5, drawY + 5 + 18 * row, 23, 5, 5, 18);
                            }
                            x = drawX + 6 + 18 * slot;
                            y = drawY + 6 + 18 * row;
                            this.boxPart(poseStack, x - 1, y - 1, 5, 17, 18, 18);
                            mc.func_175599_af().func_180450_b((ItemStack)boxContents.get(i), x, y);
                            String string = Integer.toString(((ItemStack)boxContents.get(i)).func_190916_E());
                            if (((ItemStack)boxContents.get(i)).func_190916_E() == 1) {
                                string = "";
                            }
                            mc.func_175599_af().func_180453_a(mc.field_71466_p, (ItemStack)boxContents.get(i), x, y, string);
                            ++slot;
                        }
                        while (boxWidth + 1 > slot) {
                            x = drawX + 6 + 18 * slot;
                            this.boxPart(poseStack, x - 1, y - 1, 5, 17, 18, 18);
                            ++slot;
                        }
                        this.drawBar(poseStack, drawX, drawY + (row + 1) * 18 + 5, 35, boxWidth, 5);
                    }
                } else {
                    this.box = false;
                }
            }
        }
    }

    private class FakeShulkerBox
    extends ChestScreen {
        public FakeShulkerBox(ChestContainer container, PlayerInventory inventory, ITextComponent name) {
            super(container, inventory, name);
        }
    }
}

