package com.mattsmeets.macrokey.gui.fragment;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mattsmeets.macrokey.MacroKey;
import com.mattsmeets.macrokey.event.LayerEvent;
import com.mattsmeets.macrokey.gui.GuiMacroManagement;
import com.mattsmeets.macrokey.gui.GuiModifyMacro;
import com.mattsmeets.macrokey.gui.button.KeyBindingButton;
import com.mattsmeets.macrokey.model.LayerInterface;
import com.mattsmeets.macrokey.model.MacroInterface;
import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;

public class MacroListFragment extends ExtendedList<MacroListFragment.MacroEntry> {
    private static final Logger LOGGER = LogManager.getLogger();

    private final GuiMacroManagement guiMacroManagement;

    private final LayerInterface currentLayer;

    public MacroListFragment(GuiMacroManagement guiMacroManagement, LayerInterface layer) {
        super(guiMacroManagement.getMinecraft(), guiMacroManagement.width + 45, guiMacroManagement.height, 63, guiMacroManagement.height - 32, 20);

        this.guiMacroManagement = guiMacroManagement;
        this.currentLayer = layer;

        final List<MacroInterface> macros = MacroKey.bindingsRepository.findAllMacros(true)
                .stream()
                .sorted(Comparator.comparing(MacroInterface::getUMID))
                .collect(Collectors.toList());

        for (final MacroInterface macro : macros) {
            addEntry(new MacroEntry(macro));
        }
        
    }

    public class MacroEntry extends ExtendedList.AbstractListEntry<MacroEntry> {
        private final MacroInterface macro;

        private final KeyBindingButton btnChangeKeyBinding;
        private final Button btnRemoveKeyBinding;
        private final Button btnEdit;
        private final Button btnEnabledInLayer;

        private MacroEntry(MacroInterface macro) {
            this.macro = macro;

            this.btnChangeKeyBinding = new KeyBindingButton(0, 0, 75, 20, new TranslationTextComponent(macro.getCommand().toString()), b -> {
            	guiMacroManagement.macroModify = macro;
            });

            this.btnRemoveKeyBinding = new Button(0, 0, 15, 20, new TranslationTextComponent("fragment.list.text.remove"), b -> {
            	try {
                    MacroKey.bindingsRepository.deleteMacro(macro, true, true);
                } catch (IOException e) {
                    LOGGER.error(e);
                } finally {
                    minecraft.setScreen(guiMacroManagement);
                }
            });

            this.btnEdit = new Button(0, 0, 30, 20, new TranslationTextComponent("edit"), b -> {
            	minecraft.setScreen(new GuiModifyMacro(guiMacroManagement, macro));
            });

            this.btnEnabledInLayer = new Button(0, 0, 75, 20, MacroKey.bindingsRepository.isMacroInLayer(macro, currentLayer) ? new TranslationTextComponent("disabled") : new TranslationTextComponent("enabled"), b -> {
            	if (MacroKey.bindingsRepository.isMacroInLayer(macro, currentLayer)) {
                    currentLayer.removeMacro(macro);
                    b.setMessage(new TranslationTextComponent("enabled"));
                } else {
                    currentLayer.addMacro(macro);
                    b.setMessage(new TranslationTextComponent("disabled"));
                }
                MinecraftForge.EVENT_BUS.post(new LayerEvent.LayerChangedEvent(currentLayer));
            });
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean result = this.btnEdit.mouseClicked(mouseX, mouseY, button);
            result = result || this.btnChangeKeyBinding.mouseClicked(mouseX, mouseY, button);
            result = result || this.btnRemoveKeyBinding.mouseClicked(mouseX, mouseY, button);
            result = result || this.btnEnabledInLayer.mouseClicked(mouseX, mouseY, button);

            return result;
        }

        @Override
        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            boolean result = this.btnChangeKeyBinding.mouseReleased(mouseX, mouseY, button);
            result = result || this.btnEdit.mouseReleased(mouseX, mouseY, button);

            return result;
        }

		@Override
		public void render(MatrixStack ms, int i, int y, int x, int width, int height, int mouseX, int mouseY, boolean hover, float partialTicks) {
			boolean macroKeyCodeModifyFlag = this.macro.equals(guiMacroManagement.macroModify);

            // Render macro command
            minecraft.font.draw(ms, this.macro.getCommand().toString(),
                    x + 90f - minecraft.font.width(macro.getCommand().toString()),
                    y + height / 2f - minecraft.font.lineHeight / 2f,
                    0xFFFFFF);

            if (currentLayer == null) {
                this.btnEdit.x = x + 170;
                this.btnEdit.y = y;
                this.btnEdit.render(ms, mouseX, mouseY, 0.0f);

                this.btnRemoveKeyBinding.x = x + 200;
                this.btnRemoveKeyBinding.y = y;
                this.btnRemoveKeyBinding.render(ms, mouseX, mouseY, 0.0f);

                this.btnChangeKeyBinding.x = x + 95;
                this.btnChangeKeyBinding.y = y;
                this.btnChangeKeyBinding.updateDisplayString(macro, macroKeyCodeModifyFlag);
                this.btnChangeKeyBinding.render(ms, mouseX, mouseY, 0.0f);
            } else {
                this.btnEnabledInLayer.x = x + 95;
                this.btnEnabledInLayer.y = y;
                this.btnEnabledInLayer.render(ms, mouseX, mouseY, 0.0f);
            }
		}
    }
}
