package com.mattsmeets.macrokey.gui.fragment;

import java.io.IOException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mattsmeets.macrokey.MacroKey;
import com.mattsmeets.macrokey.gui.GuiLayerManagement;
import com.mattsmeets.macrokey.gui.GuiModifyLayer;
import com.mattsmeets.macrokey.model.LayerInterface;
import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.text.TranslationTextComponent;

public class LayerListFragment extends ExtendedList<LayerListFragment.LayerEntry> {
    private static final Logger LOGGER = LogManager.getLogger();

    private final GuiLayerManagement guiLayerManagement;

    public LayerListFragment(final GuiLayerManagement guiLayerManagement) throws IOException {
        super(guiLayerManagement.getMinecraft(), guiLayerManagement.width + 45, guiLayerManagement.height, 63, guiLayerManagement.height - 32, 20);

        this.guiLayerManagement = guiLayerManagement;

        for (LayerInterface layer : MacroKey.modState.getLayers(true)) {
            addEntry(new LayerEntry(layer));
        }
    }

    public class LayerEntry extends ExtendedList.AbstractListEntry<LayerEntry> {
        private final LayerInterface layer;

        private final Button btnRemove;
        private final Button btnEdit;

        private LayerEntry(final LayerInterface layer) {
            this.layer = layer;

            this.btnEdit = new Button(0, 0, 60, 20, new TranslationTextComponent("edit"), b -> {
            	minecraft.setScreen(new GuiModifyLayer(guiLayerManagement, layer));
            });

            this.btnRemove = new Button(0, 0, 15, 20, new TranslationTextComponent("fragment.list.text.remove"), b -> {
            	try {
                    if (layer.equals(MacroKey.modState.getActiveLayer())) {
                        MacroKey.modState.setActiveLayer(null);
                    }

                    MacroKey.bindingsRepository.deleteLayer(layer, true);
                } catch (IOException e) {
                    LOGGER.error(e);
                } finally {
                    minecraft.setScreen(guiLayerManagement);
                }
            });
        }

        @Override
        public void render(MatrixStack ms, int i, int y, int x, int width, int height, int mouseX, int mouseY, boolean hover, float partialTicks) {
            // Render layer name
        	minecraft.font.draw(ms, layer.getDisplayName(),
                    x + 90f - minecraft.font.width(layer.getDisplayName()),
                    y + height / 2f - minecraft.font.lineHeight / 2f,
                    0xFFFFFF);

            // Render buttons
            this.btnEdit.x = x + 140;
            this.btnEdit.y = y;
            this.btnEdit.render(ms, mouseX, mouseY, 0.0f);

            this.btnRemove.x = x + 200;
            this.btnRemove.y = y;
            this.btnRemove.render(ms, mouseX, mouseY, 0.0f);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            final boolean btnEditResult = this.btnEdit.mouseClicked(mouseX, mouseY, button);
            final boolean btnRemoveResult = this.btnRemove.mouseClicked(mouseX, mouseY, button);

            return btnEditResult || btnRemoveResult;
        }
    }
}
