package com.mattsmeets.macrokey.gui;

import org.apache.commons.lang3.StringUtils;
import org.lwjgl.glfw.GLFW;

import com.mattsmeets.macrokey.event.MacroEvent;
import com.mattsmeets.macrokey.gui.button.KeyBindingButton;
import com.mattsmeets.macrokey.model.Macro;
import com.mattsmeets.macrokey.model.MacroInterface;
import com.mattsmeets.macrokey.model.command.StringCommand;
import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;

public class GuiModifyMacro extends Screen {
    private final Screen parentScreen;

    private final String repeatOnHoldText = I18n.get("gui.modify.text.repeat");
    private final String enableCommandText = I18n.get("gui.modify.text.enable");
    private final String commandBoxTitleText = I18n.get("gui.modify.text.command");
    private final String keyBoxTitleText = I18n.get("gui.modify.text.key");

    private final boolean isUpdatingMacro;
    private final MacroInterface macro;

    private TextFieldWidget textFieldCommand;

    private KeyBindingButton btnKeyBinding;

    private boolean changingKey = false;

    public GuiModifyMacro(final Screen parentScreen, final MacroInterface macro) {
    	super(new TranslationTextComponent(macro != null?"gui.modify.text.title.edit":"gui.modify.text.title.new"));
        this.parentScreen = parentScreen;
        this.isUpdatingMacro = macro != null;
        this.macro = isUpdatingMacro ? macro : new Macro();
    }

    GuiModifyMacro(Screen guiScreen) {
        this(guiScreen, null);
    }

    @Override
    public void init() {
        // Add macro button
        this.addButton(new Button(this.width / 2 - 155, this.height - 29, 150, 20, new TranslationTextComponent("gui.modify.text.save"), b -> {
        	if (textFieldCommand.getValue().length() <= 1) {
                return;
            }

            macro.setCommand(new StringCommand(textFieldCommand.getValue()));

            if (isUpdatingMacro) {
                MinecraftForge.EVENT_BUS.post(new MacroEvent.MacroChangedEvent(macro));
            } else {
                MinecraftForge.EVENT_BUS.post(new MacroEvent.MacroAddedEvent(macro));
            }

            minecraft.setScreen(parentScreen);
        }));

        // Cancel button
        this.addButton(new Button(this.width / 2 - 155 + 160, this.height - 29, 150, 20, new TranslationTextComponent("gui.cancel"), b -> {
        	minecraft.setScreen(parentScreen);
        }));

        // Modify key binding button
        String s = GLFW.glfwGetKeyName(macro.getKeyCode(), 0);
        if (s == null) s = " ";
        this.btnKeyBinding = this.addButton(new KeyBindingButton(this.width / 2 - 75, 100, 150, 20, new StringTextComponent(s), b -> {
        	changingKey = true;
            ((KeyBindingButton) b).updateDisplayString(macro, true);
        }));

        // Toggle macro repeat button
        this.addButton(new Button(this.width / 2 - 75, 140, 75, 20, macro.willRepeat() ? new TranslationTextComponent("enabled") : new TranslationTextComponent("disabled"), b -> {
        	macro.setRepeat(!macro.willRepeat());
            b.setMessage(macro.willRepeat() ? new TranslationTextComponent("enabled") : new TranslationTextComponent("disabled"));
        }));

        // Toggle macro active button
        this.addButton(new Button(this.width / 2 - 75, 163, 75, 20, macro.isActive() ? new TranslationTextComponent("enabled") : new TranslationTextComponent("disabled"), b -> {
        	macro.setActive(!macro.isActive());
            b.setMessage(macro.isActive() ? new TranslationTextComponent("enabled") : new TranslationTextComponent("disabled"));
        }));

        // Command text field
        this.textFieldCommand = addButton(new TextFieldWidget(this.font, this.width / 2 - 100, 50, 200, 20, new StringTextComponent(" "))); //TODO: Fill textWidget desc. 
        this.textFieldCommand.setFocus(true);
        this.textFieldCommand.setMaxLength(Integer.MAX_VALUE);
        this.textFieldCommand.setValue(this.isUpdatingMacro ? macro.getCommand().toString() : StringUtils.EMPTY);
    }

    @Override
    public void render(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(ms);

        // Render title
        drawCenteredString(ms, this.font, this.title, this.width / 2, 8, 0xFFFFFF);

        // Render labels
        // TODO : replace by GuiLabel ?
        drawString(ms, this.font, repeatOnHoldText, this.width / 2 + 50 - minecraft.font.width(repeatOnHoldText) - 140, 145, 0x5F5F60);
        drawString(ms, this.font, enableCommandText, this.width / 2 + 50 - minecraft.font.width(enableCommandText) - 140, 168, 0x5F5F60);
        drawCenteredString(ms, this.font, commandBoxTitleText, this.width / 2, 37, 0x5F5F60);
        drawCenteredString(ms, this.font, keyBoxTitleText, this.width / 2, 90, 0x5F5F60);

        // Render buttons & labels
        super.render(ms, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean charTyped(char keyValue, int modifier) {
        return this.textFieldCommand.charTyped(keyValue, modifier);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifier) {
        if (this.changingKey) {
            changingKey = false;

            if (keyCode == GLFW.GLFW_KEY_ESCAPE) {
                this.macro.setKeyCode(0);
            } else if (keyCode != GLFW.GLFW_KEY_UNKNOWN) {
                this.macro.setKeyCode(keyCode);
            }

            this.btnKeyBinding.updateDisplayString(macro, false);

            return true;
        }

        if (this.textFieldCommand.isFocused()) {
            if (keyCode == GLFW.GLFW_KEY_ESCAPE) {
                this.textFieldCommand.setFocus(false);

                return true;
            }

            return this.textFieldCommand.keyPressed(keyCode, scanCode, modifier);
        }

        return super.keyPressed(keyCode, scanCode, modifier);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.textFieldCommand.setFocus(false);

        if (this.changingKey) {
            this.changingKey = false;
            this.btnKeyBinding.updateDisplayString(macro, false);
        }

        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}
