package com.mattsmeets.macrokey.config;

import net.minecraftforge.common.ForgeConfigSpec;

//@Config(modid = ModReference.MOD_ID)
//@Config.LangKey("macrokey.config.title")
public class ModConfig {
	public static ForgeConfigSpec config;
    public static ForgeConfigSpec.IntValue repeatDelay;
    public static ForgeConfigSpec.ConfigValue<String> bindingFile;
    public static ForgeConfigSpec.BooleanValue buttonLayerSwitchDisabled;
    public static ForgeConfigSpec.IntValue buttonLayerSwitchSettingsX;
    public static ForgeConfigSpec.IntValue buttonLayerSwitchSettingsY;
    public static ForgeConfigSpec.IntValue buttonLayerSwitchSettingsW;
    public static ForgeConfigSpec.IntValue buttonLayerSwitchSettingsH;
	public static void init() {
		ForgeConfigSpec.Builder build = new ForgeConfigSpec.Builder();
		repeatDelay = build.comment("How many ticks need to pass for the repeatable command cooldown timer to expire (default: 20 ticks -> 1 second)").defineInRange("repeatDelay", 20, 0, Integer.MAX_VALUE);
		bindingFile = build.comment("What file should be used for saving the bindings and various other dynamic information (default: bindings.json)").define("bindingFile", "bindings.json");
		build.push("buttonLayerSwitchSettings");
		buttonLayerSwitchDisabled = build.comment("Hide the builder?").define("disable", false);
		buttonLayerSwitchSettingsX = build.comment("Customize the position that the button for switching layer should use, expected is 'x' (default: -100)").defineInRange("x", -100, Integer.MIN_VALUE, Integer.MAX_VALUE);
		buttonLayerSwitchSettingsY = build.comment("Customize the position that the button for switching layer should use, expected is 'y' (default: 128)").defineInRange("y", 128, Integer.MIN_VALUE, Integer.MAX_VALUE);
		buttonLayerSwitchSettingsW = build.comment("Customize the position that the button for switching layer should use, expected is 'width' (default: 200)").defineInRange("width", 200, Integer.MIN_VALUE, Integer.MAX_VALUE);
		buttonLayerSwitchSettingsH = build.comment("Customize the position that the button for switching layer should use, expected is 'height' (default: 20)").defineInRange("height", 20, Integer.MIN_VALUE, Integer.MAX_VALUE);
		build.pop();
		config = build.build();
	}
}
