/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.renderers.HudRenderer;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;

public abstract class PotionRenderer
extends HudRenderer {
    public int potX;
    public int potY;
    public WidgetAligns PotAligns;
    public int potSide;
    public int potIconSide;
    public int potTextSide;
    public int potVert;
    public int barDuration;
    public float potAlpha;
    public boolean potMini;
    public int potGap;
    Minecraft mc;
    FontRenderer fontRenderer;
    final ResourceLocation PMT = new ResourceLocation("inventoryhud", "textures/gui/potminitime.png");

    public PotionRenderer(Minecraft mc) {
        this.mc = mc;
        this.fontRenderer = mc.field_71466_p;
    }

    abstract void renderBG(MatrixStack var1, int var2, int var3, int var4);

    abstract void renderIcon(MatrixStack var1, int var2, int var3, int var4, TextureAtlasSprite var5);

    abstract void renderLevel(MatrixStack var1, int var2, int var3, int var4);

    abstract void renderTimer(MatrixStack var1, int var2, int var3, int var4, int var5);

    public void render(MatrixStack mat, int width, int height) {
        int c = 0;
        int effCount = this.mc.field_71439_g.func_70651_bq().size();
        if (effCount == 0) {
            return;
        }
        PotionSpriteUploader potionspriteuploader = this.mc.func_213248_ap();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-255.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        int xPos = this.getX(width, effCount);
        int yPos = this.getY(height, effCount);
        for (EffectInstance effect : this.mc.field_71439_g.func_70651_bq()) {
            Effect pot = effect.func_188419_a();
            if (this.potAlpha > 0.0f) {
                this.renderBG(mat, xPos, yPos, c);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(pot);
            this.mc.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
            this.renderIcon(mat, xPos, yPos, c, textureatlassprite);
            ResourceLocation lev = effect.func_76458_c() < 9 && effect.func_76458_c() >= 0 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.func_76458_c() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            this.mc.func_110434_K().func_110577_a(lev);
            this.renderLevel(mat, xPos, yPos, c);
            this.renderTimer(mat, xPos, yPos, c, effect.func_76459_b());
            ++c;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    abstract int getX(int var1, int var2);

    abstract int getY(int var1, int var2);

    private void PotPosVertChanged() {
        switch (this.PotAligns.HorAlign) {
            case RIGHT: {
                if (!this.potMini) {
                    this.potSide = -1;
                    this.potIconSide = 36;
                    this.potTextSide = -22;
                    break;
                }
                this.potSide = -1;
                this.potIconSide = 4;
                this.potTextSide = -15;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    if (!this.potMini) {
                        this.potSide = -1;
                        this.potIconSide = 36;
                        this.potTextSide = -22;
                        break;
                    }
                    this.potSide = -1;
                    this.potIconSide = 4;
                    this.potTextSide = -15;
                    break;
                }
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
                break;
            }
            case LEFT: {
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
            }
        }
    }

    public void PotPosChanged() {
        if (((Boolean)InventoryHUD.getClient().potHor.get()).booleanValue()) {
            this.PotPosHorChanged();
        } else {
            this.PotPosVertChanged();
        }
    }

    private void PotPosHorChanged() {
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    this.potSide = -1;
                    this.potTextSide = 2;
                    this.potIconSide = 4;
                    break;
                }
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case BOTTOM: {
                this.potSide = -1;
                this.potTextSide = 2;
                this.potIconSide = 4;
            }
        }
    }

    public void PotPosYChanged(boolean top) {
        this.potVert = top ? 1 : -1;
    }

    int setBarColor(int dur) {
        float r = 1.0f;
        float g = 1.0f;
        float f = (float)dur / (float)this.barDuration;
        int size = (int)(f * 12.0f) + 1;
        if (f < 0.5f) {
            g = f / 0.5f;
        } else {
            r = 1.0f - (f - 0.5f) / 0.5f;
        }
        RenderSystem.color4f((float)r, (float)g, (float)0.0f, (float)1.0f);
        return size;
    }
}

