/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeWorldType
extends ForgeRegistryEntry<ForgeWorldType> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IChunkGeneratorFactory factory;

    public static ForgeWorldType getDefaultWorldType() {
        String defaultWorldType = ForgeConfig.COMMON.defaultWorldType.get();
        if (StringUtils.func_151246_b((String)defaultWorldType) || "default".equals(defaultWorldType)) {
            return null;
        }
        ForgeWorldType def = ForgeRegistries.WORLD_TYPES.getValue(new ResourceLocation(defaultWorldType));
        if (def == null) {
            LOGGER.error("The defaultWorldType '{}' specified in the forge config has not been registered. The vanilla default generator will be used.", (Object)defaultWorldType);
        }
        return def;
    }

    public ForgeWorldType(IChunkGeneratorFactory factory) {
        this.factory = factory;
    }

    public ForgeWorldType(IBasicChunkGeneratorFactory factory) {
        this.factory = factory;
    }

    public String getTranslationKey() {
        return Util.func_200697_a((String)"generator", (ResourceLocation)this.getRegistryName());
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public ChunkGenerator createChunkGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimensionSettingsRegistry, long seed, String generatorSettings) {
        return this.factory.createChunkGenerator(biomeRegistry, dimensionSettingsRegistry, seed, generatorSettings);
    }

    public DimensionGeneratorSettings createSettings(DynamicRegistries dynamicRegistries, long seed, boolean generateStructures, boolean generateLoot, String generatorSettings) {
        return this.factory.createSettings(dynamicRegistries, seed, generateStructures, generateLoot, generatorSettings);
    }

    public static interface IBasicChunkGeneratorFactory
    extends IChunkGeneratorFactory {
        public ChunkGenerator createChunkGenerator(Registry<Biome> var1, Registry<DimensionSettings> var2, long var3);

        @Override
        default public ChunkGenerator createChunkGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimensionSettingsRegistry, long seed, String generatorSettings) {
            return this.createChunkGenerator(biomeRegistry, dimensionSettingsRegistry, seed);
        }
    }

    public static interface IChunkGeneratorFactory {
        public ChunkGenerator createChunkGenerator(Registry<Biome> var1, Registry<DimensionSettings> var2, long var3, String var5);

        default public DimensionGeneratorSettings createSettings(DynamicRegistries dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest, String generatorSettings) {
            MutableRegistry biomeRegistry = dynamicRegistries.func_243612_b(Registry.field_239720_u_);
            MutableRegistry dimensionTypeRegistry = dynamicRegistries.func_243612_b(Registry.field_239698_ad_);
            MutableRegistry dimensionSettingsRegistry = dynamicRegistries.func_243612_b(Registry.field_243549_ar);
            return new DimensionGeneratorSettings(seed, generateStructures, bonusChest, DimensionGeneratorSettings.func_242749_a((Registry)dimensionTypeRegistry, (SimpleRegistry)DimensionType.func_242718_a((Registry)dimensionTypeRegistry, (Registry)biomeRegistry, (Registry)dimensionSettingsRegistry, (long)seed), (ChunkGenerator)this.createChunkGenerator((Registry<Biome>)biomeRegistry, (Registry<DimensionSettings>)dimensionSettingsRegistry, seed, generatorSettings)));
        }
    }
}

