/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ICharacterPredicate;
import net.minecraft.crash.ReportedException;
import net.minecraft.state.Property;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Bootstrap;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final AtomicInteger field_215090_b = new AtomicInteger(1);
    private static final ExecutorService field_240974_d_ = Util.func_240979_a_("Bootstrap");
    private static final ExecutorService field_215091_c = Util.func_240979_a_("Main");
    private static final ExecutorService field_240975_f_ = Util.func_240995_n_();
    public static LongSupplier field_211180_a = System::nanoTime;
    public static final UUID field_240973_b_ = new UUID(0L, 0L);
    private static final Logger field_195650_a = LogManager.getLogger();

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> func_199749_a() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T extends Comparable<T>> String func_200269_a(Property<T> property, Object object) {
        return property.func_177702_a((Comparable)object);
    }

    public static String func_200697_a(String string, @Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return string + ".unregistered_sadface";
        }
        return string + '.' + resourceLocation.func_110624_b() + '.' + resourceLocation.func_110623_a().replace('/', '.');
    }

    public static long func_211177_b() {
        return Util.func_211178_c() / 1000000L;
    }

    public static long func_211178_c() {
        return field_211180_a.getAsLong();
    }

    public static long func_211179_d() {
        return Instant.now().toEpochMilli();
    }

    private static ExecutorService func_240979_a_(String string) {
        int n = MathHelper.func_76125_a(Runtime.getRuntime().availableProcessors() - 1, 1, 7);
        Object \u26032 = n <= 0 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(n, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        field_195650_a.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        field_195650_a.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("Worker-" + string + "-" + field_215090_b.getAndIncrement());
            return forkJoinWorkerThread;
        }, Util::func_240983_a_, true);
        return \u26032;
    }

    public static Executor func_240991_e_() {
        return field_240974_d_;
    }

    public static Executor func_215072_e() {
        return field_215091_c;
    }

    public static Executor func_240992_g_() {
        return field_240975_f_;
    }

    public static void func_240993_h_() {
        Util.func_240985_a_(field_215091_c);
        Util.func_240985_a_(field_240975_f_);
    }

    private static void func_240985_a_(ExecutorService executorService) {
        boolean bl;
        executorService.shutdown();
        try {
            bl = executorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        if (!bl) {
            executorService.shutdownNow();
        }
    }

    private static ExecutorService func_240995_n_() {
        return Executors.newCachedThreadPool(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("IO-Worker-" + field_215090_b.getAndIncrement());
            thread.setUncaughtExceptionHandler(Util::func_240983_a_);
            return thread;
        });
    }

    public static <T> CompletableFuture<T> func_215087_a(Throwable throwable) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(throwable);
        return completableFuture;
    }

    public static void func_229756_b_(Throwable throwable) {
        throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
    }

    private static void func_240983_a_(Thread thread, Throwable throwable) {
        Util.func_229757_c_(throwable);
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ReportedException) {
            Bootstrap.func_179870_a(((ReportedException)throwable).func_71575_a().func_71502_e());
            System.exit(-1);
        }
        field_195650_a.error(String.format("Caught exception in thread %s", thread), throwable);
    }

    @Nullable
    public static Type<?> func_240976_a_(DSL.TypeReference typeReference, String string) {
        if (!SharedConstants.field_240856_c_) {
            return null;
        }
        return Util.func_240990_b_(typeReference, string);
    }

    @Nullable
    private static Type<?> func_240990_b_(DSL.TypeReference typeReference, String string) {
        block2: {
            Type type = null;
            try {
                type = DataFixesManager.func_210901_a().getSchema(DataFixUtils.makeKey((int)SharedConstants.func_215069_a().getWorldVersion())).getChoiceType(typeReference, string);
            }
            catch (IllegalArgumentException \u26032) {
                field_195650_a.error("No data fixer registered for {}", (Object)string);
                if (!SharedConstants.field_206244_b) break block2;
                throw \u26032;
            }
        }
        return type;
    }

    public static OS func_110647_a() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return OS.WINDOWS;
        }
        if (string.contains("mac")) {
            return OS.OSX;
        }
        if (string.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (string.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (string.contains("linux")) {
            return OS.LINUX;
        }
        if (string.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static Stream<String> func_211565_f() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments().stream().filter(string -> string.startsWith("-X"));
    }

    public static <T> T func_223378_a(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T func_195647_a(Iterable<T> iterable, @Nullable T t) {
        Iterator<T> iterator = iterable.iterator();
        T \u26032 = iterator.next();
        if (t != null) {
            T t2 = \u26032;
            while (true) {
                if (t2 == t) {
                    if (!iterator.hasNext()) break;
                    return iterator.next();
                }
                if (!iterator.hasNext()) continue;
                t2 = iterator.next();
            }
        }
        return \u26032;
    }

    public static <T> T func_195648_b(Iterable<T> iterable, @Nullable T t) {
        Iterator<T> iterator = iterable.iterator();
        T \u26032 = null;
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (t2 == t) {
                if (\u26032 != null) break;
                \u26032 = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : t);
                break;
            }
            \u26032 = t2;
        }
        return \u26032;
    }

    public static <T> T func_199748_a(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T func_200696_a(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }

    public static <K> Hash.Strategy<K> func_212443_g() {
        return IdentityStrategy.INSTANCE;
    }

    public static <V> CompletableFuture<List<V>> func_215079_b(List<? extends CompletableFuture<? extends V>> list) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        CompletableFuture[] \u26032 = new CompletableFuture[list.size()];
        CompletableFuture \u26033 = new CompletableFuture();
        list.forEach(completableFuture2 -> {
            int n = arrayList.size();
            arrayList.add(null);
            completableFutureArray[n] = completableFuture2.whenComplete((object, throwable) -> {
                if (throwable != null) {
                    \u26033.completeExceptionally((Throwable)throwable);
                } else {
                    arrayList.set(n, object);
                }
            });
        });
        return CompletableFuture.allOf(\u26032).applyToEither((CompletionStage)\u26033, void_ -> arrayList);
    }

    public static <T> Stream<T> func_215081_a(Optional<? extends T> optional) {
        return (Stream)DataFixUtils.orElseGet(optional.map(Stream::of), Stream::empty);
    }

    public static <T> Optional<T> func_215077_a(Optional<T> optional, Consumer<T> consumer, Runnable runnable) {
        if (optional.isPresent()) {
            consumer.accept(optional.get());
        } else {
            runnable.run();
        }
        return optional;
    }

    public static Runnable func_215075_a(Runnable runnable, Supplier<String> supplier) {
        return runnable;
    }

    public static <T extends Throwable> T func_229757_c_(T t2) {
        T t2;
        if (SharedConstants.field_206244_b) {
            field_195650_a.error("Trying to throw a fatal exception, pausing in IDE", t2);
            try {
                while (true) {
                    Thread.sleep(1000L);
                    field_195650_a.error("paused");
                }
            }
            catch (InterruptedException interruptedException) {
                return t2;
            }
        }
        return t2;
    }

    public static String func_229758_d_(Throwable throwable) {
        if (throwable.getCause() != null) {
            return Util.func_229758_d_(throwable.getCause());
        }
        if (throwable.getMessage() != null) {
            return throwable.getMessage();
        }
        return throwable.toString();
    }

    public static <T> T func_240989_a_(T[] TArray, Random random) {
        return TArray[random.nextInt(TArray.length)];
    }

    public static int func_240988_a_(int[] nArray, Random random) {
        return nArray[random.nextInt(nArray.length)];
    }

    private static BooleanSupplier func_244363_a(final Path path, final Path path2) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(path, path2, new CopyOption[0]);
                    return true;
                }
                catch (IOException iOException) {
                    field_195650_a.error("Failed to rename", (Throwable)iOException);
                    return false;
                }
            }

            public String toString() {
                return "rename " + path + " to " + path2;
            }
        };
    }

    private static BooleanSupplier func_244362_a(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(path);
                    return true;
                }
                catch (IOException iOException) {
                    field_195650_a.warn("Failed to delete", (Throwable)iOException);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + path;
            }
        };
    }

    private static BooleanSupplier func_244366_b(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(path, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + path + " is deleted";
            }
        };
    }

    private static BooleanSupplier func_244367_c(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(path, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + path + " is present";
            }
        };
    }

    private static boolean func_244365_a(BooleanSupplier ... booleanSupplierArray) {
        for (BooleanSupplier booleanSupplier : booleanSupplierArray) {
            if (booleanSupplier.getAsBoolean()) continue;
            field_195650_a.warn("Failed to execute {}", (Object)booleanSupplier);
            return false;
        }
        return true;
    }

    private static boolean func_244359_a(int n, String string2, BooleanSupplier ... booleanSupplierArray) {
        String string2;
        for (int i = 0; i < n; ++i) {
            if (Util.func_244365_a(booleanSupplierArray)) {
                return true;
            }
            field_195650_a.error("Failed to {}, retrying {}/{}", (Object)string2, (Object)i, (Object)n);
        }
        field_195650_a.error("Failed to {}, aborting, progress might be lost", (Object)string2);
        return false;
    }

    public static void func_240977_a_(File file, File file2, File file3) {
        Util.func_244364_a(file.toPath(), file2.toPath(), file3.toPath());
    }

    public static void func_244364_a(Path path, Path path2, Path path3) {
        int n = 10;
        if (Files.exists(path, new LinkOption[0]) && !Util.func_244359_a(10, "create backup " + path3, Util.func_244362_a(path3), Util.func_244363_a(path, path3), Util.func_244367_c(path3))) {
            return;
        }
        if (!Util.func_244359_a(10, "remove old " + path, Util.func_244362_a(path), Util.func_244366_b(path))) {
            return;
        }
        if (!Util.func_244359_a(10, "replace " + path + " with " + path2, Util.func_244363_a(path2, path), Util.func_244367_c(path))) {
            Util.func_244359_a(10, "restore " + path + " from " + path3, Util.func_244363_a(path3, path), Util.func_244367_c(path));
        }
    }

    public static int func_240980_a_(String string, int n, int n2) {
        \u2603 = string.length();
        if (n2 >= 0) {
            for (\u2603 = 0; n < \u2603 && \u2603 < n2; ++\u2603) {
                if (!Character.isHighSurrogate(string.charAt(n++)) || n >= \u2603 || !Character.isLowSurrogate(string.charAt(n))) continue;
                ++n;
            }
        } else {
            for (\u2603 = n2; n > 0 && \u2603 < 0; ++\u2603) {
                if (!Character.isLowSurrogate(string.charAt(--n)) || n <= 0 || !Character.isHighSurrogate(string.charAt(n - 1))) continue;
                --n;
            }
        }
        return n;
    }

    public static Consumer<String> func_240982_a_(String string, Consumer<String> consumer) {
        return string2 -> consumer.accept(string + string2);
    }

    public static DataResult<int[]> func_240987_a_(IntStream intStream, int n) {
        int[] nArray = intStream.limit(n + 1).toArray();
        if (nArray.length != n) {
            String string = "Input is not a list of " + n + " ints";
            if (nArray.length >= n) {
                return DataResult.error((String)string, (Object)Arrays.copyOf(nArray, n));
            }
            return DataResult.error((String)string);
        }
        return DataResult.success((Object)nArray);
    }

    public static void func_240994_l_() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    field_195650_a.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_195650_a));
        thread.start();
    }

    public static void func_240984_a_(Path path, Path path2, Path path3) throws IOException {
        \u2603 = path.relativize(path3);
        \u2603 = path2.resolve(\u2603);
        Files.copy(path3, \u2603, new CopyOption[0]);
    }

    public static String func_244361_a(String string, ICharacterPredicate iCharacterPredicate) {
        return string.toLowerCase(Locale.ROOT).chars().mapToObj(n -> iCharacterPredicate.test((char)n) ? Character.toString((char)n) : "_").collect(Collectors.joining());
    }

    static enum IdentityStrategy implements Hash.Strategy<Object>
    {
        INSTANCE;


        public int hashCode(Object object) {
            return System.identityHashCode(object);
        }

        public boolean equals(Object object, Object object2) {
            return object == object2;
        }
    }

    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS{

            @Override
            protected String[] func_195643_b(URL uRL) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", uRL.toString()};
            }
        }
        ,
        OSX{

            @Override
            protected String[] func_195643_b(URL uRL) {
                return new String[]{"open", uRL.toString()};
            }
        }
        ,
        UNKNOWN;


        public void func_195639_a(URL uRL) {
            try {
                Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.func_195643_b(uRL)));
                for (String string : IOUtils.readLines((InputStream)process.getErrorStream())) {
                    field_195650_a.error(string);
                }
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException exception) {
                field_195650_a.error("Couldn't open url '{}'", (Object)uRL, (Object)exception);
            }
        }

        public void func_195642_a(URI uRI) {
            try {
                this.func_195639_a(uRI.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                field_195650_a.error("Couldn't open uri '{}'", (Object)uRI, (Object)malformedURLException);
            }
        }

        public void func_195641_a(File file) {
            try {
                this.func_195639_a(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                field_195650_a.error("Couldn't open file '{}'", (Object)file, (Object)malformedURLException);
            }
        }

        protected String[] func_195643_b(URL uRL) {
            String string = uRL.toString();
            if ("file".equals(uRL.getProtocol())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void func_195640_a(String string) {
            try {
                this.func_195639_a(new URI(string).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                field_195650_a.error("Couldn't open uri '{}'", (Object)string, (Object)exception);
            }
        }
    }
}

